package com.biz.crm.tpm.business.activity.plan.local.modify.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanStrategyMapper;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanStrategyModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanStrategyModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanStrategyModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 活动方案表(ActivityPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityPlanStrategyModifyRepository extends ServiceImpl<ActivityPlanStrategyModifyMapper, ActivityPlanStrategyModify> {

    @Autowired(required = false)
    private ActivityPlanStrategyMapper activityPlanStrategyMapper;


    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 根据方案编码查询方案关联策略数据
     * @param modifyCode 方案编码
     * @return 方案明细dtolist
     */
    public List<ActivityPlanStrategyModifyVo> findListVoByModifyCode(String modifyCode) {
        if (StringUtils.isBlank(modifyCode)){
            return null;
        }
        List<ActivityPlanStrategyModify> itemList = findListByModifyCode(modifyCode);
        return (List<ActivityPlanStrategyModifyVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanStrategyModify.class, ActivityPlanStrategyModifyVo.class, HashSet.class, ArrayList.class);
    }

    public List<ActivityPlanStrategyModify> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank(modifyCode)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityPlanStrategyModify.class)
                .eq(ActivityPlanStrategyModify::getModifyBusinessCode, modifyCode)
                .eq(ActivityPlanStrategyModify::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanStrategyModify> updateWrapper = new UpdateWrapper<ActivityPlanStrategyModify>().lambda();
        updateWrapper.set(ActivityPlanStrategyModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanStrategyModify::getId, ids);
        this.update(updateWrapper);
    }

    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanStrategyModify> updateWrapper = new UpdateWrapper<ActivityPlanStrategyModify>().lambda();
        updateWrapper.set(ActivityPlanStrategyModify::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanStrategyModify::getModifyBusinessCode, modifyCodes);
        this.update(updateWrapper);
    }
}

