package com.biz.crm.tpm.business.activity.plan.local.modify.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanBudgetModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 方案关联预算数据
 * @author wanghaojia
 * @date 2022/12/24 14:28
 */
public interface ActivityPlanBudgetModifyService {

    /**
     * 按条件查询营销策略
     * @param pageable 分页参数
     * @param dto 查询参数
     */
    Page<ActivityPlanBudgetVo> findByConditions(Pageable pageable, ActivityPlanBudgetDto dto);

    /**
     * 保存活动方案-关联预算数据
     *
     * @param itemDtoList 方案明细数据
     */
    void saveActivityPlanBudgetList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemDtoList);

    void deleteByModifyCodes(List<String> modifyCodes);

    /**
     * 扣减预算信息
     * @param modifyCode 方案变更编码
     * @param planCode 方案编码
     * @param doSave 是否执行扣减
     */
    void useMonthBudgetByModifyCode(String modifyCode, String planCode, boolean doSave);

    /**
     * 扣减预算信息
     * @param modifyItemBudgetList 变更的预算信息
     * @param planCode 方案编码
     * @param doSave 是否执行扣减
     */
    void useMonthBudget(List<ActivityPlanBudgetModifyDto> modifyItemBudgetList, String planCode, boolean doSave);

    /**
     * 流程驳回处理预算
     * @param modifyCode 变更编码
     * @param planCode 方案编码
     */
    void returnMonthBudgetByModifyCode(String modifyCode, String planCode);

    /**
     * 审批通过，退回减少的预算金额
     * @param activityPlanBudgets 原预算信息
     * @param budgetModifyList 变更后预算信息
     */
    void passReturnMonthBudgetByModifyCode(List<ActivityPlanBudget> activityPlanBudgets, List<ActivityPlanBudgetModify> budgetModifyList);

}
