package com.biz.crm.tpm.business.activity.plan.local.modify.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanModifyFieldValue;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import org.springframework.data.domain.Pageable;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * 活动方案明细变更接口
 * @author wanghaojia
 * @date 2022/12/6 14:21
 */
public interface ActivityPlanItemModifyService extends MnPageCacheService<ActivityPlanItemModifyVo, ActivityPlanItemModifyDto> {

    Page<ActivityPlanItemModifyVo> findByConditions(Pageable pageable, ActivityPlanItemModifyDto dto);

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    List<ActivityPlanBudgetSumVo> findBudgetCacheSumList(String cacheKey);

    /**
     * 保存活动方案明细数据-默认走校验逻辑
     *
     * @param itemCacheList 活动方案明细数据
     */
    void saveActivityPlanItemList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemCacheList, Map<String, ActivityPlanItemDto> itemMap);

    /**
     * 保存活动方案明细数据
     *
     * @param itemCacheList  活动方案明细数据
     * @param createValidate 是否走校验逻辑
     */
    void saveActivityPlanItemList(ActivityPlanModify entity,boolean update,List<ActivityPlanItemModifyDto> itemCacheList, Map<String, ActivityPlanItemDto> itemMap, boolean createValidate);

    /**
     * 活动方案明细新增校验逻辑
     *
     * @param dto
     * @param dtoList 活动方案明细数据
     * @param itemMap
     */
    void createValidateList(List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap);

    void createValidateList(ActivityPlanModifyDto dto, List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap);

    /**
     * 批量删除
     */
    void deleteByModifyCodes(List<String> modifyCodes);

    List<ActivityPlanModifyFieldValue> findItemModifyLFieldValueListByProcessNo(String processNo) throws InvocationTargetException, IllegalAccessException;

    Page<ActivityPlanModifyFieldValue> findItemModifyLFieldValueList(Pageable pageable, String modifyCode) throws InvocationTargetException, IllegalAccessException;
}
