package com.biz.crm.tpm.business.activity.plan.local.modify.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemTerminalModifyVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 活动方案变更门店服务
 * @author wanghaojia
 * @date 2023/4/25 09:48
 */
public interface ActivityPlanItemTerminalModifyService {

    /**
     * 保存活动方案-门店分摊数据
     */
    void saveActivityPlanItemTerminalList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemList);


    void deleteByModifyCodes(List<String> modifyCodes);


    /**
     * 清理缓存
     * @param cacheKey 缓存建
     */
    void clearCache(String cacheKey);
    /**
     * 新增行
     * @param cacheKey 缓存建
     * @param itemList 当前数据
     */
    void addItemCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> itemList);

    /**
     * 分页获取缓存数据
     * @param pageable 分页参数
     * @param dto 查询参数
     * @param cacheKey 缓存键
     */
    Page<ActivityPlanItemTerminalModifyVo> findCachePageList(Pageable pageable, ActivityPlanItemTerminalModifyDto dto, String cacheKey);

    /**
     * 复制行
     * @param cacheKey 缓存键
     * @param itemList 选中数据
     */
    void copyItemListCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> itemList);

    /**
     * 保存当前页数据
     * @param cacheKey 缓存键
     * @param saveList 当前页数据
     */
    void saveCurrentPageCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> saveList);

    /**
     * 删除缓存数据
     * @param cacheKey 缓存键
     * @param itemList 选中数据
     */
    void deleteCacheList(String cacheKey, List<ActivityPlanItemTerminalModifyDto> itemList);

    /**
     * 查询缓存键下的所有数据
     * @param cacheKey 缓存键
     */
    List<ActivityPlanItemTerminalModifyDto> findCacheList(String cacheKey);

    /**
     * 批量新增数据
     * @param cacheKey 缓存键
     * @param activityPlanItemTerminalList 要新增的数据
     */
    void saveListCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> activityPlanItemTerminalList);
    
}
