package com.biz.crm.tpm.business.activity.plan.local.modify.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyApproveSubmitDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 活动方案变更接口
 * @author wanghaojia
 * @date 2022/12/6 14:21
 */
public interface ActivityPlanModifyService {

    /**
     * 获取带调整的方案数据
     * @param pageable 分页参数
     * @param dto 查询参数
     * @return 分页数据
     */
    Page<ActivityPlanVo> findToModifyList(Pageable pageable, ActivityPlanDto dto);

    /**
     * 通过id获取活动方案变更数据
     */
    ActivityPlanModifyVo findById(String id);
    /**
     * 通过id或编码获取活动方案变更数据
     */
    ActivityPlanModifyVo findByIdOrCode(String id, String code);

    /**
     * 新增数据
     * @param cacheKey 明细缓存键
     * @param dto 实体对象
     * @return 新增结果
     */
    void create(String cacheKey, ActivityPlanModifyDto dto);

    /**
     * 提交审批
     */
    void submit(ActivityPlanModifyApproveSubmitDto dto);

    void processPass(ProcessStatusDto dto);


    void processRejectAndRecover(ProcessStatusDto dto);

    /**
     * 审批通过变更原方案
     * @param businessNo 方案变更编码
     */
    ActivityPlanModifyDto doUpdateOriginData(String businessNo);

    void passReturnMonthBudgetByModifyCode(String modifyBusinessCode);

    /**
     * 删除
     */
    void delete(List<String> ids);

    /**
     * 垂直促销人员变更任务
     */
    void verticalPersonUpdateJob();


}
