package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanBudgetModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanBudgetModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanBudgetModifyService;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanBudgetServiceImpl;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.OperateMarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.constant.BudgetLockConstant;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 活动方案-预算
 * @author wanghaojia
 * @date 2022/12/24 14:40
 */
@Service
public class ActivityPlanBudgetModifyServiceImpl implements ActivityPlanBudgetModifyService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityPlanBudgetModifyRepository activityPlanBudgetModifyRepository;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private MarketingStrategyBudgetSdkService marketingStrategyBudgetSdkService;

    @Autowired(required = false)
    private ActivityPlanBudgetServiceImpl activityPlanBudgetService;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;


    @Override
    public Page<ActivityPlanBudgetVo> findByConditions(Pageable pageable, ActivityPlanBudgetDto dto) {
        return activityPlanBudgetRepository.findByConditions(pageable,dto);
    }

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param itemDtoList  活动方案关联预算数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityPlanBudgetList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemDtoList) {
        Map<String, List<ActivityPlanBudget>> oldMap = Maps.newHashMap();
        if (update){
//            List<ActivityPlanBudget> oldList = activityPlanBudgetRepository.listByPlanCode(entity.getPlanCode());
//            oldMap = oldList.stream().collect(Collectors.toMap(item -> {
//                return item.getPlanItemCode() + item.getMonthBudgetCode() + item.getRelatePlanItemCode() + item.getRelateStrategyItemCode();
//            }, Function.identity()));
            //直接物理删除新建吧。
            activityPlanBudgetModifyRepository.deletePhysicalByModifyBusinessCode(entity.getModifyBusinessCode());
        }
        for (ActivityPlanItemModifyDto itemDto : itemDtoList) {
            if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                itemDto.getBudgetShares().forEach(item -> {
                    item.setPlanItemCode(itemDto.getPlanItemCode());
                    item.setPlanCode(itemDto.getPlanCode());
                    item.setModifyBusinessCode(entity.getModifyBusinessCode());
                });
            }
        }
        List<ActivityPlanBudgetModifyDto> budgetDtoList = itemDtoList.stream().map(ActivityPlanItemModifyDto::getBudgetShares).filter(Objects::nonNull)
                .flatMap(Collection::stream).collect(Collectors.toList());
        List<ActivityPlanBudgetModify> list = (List<ActivityPlanBudgetModify>) nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList,ActivityPlanBudgetModifyDto.class, ActivityPlanBudgetModify.class,HashSet.class,ArrayList.class);

        List<ActivityPlanBudgetModify> saveList = Lists.newArrayList();
        List<ActivityPlanBudgetModify> updateList = Lists.newArrayList();
        for (ActivityPlanBudgetModify item : list) {
//            String key = item.getPlanItemCode() + item.getMonthBudgetCode() + item.getRelatePlanItemCode() + item.getRelateStrategyItemCode();
//            if (oldMap.containsKey(key)){
//                item.setId(oldMap.get(key).getId());
//                updateList.add(item);
//                oldMap.remove(key);
//            }else{
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
//            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityPlanBudgetModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityPlanBudgetModifyRepository.updateBatchById(updateList);
        }
//        if (oldMap.size() > 0){
//            //待删除的数据
//            List<String> deleteIds = oldMap.values().stream().map(ActivityPlanBudget::getId).collect(Collectors.toList());
//            activityPlanBudgetRepository.deleteByIds(deleteIds);
//        }
    }

    @Override
    public void deleteByModifyCodes(List<String> planCodes) {
        activityPlanBudgetModifyRepository.deleteByModifyBusinessCodes(planCodes);
    }

    @Override
    public void useMonthBudgetByModifyCode(String modifyCode, String planCode, boolean doSave) {
        List<ActivityPlanBudgetModifyDto> modifyItemBudgetList = activityPlanBudgetModifyRepository.listDtoByModifyCodeList(Lists.newArrayList(modifyCode));
        useMonthBudget(modifyItemBudgetList,planCode,doSave);
    }

    @Override
    public void useMonthBudget(List<ActivityPlanBudgetModifyDto> modifyItemBudgetList,String planCode,boolean doSave) {
        List<ActivityPlanBudget> originBudgetList = activityPlanBudgetRepository.listByPlanCode(planCode);
        //这里只查需要占用的数据，及变更后比变更前多的金额
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream()
                .filter(item -> null != item.getUseAmount())
                .collect(Collectors.toMap(item -> {
            //占用类型+方案明细编码+月度预算编码，    应该能确定唯一了吧
            return item.getOccupyType() + item.getPlanItemCode() + item.getMonthBudgetCode();
        }, ActivityPlanBudget::getUseAmount));

        Map<String,BigDecimal> looseAmountMap = Maps.newHashMap();

        List<OperateMarketingStrategyBudgetDto> strategyOperateList = Lists.newArrayList();
        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = Lists.newArrayList();

        //先统计一遍宽限金额
        for (ActivityPlanBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            String key = budgetShareModify.getOccupyType() + budgetShareModify.getPlanItemCode() + budgetShareModify.getMonthBudgetCode();
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) > 0){
                continue;//金额变大要扣减，不做宽限
            }
            //不变或者是要退
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelateStrategyItemCode())){
                String looseAmountKey = budgetShareModify.getRelateStrategyItemCode() + budgetShareModify.getMonthBudgetCode();
                looseAmountMap.put(looseAmountKey,looseAmountMap.getOrDefault(looseAmountKey,BigDecimal.ZERO).add(originUseAmount.subtract(budgetShareModify.getUseAmount())));
            }
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())){
                String looseAmountKey = budgetShareModify.getMonthBudgetCode();
                looseAmountMap.put(looseAmountKey,looseAmountMap.getOrDefault(looseAmountKey,BigDecimal.ZERO).add(originUseAmount.subtract(budgetShareModify.getUseAmount())));
            }
            if (ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelatePlanItemCode())){
                String looseAmountKey = budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
                looseAmountMap.put(looseAmountKey,looseAmountMap.getOrDefault(looseAmountKey,BigDecimal.ZERO).add(originUseAmount.subtract(budgetShareModify.getUseAmount())));
            }
        }


        for (ActivityPlanBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            String key = budgetShareModify.getOccupyType() + budgetShareModify.getPlanItemCode() + budgetShareModify.getMonthBudgetCode();
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0){
                //不变或者是要退
                continue;
            }

            BigDecimal useAmount = budgetShareModify.getUseAmount().subtract(originUseAmount);
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelateStrategyItemCode())){
                OperateMarketingStrategyBudgetDto operateBudgetDto = new OperateMarketingStrategyBudgetDto() {{
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setStrategyCode(budgetShareModify.getRelateStrategyCode());
                    this.setStrategyItemCode(budgetShareModify.getRelateStrategyItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(useAmount);
                    this.setDoSave(doSave);
                }};
                strategyOperateList.add(operateBudgetDto);
            }

            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())){
                OperateMonthBudgetDto operateBudgetDto = new OperateMonthBudgetDto() {{
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(useAmount);
                    this.setDoSave(doSave);
                }};
                budgetOperateList.add(operateBudgetDto);
            }

            if (ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelatePlanItemCode())){
                OperateActivityPlanBudgetDto operateBudgetDto = new OperateActivityPlanBudgetDto() {{
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(useAmount);
                    this.setDoSave(doSave);
                }};
                planBudgetOperateList.add(operateBudgetDto);
            }
        }
        if (!CollectionUtils.isEmpty(strategyOperateList)){
            Set<String> monthBudgetCodeSet = strategyOperateList.stream().map(OperateMarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
            try {
                Validate.isTrue(monthBudgetLockService.lock(new ArrayList<>(monthBudgetCodeSet), TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME), "预算加锁失败，请稍后重试");
                marketingStrategyBudgetSdkService.operateAmount(strategyOperateList,looseAmountMap);
            } finally {
                monthBudgetLockService.unLock(new ArrayList<>(monthBudgetCodeSet));
            }
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            Set<String> monthBudgetCodeSet = budgetOperateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
            try {
                Validate.isTrue(monthBudgetLockService.lock(new ArrayList<>(monthBudgetCodeSet), TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME), "预算加锁失败，请稍后重试");
                monthBudgetService.operateBudget(budgetOperateList,looseAmountMap);
            } finally {
                monthBudgetLockService.unLock(new ArrayList<>(monthBudgetCodeSet));
            }
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            Set<String> monthBudgetCodeSet = planBudgetOperateList.stream().map(OperateActivityPlanBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
            try {
                Validate.isTrue(monthBudgetLockService.lock(new ArrayList<>(monthBudgetCodeSet), TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME), "预算加锁失败，请稍后重试");
                activityPlanBudgetService.operateBudget(planBudgetOperateList,looseAmountMap);
            } finally {
                monthBudgetLockService.unLock(new ArrayList<>(monthBudgetCodeSet));
            }
        }
    }

    @Override
    public void returnMonthBudgetByModifyCode(String modifyCode,String planCode) {
        List<ActivityPlanBudgetModify> modifyItemBudgetList = activityPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList(modifyCode));
        List<ActivityPlanBudget> originBudgetList = activityPlanBudgetRepository.listByPlanCode(planCode);
        //这里只查需要占用的数据，及变更后比变更前多的金额
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> {
            //占用类型+方案明细编码+关联策略编码+关联总部方案明细编码+月度预算编码，    应该能确定唯一了吧
            return item.getOccupyType() + item.getPlanItemCode() +item.getRelateStrategyItemCode() + item.getRelatePlanItemCode() + item.getMonthBudgetCode();
        }, ActivityPlanBudget::getUseAmount));

        List<OperateMarketingStrategyBudgetDto> strategyOperateList = Lists.newArrayList();
        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = Lists.newArrayList();
        for (ActivityPlanBudgetModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            String key = budgetShareModify.getOccupyType() + budgetShareModify.getPlanItemCode() +budgetShareModify.getRelateStrategyItemCode() + budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0){
                //不变或者是要退
                continue;
            }

            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelateStrategyItemCode())){
                strategyOperateList.add( new OperateMarketingStrategyBudgetDto() {{
                                             this.setBusinessCode(budgetShareModify.getPlanItemCode());
                                             this.setStrategyCode(budgetShareModify.getRelateStrategyCode());
                                             this.setStrategyItemCode(budgetShareModify.getRelateStrategyItemCode());
                                             this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                                             this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                                             this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                                         }}
                );
            }

            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())){
                budgetOperateList.add(new OperateMonthBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                }});
            }

            if (ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelatePlanItemCode())){
                planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                }});
            }
        }
        if (!CollectionUtils.isEmpty(strategyOperateList)){
            marketingStrategyBudgetSdkService.operateAmount(strategyOperateList);
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanBudgetService.operateBudget(planBudgetOperateList);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void passReturnMonthBudgetByModifyCode(List<ActivityPlanBudget> originBudgetList, List<ActivityPlanBudgetModify> modifyItemBudgetList) {
        //这里只查需要占用的数据，及变更后比变更前多的金额
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream()
                .filter(item -> null != item.getUseAmount())
                .collect(Collectors.toMap(item -> {
                    //占用类型+方案明细编码+关联策略编码+关联总部方案明细编码+月度预算编码，    应该能确定唯一了吧
                    return item.getOccupyType() + item.getPlanItemCode() + item.getMonthBudgetCode();
                }, ActivityPlanBudget::getUseAmount));

        List<OperateMarketingStrategyBudgetDto> strategyOperateList = Lists.newArrayList();
        List<OperateMonthBudgetDto> budgetOperateList = Lists.newArrayList();
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = Lists.newArrayList();
        for (ActivityPlanBudgetModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            String key = budgetShareModify.getOccupyType() + budgetShareModify.getPlanItemCode()  + budgetShareModify.getMonthBudgetCode();
            BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) >= 0){
                //不变或者是要扣
                continue;
            }

            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelateStrategyItemCode())){
                strategyOperateList.add( new OperateMarketingStrategyBudgetDto() {{
                                             this.setBusinessCode(budgetShareModify.getPlanItemCode());
                                             this.setStrategyCode(budgetShareModify.getRelateStrategyCode());
                                             this.setStrategyItemCode(budgetShareModify.getRelateStrategyItemCode());
                                             this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                                             this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                                             this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                                         }}
                );
            }

            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())){
                budgetOperateList.add(new OperateMonthBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                }});
            }

            if (ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) &&
                    StringUtils.isNotEmpty(budgetShareModify.getRelatePlanItemCode())){
                planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){{
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                }});
            }
        }
        if (!CollectionUtils.isEmpty(strategyOperateList)){
            marketingStrategyBudgetSdkService.operateAmount(strategyOperateList);
        }
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanBudgetService.operateBudget(planBudgetOperateList);
        }
    }
}
