package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案变更分页缓存实现
 * @author wanghaojia
 * @date 2022/12/16 11:34
 */
@Component
public class ActivityPlanItemModifyPageCacheHelper extends MnPageCacheHelper<ActivityPlanItemModifyVo, ActivityPlanItemModifyDto> {


    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired(required = false)
    private ActivityPlanItemModifyRepository activityPlanItemModifyRepository;
    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public String getCacheKeyPrefix() {
        return ActivityPlanConstant.ACTIVITY_PLAN_ITEM_MODIFY_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<ActivityPlanItemModifyDto> getDtoClass() {
        return ActivityPlanItemModifyDto.class;
    }

    @Override
    public Class<ActivityPlanItemModifyVo> getVoClass() {
        return ActivityPlanItemModifyVo.class;
    }

    @Override
    public List<ActivityPlanItemModifyDto> findDtoListFromRepository(ActivityPlanItemModifyDto dto, String cacheKey) {

        if (StringUtils.isEmpty(dto.getModifyBusinessCode()) && StringUtils.isEmpty(dto.getPlanCode())){
            return Lists.newArrayList();
        }
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        String redisCacheIdKey = getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = getRedisCacheDataKey(cacheKey);

        List<ActivityPlanItemModifyDto> allDtoList = null;
        if (StringUtils.isNotEmpty(dto.getModifyBusinessCode())){
            allDtoList = activityPlanItemModifyRepository.findDtoAndAttachListByModifyCode(dto.getModifyBusinessCode());
        }else {
            List<ActivityPlanItemDto> planItemDtos = activityPlanItemRepository.findDtoAndAttachListByPlanCode(dto.getPlanCode());
            //初次调整，从活动方案里面获取
            allDtoList = Lists.newArrayList();
            for (ActivityPlanItemDto planItemDto : planItemDtos) {
                ActivityPlanItemModifyDto modifyItemDto = nebulaToolkitService.copyObjectByWhiteList(planItemDto, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class);
                if (!CollectionUtils.isEmpty(planItemDto.getBudgetShares())){
                    modifyItemDto.setBudgetShares((List<ActivityPlanBudgetModifyDto>)(List)nebulaToolkitService.copyCollectionByWhiteList(planItemDto.getBudgetShares(), ActivityPlanBudgetDto.class, ActivityPlanBudgetModifyDto.class,HashSet.class,ArrayList.class));
                }
                allDtoList.add(modifyItemDto);
            }
        }

        allDtoList.sort(Comparator.comparing(ActivityPlanItemModifyDto::getPlanItemCode));
        Map<String, List<ActivityPlanItemModifyDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemModifyDto::getTemplateConfigCode));
        for (Map.Entry<String, List<ActivityPlanItemModifyDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode,entry.getKey());

            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode,entry.getKey());
            Map<Object, ActivityPlanItemModifyDto> newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            redisService.lPushAll(thisRedisIdCacheKey, this.getExpireTime(),  entry.getValue().stream().map(this::getDtoKey).toArray());
            redisTemplate.opsForHash().putAll(thisRedisDataCacheKey, newItemMap);
            redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }

        return allMap.get(templateCode);
    }

    @Override
    public boolean initToCacheFromRepository() {
        return false;
    }

    @Override
    public List<ActivityPlanItemModifyDto> newItem(String cacheKey, List<ActivityPlanItemModifyDto> itemList) {
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        ActivityPlanItemModifyDto newItem = new ActivityPlanItemModifyDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList(newItem);
    }

    @Override
    public List<ActivityPlanItemModifyDto> copyItem(String cacheKey, List<ActivityPlanItemModifyDto> itemList) {
        List<ActivityPlanItemModifyDto> newItemList = (List<ActivityPlanItemModifyDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItemModifyDto.class, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class);
        for (ActivityPlanItemModifyDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setPlanItemCode(null);
        }
        return newItemList;
    }


    @Override
    public void updateItem(String cacheKey, List<ActivityPlanItemModifyDto> itemList) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes){
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
            String businessUnitCode = servletRequestAttributes.getRequest().getParameter("businessUnitCode");

            if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)){
                for (ActivityPlanItemModifyDto itemDto : itemList) {
                    if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                        //垂直选择预算逻辑处理
                        BigDecimal headFeeAmount = BigDecimal.ZERO;
                        BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
                        BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;

                        Set<String> headMonthBudgetCodeSet = Sets.newHashSet();
                        Set<String> regionAutomaticMonthBudgetCodeSet = Sets.newHashSet();
                        Set<String> regionReferendumMonthBudgetCodeSet = Sets.newHashSet();

                        Set<String> headBudgetItemCodeSet = Sets.newHashSet();
                        Set<String> regionAutomaticBudgetItemCodeSet = Sets.newHashSet();
                        Set<String> regionReferendumBudgetItemCodeSet = Sets.newHashSet();

                        Set<String> headBudgetItemNameSet = Sets.newHashSet();
                        Set<String> regionAutomaticBudgetItemNameSet = Sets.newHashSet();
                        Set<String> regionReferendumBudgetItemNameSet = Sets.newHashSet();

                        for (ActivityPlanBudgetModifyDto budgetDto : itemDto.getBudgetShares()) {
                            if(StringUtils.isEmpty(budgetDto.getFeeBelongCode())){
                                //没有费用归口不处理
                                continue;
                            }
                            if (StringUtils.isNotEmpty(budgetDto.getUseAmountStr())){
                                NumberStringDealUtil.validateNumberStrAndSet(budgetDto.getUseAmountStr(),"本次使用预算金额",false,budgetDto::setUseAmount,BigDecimal.class);

                                if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //总部预算
                                    headFeeAmount = headFeeAmount.add(budgetDto.getUseAmount());
                                }else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //大区自投预算
                                    regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(budgetDto.getUseAmount());
                                }else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //大区公投预算
                                    regionReferendumFeeAmount = regionReferendumFeeAmount.add(budgetDto.getUseAmount());
                                }
                            }


                            if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())){
                                //总部预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    headMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    headBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    headBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())){
                                //大区自投预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    regionAutomaticMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    regionAutomaticBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    regionAutomaticBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())){
                                //大区公投预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    regionReferendumMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    regionReferendumBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    regionReferendumBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }


                        }
                        itemDto.setHeadFeeAmount(headFeeAmount);
                        itemDto.setHeadFeeAmountStr(headFeeAmount.toString());
                        itemDto.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
                        itemDto.setRegionAutomaticFeeAmountStr(regionAutomaticFeeAmount.toString());
                        itemDto.setRegionReferendumFeeAmount(regionReferendumFeeAmount);
                        itemDto.setRegionReferendumFeeAmountStr(regionReferendumFeeAmount.toString());

                        itemDto.setHeadMonthBudgetCode(String.join(",",headMonthBudgetCodeSet));
                        itemDto.setRegionAutomaticMonthBudgetCode(String.join(",",regionAutomaticMonthBudgetCodeSet));
                        itemDto.setRegionReferendumMonthBudgetCode(String.join(",",regionReferendumMonthBudgetCodeSet));
                        itemDto.setHeadBudgetItemCode(String.join(",",headBudgetItemCodeSet));
                        itemDto.setRegionAutomaticBudgetItemCode(String.join(",",regionAutomaticBudgetItemCodeSet));
                        itemDto.setRegionReferendumBudgetItemCode(String.join(",",regionReferendumBudgetItemCodeSet));
                        itemDto.setHeadBudgetItemName(String.join(",",headBudgetItemNameSet));
                        itemDto.setRegionAutomaticBudgetItemName(String.join(",",regionAutomaticBudgetItemNameSet));
                        itemDto.setRegionReferendumBudgetItemName(String.join(",",regionReferendumBudgetItemNameSet));
                    }
                }
            }

        }
    }


    @Override
    public Object getDtoKey(ActivityPlanItemModifyDto activityPlanItemModifyDto) {
        return activityPlanItemModifyDto.getId();
    }

    @Override
    public String getCheckedStatus(ActivityPlanItemModifyDto activityPlanItemModifyDto) {
        return activityPlanItemModifyDto.getChecked();
    }

    @Override
    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        return redisCacheInitKey.replace(templateCode,"");//要去掉模板编码，不然会重复初始化
    }

}
