package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemModifyService;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanModifyFieldValue;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanSapAmountEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.event.ActivityPlanSapAmountListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQueryHeadSchemeForecastListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.dto.ActivityPlanQueryHeadSchemeForecastDto;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQueryHeadSchemeForecastResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQueryHeadSchemeForecastVo;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanSapAmountResponse;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案明细变更接口
 * @author wanghaojia
 * @date 2022/12/6 14:21
 */
@Slf4j
@Service
public class ActivityPlanItemModifyServiceImpl  extends MnPageCacheServiceImpl<ActivityPlanItemModifyVo, ActivityPlanItemModifyDto> implements ActivityPlanItemModifyService {

    @Autowired(required = false)
    private ActivityPlanItemModifyRepository activityPlanItemModifyRepository;


    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    
    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    /**
     * 活动模板服务
     */
    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    /**
     * 销量任务服务
     */
    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ProcessBusinessMappingService processBusinessMappingService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityPlanItemModifyVo> findByConditions(Pageable pageable, ActivityPlanItemModifyDto dto) {
        return activityPlanItemModifyRepository.findByConditions(pageable,dto);
    }

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @Override
    public List<ActivityPlanBudgetSumVo> findBudgetCacheSumList(String cacheKey) {
        List<ActivityPlanItemModifyDto> itemList = this.findCacheList(cacheKey);
        Map<String, ActivityPlanBudgetSumVo> budgetSumVoMap = Maps.newHashMap();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (ActivityPlanItemModifyDto item : itemList) {
            if (StringUtils.isNotEmpty(item.getHeadMonthBudgetCode())){
                //预算不为空才处理
                ActivityPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getHeadMonthBudgetCode(), (key) -> new ActivityPlanBudgetSumVo() {{
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getHeadMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getHeadBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getHeadBudgetItemName());
                if (null != item.getHeadFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getHeadFeeAmountStr().trim())));
                    }catch (Exception e){
                        log.error("获取活动方案明细预算汇总时，预算金额有误！");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
            if (StringUtils.isNotEmpty(item.getMonthBudgetCode())){
                //预算不为空才处理
                ActivityPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getMonthBudgetCode(), (key) -> new ActivityPlanBudgetSumVo() {{
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getBudgetItemName());
                if (null != item.getDepartmentFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getDepartmentFeeAmountStr().trim())));
                    }catch (Exception e){
                        log.error("获取活动方案明细预算汇总时，预算金额有误！");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
        }
        if (feeBudgetCodeSet.size() > 0){
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(feeBudgetCodeList, null);
            if (null != budgetVos){
                for (MonthBudgetVo budgetVo : budgetVos) {
                    ActivityPlanBudgetSumVo budgetSumVo = budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                    budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                    budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                    budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                    budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                    budgetSumVo.setOrgCode(budgetVo.getOrgCode());
                    budgetSumVo.setOrgName(budgetVo.getOrgName());
                    if (null != budgetVo.getAccumulatedAvailableBalance()){
                        budgetSumVo.setAccumulatedAvailableBalance(budgetVo.getAccumulatedAvailableBalance());
                    }
                    if (null != budgetVo.getControlBalanceAmount()){
                        budgetSumVo.setControlBalanceAmount(budgetVo.getControlBalanceAmount());
                    }
                }
            }
        }
        List<ActivityPlanBudgetSumVo> budgetSumList = new ArrayList<>(budgetSumVoMap.values());
        return budgetSumList;
    }

    /**
     * 保存活动方案明细数据-默认走校验逻辑
     *
     * @param itemCacheList 活动方案明细数据
     */
    @Override
    public void saveActivityPlanItemList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemCacheList,Map<String, ActivityPlanItemDto> itemMap) {
        saveActivityPlanItemList(entity,update,itemCacheList, itemMap,true);
    }

    /**
     * 保存活动方案明细数据
     *
     * @param itemCacheList  活动方案明细数据
     * @param createValidate 是否走校验逻辑
     */
    @Override
    public void saveActivityPlanItemList(ActivityPlanModify entity,boolean update,List<ActivityPlanItemModifyDto> itemCacheList,Map<String, ActivityPlanItemDto> itemMap, boolean createValidate) {
        if (createValidate) {
            createValidateList(itemCacheList,itemMap);
        }
        Map<String, ActivityPlanItemModify> oldMap = Maps.newHashMap();
        if (update){
            List<ActivityPlanItemModify> oldList = activityPlanItemModifyRepository.findListByModifyBusinessCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityPlanItemModify::getId, Function.identity()));
        }
        List<ActivityPlanItemModify> saveList = Lists.newArrayList();
        List<ActivityPlanItemModify> updateList = Lists.newArrayList();
        Map<String,ActivityPlanItemModifyDto> dtoMap = Maps.newHashMap();
        for (ActivityPlanItemModifyDto item : itemCacheList) {
            dtoMap.put(item.getId(),item);
            item.setPlanCode(entity.getPlanCode());
            if (oldMap.containsKey(item.getId())){
                ActivityPlanItemModify oldItemEntity = oldMap.get(item.getId());
                item.setPlanItemCode(oldItemEntity.getPlanItemCode());
                ActivityPlanItemModify itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityPlanItemModify.class, HashSet.class, ArrayList.class);
                updateList.add(itemEntity);
                oldMap.remove(item.getId());
            }else{
                ActivityPlanItemModify itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityPlanItemModify.class, HashSet.class, ArrayList.class);
                itemEntity.setPlanCode(entity.getPlanCode());
                itemEntity.setModifyBusinessCode(entity.getModifyBusinessCode());
                itemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                itemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                itemEntity.setTenantCode(entity.getTenantCode());
                saveList.add(itemEntity);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            // redis生成活动方案明细编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
//            String ruleCode = StringUtils.join(ActivityPlanConstant.ACTIVITY_PLAN_ITEM_RULE_CODE_PRE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
//            List<String> codeList = this.generateCodeService.generateCode(ruleCode, itemCacheList.size(), 6, 2, TimeUnit.DAYS);
//            Iterator<String> codeIterator = codeList.iterator();
            for (ActivityPlanItemModify activityPlanItem : saveList) {
//                activityPlanItem.setPlanItemCode(codeIterator.next());
                ActivityPlanItemModifyDto dto = dtoMap.get(activityPlanItem.getId());
                dto.setPlanItemCode(activityPlanItem.getPlanItemCode());
                activityPlanItem.setId(null);
            }
            activityPlanItemModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityPlanItemModifyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0){
            //待删除的数据
            activityPlanItemModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }


    /**
     * 营销策略明细新增校验逻辑
     * @param dtoList 营销策略明细数据
     * @param itemMap
     */
    @Override
    public void createValidateList(List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap) {
        createValidateList(new ActivityPlanModifyDto(),dtoList,itemMap);
    }

    /**
     * 营销策略明细新增校验逻辑
     *
     * @param dtoList 营销策略明细数据
     */
    @Override
    public void createValidateList(ActivityPlanModifyDto planDto, List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap) {
        if (CollectionUtils.isEmpty(dtoList)){
            return;
        }
        //是否必填从模板上获取，这里再做下主要字段的必填校验
        Set<String> templateConfigCodeSet = Sets.newHashSet();
        for (ActivityPlanItemModifyDto dto : dtoList) {
            Validate.notBlank(dto.getTemplateConfigCode(),"活动方案明细模板不能为空！");
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
        }
        List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(Lists.newArrayList(templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()){
            throw new RuntimeException("活动方案明细模板数据有误！");
        }
        Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<ActivityPlanItemModifyDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemModifyDto::getTemplateConfigCode));

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemModifyDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        for (Map.Entry<String, List<ActivityPlanItemModifyDto>> dtoEntry : dtoMap.entrySet()) {
            List<ActivityPlanItemModifyDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(dtoEntry.getKey());
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            for (ActivityPlanItemModifyDto dto : thisDtoList) {
                //后端验证必填字段
                Validate.notBlank(dto.getActivityTypeCode(),templateDetailTitleMap.getOrDefault("activityTypeCode","活动分类")+"不能为空！");
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityBeginDateStr(),"方案开始时间",true,DateUtil.DEFAULT_YEAR_MONTH_DAY,dto::setActivityBeginDate);
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityEndDateStr(),"方案结束时间",true,DateUtil.DEFAULT_YEAR_MONTH_DAY,dto::setActivityEndDate);
//                Validate.notBlank(dto.getActivityOrgCode(),templateDetailTitleMap.getOrDefault("activityOrgCode","区域编码")+"不能为空！");
//                Validate.notBlank(dto.getProductBrandCode(),templateDetailTitleMap.getOrDefault("productBrandCode","品牌编码")+"不能为空！");
                Validate.notNull(dto.getTotalFeeAmountStr(),templateDetailTitleMap.getOrDefault("totalFeeAmountStr","费用合计")+"不能为空！");
            }
            //模板验证必填字段
            for (ActivitiesTemplateConfigDetailVo configDetail : templateConfigVo.getDetails()) {
                if (null != configDetail.getRequired() && configDetail.getRequired()) {
                    if (!propertyMap.containsKey(configDetail.getField())){
                        throw new RuntimeException("模板["+templateConfigVo.getConfigName()+"]属性["+configDetail.getTitle()+"]配置有误");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(configDetail.getField());
                    if (null != propertyDescriptor){
                        for (ActivityPlanItemModifyDto dto : thisDtoList) {
                            try {
                                Object invoke = propertyDescriptor.getReadMethod().invoke(dto);
                                if (null == invoke || StringUtils.isEmpty(invoke.toString())){
                                    throw new RuntimeException("["+configDetail.getTitle()+"]不能为空！");
                                }
                            } catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException("["+configDetail.getTitle()+"]读取失败！");
                            }
                        }
                    }else{
                        throw new RuntimeException("["+configDetail.getTitle()+"]配置有误，请检查！");
                    }
                }
            }
            ObjectConvertStringUtil.convertObjectListStrProperties(dtoList,ActivityPlanItemModifyDto.class,true,templateDetailTitleMap);
        }
        verticalValidate(planDto, dtoList, itemMap);
        headquartersValidate(planDto, dtoList, itemMap);
    }

    /**
     * 垂直的校验逻辑
     */
    private void verticalValidate(ActivityPlanModifyDto planDto, List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap){
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())){
            return;
        }
        //1、促销活动：活动/订单结束日期不能早于当前日期，活动时间已结束不允许变更活动
        //1、促销活动：已经开始的活动，活动/订单开始日期不允许变更
        //1、变更后的活动结束日期不能早于当前日期

        List<String> actFormCodes = dtoList.stream().map(ActivityPlanItemModifyDto::getActivityFormCode).distinct().collect(Collectors.toList());
        Map<String, List<ActivityFormExeDetailVo>> formMap = this.activityFormService.findPushSap(actFormCodes);

        Date nowDate = new Date();
        List<ActivityPlanItemModifyDto> validateSapList = Lists.newArrayList();
        for (ActivityPlanItemModifyDto itemDto : dtoList) {
            ActivityPlanItemDto activityPlanItem = itemMap.get(itemDto.getPlanItemCode());
            if (activityPlanItem.getActivityEndDate().before(nowDate)){
                throw new RuntimeException("["+activityPlanItem.getPlanItemCode()+"]活动时间已结束不允许变更活动");
            }
//            活动/订单结束日期不能早于当前日期
            if (itemDto.getActivityEndDate().before(nowDate) || (null != itemDto.getOrderEndDate() && itemDto.getOrderEndDate().before(nowDate))){
                throw new RuntimeException("["+activityPlanItem.getPlanItemCode()+"]活动/订单结束日期不能早于当前日期");
            }
            if (activityPlanItem.getActivityBeginDate().after(nowDate)){
                if (itemDto.getActivityBeginDate().before(nowDate) ||
                        (null != itemDto.getOrderBeginDate() && itemDto.getOrderBeginDate().before(nowDate))){
                    throw new RuntimeException("["+activityPlanItem.getPlanItemCode()+"]活动还未开始，变更开始日期时，开始日期不能早于当前日期");
                }
            }else{
//                已经开始的活动，活动/订单开始日期不允许变更
                if (activityPlanItem.getActivityBeginDate().compareTo(itemDto.getActivityBeginDate()) != 0 ||
                        (null != activityPlanItem.getOrderBeginDate() && null != itemDto.getOrderBeginDate() && activityPlanItem.getOrderBeginDate().compareTo(itemDto.getOrderBeginDate()) != 0)){
                    throw new RuntimeException("["+activityPlanItem.getPlanItemCode()+"]已经开始，活动/订单开始日期不允许变更");
                }
            }

            //促销活动，查询SAP活动发生量，不允许少于发生量,
            // 是否共用选择“是”时，不允许变更门店共用量和共用金额,
            // 追加量时，如果原活动量还有剩余，则先关闭原活动，再新增活动

            //是推送sap的活动,且是共用
            if (formMap.containsKey(itemDto.getActivityFormCode())) {
                //根据方案明细编码，获取关联的细案明细
                validateSapList.add(itemDto);
            }
            if (StringUtils.isNotBlank(itemDto.getPublicOrNot())
                    && BooleanEnum.TRUE.getCapital().equals(itemDto.getPublicOrNot())){
                if (Optional.ofNullable(activityPlanItem.getStoreUtility()).orElse(0).compareTo(Optional.ofNullable(itemDto.getStoreUtility()).orElse(0)) != 0){
                    throw new RuntimeException("["+activityPlanItem.getPlanItemCode()+"]是否共用为“是”，不允许变更门店共用量");
                }
                if (Optional.ofNullable(activityPlanItem.getStorePublicAmount()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(itemDto.getStorePublicAmount()).orElse(BigDecimal.ZERO)) != 0){
                    throw new RuntimeException("["+activityPlanItem.getPlanItemCode()+"]是否共用为“是”，不允许变更门店共用金额");
                }
            }
        }

        //促销活动校验SAP活动发生量
        if (!CollectionUtils.isEmpty(validateSapList)){
            List<String> validateSapPlanItemCodeList = validateSapList.stream().map(ActivityPlanItemModifyDto::getPlanItemCode).collect(Collectors.toList());
            ActivityPlanSapAmountEventDto sapAmountEventDto = new ActivityPlanSapAmountEventDto();
            sapAmountEventDto.setPlanItemCodeList(validateSapPlanItemCodeList);
            SerializableBiConsumer<ActivityPlanSapAmountListener, ActivityPlanSapAmountEventDto> getSapAmountByDetailItemNos =
                    ActivityPlanSapAmountListener::getSapAmountByDetailItemNos;
            ActivityPlanSapAmountResponse sapAmountResponse = (ActivityPlanSapAmountResponse) this.nebulaNetEventClient.directPublish(sapAmountEventDto,
                    ActivityPlanSapAmountListener.class, getSapAmountByDetailItemNos);
            Map<String, BigDecimal> sapMap = sapAmountResponse.getAmountMap();
            for (ActivityPlanItemModifyDto itemDto : validateSapList) {
                ActivityPlanItemDto activityPlanItem = itemMap.get(itemDto.getPlanItemCode());
                //调减：不允许少于发生量
                //追加量时，如果原活动量还有剩余，则先关闭原活动，再新增活动
                if (Optional.ofNullable(itemDto.getPeriodPromotionalNumber()).orElse(0).compareTo(Optional.ofNullable(activityPlanItem.getPeriodPromotionalNumber()).orElse(0)) <= 0){
                    BigDecimal sapAmount = sapMap.get(itemDto.getPlanItemCode());
                    if (new BigDecimal(Optional.ofNullable(itemDto.getPeriodPromotionalNumber()).orElse(0)).compareTo(Optional.ofNullable(sapAmount).orElse(BigDecimal.ZERO)) < 0){
                        throw new RuntimeException("["+activityPlanItem.getPlanItemCode()+"]调减不允许少于发生量");
                    }
                }else{
                    throw new RuntimeException("["+activityPlanItem.getPlanItemCode()+"]追加量时，如果原活动量还有剩余，则先关闭原活动，再新增活动");
                }
            }
        }
    }

    /**
     * 主体的校验逻辑
     */
    private void headquartersValidate(ActivityPlanModifyDto planDto, List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap){
        if (!BusinessUnitEnum.isDefaultBusinessUnit(planDto.getBusinessUnitCode())){
            return;
        }

        Set<String> budgetItemCodeSet = Sets.newHashSet();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (ActivityPlanItemModifyDto itemDto : dtoList) {
            //主体处理逻辑
            //预估费率=（总部承担金额+大区承担金额）/预估销售额
            if (null != itemDto.getSalesAmount() && BigDecimal.ZERO.compareTo(itemDto.getSalesAmount()) != 0) {
                BigDecimal sumFeeAmount = BigDecimal.ZERO;
                if (null != itemDto.getHeadFeeAmount()) {
                    sumFeeAmount = sumFeeAmount.add(itemDto.getHeadFeeAmount());
                }
                if (null != itemDto.getDepartmentFeeAmount()) {
                    sumFeeAmount = sumFeeAmount.add(itemDto.getDepartmentFeeAmount());
                }
                itemDto.setFeeRate(sumFeeAmount.divide(itemDto.getSalesAmount(), 4, RoundingMode.HALF_DOWN));
            }
            if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())){
                budgetItemCodeSet.add(itemDto.getHeadBudgetItemCode());
                feeBudgetCodeSet.add(itemDto.getHeadMonthBudgetCode());
            }
            if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())){
                budgetItemCodeSet.add(itemDto.getBudgetItemCode());
                feeBudgetCodeSet.add(itemDto.getMonthBudgetCode());
            }
        }
        validateCrossMonth:
        {
            if (CollectionUtils.isEmpty(feeBudgetCodeSet)) {
                break validateCrossMonth;
            }
            List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(Lists.newArrayList(budgetItemCodeSet));
            if (CollectionUtils.isEmpty(budgetItemVos)) {
                throw new RuntimeException("预算项目查询失败！");
            }
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(feeBudgetCodeList, null);
            Map<String, MonthBudgetVo> budgetVoMap = budgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));

            Map<String, BudgetItemVo> budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            Calendar calendar = Calendar.getInstance();
            for (ActivityPlanItemModifyDto item : dtoList) {
                String allowAcrossMonth = BooleanEnum.FALSE.getCapital();//默认不允许跨月
                String headYearMonth = null;
                String yearMonth = null;
                if (StringUtils.isNotEmpty(item.getHeadMonthBudgetCode())) {
                    BudgetItemVo budgetItemVo = budgetItemMap.get(item.getHeadBudgetItemCode());
                    if (null == budgetItemVo) {
                        throw new RuntimeException("预算项目[" + item.getHeadBudgetItemCode() + "]有误！");
                    }
                    if (BooleanEnum.TRUE.getCapital().equals(budgetItemVo.getAllowCrossMonth())) {
                        allowAcrossMonth = BooleanEnum.TRUE.getCapital();
                    }
                    MonthBudgetVo monthBudgetVo = budgetVoMap.get(item.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("总部预算[" + item.getHeadMonthBudgetCode() + "]有误！");
                    }
                    headYearMonth = monthBudgetVo.getYearMonthLy();
                }
                if (StringUtils.isNotEmpty(item.getMonthBudgetCode())) {
                    BudgetItemVo budgetItemVo = budgetItemMap.get(item.getBudgetItemCode());
                    if (null == budgetItemVo) {
                        throw new RuntimeException("预算项目[" + item.getBudgetItemCode() + "]有误！");
                    }
                    if (BooleanEnum.TRUE.getCapital().equals(budgetItemVo.getAllowCrossMonth())) {
                        allowAcrossMonth = BooleanEnum.TRUE.getCapital();
                    }
                    MonthBudgetVo monthBudgetVo = budgetVoMap.get(item.getMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("大区预算[" + item.getHeadMonthBudgetCode() + "]有误！");
                    }
                    yearMonth = monthBudgetVo.getYearMonthLy();
                }
                if (!BooleanEnum.FALSE.getCapital().equals(allowAcrossMonth)) {
                    continue;
                }
                if (StringUtils.isNotEmpty(headYearMonth)) {
                    //此预算项目不允许跨月使用，请修改策略开始时间、策略结束时间！
                    int year = Integer.parseInt(headYearMonth.substring(0, 4));
                    int month = Integer.parseInt(headYearMonth.substring(5)) - 1;
                    calendar.setTime(item.getActivityBeginDate());
                    if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)) {
                        throw new RuntimeException("预算项目[" + item.getBudgetItemCode() + "]不允许跨月使用，请修改活动开始时间、活动结束时间！");
                    }
                    calendar.setTime(item.getActivityEndDate());
                    if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)) {
                        throw new RuntimeException("预算项目[" + item.getBudgetItemCode() + "]不允许跨月使用，请修改活动开始时间、活动结束时间！");
                    }
                }
                if (StringUtils.isNotEmpty(yearMonth)) {
                    //此预算项目不允许跨月使用，请修改策略开始时间、策略结束时间！
                    int year = Integer.parseInt(yearMonth.substring(0, 4));
                    int month = Integer.parseInt(yearMonth.substring(5)) - 1;
                    calendar.setTime(item.getActivityBeginDate());
                    if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)) {
                        throw new RuntimeException("预算项目[" + item.getBudgetItemCode() + "]不允许跨月使用，请修改活动开始时间、活动结束时间！");
                    }
                    calendar.setTime(item.getActivityEndDate());
                    if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)) {
                        throw new RuntimeException("预算项目[" + item.getBudgetItemCode() + "]不允许跨月使用，请修改活动开始时间、活动结束时间！");
                    }
                }
            }
        }


        for (ActivityPlanItemModifyDto itemDto : dtoList) {
            ActivityPlanItemDto activityPlanItem = itemMap.get(itemDto.getPlanItemCode());
            if (itemDto.getActivityBeginDate().compareTo(activityPlanItem.getActivityBeginDate()) > 0){
                throw new RuntimeException("活动开始时间只能提前！");
            }
            if (itemDto.getActivityEndDate().compareTo(activityPlanItem.getActivityEndDate()) < 0){
                throw new RuntimeException("活动开始结束只能延后！");
            }

            if (null != itemDto.getUsedHeadFeeAmount() && itemDto.getUsedHeadFeeAmount().compareTo(BigDecimal.ZERO) > 0){
                if (null == itemDto.getHeadFeeAmount() || itemDto.getHeadFeeAmount().compareTo(itemDto.getUsedHeadFeeAmount()) < 0){
                    throw new RuntimeException("总部承担金额["+itemDto.getHeadFeeAmount()+"]不能小于已发生金额["+itemDto.getUsedHeadFeeAmount()+"]");
                }
            }
            if (null != itemDto.getUsedDepartmentFeeAmount() && itemDto.getUsedDepartmentFeeAmount().compareTo(BigDecimal.ZERO) > 0){
                if (null == itemDto.getDepartmentFeeAmount() || itemDto.getDepartmentFeeAmount().compareTo(itemDto.getUsedDepartmentFeeAmount()) < 0){
                    throw new RuntimeException("大区承担金额["+itemDto.getDepartmentFeeAmount()+"]不能小于已发生金额["+itemDto.getUsedDepartmentFeeAmount()+"]");
                }
            }
            if (null != itemDto.getUsedCustomerFeeAmount() && itemDto.getUsedCustomerFeeAmount().compareTo(BigDecimal.ZERO) > 0){
                if (null == itemDto.getCustomerFeeAmount() || itemDto.getCustomerFeeAmount().compareTo(itemDto.getUsedCustomerFeeAmount()) < 0){
                    throw new RuntimeException("客户承担金额["+itemDto.getCustomerFeeAmount()+"]不能小于已发生金额["+itemDto.getUsedCustomerFeeAmount()+"]");
                }
            }
            if (null != activityPlanItem.getUsedHeadFeeAmount() && activityPlanItem.getUsedHeadFeeAmount().compareTo(BigDecimal.ZERO) > 0){
                if (null == itemDto.getUsedHeadFeeAmount() || itemDto.getUsedHeadFeeAmount().compareTo(activityPlanItem.getUsedHeadFeeAmount()) < 0){
                    throw new RuntimeException("总部承担金额已发生金额["+itemDto.getUsedHeadFeeAmount()+"]不能小于实际已发生金额["+activityPlanItem.getUsedHeadFeeAmount()+"]");
                }
            }
            if (null != activityPlanItem.getUsedDepartmentFeeAmount() && activityPlanItem.getUsedDepartmentFeeAmount().compareTo(BigDecimal.ZERO) > 0){
                if (null == itemDto.getUsedDepartmentFeeAmount() || itemDto.getUsedDepartmentFeeAmount().compareTo(activityPlanItem.getUsedDepartmentFeeAmount()) < 0){
                    throw new RuntimeException("大区承担金额已发生金额["+itemDto.getUsedDepartmentFeeAmount()+"]不能小于实际已发生金额["+activityPlanItem.getUsedDepartmentFeeAmount()+"]");
                }
            }
            if (null != activityPlanItem.getUsedCustomerFeeAmount() && activityPlanItem.getUsedCustomerFeeAmount().compareTo(BigDecimal.ZERO) > 0){
                if (null == itemDto.getUsedCustomerFeeAmount() || itemDto.getUsedCustomerFeeAmount().compareTo(activityPlanItem.getUsedCustomerFeeAmount()) < 0){
                    throw new RuntimeException("客户承担金额已发生金额["+itemDto.getUsedCustomerFeeAmount()+"]不能小于实际已发生金额["+activityPlanItem.getUsedCustomerFeeAmount()+"]");
                }
            }
            if (BooleanEnum.TRUE.getCapital().equals(activityPlanItem.getWholeAudit())){
                //完全结案的不允许关闭
                throw new RuntimeException("活动方案明细["+activityPlanItem.getPlanItemCode()+"]已进行预算回退，不能调整");
            }
        }


//       1038320 主体方案预测表的方案明细点击确认之后则不允许再关闭或调整该方案明细，再关闭或调整时应当做出提示【该方案明细已确认，不允许关闭或调整】
        List<String> planItemCodeList = dtoList.stream().map(ActivityPlanItemModifyDto::getPlanItemCode).collect(Collectors.toList());
        ActivityPlanQueryHeadSchemeForecastDto headSchemeForecastEventDto = new ActivityPlanQueryHeadSchemeForecastDto();
        headSchemeForecastEventDto.setPlanItemCodeList(planItemCodeList);
        SerializableBiConsumer<ActivityPlanQueryHeadSchemeForecastListener, ActivityPlanQueryHeadSchemeForecastDto> headSchemeForecastConsumer = ActivityPlanQueryHeadSchemeForecastListener::findListByConditions;
        ActivityPlanQueryHeadSchemeForecastResponse headSchemeForecastEventResponse = (ActivityPlanQueryHeadSchemeForecastResponse) nebulaNetEventClient.directPublish(headSchemeForecastEventDto, ActivityPlanQueryHeadSchemeForecastListener.class, headSchemeForecastConsumer);
        if (null != headSchemeForecastEventResponse && !CollectionUtils.isEmpty(headSchemeForecastEventResponse.getList())) {
            Map<String, ActivityPlanQueryHeadSchemeForecastVo> headSchemeForecastVoMap = headSchemeForecastEventResponse.getList().stream().collect(Collectors.toMap(ActivityPlanQueryHeadSchemeForecastVo::getSchemeItemCode, Function.identity()));
            Iterator<ActivityPlanItemModifyDto> iterator = dtoList.iterator();
            while (iterator.hasNext()){
                ActivityPlanItemModifyDto next = iterator.next();
                ActivityPlanQueryHeadSchemeForecastVo headSchemeForecastVo = headSchemeForecastVoMap.get(next.getPlanItemCode());
                if (null != headSchemeForecastVo && "2".equals(headSchemeForecastVo.getStatus())){
                    //主体方案预测表已确认
                    String errorMsg = "方案明细["+next.getPlanItemCode()+"]已确认，不允许关闭";
                    throw new RuntimeException(errorMsg);
                }
            }
        }
    }


    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)){
            return;
        }
        activityPlanItemModifyRepository.deleteByModifyCodes(modifyCodes);
    }

    @Override
    public Page<ActivityPlanModifyFieldValue> findItemModifyLFieldValueList(Pageable pageable, String modifyCode) throws InvocationTargetException, IllegalAccessException {
        Page<ActivityPlanModifyFieldValue> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        page.setTotal(0);
        page.setRecords(Lists.newArrayList());

        Pageable tempPageable = PageRequest.of(1, 999999);
        ActivityPlanItemModifyDto activityPlanItemModifyDto = new ActivityPlanItemModifyDto();
        activityPlanItemModifyDto.setModifyBusinessCode(modifyCode);
        Page<ActivityPlanItemModifyVo> itemBeforeModifyPage = findItemBeforeModifyList(tempPageable, activityPlanItemModifyDto);
        Page<ActivityPlanItemModifyVo> itemModifyPage = findByConditions(tempPageable, activityPlanItemModifyDto);
        List<ActivityPlanItemModifyVo> itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List<ActivityPlanItemModifyVo> itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty(itemBeforeModifyList)) {
            return page;
        }

        List<ActivityPlanModifyFieldValue> itemModifyLFieldValueList = findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);

        //放到缓存里面
        page.setTotal(itemModifyLFieldValueList.size());
        long start = page.offset();
        if (page.getTotal() > start) {
            long end = page.offset() + page.getSize();
            if (page.getTotal() < end) {
                end = page.getTotal();
            }
            List<ActivityPlanModifyFieldValue> recordList = itemModifyLFieldValueList.subList((int) page.offset(), (int) end);
            page.setRecords(recordList);
        }

        return page;
    }

    @Override
    public List<ActivityPlanModifyFieldValue> findItemModifyLFieldValueListByProcessNo(String processNo) throws InvocationTargetException, IllegalAccessException {
        Pageable tempPageable = PageRequest.of(1, 999999);
        List<String> businessNoList = this.findModifyBusinessNoListByProcessNo(processNo);

        ActivityPlanItemModifyDto activityPlanItemModifyDto = new ActivityPlanItemModifyDto();
        activityPlanItemModifyDto.setModifyBusinessCodeList(businessNoList);
        Page<ActivityPlanItemModifyVo> itemBeforeModifyPage = findItemBeforeModifyList(tempPageable, activityPlanItemModifyDto);
        Page<ActivityPlanItemModifyVo> itemModifyPage = findByConditions(tempPageable, activityPlanItemModifyDto);
        List<ActivityPlanItemModifyVo> itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List<ActivityPlanItemModifyVo> itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty(itemBeforeModifyList)) {
            return Lists.newArrayList();
        }

        return findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);
    }

    private List<ActivityPlanModifyFieldValue> findItemModifyLFieldValueList(List<ActivityPlanItemModifyVo> itemModifyList, List<ActivityPlanItemModifyVo> itemBeforeModifyList) throws InvocationTargetException, IllegalAccessException {
        Map<String, ActivityPlanItemModifyVo> itemModifyMap = itemModifyList.stream().collect(Collectors.toMap(ActivityPlanItemModifyVo::getPlanItemCode, Function.identity()));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemModifyVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        Map<String,String> modifyFieldMap = Maps.newHashMap();
        Field[] declaredFields = ActivityPlanItemModify.class.getDeclaredFields();
        for (Field declaredField : declaredFields) {
            ApiModelProperty modelProperty = declaredField.getDeclaredAnnotation(ApiModelProperty.class);
            if (null == modelProperty){
                continue;
            }
            modifyFieldMap.put(declaredField.getName(),modelProperty.value());
        }


        List<ActivityPlanModifyFieldValue> modifyFieldValueList = Lists.newArrayList();
        for (ActivityPlanItemModifyVo itemVo : itemBeforeModifyList) {
            ActivityPlanItemModifyVo itemModifyVo = itemModifyMap.get(itemVo.getPlanItemCode());

            for (Map.Entry<String, String> entry : modifyFieldMap.entrySet()) {
                String fieldName = entry.getKey();
                String fieldTitle = entry.getValue();
                PropertyDescriptor propertyDescriptor = propertyMap.get(fieldName);
                Object beforeFieldValue = propertyDescriptor.getReadMethod().invoke(itemVo);
                Object fieldValue = propertyDescriptor.getReadMethod().invoke(itemModifyVo);
                if (null == beforeFieldValue && null == fieldValue){
                    //变更前后都是空，跳过
                    continue;
                }

                ActivityPlanModifyFieldValue modifyFieldValue = new ActivityPlanModifyFieldValue();
                modifyFieldValue.setPlanCode(itemVo.getPlanCode());
                modifyFieldValue.setPlanItemCode(itemVo.getPlanItemCode());
                modifyFieldValue.setFieldName(fieldName);
                modifyFieldValue.setFieldTitle(fieldTitle);
                if (null != beforeFieldValue && null != fieldValue){
                    //变更前后都不为空
                    if (beforeFieldValue.equals(fieldValue)){
                        //相等，跳过
                        continue;
                    }else if (propertyDescriptor.getPropertyType() == Integer.class){
                        Integer beforeFieldValueInt = (Integer) beforeFieldValue;
                        Integer fieldValueInt = (Integer) fieldValue;
                        if (beforeFieldValueInt.compareTo(fieldValueInt) == 0){
                            continue;//相等，跳过
                        }
                    }else if (propertyDescriptor.getPropertyType() == BigDecimal.class){
                        BigDecimal beforeFieldValueBigDecimal = (BigDecimal) beforeFieldValue;
                        BigDecimal fieldValueBigDecimal = (BigDecimal) fieldValue;
                        if (beforeFieldValueBigDecimal.compareTo(fieldValueBigDecimal) == 0){
                            continue;//相等，跳过
                        }
                    }
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                }else if (null != beforeFieldValue){
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                }else {
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                }
                modifyFieldValueList.add(modifyFieldValue);
            }
        }
        return modifyFieldValueList;
    }

    /**
     * 分页查询调整前数据
     * @param dto
     * @return
     */
    public Page<ActivityPlanItemModifyVo> findItemBeforeModifyList(Pageable pageable, ActivityPlanItemModifyDto dto) {
        return activityPlanItemModifyRepository.findItemBeforeModifyList(pageable,dto);
    }

    /**
     * 根据流程编码查询变更编码
     * @param processNo 流程编码
     * @return 策略变更编码
     */
    private List<String> findModifyBusinessNoListByProcessNo(String processNo){
        //查到调整前后的数据一个一个对比吧，对比完了再分页
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(processNo);
        List<ProcessBusinessMappingVo> processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty(processBusinessMappingVoList)){
            throw new RuntimeException("流程数据有误！");
        }
        return processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
    }

}
