package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemTerminalModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemTerminalModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemTerminalModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemTerminalModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2023/4/25 09:50
 */
@Service
public class ActivityPlanItemTerminalModifyServiceImpl implements ActivityPlanItemTerminalModifyService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanItemTerminalModifyRepository activityPlanItemTerminalModifyRepository;

    @Autowired(required = false)
    private ActivityPlanItemModifyPageCacheHelper itemHelper;

    /**
     * 保存更新门店明细
     */
    @Override
    public void saveActivityPlanItemTerminalList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemList) {
        //获取缓存中的门店
        if(update){
            activityPlanItemTerminalModifyRepository.deleteByModifyBusinessCode(entity.getModifyBusinessCode());
        }

        //可能要删除终端的方案明细code
        List<ActivityPlanItemTerminalModify> allList = new ArrayList<>();
        for (ActivityPlanItemModifyDto itemDto : itemList) {
            List<ActivityPlanItemTerminalModifyDto> terminalList = itemDto.getActivityPlanItemTerminalList();
            if(!CollectionUtils.isEmpty(terminalList)){
                for (ActivityPlanItemTerminalModifyDto dto : terminalList) {
                    dto.setModifyBusinessCode(entity.getModifyBusinessCode());
                    dto.setPlanCode(entity.getPlanCode());
                    dto.setPlanItemCode(itemDto.getPlanItemCode());
                    if (null == dto.getBeginDate()){
                        dto.setBeginDate(itemDto.getActivityBeginDate());
                    }
                    if (null == dto.getEndDate()){
                        dto.setEndDate(itemDto.getActivityEndDate());
                    }
                    dto.setTenantCode(TenantUtils.getTenantCode());
                }
                List<ActivityPlanItemTerminalModify> activityPlanItemTerminals = (List<ActivityPlanItemTerminalModify>)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, ActivityPlanItemTerminalModifyDto.class, ActivityPlanItemTerminalModify.class, LinkedHashSet.class, ArrayList.class);
                allList.addAll(activityPlanItemTerminals);
            }
        }
        if(!CollectionUtils.isEmpty(allList)){
            this.activityPlanItemTerminalModifyRepository.saveBatch(allList);
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        activityPlanItemTerminalModifyRepository.deleteByModifyBusinessCode(modifyCodes);
    }

    @Override
    public void clearCache(String cacheKey) {
        String itemCacheKey = cacheKey.substring(0,cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":")+1);
        ActivityPlanItemModifyDto itemDto = itemHelper.getDtoByKey(itemCacheKey, itemId);
        if (null == itemDto){
            throw new RuntimeException("明细数据未保存，请检查");
        }
        itemDto.setActivityPlanItemTerminalList(null);
        Map<Object, ActivityPlanItemModifyDto> updateMap = Maps.newHashMap();
        updateMap.put(itemId,itemDto);
        itemHelper.doSaveItem(itemCacheKey,updateMap );
    }

    @Override
    public void addItemCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> itemList) {
        String itemCacheKey = cacheKey.substring(0,cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":")+1);
        ActivityPlanItemModifyDto itemDto = itemHelper.getDtoByKey(itemCacheKey, itemId);
        if (null == itemDto){
            throw new RuntimeException("明细数据未保存，请检查");
        }
        List<ActivityPlanItemTerminalModifyDto> itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList){
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }

        ActivityPlanItemTerminalModifyDto newItem = new ActivityPlanItemTerminalModifyDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        itemTerminalList.add(0,newItem);

        Map<Object, ActivityPlanItemModifyDto> updateMap = Maps.newHashMap();
        updateMap.put(itemId,itemDto);
        itemHelper.doSaveItem(itemCacheKey,updateMap );
    }

    @Override
    public Page<ActivityPlanItemTerminalModifyVo> findCachePageList(Pageable pageable, ActivityPlanItemTerminalModifyDto dto, String cacheKey) {
        String itemCacheKey = cacheKey.substring(0,cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":")+1);
        ActivityPlanItemModifyDto itemDto = itemHelper.getDtoByKey(itemCacheKey, itemId);
        if (null == itemDto){
            throw new RuntimeException("明细数据未保存，请检查");
        }
        Page<ActivityPlanItemTerminalModifyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        page.setTotal(0);
        page.setRecords(com.google.common.collect.Lists.newArrayList());
        List<ActivityPlanItemTerminalModifyDto> dtoList = itemDto.getActivityPlanItemTerminalList();
        if (CollectionUtils.isEmpty(dtoList)){
            return page;
        }

        //放到缓存里面
        page.setTotal(dtoList.size());
        long start = page.offset();
        if (page.getTotal() > start) {
            long end = page.offset() + page.getSize();
            if (page.getTotal() < end) {
                end = page.getTotal();
            }
            List<ActivityPlanItemTerminalModifyDto> recordDtoList = dtoList.subList((int) page.offset(), (int) end);
            List<ActivityPlanItemTerminalModifyVo> voList = (List<ActivityPlanItemTerminalModifyVo>) nebulaToolkitService.copyCollectionByWhiteList(recordDtoList, ActivityPlanItemTerminalModifyDto.class, ActivityPlanItemTerminalModifyVo.class, HashSet.class, ArrayList.class);
            page.setRecords(voList);
        }
        return page;
    }

    @Override
    public List<ActivityPlanItemTerminalModifyDto> findCacheList(String cacheKey) {
        String itemCacheKey = cacheKey.substring(0,cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":")+1);
        ActivityPlanItemModifyDto itemDto = itemHelper.getDtoByKey(itemCacheKey, itemId);
        if (null == itemDto){
            throw new RuntimeException("明细数据未保存，请检查");
        }
        return itemDto.getActivityPlanItemTerminalList();
    }

    @Override
    public void saveListCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> itemList) {
        String itemCacheKey = cacheKey.substring(0,cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":")+1);
        ActivityPlanItemModifyDto itemDto = itemHelper.getDtoByKey(itemCacheKey, itemId);
        if (null == itemDto){
            throw new RuntimeException("明细数据未保存，请检查");
        }
        List<ActivityPlanItemTerminalModifyDto> itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList){
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        List<Object> idList = itemTerminalList.stream().map(ActivityPlanItemTerminalModifyDto::getId).collect(Collectors.toList());
        List<ActivityPlanItemTerminalModifyDto> updateList = itemList.stream().filter(item -> idList.contains(item.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateList)){
            Map<String, ActivityPlanItemTerminalModifyDto> existsMap = itemTerminalList.stream().collect(Collectors.toMap(ActivityPlanItemTerminalModifyDto::getId, Function.identity()));
            for (ActivityPlanItemTerminalModifyDto terminalDto : updateList) {
                ActivityPlanItemTerminalModifyDto oldTerminalDto = existsMap.get(terminalDto);
                if (null == oldTerminalDto){
                    continue;//不应该出现
                }
                BeanUtils.copyProperties(terminalDto,oldTerminalDto);
            }
        }
        List<ActivityPlanItemTerminalModifyDto> newItemList = itemList.stream().filter(item -> !idList.contains(item.getId())).collect(Collectors.toList());
        itemTerminalList.addAll(newItemList);

        Map<Object, ActivityPlanItemModifyDto> updateMap = Maps.newHashMap();
        updateMap.put(itemId,itemDto);
        itemHelper.doSaveItem(itemCacheKey,updateMap );
    }

    @Override
    public void copyItemListCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> updateList) {
        String itemCacheKey = cacheKey.substring(0,cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":")+1);
        ActivityPlanItemModifyDto itemDto = itemHelper.getDtoByKey(itemCacheKey, itemId);
        if (null == itemDto){
            throw new RuntimeException("明细数据未保存，请检查");
        }
        List<ActivityPlanItemTerminalModifyDto> itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList){
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }

        Map<String, ActivityPlanItemTerminalModifyDto> existsMap = itemTerminalList.stream().collect(Collectors.toMap(ActivityPlanItemTerminalModifyDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalModifyDto terminalDto : updateList) {
            ActivityPlanItemTerminalModifyDto oldTerminalDto = existsMap.get(terminalDto.getId());
            if (BooleanEnum.TRUE.getNumStr().equals(terminalDto.getChecked())) {
                //选中状态，代表该行数据要复制
                ActivityPlanItemTerminalModifyDto copyTerminalDto = nebulaToolkitService.copyObjectByWhiteList(terminalDto, ActivityPlanItemTerminalModifyDto.class, HashSet.class, ArrayList.class);
                copyTerminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
                copyTerminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                copyTerminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                itemTerminalList.add(0,copyTerminalDto);
            } else {
                if (null == oldTerminalDto){
                    continue;//不应该出现
                }
                BeanUtils.copyProperties(terminalDto,oldTerminalDto);
            }
        }

        Map<Object, ActivityPlanItemModifyDto> updateMap = Maps.newHashMap();
        updateMap.put(itemId,itemDto);
        itemHelper.doSaveItem(itemCacheKey,updateMap );
    }

    @Override
    public void saveCurrentPageCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> updateList) {
        String itemCacheKey = cacheKey.substring(0,cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":")+1);
        ActivityPlanItemModifyDto itemDto = itemHelper.getDtoByKey(itemCacheKey, itemId);
        if (null == itemDto){
            throw new RuntimeException("明细数据未保存，请检查");
        }
        List<ActivityPlanItemTerminalModifyDto> itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList){
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        Map<String, ActivityPlanItemTerminalModifyDto> existsMap = itemTerminalList.stream().collect(Collectors.toMap(ActivityPlanItemTerminalModifyDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalModifyDto terminalDto : updateList) {
            ActivityPlanItemTerminalModifyDto oldTerminalDto = existsMap.get(terminalDto.getId());
            if (null == oldTerminalDto){
                continue;//不应该出现
            }
            BeanUtils.copyProperties(terminalDto,oldTerminalDto);
        }

        Map<Object, ActivityPlanItemModifyDto> updateMap = Maps.newHashMap();
        updateMap.put(itemId,itemDto);
        itemHelper.doSaveItem(itemCacheKey,updateMap );
    }

    @Override
    public void deleteCacheList(String cacheKey, List<ActivityPlanItemTerminalModifyDto> updateList) {
        String itemCacheKey = cacheKey.substring(0,cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":")+1);
        ActivityPlanItemModifyDto itemDto = itemHelper.getDtoByKey(itemCacheKey, itemId);
        if (null == itemDto){
            throw new RuntimeException("明细数据未保存，请检查");
        }
        List<ActivityPlanItemTerminalModifyDto> itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList){
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }

        Map<String, ActivityPlanItemTerminalModifyDto> existsMap = itemTerminalList.stream().collect(Collectors.toMap(ActivityPlanItemTerminalModifyDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalModifyDto terminalDto : updateList) {
            ActivityPlanItemTerminalModifyDto oldTerminalDto = existsMap.get(terminalDto.getId());
            if (BooleanEnum.TRUE.getNumStr().equals(terminalDto.getChecked())) {
                //选中状态，代表该行数据要删除
                itemTerminalList.remove(oldTerminalDto);
            } else {
                if (null == oldTerminalDto){
                    continue;//不应该出现
                }
                BeanUtils.copyProperties(terminalDto,oldTerminalDto);
            }
        }

        Map<Object, ActivityPlanItemModifyDto> updateMap = Maps.newHashMap();
        updateMap.put(itemId,itemDto);
        itemHelper.doSaveItem(itemCacheKey,updateMap );
    }

}
