package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemTerminalModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemTerminalModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.service.ActivityPlanModifySdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * 活动方案变更服务接口实现
 * @author wanghaojia
 * @date 2023/4/26 14:51
 */
@Service
public class ActivityPlanModifySdkServiceImpl implements ActivityPlanModifySdkService {

    @Autowired
    private ActivityPlanModifyService activityPlanModifyService;

    @Autowired
    private ActivityPlanItemModifyRepository activityPlanItemModifyRepository;

    @Autowired
    private ActivityPlanItemTerminalModifyRepository activityPlanItemTerminalModifyRepository;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public ActivityPlanModifyVo findById(String id) {
        return activityPlanModifyService.findById(id);
    }

    @Override
    public ActivityPlanModifyVo findByIdOrCode(String id, String code) {
        return activityPlanModifyService.findByIdOrCode(id,code);
    }

    @Override
    public List<ActivityPlanItemModifyDto> findItemDtoAndAttachListByModifyCode(String modifyBusinessCode){
        return activityPlanItemModifyRepository.findDtoAndAttachListByModifyCode(modifyBusinessCode);
    }

    @Override
    public List<ActivityPlanItemTerminalModifyDto> findTerminalListByModifyBusinessCode(String modifyBusinessCode){
        List<ActivityPlanItemTerminalModify> list = activityPlanItemTerminalModifyRepository.findByModifyBusinessCode(modifyBusinessCode);
        Collection<ActivityPlanItemTerminalModifyDto> ActivityPlanItemTerminalModifyDtos = this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityPlanItemTerminalModify.class, ActivityPlanItemTerminalModifyDto.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityPlanItemTerminalModifyDto>) ActivityPlanItemTerminalModifyDtos;
    }

    @Override
    public List<ActivityPlanItemModifyDto> findDtoListByModifyCode(String businessNo) {
        if (StringUtils.isBlank(businessNo)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanItemModifyDto> list = this.activityPlanItemModifyRepository.findDtoListByModifyCode(businessNo);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}
