package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.tpm.business.activity.plan.local.entity.*;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.*;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.*;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.*;
import com.biz.crm.tpm.business.activity.plan.local.repository.*;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanModifyLogEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.PlanRelateLimitEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.event.log.ActivityPlanLogEventListener;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.constant.ActivityPlanModifyMqConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.*;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.enums.ActivityPlanModifyMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanRelatePlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanStrategyModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemTerminalVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.modify.dto.MarketingStrategyBudgetModifyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author wanghaojia
 * @date 2022/12/6 14:23
 */
@Service
public class ActivityPlanModifyServiceImpl implements ActivityPlanModifyService {

    @Autowired(required = false)
    private ActivityPlanModifyRepository activityPlanModifyRepository;
    @Autowired(required = false)
    private ActivityPlanItemModifyRepository activityPlanItemModifyRepository;
    @Autowired(required = false)
    private ActivityPlanStrategyModifyRepository activityPlanStrategyModifyRepository;
    @Autowired(required = false)
    private ActivityPlanRelatePlanModifyRepository activityPlanRelatePLanModifyRepository;
    @Autowired(required = false)
    private ActivityPlanBudgetModifyRepository activityPlanBudgetModifyRepository;

    @Autowired(required = false)
    private ActivityPlanService activityPlanService;
    @Autowired(required = false)
    private ActivityPlanRepository activityPlanRepository;
    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required = false)
    private ActivityPlanItemTerminalRepository activityPlanItemTerminalRepository;
    @Autowired(required = false)
    private ActivityPlanItemTerminalModifyRepository activityPlanItemTerminalModifyRepository;
    @Autowired(required = false)
    private ActivityPlanRelatePlanRepository activityPlanRelatePlanRepository;
    @Autowired(required = false)
    private ActivityPlanStrategyRepository activityPlanStrategyRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private ActivityPlanItemModifyService activityPlanItemModifyService;

    @Autowired(required = false)
    private ActivityPlanStrategyModifyService activityPlanStrategyModifyService;

    @Autowired(required = false)
    private ActivityPlanRelatePlanModifyService activityPlanRelatePlanModifyService;

    @Autowired(required = false)
    private ActivityPlanBudgetModifyService activityPlanBudgetModifyService;

    @Autowired(required = false)
    private ActivityPlanItemTerminalModifyService activityPlanItemTerminalModifyService;

    @Autowired(required = false)
    private MarketingStrategyBudgetSdkService marketingStrategyBudgetSdkService;


    @Autowired(required = false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Resource
    private ApplicationEventPublisher eventPublisher;

    @Autowired(required = false)
    private LoginUserService loginUserService;


    @Autowired(required = false)
    private PromotersVoService promotersVoService;
    
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;


    /**
     * 获取带调整的方案数据
     * @param pageable 分页参数
     * @param dto 查询参数
     * @return 分页数据
     */
    @Override
    public Page<ActivityPlanVo> findToModifyList(Pageable pageable, ActivityPlanDto dto) {
        return activityPlanModifyRepository.findToModifyList(pageable,dto);
    }

    /**
     * 通过id获取活动方案变更数据
     */
    @Override
    public ActivityPlanModifyVo findById(String id) {
        return findByIdOrCode(id,null);
    }

    /**
     * 通过id获取活动方案变更数据
     */
    @Override
    public ActivityPlanModifyVo findByIdOrCode(String id,String code) {
        if (StringUtils.isEmpty(id) && StringUtils.isEmpty(code)) {
            return null;
        }
        ActivityPlanModify entity = null;
        if (StringUtils.isNotEmpty(id)){
            entity = activityPlanModifyRepository.getById(id);
        }else{
            entity = activityPlanModifyRepository.getByCode(code);
        }
        if (null != entity) {
            ActivityPlanVo planVo = activityPlanService.findByCode(entity.getPlanCode());
            ActivityPlanModifyVo planModifyVo = nebulaToolkitService.copyObjectByWhiteList(planVo, ActivityPlanModifyVo.class, HashSet.class, ArrayList.class);
            BeanUtils.copyProperties(entity,planModifyVo);

            //再查下关联的策略
            List<ActivityPlanStrategyModifyVo> strategyDtos = activityPlanStrategyModifyRepository.findListVoByModifyCode(entity.getModifyBusinessCode());
            planModifyVo.setStrategyList(strategyDtos);
            //再查下大区方案关联的总部方案
            List<ActivityPlanRelatePlanModifyVo> relatePlanList = activityPlanRelatePLanModifyRepository.findListVoByModifyCode(entity.getModifyBusinessCode());
            planModifyVo.setRelatePlanList(relatePlanList);
            //再查下关联的模板配置
            planModifyVo.setTemplateList(planVo.getTemplateList());
            activityPlanModifyRepository.fillVoProperties(planModifyVo);
            return planModifyVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(String cacheKey, ActivityPlanModifyDto dto) {
        List<ActivityPlanItemModifyDto> itemList = activityPlanItemModifyService.findCacheList(cacheKey);
        create(dto,itemList);
    }

    @Transactional(rollbackFor = Exception.class)
    public String create(ActivityPlanModifyDto dto,List<ActivityPlanItemModifyDto> itemList) {
        if (CollectionUtils.isEmpty(itemList)){
            throw new RuntimeException("方案变更数据不能为空!");
        }

        List<String> planItemCodeList = itemList.stream().map(ActivityPlanItemModifyDto::getPlanItemCode).collect(Collectors.toList());
        List<ActivityPlanItemDto> originItemList = activityPlanItemRepository.findDtoAndAttachListByPlanItemCodeList(planItemCodeList);
        Map<String, ActivityPlanItemDto> originItemMap = originItemList.stream().collect(Collectors.toMap(ActivityPlanItemDto::getPlanItemCode, Function.identity()));

        createValidate(dto,itemList,originItemMap);
        ActivityPlanModify entity = null;
        ActivityPlanModifyDto oldDto = null;
        boolean update = !StringUtils.isBlank(dto.getId());

        if (!update){
            entity = nebulaToolkitService.copyObjectByWhiteList(dto,ActivityPlanModify.class,HashSet.class,ArrayList.class);
            // redis生成营销策略编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
//            String ruleCode = StringUtils.join(ActivityPlanConstant.ACTIVITY_PLAN_MODIFY_RULE_CODE_PRE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
            String code = this.generateCodeService.generateCode(ActivityPlanConstant.ACTIVITY_PLAN_MODIFY_RULE_CODE_PRE, 1, 5, 2, TimeUnit.DAYS).get(0);
            entity.setModifyBusinessCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            activityPlanModifyRepository.save(entity);
        }else{
            ActivityPlanModify oldEntity = activityPlanModifyRepository.getById(dto.getId());
            oldDto = nebulaToolkitService.copyObjectByWhiteList(dto,ActivityPlanModifyDto.class,HashSet.class,ArrayList.class);
            dto.setModifyBusinessCode(oldEntity.getModifyBusinessCode());
            dto.setTenantCode(oldEntity.getTenantCode());
            entity = nebulaToolkitService.copyObjectByWhiteList(dto,ActivityPlanModify.class,HashSet.class,ArrayList.class);
            activityPlanModifyRepository.updateById(entity);
        }
        //保存方案-策略关联
        activityPlanStrategyModifyService.saveActivityPlanStrategyList(entity, update, dto.getStrategyList());

        //保存大区方案-方案关联
        activityPlanRelatePlanModifyService.saveActivityPlanRelatePlanList(entity, update, dto.getRelatePlanList());


        activityPlanItemModifyService.saveActivityPlanItemList(entity,update,itemList,originItemMap,false);

        //保存方案-预算数据
        activityPlanBudgetModifyService.saveActivityPlanBudgetList(entity, update, itemList);

        //保存方案-门店数据（方案变更，有的才存，目前仅用于垂直促销人员变更）
        activityPlanItemTerminalModifyService.saveActivityPlanItemTerminalList(entity, update, itemList);

        //备份一份数据
        backupInitVersionData(entity.getPlanCode());

        //新增修改业务日志
        ActivityPlanModifyLogEventDto logEventDto = new ActivityPlanModifyLogEventDto();
        logEventDto.setNewest(nebulaToolkitService.copyObjectByWhiteList(entity, ActivityPlanModifyDto.class, HashSet.class, ArrayList.class));
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanModifyLogEventDto> onCreate =
                    ActivityPlanLogEventListener::onCreateModify;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onCreate);
        } else {
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanModifyLogEventDto> onUpdate =
                    ActivityPlanLogEventListener::onUpdateModify;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onUpdate);
        }
        return entity.getModifyBusinessCode();
    }


    /**
     * 策略新增保存逻辑
     * @param dto 策略数据
     * @param itemCacheList 策略行数据
     */
    private void createValidate(ActivityPlanModifyDto dto, List<ActivityPlanItemModifyDto> itemCacheList,Map<String, ActivityPlanItemDto> originItemMap) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");
        Validate.notNull(dto.getPlanCode(), "新增时，关联方案不能为空！");
//        方案编码：提交时系统自动生成，可不显示。
        Validate.notBlank(dto.getBusinessFormatCode(), "新增时，业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "新增时，业务单元不能为空！");
//        方案名称：输入框、必填项，提交时校验不能为空。
        Validate.notBlank(dto.getPlanName(), "新增时，方案名称不能为空！");
//        方案类型：下拉单选框、必填项 ，提交时校验不能为空；下拉选项值（数据字典）：总部方案、大区方案、分子公司方案、垂直重客方案、电商方案；选总部方案，不显示关联方案内容。选其他方案，均显示关联方案内容。
        Validate.notBlank(dto.getPlanType(), "新增时，方案类型不能为空！");
//        方案范围：下拉多选框、必填项，提交时校验不能为空；数据来源于组织主数据；方案范围影响填写方案内容时区域范围的选择，区域只能在方案范围之内的组织数据选择。
//        Validate.notBlank(dto.getPlanOrgCode(), "新增时，方案范围不能为空！");
//        预估费用：系统自动计算，等于方案使用预算金额的累计值。
//        方案投产比：系统自动自动计算，计算逻辑：预结案金额/销售额。
//        方案时间：时间选择器（年月日）、必填项，提交是校验不能为空。
        Validate.notBlank(dto.getBeginDateStr(), "新增时，方案开始时间不能为空！");
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            Date beginDate = dayFormat.parse(dto.getBeginDateStr());
            dto.setBeginDate(beginDate);
        }catch (Exception e){
            throw new RuntimeException("方案开始时间格式有误！");
        }
        Validate.notBlank(dto.getEndDateStr(), "新增时，方案结束时间不能为空！");
        try {
            Date endDate = dayFormat.parse(dto.getEndDateStr());
            dto.setEndDate(endDate);
        }catch (Exception e){
            throw new RuntimeException("方案结束时间格式有误！");
        }
//        方案关联限制：下拉单选框，总部方案为必填项，其他方案为不必填项；下拉选项值（数据字典）：核销后申请、核销前申请。1）核销后申请：计算方案达成及方案可核销金额，区域关联方案，以方案可核销金额为上限申请细案（允许补强），活动执行结束后系统按活动细案计算结案；2）核销前申请：跟据活动细案同时计算方案达成条件及核销金额、计算细案达成条件及核销金额，自动校验对比，细案中可使用的金额不允许超方案金额。
        if (ActivityPlanTypeEnum.headquarters.getCode().equals(dto.getPlanType())){
            Validate.notBlank(dto.getPlanRelateLimitCode(), "新增时，总部方案方案关联限制不能为空！");
        }
//        方案主题：输入框、必填项；提交时校验不能为空。
//        Validate.notBlank(dto.getPlanTitle(), "新增时，方案主题不能为空！");
//        方案目的：文本框、必填项；提交时不能为空。
//        Validate.notBlank(dto.getPlanGoal(), "新增时，方案目的不能为空！");
//        活动背景：文本框、必填项；提交时不能为空。
//        Validate.notBlank(dto.getActivityBackground(), "新增时，活动背景不能为空！");
//        活动目标：文本框、必填项；提交时不能为空。
//        Validate.notBlank(dto.getActivityTarget(), "新增时，活动目标不能为空！");
//        明细说明：文本框、必填项；提交时不能为空。
//        Validate.notBlank(dto.getDetailExplain(), "新增时，明细说明不能为空！");
        Validate.notBlank(dto.getPlanClassify(), "新增时，方案分类不能为空！");
        Validate.isTrue(!CollectionUtils.isEmpty(itemCacheList),"新增时，方案明细不能为空");

        ActivityPlanVo planVo = activityPlanService.findByCode(dto.getPlanCode());
        //业态、业务单元、部门、活动模板不能改
        dto.setBusinessFormatCode(planVo.getBusinessFormatCode());
        dto.setBusinessUnitCode(planVo.getBusinessUnitCode());
        dto.setDepartmentCode(planVo.getDepartmentCode());
        dto.setDepartmentName(planVo.getDepartmentName());

        activityPlanItemModifyService.createValidateList(dto,itemCacheList,originItemMap);

        List<ActivityPlanBudgetModifyDto> budgetDtos = matchActivityPlanBudgetRelate(dto,itemCacheList,originItemMap);
        activityPlanBudgetModifyService.useMonthBudget(budgetDtos,dto.getPlanCode(),false);

        Map<String, BigDecimal> strategyUseAmountMap = Maps.newHashMap();
        Map<String,BigDecimal> relatePlanUseAmountMap = Maps.newHashMap();

        //设置表头汇总金额
        BigDecimal budgetFeeAmount = BigDecimal.ZERO;
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal departmentFeeAmount = BigDecimal.ZERO;
        BigDecimal customerFeeAmount = BigDecimal.ZERO;
        BigDecimal totalFeeAmount = BigDecimal.ZERO;
        for (ActivityPlanItemModifyDto activityPlanItemDto : itemCacheList) {
            BigDecimal thisFeeAmount = BigDecimal.ZERO;
            BigDecimal thisTotalFeeAmount = BigDecimal.ZERO;
            if (null != activityPlanItemDto.getHeadFeeAmount()){
                headFeeAmount = headFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisTotalFeeAmount = thisTotalFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
            }
            if (null != activityPlanItemDto.getDepartmentFeeAmount()){
                departmentFeeAmount = departmentFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisTotalFeeAmount = thisTotalFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
            }
            if (null != activityPlanItemDto.getCustomerFeeAmount()){
                customerFeeAmount = customerFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
                thisTotalFeeAmount = thisTotalFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                activityPlanItemDto.setFeeAmount(thisFeeAmount);
            }
            if (null != activityPlanItemDto.getFeeAmount()){
                feeAmount = feeAmount.add(activityPlanItemDto.getFeeAmount());
            }
            if (null != activityPlanItemDto.getTotalFeeAmount()){
                if (BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())) {
                    Assert.isTrue(thisTotalFeeAmount.compareTo(activityPlanItemDto.getTotalFeeAmount()) == 0, "费用合计必须等于总部承担+大区承担+客户承担金额");
                }
                totalFeeAmount = totalFeeAmount.add(activityPlanItemDto.getTotalFeeAmount());
                if (!CollectionUtils.isEmpty(activityPlanItemDto.getBudgetShares())){
                    for (ActivityPlanBudgetModifyDto budgetShare : activityPlanItemDto.getBudgetShares()) {
                        if (null != budgetShare.getUseAmount()){
                            budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
                        }
                        if (StringUtils.isNotEmpty(budgetShare.getRelateStrategyItemCode())){
                            BigDecimal strategyUseAmount = Optional.ofNullable(strategyUseAmountMap.get(budgetShare.getRelateStrategyItemCode())).orElse(BigDecimal.ZERO);
                            strategyUseAmountMap.put(budgetShare.getRelateStrategyItemCode(),strategyUseAmount.add(budgetShare.getUseAmount()));
                        }
                        if (StringUtils.isNotEmpty(budgetShare.getRelatePlanCode())){
                            BigDecimal relatePlanUseAmount = Optional.ofNullable(relatePlanUseAmountMap.get(budgetShare.getRelatePlanCode())).orElse(BigDecimal.ZERO);
                            relatePlanUseAmountMap.put(budgetShare.getRelatePlanCode(),relatePlanUseAmount.add(budgetShare.getUseAmount()));
                        }
                    }
                }
            }
        }
        if (null != dto.getSalesAmount() && dto.getSalesAmount().compareTo(BigDecimal.ZERO) != 0){
            if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                //方案投产比=费用合计/预估销售额   垂直
                dto.setPlanIoRate(feeAmount.divide(dto.getSalesAmount(),2, RoundingMode.HALF_DOWN));
            }else{
                //方案投产比=（总计总部承担金额+总计大区承担金额）/预估销售额    主体
                dto.setPlanIoRate(totalFeeAmount.add(departmentFeeAmount).divide(dto.getSalesAmount(),2, RoundingMode.HALF_DOWN));
            }
        }
        dto.setFeeAmount(feeAmount);
        dto.setHeadFeeAmount(headFeeAmount);
        dto.setDepartmentFeeAmount(departmentFeeAmount);
        dto.setCustomerFeeAmount(customerFeeAmount);
        dto.setTotalFeeAmount(totalFeeAmount);

        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            //垂直多选预算，校验预算金额之和要等于行上的费用金额
            if (feeAmount.compareTo(budgetFeeAmount) != 0){
                throw new RuntimeException("费用金额["+feeAmount+"]不等于实际预算使用金额["+budgetFeeAmount+"]");
            }
        }


        if (strategyUseAmountMap.size() > 0){
            List<ActivityPlanStrategyModifyDto> strategyList = dto.getStrategyList();
            if (!CollectionUtils.isEmpty(strategyList)){
                Map<String, ActivityPlanStrategyModifyDto> strategyMap = strategyList.stream().collect(Collectors.toMap(ActivityPlanStrategyModifyDto::getStrategyItemCode, Function.identity(), (o, n) -> n));
                for (Map.Entry<String, BigDecimal> entry : strategyUseAmountMap.entrySet()) {
                    ActivityPlanStrategyModifyDto strategyDto = strategyMap.get(entry.getKey());
                    if (null != strategyDto){
                        strategyDto.setUseAmount(entry.getValue());
                    }
                }
            }
        }
        if (relatePlanUseAmountMap.size() > 0){
            List<ActivityPlanRelatePlanModifyDto> relatePlanList = dto.getRelatePlanList();
            if (!CollectionUtils.isEmpty(relatePlanList)){
                Map<String, ActivityPlanRelatePlanModifyDto> relatePlanMap = relatePlanList.stream().collect(Collectors.toMap(ActivityPlanRelatePlanModifyDto::getRelatePlanCode, Function.identity(), (o, n) -> n));
                for (Map.Entry<String, BigDecimal> entry : relatePlanUseAmountMap.entrySet()) {
                    ActivityPlanRelatePlanModifyDto planRelatePlanDto = relatePlanMap.get(entry.getKey());
                    if (null != planRelatePlanDto){
                        planRelatePlanDto.setUseAmount(entry.getValue());
                    }
                }
            }
        }
    }

    /**
     * 活动方案预算关联策略、方案
     *
     * @param planDto       方案头数据
     * @param originItemMap
     */
    public List<ActivityPlanBudgetModifyDto> matchActivityPlanBudgetRelate(ActivityPlanModifyDto planDto, List<ActivityPlanItemModifyDto> itemList, Map<String, ActivityPlanItemDto> originItemMap){
        List<ActivityPlanStrategyModifyDto> strategyList = planDto.getStrategyList();
        List<ActivityPlanRelatePlanModifyDto> relatePlanList = planDto.getRelatePlanList();
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
            //总部方案，关联策略不能为空
            if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())) {
                Validate.isTrue(!CollectionUtils.isEmpty(strategyList), "总部方案关联策略不能为空!");
            } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                Validate.isTrue(!CollectionUtils.isEmpty(strategyList) || !CollectionUtils.isEmpty(relatePlanList), "大区方案关联策略和方案不能同时为空!");
            } else {
                throw new RuntimeException("方案类型有误");
            }
        }

        Set<String> monthBudgetCodeSet = org.apache.commons.compress.utils.Sets.newHashSet();
        Map<String, List<MarketingStrategyBudgetDto>> relateStrategyBudgetMap = Maps.newHashMap();
        Map<String, List<MarketingStrategyBudgetDto>> strategyBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(strategyList)){
            List<String> strategyCodeList = strategyList.stream().map(ActivityPlanStrategyModifyDto::getStrategyCode).distinct().collect(Collectors.toList());
            MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
            budgetDto.setStrategyCodeList(strategyCodeList);
            List<MarketingStrategyBudgetDto> strategyBudgetDtos = marketingStrategyBudgetSdkService.findListByConditions(budgetDto);
            relateStrategyBudgetMap = strategyBudgetDtos.stream().collect(Collectors.groupingBy(MarketingStrategyBudgetDto::getMonthBudgetCode));
            strategyBudgetMap = strategyBudgetDtos.stream().collect(Collectors.groupingBy(MarketingStrategyBudgetDto::getStrategyItemCode));
            monthBudgetCodeSet.addAll(strategyBudgetDtos.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }

        Map<String, List<ActivityPlanBudget>> relatePlanBudgetMap = Maps.newHashMap();
        Map<String, List<ActivityPlanBudget>> planBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relatePlanList)){
            List<String> planCodeList = relatePlanList.stream().map(ActivityPlanRelatePlanModifyDto::getRelatePlanCode).distinct().collect(Collectors.toList());
            List<ActivityPlanBudget> activityPlanBudgets = activityPlanBudgetRepository.listByPlanCodeList(planCodeList);
            relatePlanBudgetMap = activityPlanBudgets.stream().filter(item -> StringUtils.isNotEmpty(item.getMonthBudgetCode())).collect(Collectors.groupingBy(ActivityPlanBudget::getMonthBudgetCode));
            planBudgetMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudget::getPlanItemCode));

            monthBudgetCodeSet.addAll(activityPlanBudgets.stream().map(ActivityPlanBudget::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }

        //主体判断下有没有变更金额   没变更的话直接返回原方案的预算信息
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())){
            boolean hasModifyAmount = false;
            //如果没有变更的话，直接用原方案的预算信息
            List<ActivityPlanBudgetDto> budgetDtos = Lists.newArrayList();
            for (ActivityPlanItemModifyDto itemDto : itemList) {
                ActivityPlanItemDto originItemDto = originItemMap.get(itemDto.getPlanItemCode());
                if (Optional.ofNullable(itemDto.getHeadFeeAmount()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(originItemDto.getHeadFeeAmount()).orElse(BigDecimal.ZERO)) != 0){
                    hasModifyAmount = true;
                    break;
                }
                if (Optional.ofNullable(itemDto.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(originItemDto.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)) != 0){
                    hasModifyAmount = true;
                    break;
                }
                budgetDtos.addAll(originItemDto.getBudgetShares());
            }
            if (!hasModifyAmount){
                return (List<ActivityPlanBudgetModifyDto>)(List)nebulaToolkitService.copyCollectionByWhiteList(budgetDtos,ActivityPlanBudgetDto.class,ActivityPlanBudgetModifyDto.class,HashSet.class,ArrayList.class);
            }
        }

        for (ActivityPlanItemModifyDto itemDto : itemList) {
            ActivityPlanItemDto originItemDto = originItemMap.get(itemDto.getPlanItemCode());
            //先退还下之前已经扣过的预算
            if (!CollectionUtils.isEmpty(originItemDto.getBudgetShares())){
                for (ActivityPlanBudgetDto budgetShare : originItemDto.getBudgetShares()) {
                    if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShare.getOccupyType()) &&
                            StringUtils.isNotEmpty(budgetShare.getRelateStrategyItemCode())){
                        List<MarketingStrategyBudgetDto> strategyBudgetDtos = strategyBudgetMap.get(budgetShare.getRelateStrategyItemCode());
                        //应该不能为空
                        if (!CollectionUtils.isEmpty(strategyBudgetDtos)){
                            MarketingStrategyBudgetDto budgetDto = strategyBudgetDtos.get(0);
                            budgetDto.setUsedAmount(Optional.ofNullable(budgetDto.getUsedAmount()).orElse(BigDecimal.ZERO).subtract(budgetShare.getUseAmount()));
                        }
                    }else if(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShare.getOccupyType()) &&
                            StringUtils.isNotEmpty(budgetShare.getRelatePlanItemCode())){
                        List<ActivityPlanBudget> activityPlanBudgets = planBudgetMap.get(budgetShare.getRelatePlanItemCode());
                        //应该不能为空
                        if (!CollectionUtils.isEmpty(activityPlanBudgets)){
                            ActivityPlanBudget activityPlanBudget = activityPlanBudgets.get(0);
                            activityPlanBudget.setUsedAmount(Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO).subtract(budgetShare.getUseAmount()));
                        }
                    }
                }
            }
        }
        //查下月度预算信息，保存费用归口
        Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(monthBudgetCodeSet)) {
            List<MonthBudgetVo> monthBudgetList = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
            monthBudgetMap = monthBudgetList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        }

        List<ActivityPlanBudgetModifyDto> budgetDtos = Lists.newArrayList();
        for (int i = 0; i < itemList.size(); i++) {
            ActivityPlanItemModifyDto itemDto = itemList.get(i);
            //业务单元不是垂直，清空掉明细上的预算信息，按明细上的预算信息重新保存
            List<ActivityPlanBudgetModifyDto> budgetList = Lists.newArrayList();
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
                //其他业务单元重新组装预算信息
                if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())) {
                    Validate.isTrue(!StringUtils.isEmpty(itemDto.getHeadMonthBudgetCode()), "总部方案总部预算不能为空!");
                } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                    Validate.isTrue(!StringUtils.isEmpty(itemDto.getHeadMonthBudgetCode()) || !StringUtils.isEmpty(itemDto.getMonthBudgetCode()), "大区方案总部预算和大区预算不能同时为空!");
                }
                if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())) {
                    BigDecimal headFeeAmount = itemDto.getHeadFeeAmount();
                    if (null == headFeeAmount || BigDecimal.ZERO.compareTo(headFeeAmount) == 0) {
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择总部预算后总部承担金额不能为空或0");
                    }
                } else {
                    if (null != itemDto.getHeadFeeAmount() && itemDto.getHeadFeeAmount().compareTo(BigDecimal.ZERO) != 0) {
                        throw new RuntimeException("未选择总部预算编码，总部承担金额只能为0");
                    }
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                        if (StringUtils.isNotEmpty(itemDto.getRelatePlanItemCode())) {
                            throw new RuntimeException("大区方案未填写总部预算编码不能填写关联方案明细编码");
                        }
                    }
                }
                if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())) {
                    BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount();
                    if (null == departmentFeeAmount || BigDecimal.ZERO.compareTo(departmentFeeAmount) == 0) {
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择大区预算后大区承担金额不能为空或0");
                    }
                } else if (null != itemDto.getDepartmentFeeAmount() && itemDto.getDepartmentFeeAmount().compareTo(BigDecimal.ZERO) != 0) {
                    //总部方案允许填
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                        throw new RuntimeException("未选择大区预算编码，大区承担金额只能为0");
                    }
                }

                String relateStrategyCode = itemDto.getRelateStrategyCode();
                String relateStrategyItemCode = itemDto.getRelateStrategyItemCode();

                String relateHeadStrategyCode = itemDto.getRelateHeadStrategyCode();
                String relateHeadStrategyItemCode = itemDto.getRelateHeadStrategyItemCode();

                String relatePlanCode = itemDto.getRelatePlanCode();
                String relatePlanItemCode = itemDto.getRelatePlanItemCode();

                headBudget:
                if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())) {
                    BigDecimal headFeeAmount = itemDto.getHeadFeeAmount();
                    if (null == headFeeAmount || BigDecimal.ZERO.compareTo(headFeeAmount) == 0) {
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择总部预算后总部承担金额不能为空或0");
                    }
                    BigDecimal leaveAmount = headFeeAmount;
                    if (StringUtils.isNotEmpty(relatePlanItemCode)) {
                        List<ActivityPlanBudget> planItemBudgetList = planBudgetMap.get(relatePlanItemCode);
                        if (CollectionUtils.isEmpty(planItemBudgetList)) {
                            throw new RuntimeException("总部预算编码[" + itemDto.getHeadMonthBudgetCode() + "]不属于方案明细[" + relatePlanItemCode + "]");
                        }
                        Set<String> planBudgetItemSet = planItemBudgetList.stream().map(ActivityPlanBudget::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(itemDto.getHeadMonthBudgetCode())) {
                            throw new RuntimeException("总部预算编码[" + itemDto.getHeadMonthBudgetCode() + "]不属于方案明细[" + relatePlanItemCode + "]");
                        }

                        ActivityPlanBudgetModifyDto monthBudget = new ActivityPlanBudgetModifyDto();
                        monthBudget.setPlanCode(itemDto.getPlanCode());
                        monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                        monthBudget.setRelatePlanCode(relatePlanCode);
                        monthBudget.setRelatePlanItemCode(relatePlanItemCode);
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getHeadBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getHeadBudgetItemName());
                        monthBudget.setUseAmount(leaveAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getHeadMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getHeadMonthBudgetCode()).getFeeBelongCode() : null);
                        budgetList.add(monthBudget);
                        break headBudget;//有关联方案编码，跳过
                    }
                    if (StringUtils.isNotEmpty(relateHeadStrategyItemCode)) {
                        List<MarketingStrategyBudgetDto> strategyBudgetDtos = strategyBudgetMap.get(relateHeadStrategyItemCode);
                        if (CollectionUtils.isEmpty(strategyBudgetDtos)) {
                            throw new RuntimeException("总部预算编码[" + itemDto.getHeadMonthBudgetCode() + "]不属于策略明细[" + relateHeadStrategyItemCode + "]");
                        }
                        Set<String> planBudgetItemSet = strategyBudgetDtos.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(itemDto.getHeadMonthBudgetCode())) {
                            throw new RuntimeException("总部预算编码[" + itemDto.getHeadMonthBudgetCode() + "]不属于策略明细[" + relateHeadStrategyItemCode + "]");
                        }

                        ActivityPlanBudgetModifyDto monthBudget = new ActivityPlanBudgetModifyDto();
                        monthBudget.setPlanCode(itemDto.getPlanCode());
                        monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                        monthBudget.setRelateStrategyCode(relateHeadStrategyCode);
                        monthBudget.setRelateStrategyItemCode(relateHeadStrategyItemCode);
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getHeadBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getHeadBudgetItemName());
                        monthBudget.setUseAmount(leaveAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getHeadMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getHeadMonthBudgetCode()).getFeeBelongCode() : null);
                        budgetList.add(monthBudget);
                        break headBudget;//有关联策略编码，跳过
                    }
                    List<MarketingStrategyBudgetDto> strategyBudgetDtos = relateStrategyBudgetMap.get(itemDto.getHeadMonthBudgetCode());
                    if (null != strategyBudgetDtos) {
                        for (MarketingStrategyBudgetDto strategyBudgetDto : strategyBudgetDtos) {
                            if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                break;
                            }
                            BigDecimal useAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usableAmount = useAmount.subtract(usedAmount);
                            if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                continue;
                            }
                            if (StringUtils.isNotEmpty(relateHeadStrategyItemCode)) {
                                if (!relateHeadStrategyItemCode.equals(strategyBudgetDto.getStrategyItemCode())) {
                                    //选中一个了就一个到底
                                    continue;
                                }
                            } else {
                                relateHeadStrategyItemCode = strategyBudgetDto.getStrategyItemCode();
                                relateHeadStrategyCode = strategyBudgetDto.getStrategyCode();
                            }
                            BigDecimal thisAmount = leaveAmount;
                            if (usableAmount.compareTo(thisAmount) < 0) {
                                thisAmount = usableAmount;
                            }
                            ActivityPlanBudgetModifyDto monthBudget = new ActivityPlanBudgetModifyDto();
                            monthBudget.setPlanCode(itemDto.getPlanCode());
                            monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                            monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                            monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                            monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                            monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                            monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                            monthBudget.setUseAmount(thisAmount);
                            monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode() : null);
                            budgetList.add(monthBudget);
                            leaveAmount = leaveAmount.subtract(thisAmount);
                            strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                        }
                    }
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                        //1、总部下发的方案，关联总部方案，做大区方案
                        List<ActivityPlanBudget> activityPlanBudgets = relatePlanBudgetMap.get(itemDto.getHeadMonthBudgetCode());
                        if (null != activityPlanBudgets) {
                            for (ActivityPlanBudget activityPlanBudget : activityPlanBudgets) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                    break;
                                }
                                BigDecimal useAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount = useAmount.subtract(usedAmount);
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                    continue;
                                }
                                if (StringUtils.isNotEmpty(relatePlanItemCode)) {
                                    if (!relatePlanItemCode.equals(activityPlanBudget.getPlanItemCode())) {
                                        //选中一个了就一个到底
                                        continue;
                                    }
                                } else {
                                    relatePlanItemCode = activityPlanBudget.getPlanItemCode();
                                    relatePlanCode = activityPlanBudget.getPlanCode();
                                }
                                BigDecimal thisAmount = leaveAmount;
                                if (usableAmount.compareTo(thisAmount) < 0) {
                                    thisAmount = usableAmount;
                                }
                                ActivityPlanBudgetModifyDto monthBudget = new ActivityPlanBudgetModifyDto();
                                monthBudget.setPlanCode(itemDto.getPlanCode());
                                monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                                monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                                monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                                monthBudget.setMonthBudgetCode(activityPlanBudget.getMonthBudgetCode());
                                monthBudget.setBudgetItemCode(activityPlanBudget.getBudgetItemCode());
                                monthBudget.setBudgetItemName(activityPlanBudget.getBudgetItemName());
                                monthBudget.setUseAmount(thisAmount);
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                                monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode() : null);
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }

                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) > 0) {
                        throw new RuntimeException("总部费用金额[" + headFeeAmount + "]超过实际可用余额");
                    }
                }
                departBudget:
                if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())) {
                    BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount();
                    if (null == departmentFeeAmount || BigDecimal.ZERO.compareTo(departmentFeeAmount) == 0) {
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择大区预算后大区承担金额不能为空或0");
                    }
                    BigDecimal leaveAmount = departmentFeeAmount;

                    if (StringUtils.isNotEmpty(itemDto.getRelateStrategyItemCode())) {
                        List<MarketingStrategyBudgetDto> strategyItemBudgetList = strategyBudgetMap.get(relateStrategyItemCode);
                        if (CollectionUtils.isEmpty(strategyItemBudgetList)) {
                            throw new RuntimeException("大区预算编码[" + itemDto.getMonthBudgetCode() + "]不属于策略明细[" + relateStrategyItemCode + "]");
                        }
                        Set<String> planBudgetItemSet = strategyItemBudgetList.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(itemDto.getMonthBudgetCode())) {
                            throw new RuntimeException("大区预算编码[" + itemDto.getMonthBudgetCode() + "]不属于策略明细[" + relateStrategyItemCode + "]");
                        }

                        ActivityPlanBudgetModifyDto monthBudget = new ActivityPlanBudgetModifyDto();
                        monthBudget.setPlanCode(itemDto.getPlanCode());
                        monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                        monthBudget.setRelateStrategyCode(itemDto.getRelateStrategyCode());
                        monthBudget.setRelateStrategyItemCode(itemDto.getRelateStrategyItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getBudgetItemName());
                        monthBudget.setUseAmount(leaveAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode() : null);
                        budgetList.add(monthBudget);
                        break departBudget;//有关联策略编码，跳过
                    }

                    //大区方案占用策略金额
                    List<MarketingStrategyBudgetDto> activityPlanBudgets = relateStrategyBudgetMap.get(itemDto.getMonthBudgetCode());
                    if (!CollectionUtils.isEmpty(activityPlanBudgets)) {
                        for (MarketingStrategyBudgetDto strategyBudgetDto : activityPlanBudgets) {
                            if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                break;
                            }
                            BigDecimal useAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usableAmount = useAmount.subtract(usedAmount);
                            if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                continue;
                            }
                            if (StringUtils.isNotEmpty(relateStrategyItemCode)) {
                                if (!relateStrategyItemCode.equals(strategyBudgetDto.getStrategyItemCode())) {
                                    //选中一个了就一个到底
                                    continue;
                                }
                            } else {
                                relateStrategyItemCode = strategyBudgetDto.getStrategyItemCode();
                                relateStrategyCode = strategyBudgetDto.getStrategyCode();
                            }
                            BigDecimal thisAmount = leaveAmount;
                            if (usableAmount.compareTo(thisAmount) < 0) {
                                thisAmount = usableAmount;
                            }
                            ActivityPlanBudgetModifyDto monthBudget = new ActivityPlanBudgetModifyDto();
                            monthBudget.setPlanCode(itemDto.getPlanCode());
                            monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                            monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                            monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                            monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                            monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                            monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                            monthBudget.setUseAmount(thisAmount);
                            monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode() : null);
                            budgetList.add(monthBudget);
                            leaveAmount = leaveAmount.subtract(thisAmount);
                            strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                        }
                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) > 0) {
                        throw new RuntimeException("大区方案占用策略金额[" + departmentFeeAmount + "]超过实际可用余额");
                    }
                }

                BigDecimal customerFeeAmount = itemDto.getCustomerFeeAmount();
                if (null != customerFeeAmount && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0) {
                    //有客户承担金额的话也生成一条数据，供细案占用处理
                    ActivityPlanBudgetModifyDto monthBudget = new ActivityPlanBudgetModifyDto();
                    monthBudget.setPlanCode(itemDto.getPlanCode());
                    monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                    monthBudget.setUseAmount(customerFeeAmount);
                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode());
                    budgetList.add(monthBudget);
                }

                itemDto.setRelatePlanCode(relatePlanCode);
                itemDto.setRelatePlanItemCode(relatePlanItemCode);
                itemDto.setRelateStrategyCode(relateStrategyCode);
                itemDto.setRelateStrategyItemCode(relateStrategyItemCode);
                itemDto.setRelateHeadStrategyCode(relateHeadStrategyCode);
                itemDto.setRelateHeadStrategyItemCode(relateHeadStrategyItemCode);
            } else {
                //垂直预算的逻辑
                if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())) {
                    for (ActivityPlanBudgetModifyDto budgetDto : itemDto.getBudgetShares()) {
                        BigDecimal useAmount = budgetDto.getUseAmount();
                        BigDecimal leaveAmount = useAmount;
                        List<MarketingStrategyBudgetDto> strategyBudgetDtos = strategyBudgetMap.get(budgetDto.getMonthBudgetCode());
                        if (!CollectionUtils.isEmpty(strategyBudgetDtos)) {
                            for (MarketingStrategyBudgetDto strategyBudgetDto : strategyBudgetDtos) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                    break;
                                }
                                BigDecimal strategyBudgetUseAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount = strategyBudgetUseAmount.subtract(usedAmount);
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                    continue;
                                }
                                BigDecimal thisAmount = leaveAmount;
                                if (usableAmount.compareTo(thisAmount) < 0) {
                                    thisAmount = usableAmount;
                                }
                                ActivityPlanBudgetModifyDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class);
                                monthBudget.setPlanCode(itemDto.getPlanCode());
                                monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                                monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                                monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                                monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                                monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                                monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                                monthBudget.setUseAmount(thisAmount);
                                //总部方案，“方案关联限制”为“核销后申请”的方案在方案提交时，冻结预算，不占用批复金额；
                                if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())
                                        && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                                } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())
                                        && StringUtils.isNotBlank(monthBudget.getSchemeForecastDetailCode())) {
                                    //大区方案，关联了大区方案兑付表，使用总部冻结过的预算
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                                } else {
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                                }
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }
                        List<ActivityPlanBudget> activityPlanBudgets = relatePlanBudgetMap.get(budgetDto.getMonthBudgetCode());
                        if (!CollectionUtils.isEmpty(activityPlanBudgets)) {
                            for (ActivityPlanBudget activityPlanBudget : activityPlanBudgets) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                    break;
                                }
                                BigDecimal planBudgetUseAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount = planBudgetUseAmount.subtract(usedAmount);
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                    continue;
                                }
                                BigDecimal thisAmount = leaveAmount;
                                if (usableAmount.compareTo(thisAmount) < 0) {
                                    thisAmount = usableAmount;
                                }
                                ActivityPlanBudgetModifyDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class);
                                monthBudget.setPlanCode(itemDto.getPlanCode());
                                monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                                monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                                monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                                monthBudget.setMonthBudgetCode(activityPlanBudget.getMonthBudgetCode());
                                monthBudget.setBudgetItemCode(activityPlanBudget.getBudgetItemCode());
                                monthBudget.setBudgetItemName(activityPlanBudget.getBudgetItemName());
                                monthBudget.setUseAmount(thisAmount);
                                if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())
                                        && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                                } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())
                                        && StringUtils.isNotBlank(monthBudget.getSchemeForecastDetailCode())) {
                                    //大区方案，关联了大区方案兑付表，使用总部冻结过的预算
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                                } else {
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                                }
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }
                        if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
                            //还有没处理的就直接扣预算了
                            ActivityPlanBudgetModifyDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class);
                            monthBudget.setPlanCode(itemDto.getPlanCode());
                            monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                            monthBudget.setUseAmount(leaveAmount);
                            if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())
                                    && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                            } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())
                                    && StringUtils.isNotBlank(monthBudget.getSchemeForecastDetailCode())) {
                                //大区方案，关联了大区方案兑付表，使用总部冻结过的预算
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                            } else {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            }
                            budgetList.add(monthBudget);
                        }
                    }
                }
            }
            itemDto.setBudgetShares(budgetList);
            for (ActivityPlanBudgetModifyDto dto : budgetList) {
                dto.setIndexNo(itemDto.getIndexNo());
            }
            if (!CollectionUtils.isEmpty(budgetList)){
                budgetDtos.addAll(budgetList);
            }
        }

        return budgetDtos;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submit(ActivityPlanModifyApproveSubmitDto dto) {
        Validate.notNull(dto.getId(),"ID不能为空");
        ActivityPlanModify entity = this.activityPlanModifyRepository.getById(dto.getId());
        Validate.notNull(entity,"实例对象不存在！！");
        //待提交、驳回、追回的数据才能提交
        if (!ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) &&
                !ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) &&
                !ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus())){
            throw new RuntimeException("方案变更["+entity.getModifyBusinessCode()+"]不处于待提交、驳回、追回状态，不能提交审批！");
        }
        dto.setModifyBusinessCode(entity.getModifyBusinessCode());
        //预占用预算
        activityPlanBudgetModifyService.useMonthBudgetByModifyCode(entity.getModifyBusinessCode(),entity.getPlanCode(),true);

        this.commitProcess(dto);
    }

    /**
     * 提交工作流进行审批，提交成功返回流程实例ID，提交失败则抛出异常
     */
    private void commitProcess(ActivityPlanModifyApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull(processBusiness, "提交工作流时，未传工作流对象信息!");
        processBusiness.setBusinessNo(dto.getModifyBusinessCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString(dto));
        processBusiness.setBusinessCode(ActivityPlanConstant.PROCESS_NAME_ACTIVITY_PLAN_MODIFY);
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);

        //提交成功
        activityPlanModifyRepository.updateProcessStatusAndProcessNo(dto.getModifyBusinessCode(),ProcessStatusEnum.COMMIT.getKey(),processBusinessVo.getProcessNo());
    }

    /**i
     * 流程审批通过
     * @param dto 流程数据
     */
    @Override
    public void processPass(ProcessStatusDto dto) {
        activityPlanModifyRepository.updateProcessStatus(dto.getBusinessNo(),dto.getProcessStatus());
        //这里是有事务的
        passPushMq(dto.getProcessNo(),dto.getBusinessNo());
    }


    /**
     * 审批通过推送mq处理
     * @param processNo 流程编号
     * @param businessNo 业务编码
     */
    private void passPushMq(String processNo,String businessNo){
        if (StringUtils.isEmpty(businessNo)){
            return;
        }

        List<ActivityPlanModifyMqTagEnum> pushTagList = Lists.newArrayList();
        for (ActivityPlanModifyMqTagEnum mqTagEnum : ActivityPlanModifyMqTagEnum.values()) {
            if (ActivityPlanModifyMqTagEnum.PushType.code.equals(mqTagEnum.getPushType())){
                pushTagList.add(mqTagEnum);
            }
        }

        if (CollectionUtils.isEmpty(pushTagList)){
            return;
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String accountJson = "";
        String currentAccount = "";
        if (loginUserService != null) {
            currentAccount = loginUserService.getLoginAccountName();
            AbstractCrmUserIdentity userIdentity = loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString(userIdentity);
        }
        for (ActivityPlanModifyMqTagEnum mqTagEnum : pushTagList) {
            RocketMqProducerEvent rocketMqProducerEvent = new RocketMqProducerEvent(this, currentAccount,  accountJson,
                    false,uuid,
                    ActivityPlanModifyMqConstant.PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment(),
                    mqTagEnum.getCode(),businessNo);
            eventPublisher.publishEvent(rocketMqProducerEvent);
        }
    }

    /**
     * 流程审批追回/驳回
     * @param dto 流程数据
     */
    @Override
    public void processRejectAndRecover(ProcessStatusDto dto) {
        ActivityPlanModify entity = activityPlanModifyRepository.getByCode(dto.getBusinessNo());
        activityPlanBudgetModifyService.returnMonthBudgetByModifyCode(dto.getBusinessNo(),entity.getPlanCode());
        activityPlanModifyRepository.updateProcessStatus(dto.getBusinessNo(),dto.getProcessStatus());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ActivityPlanModifyDto doUpdateOriginData(String businessNo) {
        ActivityPlanModify modifyEntity = activityPlanModifyRepository.getByCode(businessNo);
        ActivityPlan planEntity = activityPlanRepository.getByPlanCode(modifyEntity.getPlanCode());

        //方案信息直接覆盖过去吧
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantFlagOpEntity.class);
        List<String> ignoreFieldList = Arrays.stream(propertyDescriptors).map(PropertyDescriptor::getName).collect(Collectors.toList());
        ignoreFieldList.add("processStatus");
        ignoreFieldList.add("processNo");
        String[] ignoreFieldArr = ignoreFieldList.toArray(new String[]{});
        BeanUtils.copyProperties(modifyEntity,planEntity,ignoreFieldArr);
        planEntity.setCurrModifyBusinessCode(modifyEntity.getModifyBusinessCode());
        activityPlanRepository.updateById(planEntity);


        List<ActivityPlanItemModify> itemModifyList = activityPlanItemModifyRepository.findListByModifyBusinessCode(businessNo);
        List<ActivityPlanItem> itemList = activityPlanItemRepository.findListByPlanCode(modifyEntity.getPlanCode());
        Map<String, ActivityPlanItemModify> itemModifyMap = itemModifyList.stream().collect(Collectors.toMap(ActivityPlanItemModify::getPlanItemCode, Function.identity()));
        for (ActivityPlanItem activityPlanItem : itemList) {
            ActivityPlanItemModify modifyItem = itemModifyMap.get(activityPlanItem.getPlanItemCode());
            BeanUtils.copyProperties(modifyItem,activityPlanItem,ignoreFieldArr);
            activityPlanItem.setCurrModifyBusinessCode(modifyItem.getModifyBusinessCode());
        }
        activityPlanItemRepository.updateBatchById(itemList);


        //关联方案也更新下
        activityPlanRelatePlanRepository.deleteByPlanCode(planEntity.getPlanCode());
        List<ActivityPlanRelatePlanModify> relatePlanModifyList = activityPlanRelatePLanModifyRepository.findListByModifyCode(businessNo);
        if (!CollectionUtils.isEmpty(relatePlanModifyList)){
            Collection<ActivityPlanRelatePlan> budgetShareList = nebulaToolkitService.copyCollectionByBlankList(relatePlanModifyList, ActivityPlanRelatePlanModify.class, ActivityPlanRelatePlan.class, HashSet.class, ArrayList.class);
            activityPlanRelatePlanRepository.saveBatch(budgetShareList);
        }

        //策略也更新下
        activityPlanStrategyRepository.deleteByPlanCode(planEntity.getPlanCode());
        List<ActivityPlanStrategyModify> strategyModifyList = activityPlanStrategyModifyRepository.findListByModifyCode(businessNo);
        if (!CollectionUtils.isEmpty(strategyModifyList)){
            Collection<ActivityPlanStrategy> strategyList = nebulaToolkitService.copyCollectionByBlankList(strategyModifyList, ActivityPlanStrategyModify.class, ActivityPlanStrategy.class, HashSet.class, ArrayList.class);
            activityPlanStrategyRepository.saveBatch(strategyList);
        }

        //先退下减少的预算
        List<ActivityPlanBudgetModify> budgetModifyList = activityPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList(businessNo));
        List<ActivityPlanBudget> activityPlanBudgets = activityPlanBudgetRepository.listByPlanCode(planEntity.getPlanCode());
        activityPlanBudgetModifyService.passReturnMonthBudgetByModifyCode(activityPlanBudgets,budgetModifyList);

        //预算也更新下
        Map<String, BigDecimal> usedAmountMap = activityPlanBudgets.stream()
                .filter(item -> null != item.getUsedAmount())
                .collect(Collectors.groupingBy(item -> item.getPlanItemCode() + item.getMonthBudgetCode(),
                        Collectors.reducing(BigDecimal.ZERO, ActivityPlanBudget::getUsedAmount, BigDecimal::add)));
        activityPlanBudgetRepository.deletePhysicalByPlanCode(planEntity.getPlanCode());
        if (!CollectionUtils.isEmpty(budgetModifyList)){
            Collection<ActivityPlanBudget> budgetList = nebulaToolkitService.copyCollectionByBlankList(budgetModifyList, ActivityPlanBudgetModify.class, ActivityPlanBudget.class, HashSet.class, ArrayList.class);
            //设置已使用金额
            Map<String, List<ActivityPlanBudget>> budgetShareMap = budgetList.stream().collect(Collectors.groupingBy(item -> item.getPlanItemCode() + item.getMonthBudgetCode()));
            for (Map.Entry<String, BigDecimal> entry : usedAmountMap.entrySet()) {
                BigDecimal usedAmount = entry.getValue();
                if (usedAmount.compareTo(BigDecimal.ZERO) == 0){
                    continue;
                }
                List<ActivityPlanBudget> thisBudgetShareList = budgetShareMap.get(entry.getKey());
                if (CollectionUtils.isEmpty(thisBudgetShareList)){
                    continue;//讲道理不应该有这种情况
                }
                for (ActivityPlanBudget budget : thisBudgetShareList) {
                    if (budget.getUseAmount().compareTo(usedAmount) >= 0){
                        budget.setUsedAmount(Optional.ofNullable(budget.getUsedAmount()).orElse(BigDecimal.ZERO).add(usedAmount));
                        usedAmount = BigDecimal.ZERO;
                    }else{
                        budget.setUsedAmount(budget.getUseAmount());
                        usedAmount = usedAmount.subtract(budget.getUseAmount());
                    }
                }
                if (usedAmount.compareTo(BigDecimal.ZERO) != 0){
                    ActivityPlanBudget firstBudget = thisBudgetShareList.get(0);
                    firstBudget.setUsedAmount(Optional.ofNullable(firstBudget.getUsedAmount()).orElse(BigDecimal.ZERO).add(usedAmount));
                }
            }
            activityPlanBudgetRepository.saveBatch(budgetList);
        }

        //门店信息如果有的话也更新下（专用于垂直促销人员变更才会有）
        List<ActivityPlanItemTerminalModify> planItemTerminalModifyList = activityPlanItemTerminalModifyRepository.findByModifyBusinessCode(businessNo);
        if (!CollectionUtils.isEmpty(planItemTerminalModifyList)){
            Set<String> originIdSet = planItemTerminalModifyList.stream().map(ActivityPlanItemTerminalModify::getOriginId).collect(Collectors.toSet());
            activityPlanItemTerminalRepository.removeByIds(originIdSet);
            Collection<ActivityPlanItemTerminal> budgetList = nebulaToolkitService.copyCollectionByBlankList(planItemTerminalModifyList, ActivityPlanItemTerminalModify.class, ActivityPlanItemTerminal.class, HashSet.class, ArrayList.class);
            activityPlanItemTerminalRepository.saveBatch(budgetList);
        }

        ActivityPlanModifyDto activityPlanModifyDto = nebulaToolkitService.copyObjectByWhiteList(modifyEntity,ActivityPlanModifyDto.class,HashSet.class,ArrayList.class);
        List<ActivityPlanItemModifyDto> activityPlanItemDtos = (List<ActivityPlanItemModifyDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItem.class, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class);
        activityPlanModifyDto.setItemList(activityPlanItemDtos);
        return activityPlanModifyDto;
    }

    @Override
    @org.springframework.transaction.annotation.Transactional(rollbackFor = Exception.class)
    public void passReturnMonthBudgetByModifyCode(String modifyBusinessCode) {
        ActivityPlanModify modifyEntity = activityPlanModifyRepository.getByCode(modifyBusinessCode);
        ActivityPlan planEntity = activityPlanRepository.getByPlanCode(modifyEntity.getPlanCode());
        List<ActivityPlanBudgetModify> budgetModifyList = activityPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList(modifyBusinessCode));
        List<ActivityPlanBudget> activityPlanBudgets = activityPlanBudgetRepository.listByPlanCode(planEntity.getPlanCode());
        activityPlanBudgetModifyService.passReturnMonthBudgetByModifyCode(activityPlanBudgets,budgetModifyList);
    }


    private void backupInitVersionData(String planCode) {
        List<ActivityPlan> noModifyList = activityPlanRepository.list(
                Wrappers.<ActivityPlan>lambdaQuery()
                        .eq(ActivityPlan::getPlanCode, planCode)
                        .and(w -> {
                            w.eq(ActivityPlan::getHasModify, BooleanEnum.FALSE.getCapital());
                            w.or();
                            w.isNull(ActivityPlan::getHasModify);
                        })
        );
        if (CollectionUtils.isEmpty(noModifyList)){
            //不是第一次变更，已经备份过了
            return;
        }
        ActivityPlan planEntity = activityPlanRepository.getByPlanCode(planCode);
        ActivityPlanModify activityPlanModify = nebulaToolkitService.copyObjectByWhiteList(planEntity, ActivityPlanModify.class, HashSet.class, ArrayList.class);
        activityPlanModifyRepository.save(activityPlanModify);

        List<ActivityPlanItem> itemList = activityPlanItemRepository.findListByPlanCode(planCode);
        List<ActivityPlanItemModify> itemModifyList = (List<ActivityPlanItemModify>) nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItem.class, ActivityPlanItemModify.class, HashSet.class, ArrayList.class);
        activityPlanItemModifyRepository.saveBatch(itemModifyList);

        List<ActivityPlanRelatePlan> relatePlanList = activityPlanRelatePlanRepository.findListByPlanCode(planCode);
        List<ActivityPlanRelatePlanModify> relatePlanModifyList = (List<ActivityPlanRelatePlanModify>) nebulaToolkitService.copyCollectionByBlankList(relatePlanList, ActivityPlanRelatePlan.class, ActivityPlanRelatePlanModify.class, HashSet.class, ArrayList.class);
        activityPlanRelatePLanModifyRepository.saveBatch(relatePlanModifyList);

        List<ActivityPlanStrategy> strategyList = activityPlanStrategyRepository.findListByPlanCode(planCode);
        List<ActivityPlanStrategyModify> strategyModifyList = (List<ActivityPlanStrategyModify>) nebulaToolkitService.copyCollectionByBlankList(strategyList, ActivityPlanStrategy.class, ActivityPlanStrategyModify.class, HashSet.class, ArrayList.class);
        activityPlanStrategyModifyRepository.saveBatch(strategyModifyList);

        List<ActivityPlanBudget> budgetList = activityPlanBudgetRepository.listByPlanCode(planCode);
        List<ActivityPlanBudgetModify> budgetModifyList = (List<ActivityPlanBudgetModify>) nebulaToolkitService.copyCollectionByBlankList(budgetList, ActivityPlanBudget.class, ActivityPlanBudgetModify.class, HashSet.class, ArrayList.class);
        activityPlanBudgetModifyRepository.saveBatch(budgetModifyList);

        activityPlanRepository.update(
                Wrappers.<ActivityPlan>lambdaUpdate()
                        .set(ActivityPlan::getHasModify,BooleanEnum.TRUE.getCapital())
                        .eq(ActivityPlan::getPlanCode, planCode)
        );
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        List<ActivityPlanModify> entities = activityPlanModifyRepository.listByIds(ids);
        Validate.notEmpty(entities,"未查询到要删除的数据！");
        for (ActivityPlanModify entity : entities) {
            Validate.isTrue(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) ||
                            ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) ||
                            ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()),
                    "方案变更["+entity.getModifyBusinessCode()+"]不是待提交、驳回或追回状态，不能删除！");
        }
        activityPlanModifyRepository.deleteIds(ids);
        List<String> modifyCodes = entities.stream().map(ActivityPlanModify::getModifyBusinessCode).collect(Collectors.toList());
        activityPlanItemModifyService.deleteByModifyCodes(modifyCodes);
        activityPlanBudgetModifyService.deleteByModifyCodes(modifyCodes);
        activityPlanStrategyModifyService.deleteByModifyCodes(modifyCodes);
        activityPlanRelatePlanModifyService.deleteByModifyCodes(modifyCodes);

        //删除业务日志
        Collection<ActivityPlanModifyDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(entities,
                ActivityPlanModify.class, ActivityPlanModifyDto.class, HashSet.class, ArrayList.class);
        SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanModifyLogEventDto> onDelete =
                ActivityPlanLogEventListener::onDeleteModify;
        for (ActivityPlanModifyDto dto : dtoList) {
            ActivityPlanModifyLogEventDto logEventDto = new ActivityPlanModifyLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onDelete);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void verticalPersonUpdateJob() {
        //按方案分组
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE,-1);//默认处理前一天的数据
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        verticalPersonUpdateJob(simpleDateFormat.format(calendar.getTime()));
    }

    @Transactional(rollbackFor = Exception.class)
    public void verticalPersonUpdateJob(String updateDate) {
        //按方案分组
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(simpleDateFormat.parse(updateDate));
        } catch (ParseException e) {
            throw new RuntimeException("时间参数有误！");
        }
        PromotersDto mdmPromotersQueryDto = new PromotersDto();
        //1、从岗店关系中查创建时间是当天的所有门店编码
        mdmPromotersQueryDto.setUserType("ZKCC");
        mdmPromotersQueryDto.setCreateDate(updateDate);
//        mdmPromotersQueryDto.setTerminalCodeSet(allTerminalCodeSet);
        List<PromotersVo> updatePromoterVoList = promotersVoService.findTerminalPromotersByTerminal(mdmPromotersQueryDto);
        if (CollectionUtils.isEmpty(updatePromoterVoList)){
            return;
        }
        Set<String> terminalCodeList = updatePromoterVoList.stream().map(PromotersVo::getTerminalCode).collect(Collectors.toSet());
        mdmPromotersQueryDto = new PromotersDto();
        //1、从岗店关系中查创建时间是当天的所有门店编码
        mdmPromotersQueryDto.setUserType("ZKCC");
        mdmPromotersQueryDto.setTerminalCodeSet(terminalCodeList);
        List<PromotersVo> promoterVoList = promotersVoService.findTerminalPromotersByTerminal(mdmPromotersQueryDto);

        Map<String, List<PromotersVo>> terminalEmployeeMap = promoterVoList.stream().collect(Collectors.groupingBy(PromotersVo::getTerminalCode));

        //查询当前生效的活动方案中包含这部分有变更的门店 的促销人员信息
        List<ActivityPlanItemTerminalVo> verticalPersonUpdateList = activityPlanItemTerminalRepository.findVerticalPersonUpdateList(Lists.newArrayList(terminalCodeList),updateDate);

        Map<String,List<ActivityPlanItemModifyDto>> modifyItemMap = Maps.newHashMap();

        calendar.set(Calendar.HOUR_OF_DAY,23);
        calendar.set(Calendar.MINUTE,23);
        calendar.set(Calendar.SECOND,59);
        Date nowEndDate = calendar.getTime();

        calendar.add(Calendar.DATE,1);
        calendar.set(Calendar.HOUR_OF_DAY,0);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND,0);
        Date nextBeginDate = calendar.getTime();


        Map<String, List<ActivityPlanItemTerminalVo>> verticalPersonUpdatePlanMap = verticalPersonUpdateList.stream().collect(Collectors.groupingBy(ActivityPlanItemTerminalVo::getPlanCode));
        for (Map.Entry<String, List<ActivityPlanItemTerminalVo>> entry : verticalPersonUpdatePlanMap.entrySet()) {
            String planCode = entry.getKey();
            List<ActivityPlanItemTerminalVo> planTerminalList = entry.getValue();
            Map<String, List<ActivityPlanItemTerminalVo>> planItemTerminalMap = planTerminalList.stream().collect(Collectors.groupingBy(item ->
                    item.getPlanItemCode() + "-" + item.getTerminalCode()));
            List<ActivityPlanItemModifyDto> modifyItemList = Lists.newArrayList();
            for (Map.Entry<String, List<ActivityPlanItemTerminalVo>> planTerminalEntry : planItemTerminalMap.entrySet()) {
                String[] keySplit = planTerminalEntry.getKey().split("-");
                String planItemCode = keySplit[0];
                String terminalCode = keySplit[1];
                List<ActivityPlanItemTerminalVo> terminalEmployeeList = planTerminalEntry.getValue();
                List<PromotersVo> employeeList = terminalEmployeeMap.get(terminalCode);
                Set<String> employeeCodeSet = employeeList.stream().map(PromotersVo::getEmployeeCode).collect(Collectors.toSet());
                //判断下人员有无变更
                boolean hasUpdate = false;

                List<ActivityPlanItemTerminalVo> updateTerminalEmployeeList = Lists.newArrayList();
                for (ActivityPlanItemTerminalVo terminalEmployee : terminalEmployeeList) {
                    if (!employeeCodeSet.contains(terminalEmployee.getEmployeeCode())){
                        //有变更
                        hasUpdate = true;
                        updateTerminalEmployeeList.add(terminalEmployee);
                    }
                }
                if (!hasUpdate){
                    continue;
                }else {
                    //有变更的话看下当前人够不够，不够的话就不处理
                    if (employeeCodeSet.size() < terminalEmployeeList.size()){
                        continue;
                    }
                }
                ActivityPlanItemModifyDto activityPlanItemModifyDto = new ActivityPlanItemModifyDto();
                activityPlanItemModifyDto.setPlanCode(planCode);
                activityPlanItemModifyDto.setPlanItemCode(planItemCode);

                List<ActivityPlanItemTerminalModifyDto> terminalModifyList = Lists.newArrayList();
                Set<String> planEmployeeSet = terminalEmployeeList.stream().map(ActivityPlanItemTerminalVo::getEmployeeCode).collect(Collectors.toSet());
                for (ActivityPlanItemTerminalVo activityPlanItemTerminalVo : updateTerminalEmployeeList) {
                    Date beginDate = activityPlanItemTerminalVo.getBeginDate();
                    Date endDate = activityPlanItemTerminalVo.getEndDate();

                    Calendar tempCalendar = Calendar.getInstance();
                    tempCalendar.setTime(beginDate);
                    int firstDaySize = 0;
                    int daySize = 0;
                    while (tempCalendar.getTime().before(endDate)){
                        tempCalendar.add(Calendar.DATE,1);
                        daySize += 1;
                        if (tempCalendar.getTime().before(nowEndDate)){
                            firstDaySize += 1;
                        }
                    }

                    //这里的人在岗店关系里面没有了，要变更
                    BigDecimal amount = activityPlanItemTerminalVo.getAmount();
                    BigDecimal endAmount = amount.multiply(new BigDecimal(firstDaySize)).divide(new BigDecimal(daySize),2,RoundingMode.HALF_DOWN);
                    ActivityPlanItemTerminalModifyDto activityPlanItemTerminalModifyDto = nebulaToolkitService.copyObjectByWhiteList(activityPlanItemTerminalVo,ActivityPlanItemTerminalModifyDto.class,HashSet.class,ArrayList.class);
                    activityPlanItemTerminalModifyDto.setOriginId(activityPlanItemTerminalVo.getId());
                    activityPlanItemTerminalModifyDto.setBeginDate(beginDate);
                    activityPlanItemTerminalModifyDto.setEndDate(nowEndDate);
                    activityPlanItemTerminalModifyDto.setAmount(endAmount);
                    terminalModifyList.add(activityPlanItemTerminalModifyDto);

                    //找下替代他的人
                    PromotersVo thisPromotersVo = null;
                    for (PromotersVo promotersVo : employeeList) {
                        if(!planEmployeeSet.contains(promotersVo.getEmployeeCode())){
                            thisPromotersVo = promotersVo;
                            break;
                        }
                    }
                    planEmployeeSet.add(thisPromotersVo.getEmployeeCode());
                    ActivityPlanItemTerminalModifyDto activityPlanItemTerminalModifyDto2 = new ActivityPlanItemTerminalModifyDto();
                    activityPlanItemTerminalModifyDto2.setPlanCode(activityPlanItemTerminalVo.getPlanCode());
                    activityPlanItemTerminalModifyDto2.setPlanItemCode(activityPlanItemTerminalVo.getPlanItemCode());
                    activityPlanItemTerminalModifyDto2.setOriginId(activityPlanItemTerminalVo.getId());
                    BeanUtils.copyProperties(thisPromotersVo,activityPlanItemTerminalModifyDto2);
//                    activityPlanItemTerminalModifyDto2.setTerminalCode(activityPlanItemTerminalVo.getTerminalCode());
//                    activityPlanItemTerminalModifyDto2.setEmployeeCode(thisEmployeeCode);
                    activityPlanItemTerminalModifyDto2.setBeginDate(nextBeginDate);
                    activityPlanItemTerminalModifyDto2.setEndDate(activityPlanItemTerminalVo.getEndDate());
                    activityPlanItemTerminalModifyDto2.setAmount(amount.subtract(endAmount));
                    terminalModifyList.add(activityPlanItemTerminalModifyDto2);
                }
                activityPlanItemModifyDto.setActivityPlanItemTerminalList(terminalModifyList);
                modifyItemList.add(activityPlanItemModifyDto);
            }
            if (modifyItemList.size() == 0){
                //无变更
                continue;
            }
            modifyItemMap.put(planCode,modifyItemList);
        }
        if (modifyItemMap.size() == 0){
            //无变更
            return;
        }
        for (Map.Entry<String, List<ActivityPlanItemModifyDto>> entry : modifyItemMap.entrySet()) {
            String planCode = entry.getKey();
            List<ActivityPlanItemModifyDto> value = entry.getValue();
            List<String> planItemCodeList = value.stream().map(ActivityPlanItemModifyDto::getPlanItemCode).collect(Collectors.toList());
            ActivityPlanVo planVo = activityPlanService.findByCode(planCode);
            ActivityPlanModifyDto dto = nebulaToolkitService.copyObjectByWhiteList(planVo, ActivityPlanModifyDto.class, HashSet.class, ArrayList.class);
            dto.setId(null);
            List<ActivityPlanItemDto> itemDtoList = activityPlanItemRepository.findDtoAndAttachListByPlanItemCode(planItemCodeList);
            List<ActivityPlanItemModifyDto> modifyItemDtoList = Lists.newArrayList();
            for (ActivityPlanItemDto planItemDto : itemDtoList) {
                ActivityPlanItemModifyDto modifyItemDto = nebulaToolkitService.copyObjectByWhiteList(planItemDto, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class);
                if (!CollectionUtils.isEmpty(planItemDto.getBudgetShares())){
                    modifyItemDto.setBudgetShares((List<ActivityPlanBudgetModifyDto>)(List)nebulaToolkitService.copyCollectionByWhiteList(planItemDto.getBudgetShares(), ActivityPlanBudgetDto.class, ActivityPlanBudgetModifyDto.class,HashSet.class,ArrayList.class));
                }
                modifyItemDto.setId(null);
                modifyItemDtoList.add(modifyItemDto);
            }


            //设置促销人员变更信息
            Map<String, ActivityPlanItemModifyDto> modifyItemDtoMap = modifyItemDtoList.stream().collect(Collectors.toMap(ActivityPlanItemModifyDto::getPlanItemCode, Function.identity()));
            Set<String> planTerminalIdList = Sets.newHashSet();
            for (ActivityPlanItemModifyDto activityPlanItemModifyDto : value) {
                for (ActivityPlanItemTerminalModifyDto activityPlanItemTerminalModifyDto : activityPlanItemModifyDto.getActivityPlanItemTerminalList()) {
                    planTerminalIdList.add(activityPlanItemTerminalModifyDto.getOriginId());
                }
            }
            List<ActivityPlanItemTerminal> activityPlanItemTerminals = activityPlanItemTerminalRepository.listByIds(planTerminalIdList);
            Map<String, ActivityPlanItemTerminal> terminalEntityMap = activityPlanItemTerminals.stream().collect(Collectors.toMap(ActivityPlanItemTerminal::getId, Function.identity()));

            for (ActivityPlanItemModifyDto activityPlanItemModifyDto : value) {
                List<ActivityPlanItemTerminalModifyDto> planItemTerminalList = Lists.newArrayList();
                for (ActivityPlanItemTerminalModifyDto activityPlanItemTerminalModifyDto : activityPlanItemModifyDto.getActivityPlanItemTerminalList()) {
                    ActivityPlanItemTerminal activityPlanItemTerminal = terminalEntityMap.get(activityPlanItemTerminalModifyDto.getOriginId());
                    ActivityPlanItemTerminalModifyDto newPlanItemTerminal = nebulaToolkitService.copyObjectByWhiteList(activityPlanItemTerminal, ActivityPlanItemTerminalModifyDto.class, HashSet.class, ArrayList.class);
//                    BeanUtil.copyProperties(activityPlanItemTerminalModifyDto,newPlanItemTerminal);
                    newPlanItemTerminal.setId(null);
                    newPlanItemTerminal.setOriginId(activityPlanItemTerminalModifyDto.getOriginId());
                    newPlanItemTerminal.setEmployeeCode(activityPlanItemTerminalModifyDto.getEmployeeCode());
                    newPlanItemTerminal.setName(activityPlanItemTerminalModifyDto.getName());
                    newPlanItemTerminal.setEmpId(activityPlanItemTerminalModifyDto.getEmpId());
                    newPlanItemTerminal.setResponsibleBusiness(activityPlanItemTerminalModifyDto.getResponsibleBusiness());
                    newPlanItemTerminal.setResponsibleSupervision(activityPlanItemTerminalModifyDto.getResponsibleSupervision());
                    newPlanItemTerminal.setBeginDate(activityPlanItemTerminalModifyDto.getBeginDate());
                    newPlanItemTerminal.setEndDate(activityPlanItemTerminalModifyDto.getEndDate());
                    newPlanItemTerminal.setAmount(activityPlanItemTerminalModifyDto.getAmount());

                    planItemTerminalList.add(newPlanItemTerminal);
                }
                ActivityPlanItemModifyDto planItemModifyDto = modifyItemDtoMap.get(activityPlanItemModifyDto.getPlanItemCode());
                planItemModifyDto.setActivityPlanItemTerminalList(planItemTerminalList);
            }

            //岗店关系有变更且有人员更替,自动生成方案变更数据
            String modifyBusinessCode = create(dto,modifyItemDtoList);
            //直接审批通过并变更数据
            ProcessStatusDto processStatusDto = new ProcessStatusDto();
            processStatusDto.setBusinessNo(modifyBusinessCode);
            processStatusDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            processPass(processStatusDto);
        }
    }
}
