package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanStrategyModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanStrategyModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanStrategyModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanStrategyModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案-关联策略服务
 * @author wanghaojia
 * @date 2022/11/23 16:01
 */
@Service
public class ActivityPlanStrategyModifyServiceImpl implements ActivityPlanStrategyModifyService {

    @Autowired(required = false)
    private ActivityPlanStrategyModifyRepository activityPlanStrategyRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param strategyList  活动方案关联策略数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityPlanStrategyList(ActivityPlanModify entity,boolean update, List<ActivityPlanStrategyModifyDto> strategyList) {
        if (CollectionUtils.isEmpty(strategyList)){
            return;
        }

        Map<String, ActivityPlanStrategyModify> oldMap = Maps.newHashMap();
        if (update){
            List<ActivityPlanStrategyModify> oldList = activityPlanStrategyRepository.findListByModifyCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityPlanStrategyModify::getId, Function.identity()));
        }
        List<ActivityPlanStrategyModify> activityPlanStrategies = (List<ActivityPlanStrategyModify>) nebulaToolkitService.copyCollectionByWhiteList(strategyList, ActivityPlanStrategyModifyDto.class, ActivityPlanStrategyModify.class, HashSet.class, ArrayList.class);

        List<ActivityPlanStrategyModify> saveList = Lists.newArrayList();
        List<ActivityPlanStrategyModify> updateList = Lists.newArrayList();
        for (ActivityPlanStrategyModify item : activityPlanStrategies) {
            if (oldMap.containsKey(item.getId())){
                updateList.add(item);
                oldMap.remove(item.getId());
            }else{
                item.setPlanCode(entity.getPlanCode());
                item.setModifyBusinessCode(entity.getModifyBusinessCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityPlanStrategyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityPlanStrategyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0){
            //待删除的数据
            activityPlanStrategyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)){
            return;
        }
        activityPlanStrategyRepository.deleteByModifyCodes(modifyCodes);
    }
}
