package com.biz.crm.tpm.business.activity.plan.local.notifier;

import com.biz.crm.kms.business.financial.auditing.sdk.dto.totpm.KmsActivityPlanItemDto;
import com.biz.crm.kms.business.financial.auditing.sdk.dto.totpm.KmsCreateActivityPlanDto;
import com.biz.crm.kms.business.financial.auditing.sdk.event.KmsCreateActivityPlanEvent;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.KmsCreateActivityPlanResponse;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDetailDto;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanWhereFrom;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * KMS生成活动方案
 * @author wanghaojia
 * @date 2023/4/8 13:53
 */
@Component
public class KmsCreateActivityPlanEventImpl implements KmsCreateActivityPlanEvent {

    @Autowired(required = false)
    private ActivityPlanService activityPlanService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;


    @Autowired(required = false)
    private ProductVoService productVoService;

    @Override
    public KmsCreateActivityPlanResponse createActivityPlan(KmsCreateActivityPlanDto dto) {
        List<KmsActivityPlanItemDto> itemList = dto.getItemList();
        Validate.isTrue(!CollectionUtils.isEmpty(dto.getItemList()),"明细行不能为空");
        String[] propertiesFilter = new String[]{"itemList"};
        ActivityPlanDto activityPlanDto = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlanDto.class, HashSet.class, ArrayList.class, propertiesFilter);
        activityPlanDto.setPlanType(ActivityPlanTypeEnum.region.getCode());
        List<ActivityPlanItemDto> activityPlanItemList = Lists.newArrayList();
        List<String> activityOrgCodeList = dto.getItemList().stream().map(KmsActivityPlanItemDto::getActivityOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String,SalesOrgVo> salesOrgMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(activityOrgCodeList)){
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findBySalesOrgCodes(activityOrgCodeList);
            salesOrgMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(),(o,n)->n));
        }
        List<String> productCodeList = itemList.stream().map(KmsActivityPlanItemDto::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String,ProductVo> productVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(productCodeList)){
            List<ProductVo> productVoList = productVoService.findByCodes(productCodeList);
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(),(o,n)->n));
        }
        for (KmsActivityPlanItemDto kmsActivityPlanItemDto : itemList) {
            ActivityPlanItemDto itemDto = nebulaToolkitService.copyObjectByWhiteList(kmsActivityPlanItemDto, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);
            itemDto.setActivityBeginDate(kmsActivityPlanItemDto.getActivityBeginTime());
            itemDto.setActivityEndDate(kmsActivityPlanItemDto.getActivityEndTime());
            if (StringUtils.isNotEmpty(kmsActivityPlanItemDto.getActivityOrgCode())){
                SalesOrgVo salesOrgVo = salesOrgMap.get(kmsActivityPlanItemDto.getActivityOrgCode());
                if (null != salesOrgVo){
                    itemDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                    itemDto.setDistributionChannelCode(salesOrgVo.getChannelCode());
                    itemDto.setDistributionChannelName(salesOrgVo.getChannelName());
                }
            }
            //查下产品单位
            if (StringUtils.isNotEmpty(itemDto.getProductCode()) && productVoMap.containsKey(itemDto.getProductCode())){
                ProductVo productVo = productVoMap.get(itemDto.getProductCode());
                itemDto.setProductUnit(productVo.getBaseUnit());
            }
            activityPlanItemList.add(itemDto);
            activityPlanDto.setRegionCode(itemDto.getRegion());
        }
        activityPlanDto.setItemList(activityPlanItemList);
        if (StringUtils.isEmpty(dto.getWhereFrom())){
            activityPlanDto.setWhereFrom(ActivityPlanWhereFrom.KMS.getCode());
        }else{
            activityPlanDto.setWhereFrom(dto.getWhereFrom());
        }
        String planCode = activityPlanService.createActivityPlan(activityPlanDto);
        return new KmsCreateActivityPlanResponse(){{
            this.setPlanCode(planCode);
        }};
    }

}
