package com.biz.crm.tpm.business.activity.plan.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanQueryActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanQueryActivityDetailPlanResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQueryActivityDetailPlanListener;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 活动方案(ActivityPlan)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class ActivityPlanDataViewRegister implements MnDataviewRegister {

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    @Qualifier("inParameterOperatorBindingStrategy")
    private ParameterOperatorBindingStrategy inParameterOperatorBindingStrategy;

    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Override
    public String code() {
        return "tpm_activity_plan_data_view";
    }

    @Override
    public String desc() {
        return "TPM-活动方案";
    }

    @Override
    public String buildSql() {
        return "select\n" +
                "a.id,\n" +
                "a.create_account,\n" +
                "a.create_name,\n" +
                "a.create_time,\n" +
                "a.modify_account,\n" +
                "a.modify_name,\n" +
                "a.modify_time,\n" +
                "a.del_flag,\n" +
                "a.enable_status,\n" +
                "a.remark,\n" +
                "a.tenant_code,\n" +
                "a.plan_code,\n" +
                "a.plan_name,\n" +
                "a.plan_type,\n" +
                "a.business_format_code,\n" +
                "a.business_unit_code,\n" +
                "a.begin_date,\n" +
                "a.end_date,\n" +
                "a.plan_org_code,\n" +
                "a.plan_org_name,\n" +
                "a.plan_classify,\n" +
                "a.plan_relate_limit_code,\n" +
                "a.plan_status,\n" +
                "a.fee_amount,\n" +
                "a.head_fee_amount,\n" +
                "a.department_fee_amount,\n" +
                "a.customer_fee_amount,\n" +
                "a.total_fee_amount,\n" +
                "a.region_automatic_fee_amount,\n" +
                "a.region_referendum_fee_amount,\n" +
                "a.used_amount,\n" +
                "a.sales_amount,\n" +
                "a.plan_io_rate,\n" +
                "a.plan_title,\n" +
                "a.plan_goal,\n" +
                "a.activity_background,\n" +
                "a.activity_target,\n" +
                "a.detail_explain,\n" +
                "a.full_accept,\n" +
                "a.template_config_code,\n" +
                "a.template_config_name,\n" +
                "a.process_no,\n" +
                "a.process_status,\n" +
                "a.where_from,\n" +
                "a.has_modify,\n" +
                "a.curr_modify_business_code,\n" +
                "a.is_cross_month,\n" +
                "a.nect_business_unit_code,\n" +
                "a.is_validate,\n" +
                "a.region_code,\n" +

                "group_concat(org.org_code) as department_code,\n" +
                "group_concat(org.org_name) as department_name,\n" +
                "'' as parent_department_name,\n" +
                "'' as plan_item_code,\n" +
                "'' as relate_detail_plan_code\n" +
                " from tpm_activity_plan a\n" +
                " left join tpm_activity_plan_org org on org.plan_code = a.plan_code\n" +
                "where a.tenant_code = :tenantCode\n" +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'\n" +
                "group by a.plan_code";
    }

    @Override
    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        if (!(executeParameter instanceof DatabaseExecuteParameter)){
            return null;
        }
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter) executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = databaseExecuteExternalRequest.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        String valueStr = String.valueOf(value);
        if (ActivityPlanExecuteParameterBuildInterceptor.parent_department_name.equals(databaseExecuteParameter.getTargetFieldName())){
           return parentDepartmentNameQuery(databaseExecuteParameter,valueStr);
        }else if (ActivityPlanExecuteParameterBuildInterceptor.plan_item_code.equals(databaseExecuteParameter.getTargetFieldName())){
           return planItemCodeQuery(databaseExecuteParameter,valueStr);
        }else if (ActivityPlanExecuteParameterBuildInterceptor.relate_detail_plan_code.equals(databaseExecuteParameter.getTargetFieldName())){
           return relateDetailPlanItemCodeQuery(databaseExecuteParameter,valueStr);
        }else if (ActivityPlanExecuteParameterBuildInterceptor.process_no.equals(databaseExecuteParameter.getTargetFieldName())){
           return processNoQuery(databaseExecuteParameter,valueStr);
        }
        return valueStr;
    }

    private Object processNoQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "plan_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        List<ProcessBusinessMappingVo> processBusinessMappingVos = processBusinessMappingService.findAllByProcessNoCollection(Lists.newArrayList(valueStr));
        if (CollectionUtils.isEmpty(processBusinessMappingVos)){
            return Lists.newArrayList("_");
        }
        return processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
    }

    private Object parentDepartmentNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr){
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "department_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        List<String> orgCodeList = Lists.newArrayList("_");
        //上级组织查询
        OrgQueryDto orgQueryDto = new OrgQueryDto();
        orgQueryDto.setOrgName(valueStr);
        Set<String> parentCodeSet = orgVoService.findByOrgQueryDto(orgQueryDto);
        if (CollectionUtils.isEmpty(parentCodeSet)){
            return orgCodeList;
        }
        orgQueryDto.setOrgName(null);
        List<String> parentOrgCodeList = Lists.newArrayList(parentCodeSet);
        orgQueryDto.setParentOrgCodeList(parentOrgCodeList);
        Set<String> codeSet = orgVoService.findByOrgQueryDto(orgQueryDto);
        orgCodeList.addAll(codeSet);
        return orgCodeList;
    }

    private Object relateDetailPlanItemCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "plan_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        //根据细案明细编码查询方案编码
        List<String> planCodeList = Lists.newArrayList("_");
        ActivityPlanQueryActivityDetailPlanDto queryActivityDetailPlanDto = new ActivityPlanQueryActivityDetailPlanDto();
        List<String> detailPlanCodeList = Arrays.asList(valueStr.split("[, ，]"));
        queryActivityDetailPlanDto.setDetailPlanCodeList(detailPlanCodeList);
        SerializableBiConsumer<ActivityPlanQueryActivityDetailPlanListener, ActivityPlanQueryActivityDetailPlanDto> queryActivityDetailPlan =
                ActivityPlanQueryActivityDetailPlanListener::detailPlanRelatePlanCodeList;
        ActivityPlanQueryActivityDetailPlanResponse queryActivityDetailPlanResponse = (ActivityPlanQueryActivityDetailPlanResponse) this.nebulaNetEventClient.directPublish(queryActivityDetailPlanDto,
                ActivityPlanQueryActivityDetailPlanListener.class, queryActivityDetailPlan);
        if (!CollectionUtils.isEmpty(queryActivityDetailPlanResponse.getPlanCodeList())){
            planCodeList.addAll(queryActivityDetailPlanResponse.getPlanCodeList());
        }
        return planCodeList;
    }

    private Object planItemCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "plan_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        //根据方案明细编码查询方案编码
        List<String> planCodeList = Lists.newArrayList("_");
        planCodeList.addAll(activityPlanItemRepository.findPlanCodeListByItemCodeList(Arrays.asList(valueStr.split("[, ，]"))));
        return planCodeList;
    }


}
