package com.biz.crm.tpm.business.activity.plan.local.register;

import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.persistence.EntityManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Description 活动方案视图字段扩展
 * @Author xiaoyoujun
 * @Date 2023/2/8 上午10:02
 */
@Slf4j
@Component
public class ActivityPlanQueryInterceptor implements ExternalQueryInterceptor {

    //扩展字段
    private static final String PARENT_NAME = "parent_org_name";
    private static final String DEPARTMENT_CODE = "department_code";

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Override
    public String code() {
        return "tpm_activity_plan_data_view"+"_"+PARENT_NAME;
    }

    @Override
    public String name() {
        return "活动方案-上级部门";
    }

    @Override
    public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String... strings) {
        //查询结果
        List<Map<String, Object>> results = executeContent.getResults();
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        //产品组会添加空数据进来。。。。过滤下
        List<String> orgCodeList = results.stream().filter(Objects::nonNull).map(item -> item.get(DEPARTMENT_CODE)).filter(Objects::nonNull)
                .flatMap(item -> Arrays.stream(String.valueOf(item).split(",")))
                .distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgCodeList)){
            return null;
        }
        List<OrgVo> orgVos = orgVoService.findByOrgCodes(orgCodeList);
        if (CollectionUtils.isEmpty(orgVos)){
            return null;
        }
        List<String> parentOrgCodeList = orgVos.stream().map(OrgVo::getParentCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parentOrgCodeList)){
            return null;
        }
        List<OrgVo> parentOrgVos = orgVoService.findByOrgCodes(parentOrgCodeList);
        if (CollectionUtils.isEmpty(parentOrgVos)){
            return null;
        }
        Map<String, String> orgParentMap = orgVos.stream().filter(item -> StringUtil.isNotEmpty(item.getParentCode()))
                .collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getParentCode, (o, n) -> n));
        Map<String, String> parentNameMap = parentOrgVos.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (o, n) -> n));

        //数据处理
        List<Object[]> contents = Lists.newArrayList();
        for (Map<String, Object> item : results) {
            if (null == item){
                contents.add(null);
                continue;
            }
            Object departmentCodeObj = item.get(DEPARTMENT_CODE);
            if (null == departmentCodeObj){
                contents.add(null);
                continue;
            }
            List<String> parentOrgNameList = Lists.newArrayList();
            String orgCodes = String.valueOf(departmentCodeObj);
            for (String orgCode : orgCodes.split(",")) {
                String parentOrgCode = orgParentMap.get(orgCode);
                if (StringUtil.isEmpty(parentOrgCode)){
                    continue;
                }
                String parentOrgName = parentNameMap.get(parentOrgCode);
                if (StringUtil.isEmpty(parentOrgName)){
                    continue;
                }
                parentOrgNameList.add(parentOrgName);
            }
            contents.add(parentOrgNameList.toArray(new Object[]{}));
        }
        return contents;
    }
}
