package com.biz.crm.tpm.business.activity.plan.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemExtend;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

import javax.persistence.Column;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 活动方案(ActivityPlan)数据视图注册器
 *
 * @author xiaoyoujun
 * @since
 */
@Component
public class ActivityPlanReportDataViewRegister implements DataviewRegister {

    private List<String> itemTableFieldList = null;
    private List<String> extendTableFieldList = null;

    @Override
    public String code() {
        return "tpm_activity_plan_Report_data_view";
    }

    @Override
    public String desc() {
        return "TPM-活动方案报表";
    }

    @Override
    public String buildSql() {

        StringBuilder itemTableFieldBuilder = new StringBuilder();
        List<String> itemTableFieldList = getItemTableFieldList();
        for (String tableField : itemTableFieldList) {
            itemTableFieldBuilder.append("b.").append(tableField).append("\n,");
        }

        StringBuilder extendTableFieldBuilder = new StringBuilder();
        List<String> extendTableFieldList = getExtendTableFieldList();
        for (String tableField : extendTableFieldList) {
            extendTableFieldBuilder.append("c.").append(tableField).append("\n,");
        }
        return "select \n" +
                "a.plan_code, \n" +
                "a.plan_name, \n" +
                "a.business_format_code, \n" +
                "a.business_unit_code, \n" +
                "a.plan_type, \n" +
                "a.department_code,\n" +
                "a.department_name,\n" +
                "a.plan_classify, \n" +
                "a.plan_relate_limit_code, \n" +
                "a.plan_org_code,\n" +
                "a.plan_org_erp_code,\n" +
                "a.plan_org_name,\n" +
                "a.begin_date,\n" +
                "a.end_date,\n" +
                "a.process_status,\n" +
                itemTableFieldBuilder +
                extendTableFieldBuilder +
                "substr(b.activity_begin_date,1,10) activity_begin_date, \n" +
                "substr(b.activity_end_date,1,10) activity_end_date, \n" +
                "substr(b.fee_year_month,1,7) fee_year_month \n" +
                "from tpm_activity_plan_item b \n" +
                "left join tpm_activity_plan_item_extend c on c.plan_code = b.plan_code and c.plan_item_code = b.plan_item_code\n" +
                "left join tpm_activity_plan a on a.plan_code = b.plan_code\n" +
                "where a.tenant_code = :tenantCode and b.del_flag = '009' ORDER BY b.plan_item_code ASC";
    }

    public synchronized List<String> getItemTableFieldList() {
        if (null == this.itemTableFieldList) {
            List<String> tableFieldList = Lists.newArrayList();
            List<Field> declaredFields = getPropertyField(ActivityPlanItem.class);
            for (Field declaredField : declaredFields) {
                Column column = declaredField.getDeclaredAnnotation(Column.class);
                if (null == column) {
                    continue;
                }
                tableFieldList.add(column.name());
            }
            List<String> excludeFieldList = Lists.newArrayList("plan_code", "activity_begin_date", "activity_end_date", "fee_year_month");
            tableFieldList.removeAll(excludeFieldList);
            this.itemTableFieldList = tableFieldList;
        }
        return this.itemTableFieldList;
    }

    public List<Field> getPropertyField(Class<?> clazz) throws BeansException {
        List<Field> propertyFieldList = Lists.newArrayList();
        return getPropertyField(clazz,propertyFieldList);
    }

    public List<Field> getPropertyField(Class<?> clazz,List<Field> propertyFieldList) throws BeansException {
        Field[] declaredFields = clazz.getDeclaredFields();
        propertyFieldList.addAll(Arrays.asList(declaredFields));
        if (clazz.getSuperclass() != Object.class){
            getPropertyField(clazz.getSuperclass(),propertyFieldList);
        }
        return propertyFieldList;
    }


    public synchronized List<String> getExtendTableFieldList() {
        if (null == this.extendTableFieldList) {
            List<String> tableFieldList = Lists.newArrayList();
            Field[] declaredFields = ActivityPlanItemExtend.class.getDeclaredFields();
            for (Field declaredField : declaredFields) {
                Column column = declaredField.getDeclaredAnnotation(Column.class);
                if (null == column) {
                    continue;
                }
                tableFieldList.add(column.name());
            }
            List<String> excludeFieldList = Lists.newArrayList("id", "tenant_code", "plan_code", "plan_item_code");
            tableFieldList.removeAll(excludeFieldList);
            this.extendTableFieldList = tableFieldList;
        }
        return this.extendTableFieldList;
    }

}
