package com.biz.crm.tpm.business.activity.plan.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @Description:主体活动方案明细表
 * @Author qiancheng
 * @Date 2023/4/7
 */
@Component
public class MainActivityPlanReportDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_main_activity_plan_Report_data_view";
    }

    @Override
    public String desc() {
        return "TPM-主体活动方案明细表";
    }

    @Override
    public String buildSql() {
        return "select " +
                "a.business_format_code, " +
                "a.business_unit_code, " +
                "a.plan_type, " +
                "a.department_code, " +
                "a.department_name, " +
                "a.plan_code, " +
                "a.plan_name, " +
                "b.plan_item_code, " +
                "b.is_close, " +
                "a.plan_classify, " +
                "a.plan_org_code, " +
                "a.plan_org_name, " +
                "a.plan_relate_limit_code, " +
                "a.begin_date, " +
                "a.end_date, " +
                "a.full_accept, " +
                "a.is_cross_month, " +
                "a.sales_amount, " +
                "a.process_status, " +

                "ps.strategy_code as relate_strategy_code, " +
                "ps.strategy_name as psStrategyName, " +
                "ifnull(b.relate_strategy_item_code,be.relate_head_strategy_item_code) as relate_strategy_item_code, " +
                "ps.fee_amount as psFeeAmount, " +
                "ps.used_amount as psUsedAmount, " +
                "ps.usable_amount as psUsableAmount, " +
                "ps.use_amount as psUseAmount, " +

                "b.relate_plan_code, " +
                "prp.relate_plan_name as prpRelatePlanName, " +
                "b.relate_plan_item_code, " +
                "prp.relate_plan_total_fee_amount as prpTotalFeeAmount, " +
                "prp.used_amount as prpUsedAmount, " +
                "prp.usable_amount as prpUsableAmount, " +
                "prp.use_amount as prpUseAmount, " +

                "b.activity_type_code, " +
                "b.activity_type_name, " +
                "b.activity_form_code, " +
                "b.activity_form_name, " +
                "b.activity_begin_date, " +
                "b.activity_end_date, " +
                "b.order_begin_date, " +
                "b.order_end_date, " +
                "b.head_month_budget_code, " +
                "b.head_budget_Item_code, " +
                "b.head_budget_item_name, " +
                "b.month_budget_code, " +
                "b.budget_Item_code, " +
                "b.budget_item_name, " +
                "substr(b.fee_year_month,1,7) fee_year_month, " +
                "b.first_channel_code, " +
                "b.first_channel_name, " +
                "b.second_channel_code, " +
                "b.second_channel_name, " +
                "b.sales_institution_code, " +
                "b.sales_region_code, " +
                "b.sales_region_name, " +
                "b.sales_org_code, " +
                "b.sales_org_name, " +
                "b.activity_org_code, " +
                "b.activity_org_name, " +
                "b.system_code, " +
                "b.system_name, " +
                "b.promotion_object, " +
                "b.promotion_type, " +
                "b.product_brand_code, " +
                "b.product_brand_name, " +
                "b.product_category_code, " +
                "b.product_category_name, " +
                "b.product_item_code, " +
                "b.product_item_name, " +
                "b.product_code, " +
                "b.product_name, " +
                "b.product_unit, " +
                "b.product_quantity, " +
                "b.original_supply_price, " +
                "b.supplier_code, " +
                "b.supplier_name, " +
                "b.material_code, " +
                "b.material_name, " +
                "b.price_with_tax, " +
                "b.total_fee_amount, " +
                "b.head_fee_amount, " +
                "b.department_fee_amount, " +
                "b.customer_fee_amount, " +
                "b.car_gift_group, " +
                "b.distribution_channel_code, " +
                "b.customer_group_code, " +
                "b.customer_group_name, " +
                "b.customer_code, " +
                "b.customer_name, " +
                "b.gift_code, " +
                "b.gift_name, " +
                "b.gift_unit, " +
                "b.gift_quantity, " +
                "b.face_value, " +
                "b.personal_income_tax, " +
                "b.is_deduction_fee_pool, " +
                "b.audit_type, " +
                "b.audit_condition_code " +

                "from tpm_activity_plan a\n" +
                "left join tpm_activity_plan_item b on a.plan_code = b.plan_code\n" +
                "left join tpm_activity_plan_item_extend be on b.plan_code = be.plan_code and b.id = be.id\n" +
                "left join tpm_activity_plan_relate_plan prp on b.plan_code = prp.plan_code and b.relate_plan_code = prp.relate_plan_code and prp.del_flag = '009'\n" +
                "left join tpm_activity_plan_strategy ps on b.plan_code = ps.plan_code and ps.del_flag = '009' and ifnull(b.relate_strategy_item_code,be.relate_head_strategy_item_code) = ps.strategy_item_code\n"+
                "where a.tenant_code = :tenantCode  " +
                "and a.business_unit_code = '" + BusinessUnitEnum.HEADQUARTERS.getCode() +"' " +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode()+"' " +
                "and b.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode()+"'";
    }
}
