package com.biz.crm.tpm.business.activity.plan.local.repository;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemExtendField;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanItemExtendFieldMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/3/6 10:02
 */
@Component
public class ActivityPlanItemExtendFieldRepository extends ServiceImpl<ActivityPlanItemExtendFieldMapper, ActivityPlanItemExtendField> {

    /**
     * 根据方案明细编码 删除
     */
    public void deleteByPlanItemCodeList(List<String> planitemCodeList) {
        if(CollUtil.isEmpty(planitemCodeList)){
            return;
        }
        this.remove(Wrappers.<ActivityPlanItemExtendField>lambdaQuery()
                .in(ActivityPlanItemExtendField::getPlanItemCode,planitemCodeList)
                .eq(ActivityPlanItemExtendField::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    @Override
    public boolean saveBatch(Collection<ActivityPlanItemExtendField> entityList, int batchSize) {
        List<List<ActivityPlanItemExtendField>> partition = Lists.partition(Lists.newArrayList(entityList), 1000);
        for (List<ActivityPlanItemExtendField> listPartition : partition) {
            //真实插入数据
            baseMapper.insertBatchSomeColumn(listPartition);
        }
        return true;
    }

    /**
     * 根据方案明细编码 删除
     */
    public void deleteByPlanCodeList(List<String> planCodeList) {
        if(CollUtil.isEmpty(planCodeList)){
            return;
        }
        this.remove(Wrappers.<ActivityPlanItemExtendField>lambdaQuery()
                .in(ActivityPlanItemExtendField::getPlanCode,planCodeList)
                .eq(ActivityPlanItemExtendField::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public List<ActivityPlanItemExtendField> listByPlanCode(String planCode) {
        if (StringUtils.isBlank(planCode)){
            return Lists.newArrayList();
        }
        return this.list(Wrappers.<ActivityPlanItemExtendField>lambdaQuery()
                .eq(ActivityPlanItemExtendField::getPlanCode,planCode)
                .eq(ActivityPlanItemExtendField::getTenantCode, TenantUtils.getTenantCode())
        );
    }

    public List<ActivityPlanItemExtendField> listByPlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)){
            return Lists.newArrayList();
        }
        return this.list(Wrappers.<ActivityPlanItemExtendField>lambdaQuery()
                .in(ActivityPlanItemExtendField::getPlanItemCode,planItemCodeList)
                .eq(ActivityPlanItemExtendField::getTenantCode, TenantUtils.getTenantCode())
        );
    }
}
