package com.biz.crm.tpm.business.activity.plan.local.repository;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemProduct;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanItemProductMapper;
import jodd.util.StringUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;


/**
 * 活动方案表(ActivityPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityPlanItemProductRepository extends ServiceImpl<ActivityPlanItemProductMapper, ActivityPlanItemProduct> {

    public List<ActivityPlanItemProduct> findListByPlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityPlanItemProduct.class)
                .in(ActivityPlanItemProduct::getPlanItemCode, planItemCodeList)
        );
    }

    public void deleteByPlanItemCodeList(List<String> planCodeItemList) {
        if (CollectionUtils.isEmpty(planCodeItemList)){
            return;
        }
        LambdaQueryWrapper<ActivityPlanItemProduct> updateWrapper = new LambdaQueryWrapper<ActivityPlanItemProduct>();
        updateWrapper.in(ActivityPlanItemProduct::getPlanItemCode, planCodeItemList);
        this.remove(updateWrapper);
    }
}

