package com.biz.crm.tpm.business.activity.plan.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemRelateDetailItem;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanItemRelateDetailItemMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemRelateDetailItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * @Author : dengwei
 * @Date :2023/10/3  18:15
 * @Description: 活动方案关联细案
 */
@Component
@Slf4j
public class ActivityPlanItemRelateDetailItemRepository extends ServiceImpl<ActivityPlanItemRelateDetailItemMapper, ActivityPlanItemRelateDetailItem> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanItemRelateDetailItemVo> findListByPlanCode(String planCode) {
        if(StringUtils.isEmpty(planCode)){
            return Lists.newArrayList();
        }

        List<ActivityPlanItemRelateDetailItem> list = this.lambdaQuery().eq(ActivityPlanItemRelateDetailItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanItemRelateDetailItem::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityPlanItemRelateDetailItem::getPlanCode, planCode)
                .list();
        return (List<ActivityPlanItemRelateDetailItemVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityPlanItemRelateDetailItem.class, ActivityPlanItemRelateDetailItemVo.class, LinkedHashSet.class, ArrayList.class);
    }

    public List<ActivityPlanItemRelateDetailItemDto> findDtoListByPlanCode(String planCode) {
        if(StringUtils.isEmpty(planCode)){
            return Lists.newArrayList();
        }

        List<ActivityPlanItemRelateDetailItem> list = this.lambdaQuery().eq(ActivityPlanItemRelateDetailItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanItemRelateDetailItem::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityPlanItemRelateDetailItem::getPlanCode, planCode)
                .list();
        return (List<ActivityPlanItemRelateDetailItemDto>) this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityPlanItemRelateDetailItem.class, ActivityPlanItemRelateDetailItemDto.class, LinkedHashSet.class, ArrayList.class);

    }

    public List<ActivityPlanItemRelateDetailItem> findDtoByPlanCodeList(List<String> planCodeList) {
        if(CollectionUtils.isEmpty(planCodeList)){
            return Lists.newArrayList();
        }
        List<ActivityPlanItemRelateDetailItem> list = this.lambdaQuery().eq(ActivityPlanItemRelateDetailItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanItemRelateDetailItem::getTenantCode, TenantUtils.getTenantCode())
                .in(ActivityPlanItemRelateDetailItem::getPlanCode, planCodeList)
                .list();
        return list;
    }

    public List<ActivityPlanItemRelateDetailItemVo> findCountByPlanCodeList(List<String> planItemCodeList) {
        if(CollectionUtils.isNotEmpty(planItemCodeList)){
            List<ActivityPlanItemRelateDetailItem> list = this.lambdaQuery().in(ActivityPlanItemRelateDetailItem::getPlanItemCode, planItemCodeList)
                    .select(ActivityPlanItemRelateDetailItem::getPlanItemCode)
                    .list();

            if(CollectionUtils.isNotEmpty(list)){
                Collection<ActivityPlanItemRelateDetailItemVo> activityPlanItemRelateDetailItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityPlanItemRelateDetailItem.class, ActivityPlanItemRelateDetailItemVo.class, LinkedHashSet.class, ArrayList.class);
                return (List<ActivityPlanItemRelateDetailItemVo>)activityPlanItemRelateDetailItemVos;
            }
        }
        return Lists.newArrayList();
    }

    public void deleteByPlanCode(String planCode) {
        if(StringUtils.isEmpty(planCode)){
            return;
        }
        this.remove(Wrappers.lambdaUpdate(ActivityPlanItemRelateDetailItem.class).eq(ActivityPlanItemRelateDetailItem::getPlanCode,planCode));
    }
}
