package com.biz.crm.tpm.business.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemTerminal;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanItemTerminalMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemTerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.persister.entity.BasicEntityPropertyMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Collection;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/12 11:01
 * @description：方案明细门店
 */
@Component
public class ActivityPlanItemTerminalRepository extends ServiceImpl<ActivityPlanItemTerminalMapper, ActivityPlanItemTerminal> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanItemTerminalVo> findVerticalPersonUpdateList(List<String> terminalCodeList,String updateDate) {
        return baseMapper.findVerticalPersonUpdateList(terminalCodeList,updateDate);
    }

    /**
     * 根据方案编码，查询方案对应预算
     * @param planItemCodeList 方案明细编码集合
     **/
    public List<ActivityPlanItemTerminalDto> listDtoByPlanItemCodeList(List<String> planItemCodeList) {
        List<ActivityPlanItemTerminal> entityList = listByPlanItemCodeList(planItemCodeList);
        if (!CollectionUtils.isEmpty(entityList)){
            List<ActivityPlanItemTerminalDto> dtoList = (List<ActivityPlanItemTerminalDto>) nebulaToolkitService.copyCollectionByBlankList(entityList,ActivityPlanItemTerminal.class,ActivityPlanItemTerminalDto.class, HashSet.class, ArrayList.class);
            ObjectConvertStringUtil.fillObjectListStrProperties(dtoList,ActivityPlanItemTerminalDto.class);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    public List<ActivityPlanItemTerminal> listByPlanItemCodeList(List<String> planItemCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(planItemCodeList)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .in(ActivityPlanItemTerminal::getPlanItemCode, planItemCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

}
