package com.biz.crm.tpm.business.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanOrg;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanOrgMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/8/16 16:51
 */
@Component
public class ActivityPlanOrgRepository extends ServiceImpl<ActivityPlanOrgMapper, ActivityPlanOrg> {

    public void deleteByPlanId(String planId) {
        if (StringUtils.isBlank(planId)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        this.lambdaUpdate()
                .eq(ActivityPlanOrg::getPlanId, planId)
                .eq(ActivityPlanOrg::getTenantCode, tenantCode)
                .remove();
    }

    public List<ActivityPlanOrg> findByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.lambdaQuery()
                .in(ActivityPlanOrg::getPlanCode, planCodeList)
                .eq(ActivityPlanOrg::getTenantCode, tenantCode)
                .list();
    }

}
