package com.biz.crm.tpm.business.activity.plan.local.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanRelatePlan;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanRelatePlanMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanRelatePlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 活动方案表(ActivityPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityPlanRelatePlanRepository extends ServiceImpl<ActivityPlanRelatePlanMapper, ActivityPlanRelatePlan> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 根据方案编码查询方案关联策略数据
     * @param planCode 方案编码
     * @return 方案明细dtolist
     */
    public List<ActivityPlanRelatePlanVo> findListVoByPlanCode(String planCode) {
        if (StringUtils.isBlank(planCode)){
            return null;
        }
        List<ActivityPlanRelatePlan> itemList = findListByPlanCode(planCode);
        return (List<ActivityPlanRelatePlanVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanRelatePlan.class, ActivityPlanRelatePlanVo.class, HashSet.class, ArrayList.class);
    }

    public List<ActivityPlanRelatePlan> findListByPlanCode(String planCode) {
        if (StringUtils.isBlank(planCode)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityPlanRelatePlan.class)
                .eq(ActivityPlanRelatePlan::getPlanCode, planCode)
                .eq(ActivityPlanRelatePlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanRelatePlan> updateWrapper = new UpdateWrapper<ActivityPlanRelatePlan>().lambda();
        updateWrapper.set(ActivityPlanRelatePlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanRelatePlan::getId, ids);
        this.update(updateWrapper);
    }

    /**
     * 通过方案编码删除
     * @param planCode 方案编码
     */
    public void deleteByPlanCode(String planCode){
        if (StringUtil.isEmpty(planCode)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanRelatePlan> updateWrapper = new UpdateWrapper<ActivityPlanRelatePlan>().lambda();
        updateWrapper.set(ActivityPlanRelatePlan::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityPlanRelatePlan::getPlanCode, planCode);
        this.update(updateWrapper);
    }

}

