package com.biz.crm.tpm.business.activity.plan.local.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanStrategy;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanStrategyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanStrategyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import jodd.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 活动方案表(ActivityPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityPlanStrategyRepository extends ServiceImpl<ActivityPlanStrategyMapper, ActivityPlanStrategy> {

    @Autowired(required = false)
    private ActivityPlanStrategyMapper activityPlanStrategyMapper;


    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 根据方案编码查询方案关联策略数据
     * @param planCode 方案编码
     * @return 方案明细dtolist
     */
    public List<ActivityPlanStrategyVo> findListVoByPlanCode(String planCode) {
        if (StringUtils.isBlank(planCode)){
            return null;
        }
        List<ActivityPlanStrategy> itemList = findListByPlanCode(planCode);
        return (List<ActivityPlanStrategyVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanStrategy.class, ActivityPlanStrategyVo.class, HashSet.class, ArrayList.class);
    }

    /**
     * 根据方案编码查询方案关联策略数据
     * @param planCodeList 方案编码集合
     * @return 方案明细dtolist
     */
    public List<ActivityPlanStrategyVo> findListVoByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)){
            return null;
        }
        List<ActivityPlanStrategy> itemList = findListByPlanCodeList(planCodeList);
        return (List<ActivityPlanStrategyVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanStrategy.class, ActivityPlanStrategyVo.class, HashSet.class, ArrayList.class);
    }

    public List<ActivityPlanStrategy> findListByPlanCode(String planCode) {
        if (StringUtils.isBlank(planCode)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityPlanStrategy.class)
                .eq(ActivityPlanStrategy::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityPlanStrategy::getPlanCode, planCode)
                .eq(ActivityPlanStrategy::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    public List<ActivityPlanStrategy> findListByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)){
            return Lists.newArrayList();
        }
        return this.list(Wrappers.lambdaQuery(ActivityPlanStrategy.class)
                .eq(ActivityPlanStrategy::getTenantCode, TenantUtils.getTenantCode())
                .in(ActivityPlanStrategy::getPlanCode, planCodeList)
                .eq(ActivityPlanStrategy::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanStrategy> updateWrapper = new UpdateWrapper<ActivityPlanStrategy>().lambda();
        updateWrapper.set(ActivityPlanStrategy::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanStrategy::getId, ids);
        this.update(updateWrapper);
    }

    public void deleteByPlanCode(String planCode) {
        if (StringUtil.isEmpty(planCode)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanStrategy> updateWrapper = new UpdateWrapper<ActivityPlanStrategy>().lambda();
        updateWrapper.set(ActivityPlanStrategy::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityPlanStrategy::getPlanCode, planCode);
        this.update(updateWrapper);
    }
}

