package com.biz.crm.tpm.business.activity.plan.local.repository;


import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanTemplate;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanTemplateMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;


/**
 * 活动方案表(ActivityPlan)表数据库访问层
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:54
 */
@Component
public class ActivityPlanTemplateRepository extends ServiceImpl<ActivityPlanTemplateMapper, ActivityPlanTemplate> {

    @Autowired(required = false)
    private ActivityPlanTemplateMapper activityPlanTemplateMapper;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 根据方案编码查询方案模板配置数据
     * @param planCode 方案编码
     * @return 方案明细dtolist
     */
    public List<ActivityPlanTemplateVo> findListVoByPlanCode(String planCode) {
        if (StringUtils.isBlank(planCode)){
            return null;
        }
        List<ActivityPlanTemplate> itemList = findListByPlanCode(planCode);
        return (List<ActivityPlanTemplateVo>) nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanTemplate.class, ActivityPlanTemplateVo.class, HashSet.class, ArrayList.class);
    }

    public List<ActivityPlanTemplate> findListByPlanCode(String planCode) {
        if (StringUtils.isBlank(planCode)){
            return null;
        }
        return this.list(Wrappers.lambdaQuery(ActivityPlanTemplate.class)
                .eq(ActivityPlanTemplate::getPlanCode, planCode)
                .eq(ActivityPlanTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        );
    }

    /**
     * 通过id删除
     * @param ids id集合
     */
    public void deleteByIds(List<String> ids){
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaUpdateWrapper<ActivityPlanTemplate> updateWrapper = new UpdateWrapper<ActivityPlanTemplate>().lambda();
        updateWrapper.set(ActivityPlanTemplate::getDelFlag, DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanTemplate::getId, ids);
        this.update(updateWrapper);
    }

}

