package com.biz.crm.tpm.business.activity.plan.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.plan.local.entity.CorrectionDiscountRateQuantum;
import com.biz.crm.tpm.business.activity.plan.local.mapper.CorrectionDiscountRateQuantumMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Component
public class CorrectionDiscountRateQuantumRepository extends ServiceImpl<CorrectionDiscountRateQuantumMapper,CorrectionDiscountRateQuantum> {

    public void removeByYearMonth(List<String> yearMonths,String regionCode,String systemCode) {
        if(CollectionUtils.isEmpty(yearMonths)) return;
        this.lambdaUpdate().in(CorrectionDiscountRateQuantum::getYearMonthStr,yearMonths)
                .eq(StringUtils.isNotEmpty(regionCode),CorrectionDiscountRateQuantum::getRegionCode,regionCode)
                .eq(StringUtils.isNotEmpty(systemCode),CorrectionDiscountRateQuantum::getSystemCode,systemCode)
                .remove();
    }
}
