package com.biz.crm.tpm.business.activity.plan.local.service;

import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/7/27 23:59
 */
public interface ActivityPlanAsyncService {


    /**
     * 活动方案新增编辑
     *
     * @param cacheKey  明细缓存key
     * @param loginUser
     * @return
     */
    void saveActivityPlanAsync(ActivityPlanDto dto, String cacheKey, UserIdentity loginUser);

    /**
     * 关闭方案明细
     * @param itemList 方案明细数据
     * @param userIdentity 当前登录人信息
     */
    void closeItemListAsync(List<ActivityPlanItem> itemList, UserIdentity userIdentity);

    /**
     * 按方案id一键关闭
     * @param ids 方案id集合
     * @param userIdentity 当前登录人信息
     */
    void closeItemByPlanIdsAsync(List<String> ids, UserIdentity userIdentity);

}
