package com.biz.crm.tpm.business.activity.plan.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanStrategyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 方案关联预算数据
 * @author wanghaojia
 * @date 2022/12/24 14:28
 */
public interface ActivityPlanBudgetService {

    /**
     * 按条件查询营销策略
     * @param pageable 分页参数
     * @param dto 查询参数
     */
    Page<ActivityPlanBudgetVo> findByConditions(Pageable pageable, ActivityPlanBudgetDto dto);

    /**
     * 保存活动方案-关联预算数据
     *
     * @param itemDtoList 方案明细数据
     */
    void saveActivityPlanBudgetList(ActivityPlan entity, boolean update, List<ActivityPlanItemDto> itemDtoList);

    /**
     * 扣减月度预算
     */
    List<ActivityPlanBudgetDto> useMonthBudgetByPlanCodeList(List<String> planCodeList);

    void useMonthBudget(List<ActivityPlanBudgetDto> budgetList, boolean doSave);


    /**
     * 退回月度预算
     *
     * @param planItemCodeList
     */
    void returnMonthBudgetByPlanItemCodeList(List<String> planItemCodeList);


    void returnCarGiftMonthBudgetByPlanItemCodeList(List<String> planItemCodeList);

    /**
     * 退回月度预算
     *
     * @param planCodeList
     */
    void returnMonthBudgetByPlanCodeList(List<String> planCodeList);

    /**
     * 占用方案预算
     */
    void operateBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList);

    void operateBudget(List<OperateActivityPlanBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap);

    /**
     * 占用客户预算
     * @param planBudgetOperateList
     */
    void operateCustomerBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList);


    void deleteByPlanCodes(List<String> planCodes);


    /**
     * 活动方案获取可以选择的大区
     * @param pageable 分页参数
     * @param dto 查询属性
     * @return 策略预算数据
     */
    Page<MarketingStrategyBudgetVo> findChooseStrategyBudgetList(Pageable pageable, MarketingStrategyBudgetDto dto);

}
