package com.biz.crm.tpm.business.activity.plan.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 活动方案明细表(ActivityPlanItem)表服务接口
 *
 * @author wanghaojia
 * @since 2022-11-01 15:11:38
 */
public interface ActivityPlanItemService  extends MnPageCacheService<ActivityPlanItemVo,ActivityPlanItemDto> {

    /**
     * 分页查询所有数据
     *
     * @param pageable
     * @param activityPlanItemDto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo>
     * @author huojia
     * @date 2022/12/9 16:52
     **/
    Page<ActivityPlanItemVo> findByConditions(Pageable pageable, ActivityPlanItemDto activityPlanItemDto);

    /**
     * 分页查询活动方案明细预算汇总数据
     * @param pageable 分页参数
     * @param dto 查询属性
     * @return
     */
    Page<ActivityPlanItemBudgetVo> findItemBudgetByConditions(Pageable pageable, ActivityPlanItemBudgetDto dto);

    /**
     * 活动方案明细预算金额使用
     */
    List<ActivityPlanItemBudgetVo> findItemBudgetListByConditions(ActivityPlanItemBudgetDto dto);

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    List<ActivityPlanBudgetSumVo> findBudgetCacheSumList(String businessUnitCode,String cacheKey);

    /**
     * 保存活动方案明细数据-默认走校验逻辑
     *
     * @param itemCacheList 活动方案明细数据
     */
    void saveActivityPlanItemList(ActivityPlan entity,boolean update,List<ActivityPlanItemDto> itemCacheList);

    /**
     * 保存活动方案明细数据
     *
     * @param itemCacheList  活动方案明细数据
     * @param createValidate 是否走校验逻辑
     */
    void saveActivityPlanItemList(ActivityPlan entity,boolean update,List<ActivityPlanItemDto> itemCacheList, boolean createValidate,boolean tempSave);

    String generateCode();

    List<String> generateCodeList(int size);

    /**
     * 活动方案明细新增校验逻辑
     *
     * @param dtoList 活动方案明细数据
     */
    void createValidateList(List<ActivityPlanItemDto> dtoList);

    void createValidateList(ActivityPlanDto dto, List<ActivityPlanItemDto> dtoList);

    /**
     * 活动类型下拉
     *
     * @param dto 活动类型查询参数
     */
    List<CommonSelectVo> findActivityTypeSelectList(ActivityTypeSelectDto dto);

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     * @return 活动形式下拉数据
     */
    List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto);

    /**
     * 通过方案编码删除方案明细
     * @param planCodes 方案编码集合
     */
    void deleteByPlanCodes(List<String> planCodes);

    List<String> closeItem(List<String> ids, boolean throwException);

    /**
     * 关闭方案，查出来entity作为参数，不重复查
     * @param itemList 方案明细集合
     * @param throwException 是否抛异常
     * @return 错误信息
     */
    List<String> closeItemList(List<ActivityPlanItem> itemList, boolean throwException);

    /**
     * 关闭方案基础验证
     */
    List<ActivityPlanItem> closeItemBaseVerifyItem(List<String> ids, boolean throwException, List<String> errorMsgList);

    void createActivityPlanItem(List<ActivityPlanItemDto> itemList);


    Page<ActivityPlanItemVo> findPlanItemNoActivityDetail(Pageable pageable, String yearMonth, String salesOrgCode);
    /**
     * 计算销售计划占比
     * @param dto
     * @return
     */
    Map<String, BigDecimal> calculateSalePlanProportion(ActivityPlanItemDto dto);

    /**
     * 计算行项目数据
     * @param dto
     * @return
     */
    ActivityPlanItemVo calculateItemData(ActivityPlanItemDto dto);

    void proportionByPos(ActivityPlanDto dto, String cacheKey);

    /**
     * 关键指标-申请金额 根据方案明细编码获取活动方案获取费用合计
     * @param dto
     * @return
     */
    ActivityPlanItemBase applyAmountFindByItemCode(ActivityPlanItemDto dto);
    /**
     * 条件查询总条数
     *
     * @param activityPlanItemDto
     * @return
     */
    Integer findTotalByConditions(ActivityPlanItemDto activityPlanItemDto);

    void tempSaveValidata(ActivityPlanDto dto, List<ActivityPlanItemDto> itemCacheList);

    /**
     * 总部方案明细编码查询大区方案明细
     * @param planItemCode
     * @return
     */
    List<ActivityPlanItemVo> findByHeadquartersPlanItemCode(String planItemCode);

    ActivityPlanItemVo findListByPlanItemCode(String planItemCode);

    List<ActivityPlanBudgetVo> findItemBudgetListByPlanCode(String planCode);

    void updateAuditStatusByCodes(List<String> auditPlanItemCodes);

    List<ActivityPlanBudgetVo> findItemBudgetListByPlanItemCode(String planItemCode);

    List<ActivityPlanItemVo> findListByPlanCodes(List<String> businessNoList);

    void updatePlanItemSapState(String planItemCode, boolean success);
}

