package com.biz.crm.tpm.business.activity.plan.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemTerminalVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/12 11:02
 * @description：方案明细门店
 */
public interface ActivityPlanItemTerminalService {

    /**
     * 保存更新明细门店
     *
     * @param entity
     * @param update
     * @param itemDtoList
     * @param cacheKey
     */
    void saveActivityPlanItemTerminal(ActivityPlan entity, boolean update, List<ActivityPlanItemDto> itemDtoList, String cacheKey);

    void createValidateList(ActivityPlanDto planDto, ActivityPlanItemDto itemDto, List<ActivityPlanItemTerminalDto> dtoList);

    /**
     * 从缓存中添加终端明细到行项目上
     * @param dto
     */
    void addTerminalFromCache(ActivityPlanItemDto dto);

    /**
     * 修改终端缓存
     *
     * @param dto
     * @param autoFill
     */
    void changeTerminalDetail(ActivityPlanItemDto dto, boolean autoFill);

    /**
     * 导入添加数据
     * @param cacheKey 缓存建
     * @param itemTerminalDtoList 门店数据
     */
    void importNewItem(String cacheKey, List<ActivityPlanItemTerminalDto> itemTerminalDtoList);

    /**
     * 清理缓存
     * @param cacheKey 缓存建
     */
    void clearCache(String cacheKey);
    /**
     * 新增行
     * @param cacheKey 缓存建
     * @param itemList 当前数据
     */
    void addItemCache(String cacheKey, List<ActivityPlanItemTerminalDto> itemList);

    /**
     * 分页获取缓存数据
     * @param pageable 分页参数
     * @param dto 查询参数
     * @param cacheKey 缓存键
     */
    Page<ActivityPlanItemTerminalVo> findCachePageList(Pageable pageable, ActivityPlanItemTerminalDto dto, String cacheKey);

    /**
     * 复制行
     * @param cacheKey 缓存键
     * @param itemList 选中数据
     */
    void copyItemListCache(String cacheKey, List<ActivityPlanItemTerminalDto> itemList);

    /**
     * 保存当前页数据
     * @param cacheKey 缓存键
     * @param saveList 当前页数据
     */
    void saveCurrentPageCache(String cacheKey, List<ActivityPlanItemTerminalDto> saveList);

    /**
     * 删除缓存数据
     * @param cacheKey 缓存键
     * @param itemList 选中数据
     */
    void deleteCacheList(String cacheKey, List<ActivityPlanItemTerminalDto> itemList);

    /**
     * 查询缓存键下的所有数据
     * @param cacheKey 缓存键
     */
    List<ActivityPlanItemTerminalDto> findCacheList(String cacheKey);

    /**
     * 批量新增数据
     * @param cacheKey 缓存键
     * @param activityPlanItemTerminalList 要新增的数据
     */
    void saveListCache(String cacheKey, List<ActivityPlanItemTerminalDto> activityPlanItemTerminalList);

    void proportionByTerminal(ActivityPlanItemDto dto);

    void proportionByTerminalEmployee(ActivityPlanItemDto dto);

    /**
     * 按POS分摊
     * @param dto 方案数据
     * @param cacheKey 缓存键
     */
    void proportionByPos(ActivityPlanDto dto, String cacheKey, List<ActivityPlanItemDto> itemCacheList);

    void proportionAmountByTotalFeeAmount(ActivityPlanItemDto dto);

    List<TerminalVo> findAvaiableTerminal(ActivityPlanItemDto dto);

    /**
     * 初始化符合条件的门店到行明细上
     * @param dto
     */
    void initActivityPlanItemTerminal(ActivityPlanItemTerminalDto dto, String cacheKey);

    /**
     * 按pos分摊-按当前门店重新分摊
     * @param dto
     * @param cacheKey
     */
    void proportionPosByCurrTerminal(ActivityPlanItemTerminalDto dto, String cacheKey);

}
