package com.biz.crm.tpm.business.activity.plan.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanOutDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.ActivityPlanItemPushSfaDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.ActivityPlanItemPushSfaDisplayDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportMainVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 活动方案表(ActivityPlan)表服务接口
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:44
 */
public interface ActivityPlanService {

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    Page<ActivityPlanVo> findByConditions(Pageable pageable, ActivityPlanDto dto);

    /**
     * 查询可以选择的月度预算
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    Page<MonthBudgetVo> findMonthBudgetByConditions(Pageable pageable, ActivityPlanBudgetDto planBudgetDto, MonthBudgetDto dto);

    ActivityPlanVo findByCode(String code);

    void saveActivityPlan(ActivityPlanDto dto, String cacheKey);

    /**
     * @Description 活动方案新增原子接口
     * @param dto 提交参数
     * @return
     */
    ActivityPlanDto atomSaveActivityPlan(ActivityPlanDto dto);

    /**
     * 通过id获取活动方案数据
     * @param id 活动方案id
     */
    ActivityPlanVo findById(String id);

    /**
     * 垂直扣减大日期库存盘点
     * @param planCodeList 方案编码集合
     */
    void useInventoryCheck(List<String> planCodeList);

    void returnInventoryCheck(List<String> planCodeList);

    /**
     * 删除活动方案
     * @param ids 要删除的活动方案id
     */
    void delete(List<String> ids);
    /**
     * 提交工作流审批
     * @param ids 要提交的业务id
     * @param dto 提交参数
     */
    void submitApproval(List<String> ids, ActivityPlanApproveSubmitDto dto);
    /**
     * 流程审批通过
     */
    void processPass(ProcessStatusDto dto);
    /**
     * 流程审批驳回/追回
     */
    void processRejectAndRecover(ProcessStatusDto dto);

    /**
     * 构建方案参数
     * @param businessNoList
     * @return
     */
    List<ActivityPlanDto> buildActivityPlanParms(List<String> businessNoList);

    /**
     * 合同生成方案（定时任务）
     */
    void contractGenerateActivityPlan();



    /**
     * 通过方案编码查询推送sfa数据
     * @param planCodes 方案编码
     * @return
     */
    List<ActivityPlanItemPushSfaDto> findSfaDataByPlanCodes(List<String> planCodes);

    /**
     * 通过方案编码查询推送sfa数据
     * @param planCodes 方案编码
     * @return
     */
    List<ActivityPlanItemPushSfaDisplayDto> findSfaDisplayDataByPlanCodes(List<String> planCodes);

    /**
     * 根据方案编码集合查询详情
     * @param planCodes 方案编码集合
     * @return
     */
    List<ActivityPlanVo> findByCodes(Set<String> planCodes);

    List<ActivityPlanVo> findPlanActivityEndTime(Set<String> activityDetailCodes);

    List<ActivityPlanItemDto> findByPlanItem(String planCode);

    /**
     * 从缓存中计算表头金额
     * @param cacheKey 缓存键
     */
    ActivityPlanVo calculateHeadAmount(ActivityPlanDto planDto,String cacheKey);

    void proportionByTerminalEmployee(ActivityPlanDto dto, String cacheKey);

    void calculateSalePlanProportion(ActivityPlanDto dto, String cacheKey);

    void proportionByTerminal(ActivityPlanDto dto, String cacheKey);

    /**
     * 活动方案申请可以选择的总部方案
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据ø
     */
    Page<ActivityPlanVo> findRelateActivityPlanListByConditions(Pageable pageable, ActivityPlanDto dto);


    String createActivityPlan(ActivityPlanDto dto);

    List<String> submitIsOverBudget(String processNo);

    List<String> submitIsOverBudgetByIds(List<String> ids);

    ActivityPlanSubmitReportMainVo submitPageReport(String processNo);

    ActivityPlanSubmitReportMainVo modifySubmitPageReport(String processNo);

    ActivityPlanOutDto saveActivityPlanNoCache(ActivityPlanOutDto dto);

    ActivityPlanVo findByPlanItemCode(String planItemCode);

    void deleteForOut(List<String> ids);

    /**
     * 主体方案预测活动结束时间延期
     * @param list
     */
    void updateActivityDelayEndTime(List<ActivityPlanItemDto> list);

    void pushActivityToFreeGoods(List<String> planCodes);
}

