package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanAsyncService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanLockService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/7/28 00:00
 */
@Service
@Slf4j
public class ActivityPlanAsyncServiceImpl implements ActivityPlanAsyncService {



    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private ActivityPlanService activityPlanService;

    @Autowired(required = false)
    private ActivityPlanLockService activityPlanLockService;

    /**
     * 活动方案新增编辑
     *
     * @param cacheKey  明细缓存key
     * @param loginUser
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Async
    public void saveActivityPlanAsync(ActivityPlanDto dto, String cacheKey, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        try {
            activityPlanItemPageCacheHelper.sendMsg("开始执行...！");
            activityPlanService.saveActivityPlan(dto,cacheKey);
//            activityPlanItemPageCacheHelper.sendMsg("数据保存成功！");
        }catch (Exception e){
            log.error(e.getMessage(), e);
            activityPlanItemPageCacheHelper.sendMsg("数据保存失败："+e.getMessage(),ExecStatusEnum.RUNNING.getKey());
            throw e;
        }
    }

    /**
     * 活动方案关闭明细
     */
    @Override
    @Async
    public void closeItemListAsync(List<ActivityPlanItem> itemList, UserIdentity userIdentity) {
        if (CollectionUtil.isEmpty(itemList)) {
            return;
        }
        loginUserService.refreshAuthentication(userIdentity);
        activityPlanLockService.closeItemList(itemList);
    }

    @Override
    @Async
    public void closeItemByPlanIdsAsync(List<String> ids, UserIdentity userIdentity) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        loginUserService.refreshAuthentication(userIdentity);
        activityPlanLockService.closeItemByPlanIds(ids);
    }


}
