package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.OperateMarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.constant.BudgetLockConstant;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashOperateDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmVerticalSchemeCashOperateTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmVerticalSchemeForecastService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 活动方案-预算
 * @author wanghaojia
 * @date 2022/12/24 14:40
 */
@Service
public class ActivityPlanBudgetServiceImpl implements ActivityPlanBudgetService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private MarketingStrategyBudgetSdkService marketingStrategyBudgetSdkService;

    @Autowired(required = false)
    private ActivityPlanBudgetServiceImpl activityPlanBudgetService;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastService verticalSchemeForecastService;

    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Override
    public Page<ActivityPlanBudgetVo> findByConditions(Pageable pageable, ActivityPlanBudgetDto dto) {
        return activityPlanBudgetRepository.findByConditions(pageable,dto);
    }

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param itemDtoList  活动方案关联预算数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityPlanBudgetList(ActivityPlan entity, boolean update, List<ActivityPlanItemDto> itemDtoList) {
        Map<String, List<ActivityPlanBudget>> oldMap = Maps.newHashMap();
        if (update){
//            List<ActivityPlanBudget> oldList = activityPlanBudgetRepository.listByPlanCode(entity.getPlanCode());
//            oldMap = oldList.stream().collect(Collectors.toMap(item -> {
//                return item.getPlanItemCode() + item.getMonthBudgetCode() + item.getRelatePlanItemCode() + item.getRelateStrategyItemCode();
//            }, Function.identity()));
            //直接物理删除新建吧。
            activityPlanBudgetRepository.deletePhysicalByPlanCode(entity.getPlanCode());
        }
        for (ActivityPlanItemDto itemDto : itemDtoList) {
            if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                itemDto.getBudgetShares().forEach(item -> {
                    item.setPlanItemCode(itemDto.getPlanItemCode());
                    item.setPlanCode(itemDto.getPlanCode());
                });
            }
        }
        List<ActivityPlanBudgetDto> budgetDtoList = itemDtoList.stream().map(ActivityPlanItemDto::getBudgetShares).filter(Objects::nonNull)
                .flatMap(Collection::stream).collect(Collectors.toList());
        List<ActivityPlanBudget> list = (List<ActivityPlanBudget>) nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList,ActivityPlanBudgetDto.class,ActivityPlanBudget.class,HashSet.class,ArrayList.class);

        List<ActivityPlanBudget> saveList = Lists.newArrayList();
        List<ActivityPlanBudget> updateList = Lists.newArrayList();
        for (ActivityPlanBudget item : list) {
//            String key = item.getPlanItemCode() + item.getMonthBudgetCode() + item.getRelatePlanItemCode() + item.getRelateStrategyItemCode();
//            if (oldMap.containsKey(key)){
//                item.setId(oldMap.get(key).getId());
//                updateList.add(item);
//                oldMap.remove(key);
//            }else{
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
//            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            int i = 0;
            int size = saveList.size();
            for (List<ActivityPlanBudget> activityPlanBudgets : Lists.partition(saveList,1000)) {
                activityPlanItemPageCacheHelper.sendMsg("正在保存第["+1000*(i++)+"/"+ size +"]条方案预算扩展信息...");
                activityPlanBudgetRepository.saveBatch(activityPlanBudgets);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)){
            int i = 0;
            int size = updateList.size();
            for (List<ActivityPlanBudget> activityPlanBudgets : Lists.partition(updateList,1000)) {
                activityPlanItemPageCacheHelper.sendMsg("正在更新第["+1000*(i++)+"/"+ size +"]条方案预算扩展信息...");
                activityPlanBudgetRepository.updateBatchById(activityPlanBudgets);
            }
        }
//        if (oldMap.size() > 0){
//            //待删除的数据
//            List<String> deleteIds = oldMap.values().stream().map(ActivityPlanBudget::getId).collect(Collectors.toList());
//            activityPlanBudgetRepository.deleteByIds(deleteIds);
//        }
    }

    @Override
    public void deleteByPlanCodes(List<String> planCodes) {
        activityPlanBudgetRepository.deleteByPlanCodes(planCodes);
    }

    /**
     * 扣减月度预算
     */
    @Override
    @Transactional
    public List<ActivityPlanBudgetDto> useMonthBudgetByPlanCodeList(List<String> planCodeList){
        List<ActivityPlanBudget> activityPlanBudgets = activityPlanBudgetRepository.listByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(activityPlanBudgets)){
            return Lists.newArrayList();
        }
        List<ActivityPlanBudgetDto> activityPlanBudgetDtos = (List<ActivityPlanBudgetDto>) nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets, ActivityPlanBudget.class, ActivityPlanBudgetDto.class, HashSet.class, ArrayList.class);
        useMonthBudget(activityPlanBudgetDtos,true);
        return activityPlanBudgetDtos;
    }

    /**
     * 扣减月度预算
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void useMonthBudget(List<ActivityPlanBudgetDto> budgetList,boolean doSave){
        //1、占用策略预算，同时 总部方案占用总部月度预算，大区方案占用大区月度预算
        List<OperateMarketingStrategyBudgetDto> strategyOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的并且策略明细编码不为空
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0  &&
                    ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType()) &&
                    StringUtils.isNotEmpty(item.getRelateStrategyItemCode());
        }).map(item -> new OperateMarketingStrategyBudgetDto() {{
            this.setBusinessCode(item.getPlanItemCode());
            this.setStrategyCode(item.getRelateStrategyCode());
            this.setStrategyItemCode(item.getRelateStrategyItemCode());
            this.setMonthBudgetCode(item.getMonthBudgetCode());
            this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
            this.setOperationAmount(item.getUseAmount());
            this.setDoSave(doSave);
        }}).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(strategyOperateList)){
            marketingStrategyBudgetSdkService.operateAmount(strategyOperateList);
        }

        List<OperateMonthBudgetDto> budgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType());
        }).map(item -> new OperateMonthBudgetDto(){{
            this.setBusinessCode(item.getPlanItemCode());
            this.setIndexNo(item.getIndexNo());
            this.setMonthBudgetCode(item.getMonthBudgetCode());
            this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
            this.setOperationAmount(item.getUseAmount());
            this.setDoSave(doSave);
        }}).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }

        //垂直总部方案，核销后申请，做冻结
        List<OperateMonthBudgetDto> freezeBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode().equals(item.getOccupyType());
        }).map(item -> new OperateMonthBudgetDto(){{
            this.setBusinessCode(item.getPlanItemCode());
            this.setIndexNo(item.getIndexNo());
            this.setMonthBudgetCode(item.getMonthBudgetCode());
            this.setOperationType(BudgetOperationTypeEnum.FREEZE.getCode());
            this.setOperationAmount(item.getUseAmount());
            this.setDoSave(doSave);
        }}).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(freezeBudgetOperateList)){
            monthBudgetService.operateBudget(freezeBudgetOperateList);
        }

        //2、大区方案占用总部方案预算
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(item.getOccupyType()) &&
                    StringUtils.isNotEmpty(item.getRelatePlanItemCode());
        }).map(item -> new OperateActivityPlanBudgetDto(){{
            this.setBusinessCode(item.getPlanItemCode());
            this.setIndexNo(item.getIndexNo());
            this.setPlanCode(item.getRelatePlanCode());
            this.setPlanItemCode(item.getRelatePlanItemCode());
            this.setMonthBudgetCode(item.getMonthBudgetCode());
            this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
            this.setOperationAmount(item.getUseAmount());
            this.setDoSave(doSave);
        }}).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanBudgetService.operateBudget(planBudgetOperateList);
        }

        //垂直大区方案，做冻结转批复
        List<OperateMonthBudgetDto> headUnfreezeBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode().equals(item.getOccupyType());
        }).map(item -> new OperateMonthBudgetDto(){{
            this.setBusinessCode(item.getPlanItemCode());
            this.setIndexNo(item.getIndexNo());
            this.setMonthBudgetCode(item.getMonthBudgetCode());
            this.setOperationType(BudgetOperationTypeEnum.UNFREEZE.getCode());
            this.setOperationAmount(item.getUseAmount());
            this.setDoSave(doSave);
        }}).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(headUnfreezeBudgetOperateList)){
            monthBudgetService.operateBudget(headUnfreezeBudgetOperateList);
            List<OperateMonthBudgetDto> headUseBudgetOperateList = (List<OperateMonthBudgetDto>) this.nebulaToolkitService.copyCollectionByWhiteList(headUnfreezeBudgetOperateList, OperateMonthBudgetDto.class, OperateMonthBudgetDto.class, HashSet.class, ArrayList.class);
            headUseBudgetOperateList.forEach(operate->operate.setOperationType(BudgetOperationTypeEnum.USE.getCode()));
            monthBudgetService.operateBudget(headUseBudgetOperateList);
        }
        List<TpmVerticalSchemeForecastBudgetCashOperateDto> verticalSchemeForecastBudgetCashOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode().equals(item.getOccupyType());
        }).map(item -> new TpmVerticalSchemeForecastBudgetCashOperateDto(){{
            this.setDetailCode(item.getSchemeForecastDetailCode());
            this.setOperateType(TpmVerticalSchemeCashOperateTypeEnum.use.getCode());
            this.setOperateAmount(item.getUseAmount());
        }}).collect(Collectors.toList());
        if ((!CollectionUtils.isEmpty(verticalSchemeForecastBudgetCashOperateList))) {
            List<String> keys = verticalSchemeForecastBudgetCashOperateList.stream().map(TpmVerticalSchemeForecastBudgetCashOperateDto::getDetailCode).distinct().collect(Collectors.toList());
            List<String> lockedKeys = verticalSchemeForecastService.lock(keys, TimeUnit.SECONDS, 60, 5);
            try {
                verticalSchemeForecastService.operate(verticalSchemeForecastBudgetCashOperateList, doSave);
            } finally {
                if (!CollectionUtils.isEmpty(lockedKeys)) {
                    verticalSchemeForecastService.unLock(lockedKeys);
                }
            }
        }
    }

    @Override
    @Transactional
    public void returnMonthBudgetByPlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)){
            return;
        }
        List<ActivityPlanBudget> planBudgetList = activityPlanBudgetRepository.listByPlanItemCodeList(planItemCodeList);
        if (CollectionUtils.isEmpty(planBudgetList)){
            return;
        }
        returnMonthBudget(planBudgetList);
    }

    /**
     * 随车搭赠的预算退回单独走
     */
    @Override
    @Transactional
    public void returnCarGiftMonthBudgetByPlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)){
            return;
        }
        List<ActivityPlanBudget> planBudgetList = activityPlanBudgetRepository.findCarGiftCloseReturnBudgetList(planItemCodeList);
        if (CollectionUtils.isEmpty(planBudgetList)){
            return;
        }
        returnMonthBudget(planBudgetList);
    }

    /**
     * 退回月度预算
     *
     * @param planCodeList
     */
    @Override
    @Transactional
    public void returnMonthBudgetByPlanCodeList(List<String> planCodeList){
        if (CollectionUtils.isEmpty(planCodeList)){
            return;
        }
        List<ActivityPlanBudget> planBudgetList = activityPlanBudgetRepository.listByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(planBudgetList)){
            return;
        }
        returnMonthBudget(planBudgetList);
    }

    /**
     * 扣减月度预算
     */
    @Transactional
    public void returnMonthBudget(List<ActivityPlanBudget> budgetList){
        //1、占用策略预算，同时 总部方案占用总部月度预算，大区方案占用大区月度预算
        List<OperateMarketingStrategyBudgetDto> strategyOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的并且策略明细编码不为空
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0  &&
                    ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType()) &&
                    StringUtils.isNotEmpty(item.getRelateStrategyItemCode());
        }).map(item -> {
            return new OperateMarketingStrategyBudgetDto() {{
                this.setBusinessCode(item.getPlanItemCode());
                this.setStrategyCode(item.getRelateStrategyCode());
                this.setStrategyItemCode(item.getRelateStrategyItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(strategyOperateList)){
            marketingStrategyBudgetSdkService.operateAmount(strategyOperateList);
        }

        List<OperateMonthBudgetDto> budgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType());
        }).map(item -> {
            return new OperateMonthBudgetDto(){{
                this.setBusinessCode(item.getPlanItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(budgetOperateList)){
            monthBudgetService.operateBudget(budgetOperateList);
        }

        //垂直总部方案，核销后申请，做冻结
        List<OperateMonthBudgetDto> freezeBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode().equals(item.getOccupyType());
        }).map(item -> {
            return new OperateMonthBudgetDto(){{
                this.setBusinessCode(item.getPlanItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.UNFREEZE.getCode());
                this.setOperationAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(freezeBudgetOperateList)){
            monthBudgetService.operateBudget(freezeBudgetOperateList);
        }

        //2、大区方案占用总部方案预算
        List<OperateActivityPlanBudgetDto> planBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(item.getOccupyType());
        }).map(item -> {
            return new OperateActivityPlanBudgetDto(){{
                this.setBusinessCode(item.getPlanItemCode());
                this.setPlanCode(item.getRelatePlanCode());
                this.setPlanItemCode(item.getRelatePlanItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planBudgetOperateList)){
            activityPlanBudgetService.operateBudget(planBudgetOperateList);
        }

        //垂直大区方案，做退批复再冻结
        List<OperateMonthBudgetDto> headReturnBudgetOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode().equals(item.getOccupyType());
        }).map(item -> {
            return new OperateMonthBudgetDto(){{
                this.setBusinessCode(item.getPlanItemCode());
                this.setMonthBudgetCode(item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(headReturnBudgetOperateList)){
            monthBudgetService.operateBudget(headReturnBudgetOperateList);
            List<OperateMonthBudgetDto> headFreezeBudgetOperateList = (List<OperateMonthBudgetDto>) this.nebulaToolkitService.copyCollectionByWhiteList(headReturnBudgetOperateList, OperateMonthBudgetDto.class, OperateMonthBudgetDto.class, HashSet.class, ArrayList.class);
            headFreezeBudgetOperateList.forEach(operate->operate.setOperationType(BudgetOperationTypeEnum.FREEZE.getCode()));
            monthBudgetService.operateBudget(headFreezeBudgetOperateList);
        }
        List<TpmVerticalSchemeForecastBudgetCashOperateDto> verticalSchemeForecastBudgetCashOperateList = budgetList.stream().filter(item -> {
            //扣减类型为占用预算的
            return null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 &&
                    ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode().equals(item.getOccupyType());
        }).map(item -> {
            return new TpmVerticalSchemeForecastBudgetCashOperateDto(){{
                this.setDetailCode(item.getSchemeForecastDetailCode());
                this.setOperateType(TpmVerticalSchemeCashOperateTypeEnum.back.getCode());
                this.setOperateAmount(item.getUseAmount());
            }};
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(verticalSchemeForecastBudgetCashOperateList)) {
            List<String> keys = verticalSchemeForecastBudgetCashOperateList.stream().map(TpmVerticalSchemeForecastBudgetCashOperateDto::getDetailCode).distinct().collect(Collectors.toList());
            List<String> lockedKeys = verticalSchemeForecastService.lock(keys, TimeUnit.SECONDS, 60, 5);
            try {
                verticalSchemeForecastService.operate(verticalSchemeForecastBudgetCashOperateList, true);
            } finally {
                if (!CollectionUtils.isEmpty(lockedKeys)) {
                    verticalSchemeForecastService.unLock(lockedKeys);
                }
            }
        }
    }

    @Override
    public void operateBudget(List<OperateActivityPlanBudgetDto> operateList) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        Set<String> monthBudgetCodeSet = operateList.stream().map(OperateActivityPlanBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
        try {
            Validate.isTrue(monthBudgetLockService.lock(new ArrayList<>(monthBudgetCodeSet), TimeUnit.SECONDS, BudgetLockConstant.DEFAULT_LOCK_TIME), "预算加锁失败，请稍后重试");
            operateBudget(operateList,Maps.newHashMap());
        } finally {
            monthBudgetLockService.unLock(new ArrayList<>(monthBudgetCodeSet));
        }
    }

    @Override
    public void operateBudget(List<OperateActivityPlanBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        operateList.forEach(dto -> {
            if (!redisLockService.isLock(BudgetLockConstant.MONTH_BUDGET_LOCK + dto.getMonthBudgetCode())) {
                throw new RuntimeException("预算操作失败，月度预算" + dto.getMonthBudgetCode() + "未加锁！");
            }
        });
        List<ActivityPlanBudget> activityPlanBudgets = validateOperateBudget(operateList);
        Map<String, List<ActivityPlanBudget>> budgetEntityMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(item -> item.getPlanItemCode() + item.getMonthBudgetCode()));
        List<MonthBudgetDetailDto> detailList = Lists.newArrayList();
        for (OperateActivityPlanBudgetDto operateMonthBudgetDto : operateList) {
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();

            List<ActivityPlanBudget> monthBudgetEntities = budgetEntityMap.get(operateMonthBudgetDto.getPlanItemCode()+ operateMonthBudgetDto.getMonthBudgetCode());
            BigDecimal looseAmount = looseAmountMap.getOrDefault(operateMonthBudgetDto.getPlanItemCode()+operateMonthBudgetDto.getMonthBudgetCode(),BigDecimal.ZERO);
            for (int i = 0; i < monthBudgetEntities.size(); i++) {
                ActivityPlanBudget monthBudgetEntity = monthBudgetEntities.get(i);
                boolean negate = false;
                if (monthBudgetEntity.getUseAmount().compareTo(BigDecimal.ZERO) < 0){
                    //方案申请金额是负数，反着来算！！！
                    negate = true;
                }
                BigDecimal usableAmount = monthBudgetEntity.getUseAmount().subtract(monthBudgetEntity.getUsedAmount()).add(looseAmount);
                looseAmount = BigDecimal.ZERO;
                operateMonthBudgetDto.setOperationAmount(BigDecimal.ZERO);
                // 根据预算类型操作预算
                BigDecimal thisOperationAmount = operationAmount;
                if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                    if (i == monthBudgetEntities.size() -1){
                        if (negate){
                            //-42 < -7
                            Validate.isTrue(usableAmount.compareTo(thisOperationAmount) <= 0, (StringUtils.isNotEmpty(businessCode) ? "["+businessCode+"]" : "第["+operateMonthBudgetDto.getIndexNo()+"]行")+ "使用金额["+thisOperationAmount+"]大于当前可用余额" + usableAmount + "，请检查！");
                        }else{
                            Validate.isTrue(usableAmount.compareTo(thisOperationAmount) >= 0, (StringUtils.isNotEmpty(businessCode) ? "["+businessCode+"]" : "第["+operateMonthBudgetDto.getIndexNo()+"]行")+ "使用金额["+thisOperationAmount+"]大于当前可用余额" + usableAmount + "，请检查！");
                        }
                    }else if (!negate && usableAmount.compareTo(operationAmount) < 0){
                        thisOperationAmount = usableAmount;
                    }else if (negate && usableAmount.compareTo(operationAmount) > 0){
                        //-4 > -7
                        thisOperationAmount = usableAmount;
                    }
                    operationAmount = operationAmount.subtract(thisOperationAmount);
                    monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().add(thisOperationAmount));
                }else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                    monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().subtract(operationAmount));
                }
            }
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave){
            activityPlanBudgetService.updateOperateBudget(activityPlanBudgets,detailList);
        }
    }

    public List<ActivityPlanBudget> validateOperateBudget(List<OperateActivityPlanBudgetDto> operateList) {
        for (OperateActivityPlanBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notEmpty(operateMonthBudgetDto.getMonthBudgetCode(), "操作预算时，预算编码不能为空！");
            Validate.notNull(operateMonthBudgetDto.getOperationAmount(), "操作预算时，操作金额不能为空！");
            Validate.notEmpty(operateMonthBudgetDto.getOperationType(), "操作预算时，操作类型不能为空！");
            Validate.notEmpty(operateMonthBudgetDto.getPlanItemCode(), "操作方案预算时，方案明细编码不能为空！");
        }

        List<String> operateCodeList = operateList.stream().map(item -> item.getPlanItemCode()+item.getMonthBudgetCode()).distinct().collect(Collectors.toList());
        List<ActivityPlanBudget> budgetEntityList = activityPlanBudgetRepository.listByOperateCodeList(operateCodeList);
        if (budgetEntityList.size() < operateCodeList.size()){
            List<String> existsCodes = budgetEntityList.stream().map(item -> item.getPlanItemCode()+item.getMonthBudgetCode()).collect(Collectors.toList());
            String notExistsJoinCodesStr = operateCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("预算操作失败，活动明细[" + notExistsJoinCodesStr + "]查询失败，请检查预算是否启用或是否存在！！");
        }
        for (ActivityPlanBudget activityPlanItem : budgetEntityList) {
            if (null == activityPlanItem.getUseAmount()){
                activityPlanItem.setUseAmount(BigDecimal.ZERO);
            }
            if (null == activityPlanItem.getUsedAmount()){
                activityPlanItem.setUsedAmount(BigDecimal.ZERO);
            }
        }
        return budgetEntityList;
    }

    @Override
    public void operateCustomerBudget(List<OperateActivityPlanBudgetDto> operateList) {
        List<ActivityPlanBudget> activityPlanBudgets = validateOperateCustomerBudget(operateList);
        Map<String, List<ActivityPlanBudget>> budgetEntityMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudget::getPlanItemCode));
        List<MonthBudgetDetailDto> detailList = Lists.newArrayList();
        for (OperateActivityPlanBudgetDto operateMonthBudgetDto : operateList) {
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();

            List<ActivityPlanBudget> monthBudgetEntities = budgetEntityMap.get(operateMonthBudgetDto.getPlanItemCode());
            for (int i = 0; i < monthBudgetEntities.size(); i++) {
                ActivityPlanBudget monthBudgetEntity = monthBudgetEntities.get(i);
                BigDecimal usableAmount = monthBudgetEntity.getUseAmount().subtract(monthBudgetEntity.getUsedAmount());
                // 根据预算类型操作预算
                BigDecimal thisOperationAmount = operationAmount;
                if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                    if (i == monthBudgetEntities.size() -1){
//                        Validate.isTrue(usableAmount.compareTo(thisOperationAmount) >= 0, "["+businessCode+"]使用金额["+thisOperationAmount+"]大于当前可用余额" + usableAmount + "，请检查！");
                    }else if (usableAmount.compareTo(operationAmount) < 0){
                        thisOperationAmount = usableAmount;
                        operationAmount = operationAmount.subtract(thisOperationAmount);
                    }
                    monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().add(thisOperationAmount));
                }else if (BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) {
                    monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().subtract(operationAmount));
                }
            }
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave){
            activityPlanBudgetService.updateOperateBudget(activityPlanBudgets,detailList);
        }
    }

    public List<ActivityPlanBudget> validateOperateCustomerBudget(List<OperateActivityPlanBudgetDto> operateList) {
        for (OperateActivityPlanBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notNull(operateMonthBudgetDto.getOperationAmount(), "操作预算时，操作金额不能为空！");
            Validate.notEmpty(operateMonthBudgetDto.getOperationType(), "操作预算时，操作类型不能为空！");
            Validate.notEmpty(operateMonthBudgetDto.getPlanItemCode(), "操作方案预算时，方案明细编码不能为空！");
        }
        List<String> operateCodeList = operateList.stream().map(OperateActivityPlanBudgetDto::getPlanItemCode).distinct().collect(Collectors.toList());
        List<ActivityPlanBudget> budgetEntityList = activityPlanBudgetRepository.listCustomerBudgetByOperateCodeList(operateCodeList);
        if (budgetEntityList.size() < operateCodeList.size()){
            List<String> existsCodes = budgetEntityList.stream().map(item -> item.getPlanItemCode()+item.getMonthBudgetCode()).collect(Collectors.toList());
            String notExistsJoinCodesStr = operateCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("预算操作失败，活动方案客户预算[" + notExistsJoinCodesStr + "]查询失败，请检查预算是否启用或是否存在！！");
        }
        for (ActivityPlanBudget activityPlanItem : budgetEntityList) {
            if (null == activityPlanItem.getUseAmount()){
                activityPlanItem.setUseAmount(BigDecimal.ZERO);
            }
            if (null == activityPlanItem.getUsedAmount()){
                activityPlanItem.setUsedAmount(BigDecimal.ZERO);
            }
        }
        return budgetEntityList;
    }

    /**
     * 保存更新操作预算数据
     * @param budgetList 预算头数据
     * @param detailList 预算明细数据
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateOperateBudget(Collection<ActivityPlanBudget> budgetList, List<MonthBudgetDetailDto> detailList) {
        this.activityPlanBudgetRepository.updateBatchById(budgetList);
    }

    @Override
    public Page<MarketingStrategyBudgetVo> findChooseStrategyBudgetList(Pageable pageable, MarketingStrategyBudgetDto dto) {
        return marketingStrategyBudgetSdkService.findByConditions(pageable,dto);
    }

}
