package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.entity.SfaActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.repository.SfaActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanDockingSfaService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanCreateResult;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.SfaActivityPlanDisplayCreateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.person.SfaActivityPlanPersonCreateDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/3/31 15:08
 */
@Service
public class ActivityPlanDockingSfaServiceImpl implements ActivityPlanDockingSfaService {

    @Autowired(required = false)
    private SfaActivityPlanItemRepository sfaActivityPlanItemRepository;
    
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    
    @Override
    public List<SfaActivityPlanCreateResult> sfaActivityPlanCreatePerson(List<SfaActivityPlanPersonCreateDto> list) {
        List<SfaActivityPlanItem> entityList = (List<SfaActivityPlanItem>) nebulaToolkitService.copyCollectionByWhiteList(list,SfaActivityPlanPersonCreateDto.class, SfaActivityPlanItem.class, HashSet.class, ArrayList.class);
        String tenantCode = TenantUtils.getTenantCode();
        entityList.forEach(item -> {
            item.setTenantCode(tenantCode);
        });
        sfaActivityPlanItemRepository.saveBatch(entityList);
//
//
//        ActivityPlan activityPlan = new ActivityPlan();
//        //是否完全承接默认为否
//        ActivityPlanItem activityPlanItem = new ActivityPlanItem();

        int index = 0;
        List<SfaActivityPlanCreateResult> result = Lists.newArrayList();
        for (SfaActivityPlanItem sfaActivityPlanItem : entityList) {
            result.add(new SfaActivityPlanCreateResult(){{
                this.setSfaPlanCode(sfaActivityPlanItem.getSfaPlanCode());
                this.setPlanCode("AP000001");
                this.setPlanItemCode("AX"+String.format("%05d",index+1));
            }});
        }
        return result;
    }

    @Override
    public void sfaActivityPlanCreateDisplay(List<SfaActivityPlanDisplayCreateDto> list) {
        List<SfaActivityPlanItem> entityList = (List<SfaActivityPlanItem>) nebulaToolkitService.copyCollectionByWhiteList(list,SfaActivityPlanDisplayCreateDto.class, SfaActivityPlanItem.class, HashSet.class, ArrayList.class);
        String tenantCode = TenantUtils.getTenantCode();
        entityList.forEach(item -> {
            item.setTenantCode(tenantCode);
        });
        sfaActivityPlanItemRepository.saveBatch(entityList);
    }

}
