package com.biz.crm.tpm.business.activity.plan.local.service.internal;


import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemAsyncService;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 营销策略(ActivityDetail) 异步方法
 *
 * @author wanghaojia
 * @since 2022-11-03 18:22:11
 */
@Slf4j
@Service("activityPlanItemAsyncService")
public class ActivityPlanItemAsyncServiceImpl implements ActivityPlanItemAsyncService {


    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 推个mq消息自动关闭细案
     */
    @Async
    @Override
    public void closeActivityDetailPlanItem(List<String> itemCodeList, AbstractCrmUserIdentity userIdentity) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        loginUserService.refreshAuthentication(userIdentity);
        List<List<String>> entityGroupList = Lists.partition(itemCodeList, 400);
        entityGroupList.forEach(list -> {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSON.toJSONString(list));
            mqMessageVo.setTopic(ActivityPlanPassMqTagConstant.CLOSE_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(ActivityPlanPassMqTagConstant.CLOSE_AUTO_CLOSE_DETAIL_PLAN);
            rocketMqProducer.sendMqMsg(mqMessageVo);
            try {
                //单位：毫秒 防止MQ消息发送过于频繁
                Thread.sleep(200);
            } catch (Exception e) {
                log.error("", e);
            }
        });
    }

}

