package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.vo.ImportProcessMsgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemTerminalRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyItemSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案分页缓存处理类
 * @author wanghaojia
 * @date 2022/12/16 11:22
 */
@Slf4j
@Component
public class ActivityPlanItemPageCacheHelper extends MnPageCacheHelper<ActivityPlanItemVo, ActivityPlanItemDto> {

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MarketingStrategyItemSdkService marketingStrategyItemSdkService;

    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Autowired(required = false)
    private ActivityPlanItemTerminalRepository activityPlanItemTerminalRepository;

    @Autowired(required = false)
    private ChannelMsgService channelMsgService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Value("${spring.application.name:}")
    private String applicationName;

    private ThreadLocal<Integer> websocketOrder = new ThreadLocal<>();

    @Override
    public String getCacheKeyPrefix() {
        return ActivityPlanConstant.ACTIVITY_PLAN_ITEM_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<ActivityPlanItemDto> getDtoClass() {
        return ActivityPlanItemDto.class;
    }

    @Override
    public Class<ActivityPlanItemVo> getVoClass() {
        return ActivityPlanItemVo.class;
    }

    @Override
    public List<ActivityPlanItemDto> findDtoListFromRepository(ActivityPlanItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getPlanCode())){
            return Lists.newArrayList();
        }
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        String redisCacheIdKey = getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = getRedisCacheDataKey(cacheKey);

        //有策略编码，从数据库里面查出来放到缓存里面
        List<ActivityPlanItemDto> allDtoList = activityPlanItemRepository.findDtoAndAttachListByPlanCode(dto.getPlanCode());
        allDtoList.sort(Comparator.comparing(ActivityPlanItemDto::getPlanItemCode));

        Map<String, List<ActivityPlanItemDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemDto::getTemplateConfigCode));
        for (Map.Entry<String, List<ActivityPlanItemDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode,entry.getKey());

            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode,entry.getKey());
            Map<Object, ActivityPlanItemDto> newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            redisService.lPushAll(thisRedisIdCacheKey, this.getExpireTime(), entry.getValue().stream().map(this::getDtoKey).toArray());
            redisTemplate.opsForHash().putAll(thisRedisDataCacheKey, newItemMap);
            redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }

        return allMap.get(templateCode);
    }

    @Override
    public void fillVoListProperties(List<ActivityPlanItemVo> records) {
        super.fillVoListProperties(records);
    }

    @Override
    public boolean initToCacheFromRepository() {
        return false;
    }

    @Override
    public List<ActivityPlanItemDto> newItem(String cacheKey, List<ActivityPlanItemDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码
        //页面新增
        ActivityPlanItemDto newItem = new ActivityPlanItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList(newItem);
    }

    /**
     * 导入新增数据
     * @param cacheKey
     * @param itemList
     * @return
     */
    public void importNewItem(String cacheKey, List<ActivityPlanItemDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);

        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        //导入新增数据
        for (ActivityPlanItemDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTemplateConfigCode(templateCode);
        }

        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        redisService.lPushAll(redisCacheIdKey, this.getExpireTime(),newIdArr );

        Map<Object, ActivityPlanItemDto> updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        redisTemplate.opsForHash().putAll(redisCacheDataKey, updateMap);
        redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    @Override
    public List<ActivityPlanItemDto> copyItem(String cacheKey, List<ActivityPlanItemDto> itemList) {
        List<ActivityPlanItemDto> newItemList = (List<ActivityPlanItemDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItemDto.class, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);
        for (ActivityPlanItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setPlanItemCode(null);
        }
        return newItemList;
    }

    @Override
    public void updateItem(String cacheKey, List<ActivityPlanItemDto> itemList) {
        String[] split = cacheKey.split(":");
        String lockKey = ActivityPlanConstant.LOCK_ACTIVITY_PLAN_SAVE+split[0];
        if (redisLockService.isLock(lockKey)){
            throw new RuntimeException("数据已提交，请勿重复操作！");
        }

        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes){
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) requestAttributes;
            String businessUnitCode = servletRequestAttributes.getRequest().getParameter("businessUnitCode");

            if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)){
                for (ActivityPlanItemDto itemDto : itemList) {
                    if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())){
                        //垂直选择预算逻辑处理
                        BigDecimal headFeeAmount = BigDecimal.ZERO;
                        BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
                        BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;

                        Set<String> headMonthBudgetCodeSet = Sets.newHashSet();
                        Set<String> regionAutomaticMonthBudgetCodeSet = Sets.newHashSet();
                        Set<String> regionReferendumMonthBudgetCodeSet = Sets.newHashSet();

                        Set<String> headBudgetItemCodeSet = Sets.newHashSet();
                        Set<String> regionAutomaticBudgetItemCodeSet = Sets.newHashSet();
                        Set<String> regionReferendumBudgetItemCodeSet = Sets.newHashSet();

                        Set<String> headBudgetItemNameSet = Sets.newHashSet();
                        Set<String> regionAutomaticBudgetItemNameSet = Sets.newHashSet();
                        Set<String> regionReferendumBudgetItemNameSet = Sets.newHashSet();

                        for (ActivityPlanBudgetDto budgetDto : itemDto.getBudgetShares()) {
                            if(StringUtils.isEmpty(budgetDto.getFeeBelongCode())){
                                //没有费用归口不处理
                                continue;
                            }
                            if (StringUtils.isNotEmpty(budgetDto.getUseAmountStr())){
                                NumberStringDealUtil.validateNumberStrAndSet(budgetDto.getUseAmountStr(),"本次使用预算金额",false,budgetDto::setUseAmount,BigDecimal.class);

                                if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //总部预算
                                    headFeeAmount = headFeeAmount.add(budgetDto.getUseAmount());
                                }else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //大区自投预算
                                    regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(budgetDto.getUseAmount());
                                }else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())){
                                    //大区公投预算
                                    regionReferendumFeeAmount = regionReferendumFeeAmount.add(budgetDto.getUseAmount());
                                }
                            }


                            if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())){
                                //总部预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    headMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    headBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    headBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())){
                                //大区自投预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    regionAutomaticMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    regionAutomaticBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    regionAutomaticBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())){
                                //大区公投预算
                                if (StringUtils.isNotEmpty(budgetDto.getMonthBudgetCode())){
                                    regionReferendumMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemCode())){
                                    regionReferendumBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                                }
                                if (StringUtils.isNotEmpty(budgetDto.getBudgetItemName())){
                                    regionReferendumBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                                }
                            }


                        }
                        itemDto.setHeadFeeAmount(headFeeAmount);
                        itemDto.setHeadFeeAmountStr(headFeeAmount.toString());
                        itemDto.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
                        itemDto.setRegionAutomaticFeeAmountStr(regionAutomaticFeeAmount.toString());
                        itemDto.setRegionReferendumFeeAmount(regionReferendumFeeAmount);
                        itemDto.setRegionReferendumFeeAmountStr(regionReferendumFeeAmount.toString());

                        itemDto.setHeadMonthBudgetCode(String.join(",",headMonthBudgetCodeSet));
                        itemDto.setRegionAutomaticMonthBudgetCode(String.join(",",regionAutomaticMonthBudgetCodeSet));
                        itemDto.setRegionReferendumMonthBudgetCode(String.join(",",regionReferendumMonthBudgetCodeSet));
                        itemDto.setHeadBudgetItemCode(String.join(",",headBudgetItemCodeSet));
                        itemDto.setRegionAutomaticBudgetItemCode(String.join(",",regionAutomaticBudgetItemCodeSet));
                        itemDto.setRegionReferendumBudgetItemCode(String.join(",",regionReferendumBudgetItemCodeSet));
                        itemDto.setHeadBudgetItemName(String.join(",",headBudgetItemNameSet));
                        itemDto.setRegionAutomaticBudgetItemName(String.join(",",regionAutomaticBudgetItemNameSet));
                        itemDto.setRegionReferendumBudgetItemName(String.join(",",regionReferendumBudgetItemNameSet));
                    }
                }
                //垂直有门店分摊数据要单独处理一下,不在这里做更新
                String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
                List<Object> idList = itemList.stream().map(ActivityPlanItemDto::getId).collect(Collectors.toList());
                List<Object> existsObjList = redisTemplate.opsForHash().multiGet(redisCacheDataKey, idList);
                if (!CollectionUtils.isEmpty(existsObjList)){
                    List<ActivityPlanItemDto> existsList = (List<ActivityPlanItemDto>) (List) existsObjList;
                    Map<String, ActivityPlanItemDto> existsMap = existsList.stream().collect(Collectors.toMap(ActivityPlanItemDto::getId, Function.identity()));
                    for (ActivityPlanItemDto itemDto : itemList) {
                        ActivityPlanItemDto existItemDto = existsMap.get(itemDto.getId());
                        if (null != existItemDto && !CollectionUtils.isEmpty(existItemDto.getActivityPlanItemTerminalList())){
                            itemDto.setActivityPlanItemTerminalList(existItemDto.getActivityPlanItemTerminalList());
                        }
                    }
                }
            }

            // 方案承接方案、或承接策略时。更据关联的方案/策略，他们的是否承接配置，及模板配置中承接时是否可修改。明细上对应字段的取值从关联的方案/策略明细上获取、并校验。
            if (BusinessUnitEnum.HEADQUARTERS.getCode().equals(businessUnitCode)){
                //找出所有关联的方案明细
                List<String> relatePlanItemCodes = itemList.stream().map(ActivityPlanItemDto::getRelatePlanItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<ActivityPlanItemVo> activityPlanItemVoList = activityPlanItemRepository.findRelatedPlanItemByCodes(relatePlanItemCodes);
                Map<String, ActivityPlanItemVo> activityPlanMap = activityPlanItemVoList.stream().collect(Collectors.toMap(ActivityPlanItemVo::getPlanItemCode, Function.identity()));
                //找出所有关联的策略明细
                List<String> relateStrategyItemCodes = itemList.stream().map(ActivityPlanItemDto::getRelateStrategyItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<MarketingStrategyItemVo> strategyItemVos = marketingStrategyItemSdkService.findByItemCodes(relateStrategyItemCodes);
                Map<String, MarketingStrategyItemVo> strategyItemVoMap = strategyItemVos.stream().collect(Collectors.toMap(MarketingStrategyItemVo::getStrategyItemCode, Function.identity()));
                //找出所有模板配置
                List<String> templateCodes = itemList.stream().map(ActivityPlanItemDto::getTemplateConfigCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(templateCodes);
                Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));

                for (ActivityPlanItemDto item : itemList) {

                    // 同时关联方案和策略
                   if (!StringUtils.isEmpty(item.getRelatePlanItemCode())
                           && !CollectionUtils.isEmpty(activityPlanMap)
                           && !StringUtils.isEmpty(item.getRelateStrategyItemCode())
                           && !CollectionUtils.isEmpty(strategyItemVoMap)) {

                       //关联的方案明细
                       ActivityPlanItemVo relatePlanItemVo = activityPlanMap.get(item.getRelatePlanItemCode());
                       if (null == relatePlanItemVo) {
                           throw new IllegalArgumentException("获取承接的方案数据时，未查询到关联的方案明细信息! 方案明细编码["+item.getRelatePlanItemCode()+"]");
                       }
                       //关联的策略明细
                       MarketingStrategyItemVo relateStrategyItemVo = strategyItemVoMap.get(item.getRelateStrategyItemCode());
                       if (null == relateStrategyItemVo) {
                           throw new IllegalArgumentException("获取承接的策略数据时，未查询到关联的策略明细信息! 策略明细编码["+item.getRelateStrategyItemCode()+"]");
                       }
                       //对应的模板配置
                       ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(item.getTemplateConfigCode());
                       if (null == templateConfigVo) {
                           throw new IllegalArgumentException("处理承接数据时，未查询到对应的活动模板配置信息! 模板编码["+item.getTemplateConfigCode()+"]");
                       }
                       ActivityPlanItemDto relatePlanItemDto = nebulaToolkitService.copyObjectByWhiteList(relatePlanItemVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);
                       ObjectConvertStringUtil.fillObjectStrProperties(relatePlanItemDto,ActivityPlanItemDto.class);
                       ActivityPlanItemDto correspondenceDto = this.correspondence(relateStrategyItemVo);
                       ObjectConvertStringUtil.fillObjectStrProperties(correspondenceDto,ActivityPlanItemDto.class);
                       this.handleAcceptFieldData(item,relatePlanItemDto,correspondenceDto,templateConfigVo);

                       continue;
                   }
                   // 只关联方案
                   if (!StringUtils.isEmpty(item.getRelatePlanItemCode())
                           && !CollectionUtils.isEmpty(activityPlanMap)
                           && StringUtils.isEmpty(item.getRelateStrategyItemCode())) {

                       //关联的方案明细
                       ActivityPlanItemVo relatePlanItemVo = activityPlanMap.get(item.getRelatePlanItemCode());
                       if (null == relatePlanItemVo) {
                           throw new IllegalArgumentException("获取承接的方案数据时，未查询到关联的方案明细信息! 方案明细编码["+item.getRelatePlanItemCode()+"]");
                       }
                       //对应的模板配置
                       ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(item.getTemplateConfigCode());
                       if (null == templateConfigVo) {
                           throw new IllegalArgumentException("处理承接数据时，未查询到对应的活动模板配置信息! 模板编码["+item.getTemplateConfigCode()+"]");
                       }
                       ActivityPlanItemDto relatePlanItemDto = nebulaToolkitService.copyObjectByWhiteList(relatePlanItemVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);
                       ObjectConvertStringUtil.fillObjectStrProperties(relatePlanItemDto,ActivityPlanItemDto.class);
                       //处理数据
                       this.handleAcceptFieldData(item,relatePlanItemDto,templateConfigVo);

                       continue;
                   }
                   //只关联策略
                   if (StringUtils.isEmpty(item.getRelatePlanItemCode())
                           && !StringUtils.isEmpty(item.getRelateStrategyItemCode())
                           && !CollectionUtils.isEmpty(strategyItemVoMap)) {
                       //关联的策略明细
                       MarketingStrategyItemVo relateStrategyItemVo = strategyItemVoMap.get(item.getRelateStrategyItemCode());
                       if (null == relateStrategyItemVo) {
                           throw new IllegalArgumentException("获取承接的策略数据时，未查询到关联的策略明细信息! 策略明细编码["+item.getRelateStrategyItemCode()+"]");
                       }
                       //对应的模板配置
                       ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(item.getTemplateConfigCode());
                       if (null == templateConfigVo) {
                           throw new IllegalArgumentException("处理承接数据时，未查询到对应的活动模板配置信息! 模板编码["+item.getTemplateConfigCode()+"]");
                       }
                       ActivityPlanItemDto correspondenceDto = this.correspondence(relateStrategyItemVo);
                       ObjectConvertStringUtil.fillObjectStrProperties(correspondenceDto,ActivityPlanItemDto.class);
                       //处理数据
                       this.handleAcceptFieldData(item,correspondenceDto,templateConfigVo);

                       continue;
                   }
                }
            }
        }
    }

    @Override
    public List<ActivityPlanItemVo> dtoListToVoList(List<ActivityPlanItemDto> itemDtoList) {
        return super.dtoListToVoList(itemDtoList);
    }

    @Override
    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        return redisCacheInitKey.replace(templateCode,"");//要去掉模板编码，不然会重复初始化
    }

    @Override
    public Object getDtoKey(ActivityPlanItemDto activityPlanItemDto) {
        return activityPlanItemDto.getId();
    }

    @Override
    public String getCheckedStatus(ActivityPlanItemDto activityPlanItemDto) {
        return activityPlanItemDto.getChecked();
    }

    /**
     * 处理只承接字段数据
     *
     * @param item 方案明细
     * @param relateDto 关联的方案/策略明细
     * @param templateConfigVo 模板配置详情
     */
    private void handleAcceptFieldData(ActivityPlanItemDto item, ActivityPlanItemDto relateDto, ActivitiesTemplateConfigVo templateConfigVo) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        //完全承接
        if (BooleanEnum.TRUE.getNumStr().equals(item.getHeadMonthBudgetFullAccept())) {

            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null != config.getEditableWhenUndertake() && !config.getEditableWhenUndertake()){
                    if (!propertyMap.containsKey(config.getField())){
                        throw new RuntimeException("模板["+templateConfigVo.getConfigCode()+templateConfigVo.getConfigName()+"]属性["+config.getTitle()+"]的属性["+config.getField()+"]配置有误!");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(config.getField());
                    if (null != propertyDescriptor){
                        try {
                            Object itemInvoke = propertyDescriptor.getReadMethod().invoke(relateDto);
                            if (null != itemInvoke) {
                                propertyDescriptor.getWriteMethod().invoke(item,itemInvoke);
                            }

                        } catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("["+config.getTitle()+"]配置有误！");
                        }
                    }else{
                        throw new RuntimeException("["+config.getTitle()+"]配置有误，请检查！");
                    }
                }
            }

        }else {
            //部分承接
            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null != config.getEditableWhenUndertakePart() && !config.getEditableWhenUndertakePart()){
                    if (!propertyMap.containsKey(config.getField())){
                        throw new RuntimeException("模板["+templateConfigVo.getConfigCode()+templateConfigVo.getConfigName()+"]属性["+config.getTitle()+"]的属性["+config.getField()+"]配置有误!");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(config.getField());
                    if (null != propertyDescriptor){
                        try {
                            Object itemInvoke = propertyDescriptor.getReadMethod().invoke(relateDto);
                            if (null != itemInvoke) {
                                propertyDescriptor.getWriteMethod().invoke(item,itemInvoke);
                            }

                        } catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("["+config.getTitle()+"]配置有误！");
                        }
                    }else{
                        throw new RuntimeException("["+config.getTitle()+"]配置有误，请检查！");
                    }
                }
            }
        }
    }

    /**
     * 同时关联方案和策略时，处理承接数据
     *
     * @param item 方案明细
     * @param relatePlanItemDto 关联的方案明细
     * @param relateStrategyItemData 关联的策略明细转换成方案明细后的数据
     * @param templateConfigVo 模板配置详情
     */
    private void handleAcceptFieldData(ActivityPlanItemDto item, ActivityPlanItemDto relatePlanItemDto,ActivityPlanItemDto relateStrategyItemData, ActivitiesTemplateConfigVo templateConfigVo) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));
        //完全承接
        if (BooleanEnum.TRUE.getNumStr().equals(item.getHeadMonthBudgetFullAccept())
                && BooleanEnum.TRUE.getNumStr().equals(item.getMonthBudgetFullAccept())) {

            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null != config.getEditableWhenUndertake() && !config.getEditableWhenUndertake()){
                    if (!propertyMap.containsKey(config.getField())){
                        throw new RuntimeException("模板["+templateConfigVo.getConfigName()+"]属性["+config.getTitle()+"]配置有误");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(config.getField());
                    if (null != propertyDescriptor){
                        try {
                            Object itemInvoke = propertyDescriptor.getReadMethod().invoke(relatePlanItemDto);
                            if (null != itemInvoke) {
                                propertyDescriptor.getWriteMethod().invoke(item,itemInvoke);
                            }

                        } catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("["+config.getTitle()+"]读取失败！");
                        }
                    }else{
                        throw new RuntimeException("["+config.getTitle()+"]配置有误，请检查！");
                    }
                }
            }

        }else if (!BooleanEnum.TRUE.getNumStr().equals(item.getHeadMonthBudgetFullAccept())
                && !BooleanEnum.TRUE.getNumStr().equals(item.getMonthBudgetFullAccept())){
            //部分承接
            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null != config.getEditableWhenUndertakePart() && !config.getEditableWhenUndertakePart()){
                    if (!propertyMap.containsKey(config.getField())){
                        throw new RuntimeException("模板["+templateConfigVo.getConfigName()+"]属性["+config.getTitle()+"]配置有误");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(config.getField());
                    if (null != propertyDescriptor){
                        try {
                            Object itemInvoke = propertyDescriptor.getReadMethod().invoke(relateStrategyItemData);
                            if (null != itemInvoke) {
                                propertyDescriptor.getWriteMethod().invoke(item,itemInvoke);
                            }

                        } catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("["+config.getTitle()+"]读取失败！");
                        }
                    }else{
                        throw new RuntimeException("["+config.getTitle()+"]配置有误，请检查！");
                    }
                }
            }

        }else {
            // 关联的方案和策略中，某个为完全承接、某个为部分承接时
            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null != config.getEditableWhenUndertake() && !config.getEditableWhenUndertake()
                        && null != config.getEditableWhenUndertakePart() && config.getEditableWhenUndertakePart() ){
                    if (!propertyMap.containsKey(config.getField())){
                        throw new RuntimeException("模板["+templateConfigVo.getConfigName()+"]属性["+config.getTitle()+"]配置有误");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(config.getField());
                    if (null != propertyDescriptor){
                        try {
                            Object itemInvoke = propertyDescriptor.getReadMethod().invoke(relatePlanItemDto);
                            if (null != itemInvoke) {
                                propertyDescriptor.getWriteMethod().invoke(item,itemInvoke);
                            }

                        } catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("["+config.getTitle()+"]读取失败！");
                        }
                    }else{
                        throw new RuntimeException("["+config.getTitle()+"]配置有误，请检查！");
                    }
                }
            }

        }
    }



        /**
         * 策略明细字段 对应 方案明细字段
         *
         * @param relateVo
         * @return
         */
    private ActivityPlanItemDto correspondence(MarketingStrategyItemVo relateVo) {
        relateVo.setActivityNumber(null);//活动号这个字段含义有问题，先置空
        ActivityPlanItemDto dto = nebulaToolkitService.copyObjectByWhiteList(relateVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class);

        return dto;
    }


    /**
     * 发送进度消息
     */
    public void sendMsg(String remark) {
        sendMsg(remark, ExecStatusEnum.RUNNING.getKey());
    }


    /**
     * 发送进度消息
     */
    public void sendMsg(String remark,String execStatus) {
        sendMsg(ActivityPlanConstant.WEBSOCKET_MODEL_CODE_SAVE,remark,execStatus);
    }

    /**
     * 关闭活动方案 发送进度消息
     */
    public void sendCloseMsg(String remark) {
        sendCloseMsg(remark, ExecStatusEnum.RUNNING.getKey());
    }
    /**
     * 关闭活动方案 发送进度消息
     */
    public void sendCloseMsg(String remark,String execStatus) {
        sendMsg(ActivityPlanConstant.WEBSOCKET_MODEL_CODE_ITEM_CLOSE,remark,execStatus);
    }

    /**
     * 发送进度消息
     */
    public void sendMsg(String modelCode,String remark,String execStatus) {
        Integer order = websocketOrder.get();
        if (null == order){
            order = 0;
        }
        websocketOrder.set(order + 1);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("remark",remark);
        String time = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN);
        jsonObject.put("time",time);
        jsonObject.put("applicationName",applicationName);
        jsonObject.put("execStatus",execStatus);
        jsonObject.put("order",order);
        if (ExecStatusEnum.FINISH.getKey().equals(execStatus)){
            //任务执行结束之后清理threadLocal
            websocketOrder.remove();;
        }
        byte[] jsonBytes = JSONObject.toJSONBytes(jsonObject);
        String tenantCode = TenantUtils.getTenantCode();
        log.info(" activity_plan model send msg2: tenantCode = {} , applicationName = {} , modelCode = {} ", tenantCode, applicationName, modelCode);
        UserIdentity loginUser = loginUserService.getLoginUser();
        //公共导入通道
        this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, applicationName, modelCode, loginUser.getAccount(), jsonBytes);
    }

}
