package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRelateDetailItemRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemRelateDetailItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/10/3  18:39
 * @Description: 活动方案关联细案缓存助手
 */
@Slf4j
@Component
public class ActivityPlanItemRelateDetailItemPageCacheHelper extends MnPageCacheHelper<ActivityPlanItemRelateDetailItemVo, ActivityPlanItemRelateDetailItemDto> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired(required = false)
    private ActivityPlanItemRelateDetailItemRepository activityPlanItemRelateDetailItemRepository;

    @Override
    public String getCacheKeyPrefix() {
        return ActivityPlanConstant.ACTIVITY_PLAN_ITEM_RELATE_DETAIL_ITEM_CACHE_KEY_PREFIX;
    }

    @Override
    public Class<ActivityPlanItemRelateDetailItemDto> getDtoClass() {
        return ActivityPlanItemRelateDetailItemDto.class;
    }

    @Override
    public Class<ActivityPlanItemRelateDetailItemVo> getVoClass() {
        return ActivityPlanItemRelateDetailItemVo.class;
    }

    @Override
    public List<ActivityPlanItemRelateDetailItemDto> findDtoListFromRepository(ActivityPlanItemRelateDetailItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty(dto.getPlanCode())){
            return Lists.newArrayList();
        }
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        String redisCacheIdKey = getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = getRedisCacheDataKey(cacheKey);

        //有策略编码，从数据库里面查出来放到缓存里面
        List<ActivityPlanItemRelateDetailItemDto> allDtoList = activityPlanItemRelateDetailItemRepository.findDtoListByPlanCode(dto.getPlanCode());
        ObjectConvertStringUtil.fillObjectListStrProperties(allDtoList,ActivityPlanItemRelateDetailItemDto.class);
        allDtoList.sort(Comparator.comparing(ActivityPlanItemRelateDetailItemDto::getPlanItemCode));

        Map<String, List<ActivityPlanItemRelateDetailItemDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemRelateDetailItemDto::getTemplateConfigCode));
        for (Map.Entry<String, List<ActivityPlanItemRelateDetailItemDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode,entry.getKey());

            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode,entry.getKey());
            Map<Object, ActivityPlanItemRelateDetailItemDto> newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            redisService.lPushAll(thisRedisIdCacheKey, this.getExpireTime(), entry.getValue().stream().map(this::getDtoKey).toArray());
            redisTemplate.opsForHash().putAll(thisRedisDataCacheKey, newItemMap);
            redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }

        return allMap.get(templateCode);
    }

    @Override
    public boolean initToCacheFromRepository() {
        return false;
    }

    @Override
    public void fillVoListProperties(List<ActivityPlanItemRelateDetailItemVo> records){
        for (ActivityPlanItemRelateDetailItemVo record : records) {
            record.setActivityForm(record.getActivityFormName());
            record.setActivityType(record.getActivityTypeName());
        }
    }

    @Override
    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        return redisCacheInitKey.replace(templateCode,"");//要去掉模板编码，不然会重复初始化
    }

    @Override
    public List<ActivityPlanItemRelateDetailItemDto> newItem(String cacheKey, List<ActivityPlanItemRelateDetailItemDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码
        //页面新增
        ActivityPlanItemRelateDetailItemDto newItem = new ActivityPlanItemRelateDetailItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList(newItem);
    }

    @Override
    public List<ActivityPlanItemRelateDetailItemDto> copyItem(String cacheKey, List<ActivityPlanItemRelateDetailItemDto> itemList) {
        List<ActivityPlanItemRelateDetailItemDto> newItemList = (List<ActivityPlanItemRelateDetailItemDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItemRelateDetailItemDto.class, ActivityPlanItemRelateDetailItemDto.class, HashSet.class, ArrayList.class);
        for (ActivityPlanItemRelateDetailItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setPlanItemCode(null);
        }
        return newItemList;
    }

    @Override
    public Object getDtoKey(ActivityPlanItemRelateDetailItemDto activityPlanItemRelateDetailItemDto) {
        return activityPlanItemRelateDetailItemDto.getId();
    }

    @Override
    public String getCheckedStatus(ActivityPlanItemRelateDetailItemDto activityPlanItemRelateDetailItemDto) {
        return activityPlanItemRelateDetailItemDto.getChecked();
    }

    public void importNewItem(String cacheKey, List<ActivityPlanItemRelateDetailItemDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);

        String[] split = cacheKey.split(":");
        String templateCode = split[split.length-1];//模板编码

        //导入新增数据
        for (ActivityPlanItemRelateDetailItemDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTemplateConfigCode(templateCode);
        }

        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        redisService.lPushAll(redisCacheIdKey, this.getExpireTime(),newIdArr );

        Map<Object, ActivityPlanItemRelateDetailItemDto> updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        redisTemplate.opsForHash().putAll(redisCacheDataKey, updateMap);
        redisService.expire(redisCacheDataKey, this.getExpireTime());
    }
}
