package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemRelateDetailItem;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRelateDetailItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemRelateDetailItemService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemRelateDetailItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/10/3  18:20
 * @Description: 活动方案关联细案
 */
@Slf4j
@Service("activityPlanItemRelateDetailItemService")
public class ActivityPlanItemRelateDetailItemServiceImpl extends MnPageCacheServiceImpl<ActivityPlanItemRelateDetailItemVo, ActivityPlanItemRelateDetailItemDto> implements ActivityPlanItemRelateDetailItemService {

    @Autowired(required = false)
    private ActivityPlanItemRelateDetailItemRepository activityPlanItemRelateDetailItemRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void savePlanItemRelateDetailItem(ActivityPlan entity, boolean update, List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList) {
        if(CollectionUtils.isEmpty(relateDetailItemDtoList)){
            activityPlanItemRelateDetailItemRepository.deleteByPlanCode(entity.getPlanCode());
            return;
        }
        ObjectConvertStringUtil.convertObjectListStrProperties(relateDetailItemDtoList,ActivityPlanItemRelateDetailItemDto.class,true);

        List<ActivityPlanItemRelateDetailItemDto> updateDtoList = new ArrayList<>();
        List<ActivityPlanItemRelateDetailItemDto> saveDtoList = new ArrayList<>();
        Map<String, ActivityPlanItemRelateDetailItemVo> oldMap = new HashMap<>();

        if(update) {
            List<ActivityPlanItemRelateDetailItemVo> relateDetailItemVoList = activityPlanItemRelateDetailItemRepository.findListByPlanCode(entity.getPlanCode());
            if (CollectionUtils.isNotEmpty(relateDetailItemVoList)) {
                oldMap = relateDetailItemVoList.stream().collect(Collectors.toMap(ActivityPlanItemRelateDetailItemVo::getId, Function.identity()));
            }
        }
        for (ActivityPlanItemRelateDetailItemDto relateDetailItemDto : relateDetailItemDtoList) {
            if(oldMap.containsKey(relateDetailItemDto.getId())){
                updateDtoList.add(relateDetailItemDto);
                oldMap.remove(relateDetailItemDto.getId());
            }else {
                saveDtoList.add(relateDetailItemDto);
            }
        }

        //保存数据
        if(CollectionUtils.isNotEmpty(saveDtoList)){
            Collection<ActivityPlanItemRelateDetailItem> activityPlanItemRelateDetailItems = this.nebulaToolkitService.copyCollectionByWhiteList(saveDtoList, ActivityPlanItemRelateDetailItemDto.class, ActivityPlanItemRelateDetailItem.class, LinkedHashSet.class, ArrayList.class);
            activityPlanItemRelateDetailItems.forEach(item->{
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setPlanCode(entity.getPlanCode());
            });
            this.activityPlanItemRelateDetailItemRepository.saveBatch(activityPlanItemRelateDetailItems);
        }
        //更新数据
        if(CollectionUtils.isNotEmpty(updateDtoList)){
            Collection<ActivityPlanItemRelateDetailItem> activityPlanItemRelateDetailItems = this.nebulaToolkitService.copyCollectionByWhiteList(updateDtoList, ActivityPlanItemRelateDetailItemDto.class, ActivityPlanItemRelateDetailItem.class, LinkedHashSet.class, ArrayList.class);
            this.activityPlanItemRelateDetailItemRepository.updateBatchById(activityPlanItemRelateDetailItems);
        }
        //删除数据
        if(MapUtils.isNotEmpty(oldMap)){
            Set<String> ids = oldMap.keySet();
            this.activityPlanItemRelateDetailItemRepository.removeByIds(ids);
        }

    }

    @Override
    public List<ActivityPlanItemRelateDetailItemDto> findDtoByPlanCodeList(List<String> planCodeList) {
        if(CollectionUtils.isEmpty(planCodeList)){
            return Lists.newArrayList();
        }
        List<ActivityPlanItemRelateDetailItem> activityPlanItemRelateDetailItemList = this.activityPlanItemRelateDetailItemRepository.findDtoByPlanCodeList(planCodeList);
        if(CollectionUtils.isEmpty(activityPlanItemRelateDetailItemList)){
            return Lists.newArrayList();
        }
        Collection<ActivityPlanItemRelateDetailItemDto> activityPlanItemRelateDetailItemDtos = this.nebulaToolkitService.copyCollectionByWhiteList(activityPlanItemRelateDetailItemList, ActivityPlanItemRelateDetailItem.class, ActivityPlanItemRelateDetailItemDto.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityPlanItemRelateDetailItemDto>) activityPlanItemRelateDetailItemDtos;
    }
}
