package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年11月27日 19:11
 */
@Slf4j
@Service
public class ActivityPlanItemSdkServiceImpl implements ActivityPlanItemSdkService {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityPlanItemService activityPlanItemService;

    /**
     * 分页查询
     *
     * @author huojia
     * @date 2022/12/9 16:53
     * @param pageable
     * @param activityPlanItemDto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo>
     **/
    @Override
    public Page<ActivityPlanItemVo> findByConditions(Pageable pageable, ActivityPlanItemDto activityPlanItemDto) {
        return activityPlanItemService.findByConditions(pageable, activityPlanItemDto);
    }

    @Override
    public List<ActivityPlanItemBudgetVo> findItemBudgetListByConditions(ActivityPlanItemBudgetDto activityPlanItemBudgetDto) {
        return activityPlanItemService.findItemBudgetListByConditions( activityPlanItemBudgetDto);
    }

    /**
     * 根据明细编码批量查询方案明细
     *
     * @param itemCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo>
     * @author huojia
     * @date 2022/11/27 19:11
     **/
    @Override
    public List<ActivityPlanItemVo> listByItemCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanItem> activityPlanItemList = activityPlanItemRepository.listByDetailCodeList(itemCodeList);
        if (CollectionUtils.isEmpty(activityPlanItemList)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanItemVo> activityPlanItemVos = (List<ActivityPlanItemVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                activityPlanItemList, ActivityPlanItem.class, ActivityPlanItemVo.class, LinkedHashSet.class, ArrayList.class
        );
        List<ActivityPlanBudget> budgetList = activityPlanBudgetRepository.listByDetailCodeList(itemCodeList);
        // 预算
        if (!CollectionUtils.isEmpty(budgetList)) {
            List<ActivityPlanBudgetVo> activityPlanBudgetVos = (List<ActivityPlanBudgetVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                    budgetList, ActivityPlanBudget.class, ActivityPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class
            );
            Map<String, List<ActivityPlanBudgetVo>> budgetMap = activityPlanBudgetVos.stream().collect(Collectors.groupingBy(ActivityPlanBudgetVo::getPlanItemCode));
            activityPlanItemVos.forEach(activityPlanItemVo -> {
                activityPlanItemVo.setBudgetShares(budgetMap.get(activityPlanItemVo.getPlanItemCode()));
            });
        }
        return activityPlanItemVos;
    }

    /**
     * 调整预算上向下规划金额、是否完全规划
     *
     * @param operationBudgetList
     * @author huojia
     * @date 2022/11/30 20:43
     **/
    @Override
    public void operationBudget(List<ActivityPlanBudgetDto> operationBudgetList) {
        if (CollectionUtils.isEmpty(operationBudgetList)) {
            return;
        }
        // 查询活动方案预算
        Set<String> planItemCodeSet = operationBudgetList.stream().map(ActivityPlanBudgetDto::getPlanItemCode).collect(Collectors.toSet());
        List<ActivityPlanItem> activityPlanItems = activityPlanItemRepository.listByDetailCodeList(new ArrayList<>(planItemCodeSet));
        /*List<ActivityPlanBudget> allBudgetList = activityPlanBudgetRepository.listByDetailCodeList(new ArrayList<>(planItemCodeSet));
        if (CollectionUtils.isEmpty(allBudgetList)) {
            throw new RuntimeException("活动方案预算查询失败！");
        }*/
        // 分组
        /*Map<String, List<ActivityPlanBudget>> planBudgetMap = allBudgetList.stream()
                .collect(Collectors.groupingBy(ActivityPlanBudget::getPlanItemCode));*/
        Map<String, List<ActivityPlanBudgetDto>> planBudgetDtoMap = operationBudgetList.stream()
                .collect(Collectors.groupingBy(ActivityPlanBudgetDto::getPlanItemCode));
        Map<String, ActivityPlanItem> itemMap = activityPlanItems.stream()
                .collect(Collectors.toMap(ActivityPlanItem::getPlanItemCode, Function.identity()));
        // 按维度对应
        planBudgetDtoMap.forEach((planItemCode, planBudgetDtoList) -> {
            /*List<ActivityPlanBudget> budgetList = planBudgetMap.get(planItemCode);*/
            /*Map<String, ActivityPlanBudgetDto> map = planBudgetDtoList.stream()
                    .collect(Collectors.toMap(ActivityPlanBudgetDto::getMonthBudgetCode, Function.identity()));*/
            /*budgetList.forEach(planBudget -> {
                if (!map.containsKey(planBudget.getMonthBudgetCode())) {
                    return;
                }
                ActivityPlanBudgetDto activityPlanBudgetDto = map.get(planBudget.getMonthBudgetCode());
                planBudget.setDownAmount(Optional.ofNullable(planBudget.getDownAmount()).orElse(BigDecimal.ZERO).add(activityPlanBudgetDto.getThisDownAmount()));
                if (planBudget.getDownAmount().compareTo(planBudget.getUseAmount()) == 0) {
                    planBudget.setIsAllDown(BooleanEnum.TRUE.getCapital());
                }
            });*/
            ActivityPlanItem activityPlanItem = itemMap.get(planItemCode);
            BigDecimal downAmount = Optional.ofNullable(activityPlanItem.getDownAmount()).orElse(BigDecimal.ZERO);
            activityPlanItem.setDownAmount(
                    downAmount.add(planBudgetDtoList.stream()
                            .map(ActivityPlanBudgetDto::getThisDownAmount)
                            .filter(Objects::nonNull)
                            .reduce(BigDecimal.ZERO, BigDecimal::add))
            );
            // 完全向下规划：已向下规划金额 = 点内+点外
            BigDecimal add = Optional.ofNullable(activityPlanItem.getHeadFeeAmount()).orElse(BigDecimal.ZERO)
                    .add(Optional.ofNullable(activityPlanItem.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO));
            if (activityPlanItem.getDownAmount().compareTo(add) >= 0) {
                activityPlanItem.setIsAllDown(BooleanEnum.TRUE.getCapital());
            } else {
                activityPlanItem.setIsAllDown(BooleanEnum.FALSE.getCapital());
            }
            this.activityPlanItemRepository.updateById(activityPlanItem);
            /*this.activityPlanBudgetRepository.updateBatchById(budgetList);*/
        });
    }

    @Override
    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto) {

        Validate.notNull(dto,"输入参数不能为空");
        if(StringUtils.isEmpty(dto.getPlanName())&&StringUtils.isEmpty(dto.getDepartmentName())&&StringUtils.isEmpty(dto.getSupplierName())){
            throw new RuntimeException("输入的参数不能都为空");
        }

        List<RedPacketQueryScheme2Vo> redPacketQueryScheme2Vos = this.activityPlanItemRepository.redPacketQueryScheme(dto);

        return redPacketQueryScheme2Vos;
    }

    /**
     * 根据活动号判断同一活动号下面的方案是否都已关闭,存在未关闭的则返回false
     *
     * @param actNo 活动号
     * @return Boolean
     **/
    @Override
    public Boolean getAllColseByActNumber(String actNo) {
        if(StringUtils.isBlank(actNo)){
            return false;
        }
        int count = this.activityPlanItemRepository.lambdaQuery()
                .eq(ActivityPlanItem::getActivityNumber,actNo)
                .eq(ActivityPlanItem::getIsClose,BooleanEnum.FALSE.getCapital())
                .eq(ActivityPlanItem::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlanItem::getTenantCode, TenantUtils.getTenantCode())
                .count();
        return count == 0;
    }
    /**
     * 条件查询总条数
     *
     * @param activityPlanItemDto
     * @return
     */
    @Override
    public Integer findTotalByConditions(ActivityPlanItemDto activityPlanItemDto) {
        return activityPlanItemService.findTotalByConditions(activityPlanItemDto);
    }

    @Override
    public List<ActivityPlanItemVo> findRelatedPlanItemByCodes(List<String> relatePlanItemCodes) {
        if (CollectionUtils.isEmpty(relatePlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.activityPlanItemRepository.findRelatedPlanItemByCodes(relatePlanItemCodes);
    }

    @Override
    public List<ActivityPlanItemVo> findByHeadquartersPlanItemCode(String planItemCode) {
        if(StringUtils.isEmpty(planItemCode)){
            return Lists.newArrayList();
        }
        return activityPlanItemService.findByHeadquartersPlanItemCode(planItemCode);
    }

    @Override
    public ActivityPlanItemVo findListByPlanItemCode(String planItemCode) {
        if(StringUtils.isEmpty(planItemCode)){
            return null;
        }
        return activityPlanItemService.findListByPlanItemCode(planItemCode);
    }

    @Override
    public List<String> findItemCodeListByRelatePlanItemCodeList(List<String> planItemCodeList) {
        if(CollectionUtils.isEmpty(planItemCodeList)){
            return null;
        }
        return activityPlanItemRepository.findItemCodeListByRelatePlanItemCodeList(planItemCodeList);
    }

    @Override
    public List<ActivityPlanBudgetVo> findItemBudgetListByPlanCode(String planCode) {
        if(StringUtils.isEmpty(planCode)){
            return Lists.newArrayList();
        }
        return activityPlanItemService.findItemBudgetListByPlanCode(planCode);
    }

    @Override
    public void updateAuditStatusByCodes(List<String> auditPlanItemCodes) {
        if(CollectionUtils.isNotEmpty(auditPlanItemCodes)){
            activityPlanItemService.updateAuditStatusByCodes(auditPlanItemCodes);
        }
    }

    @Override
    public List<ActivityPlanBudgetVo> findItemBudgetListByPlanItemCode(String planItemCode) {
        if(StringUtils.isEmpty(planItemCode)){
            return Lists.newArrayList();
        }
        return activityPlanItemService.findItemBudgetListByPlanItemCode(planItemCode);
    }

    @Override
    public void updateWholeAuditByPlanItemCode(String businessCode) {
        activityPlanItemRepository.updateWholeAuditByPlanItemCode(businessCode);
    }

    /**
     * 事中费用申请：报表年月的活动，“核销方式”为“事中”，“结案形式”为“随单”TPM审批状态为“审批通过”的方案明细费用合计
     * @param activityPlanItemDtos
     * @return
     */
    @Override
    public List<ActivityPlanItemVo> findListForFR(List<ActivityPlanItemDto> activityPlanItemDtos) {
        if(CollectionUtils.isEmpty(activityPlanItemDtos)) {
            return Lists.newArrayListWithCapacity(0);
        }
        return this.activityPlanItemRepository.findListForFR(activityPlanItemDtos);
    }

    @Override
    public List<ActivityPlanItemVo> findCostListForFR(List<ActivityPlanItemDto> itemDtos, String code) {
        if(CollectionUtils.isEmpty(itemDtos)) {
            return Lists.newArrayListWithCapacity(0);
        }
        return this.activityPlanItemRepository.findCostListForFR(itemDtos,code);
    }

    @Override
    public void updateAlreadyAuditAmount(List<ActivityPlanItemDto> activityPlanItemDtoList) {
        if(CollectionUtils.isEmpty(activityPlanItemDtoList)){
            return;
        }
        Map<String, ActivityPlanItemDto> activityPlanItemDtoMap = activityPlanItemDtoList.stream().collect(Collectors.toMap(ActivityPlanItemDto::getPlanItemCode, Function.identity()));
        List<String> planItemCodes = activityPlanItemDtoList.stream().map(ActivityPlanItemDto::getPlanItemCode).collect(Collectors.toList());
        List<ActivityPlanItemDto> activityPlanItemDtos = activityPlanItemRepository.findDtoListByPlanItemCodeList(planItemCodes);
        List<ActivityPlanItem> activityPlanItemUpadtes = new ArrayList<>();
        for (ActivityPlanItemDto activityPlanItemDto : activityPlanItemDtos) {
            ActivityPlanItem activityPlanItem = new ActivityPlanItem();
            activityPlanItem.setId(activityPlanItemDto.getId());
            ActivityPlanItemDto activityPlanItemDto1 = activityPlanItemDtoMap.get(activityPlanItemDto.getPlanItemCode());
            if(activityPlanItemDto1!=null) {
                activityPlanItem.setAlreadyAuditAmount(Optional.ofNullable(activityPlanItemDto.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO).add(activityPlanItemDto1.getAlreadyAuditAmount()));
                activityPlanItemUpadtes.add(activityPlanItem);
            }
        }
        this.activityPlanItemRepository.updateBatchById(activityPlanItemUpadtes);
    }
}
