package com.biz.crm.tpm.business.activity.plan.local.service.internal;


import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.price.sdk.dto.PriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.promotion.material.sdk.service.PromotionMaterialService;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.extend.field.service.ExtendFieldService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.form.sdk.constant.ActivityFormDataConstant;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.enums.VerticalActivityTypeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemExtendField;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemExtendFieldRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.thirld.PlanPushFreeGoods;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanItemCloseLogDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanItemCloseLogEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.*;
import com.biz.crm.tpm.business.activity.plan.sdk.event.log.ActivityPlanLogEventListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityDetailPlanPlanListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQueryActivityDetailPlanListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQueryHeadSchemeForecastListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.dto.ActivityPlanQueryHeadSchemeForecastDto;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQueryHeadSchemeForecastResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQueryHeadSchemeForecastVo;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemExtendFieldBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.*;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.constant.TpmInventoryCheckConstant;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.TpmInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.service.TpmInventoryCheckService;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.vo.TpmInventoryCheckVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import liquibase.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案明细表(ActivityPlanItem)表服务实现类
 *
 * @author wanghaojia
 * @since 2022-11-01 15:11:38
 */
@Slf4j
@Service("activityPlanItemService")
public class ActivityPlanItemServiceImpl extends MnPageCacheServiceImpl<ActivityPlanItemVo, ActivityPlanItemDto> implements ActivityPlanItemService {

    //定义方案促销模版常量
    private static final String TEMPLATE_CONFIG_CODE = "HDMBPZ3922";

    //定义奶卡模版常量
    private static final String TEMPLATE_MILK_CARD_CODE = "HDMBPZ2023081600000001";
    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private ActivityPlanItemExtendFieldRepository activityPlanItemExtendFieldRepository;

    @Autowired(required = false)
    private ActivityPlanRepository activityPlanRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 生成编码服务
     */
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    /**
     * 活动类型服务
     */
    @Autowired(required = false)
    private ActivityPlanBudgetService activityPlanBudgetService;
    /**
     * 活动类型服务
     */
    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    /**
     * 活动形式服务长
     */
    @Autowired(required = false)
    private ActivityFormService activityFormService;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    /**
     * 活动模板服务
     */
    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Autowired(required = false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private CustomerVoService customerVoService;

    @Autowired(required = false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private TpmInventoryCheckService inventoryCheckService;

    @Autowired(required = false)
    private PromotionMaterialService promotionMaterialService;

    @Autowired(required = false)
    private ActivityPlanItemTerminalService activityPlanItemTerminalService;

    @Autowired(required = false)
    private TerminalVoService terminalVoService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private PriceModelVoService priceModelVoService;

    @Autowired(required = false)
    private PriceVoService priceVoService;

    @Autowired(required = false)
    private ExtendFieldService extendFieldService;

    @Autowired(required = false)
    private BudgetItemService budgetItemService;

    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private PlanPushFreeGoods planPushFreeGoods;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    /**
     * 分页查询
     *
     * @param pageable
     * @param activityPlanItemDto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo>
     * @author huojia
     * @date 2022/12/9 16:53
     **/
    @Override
    public Page<ActivityPlanItemVo> findByConditions(Pageable pageable, ActivityPlanItemDto activityPlanItemDto) {
        return activityPlanItemRepository.findByConditions(pageable, activityPlanItemDto);
    }

    @Override
    public Page<ActivityPlanItemBudgetVo> findItemBudgetByConditions(Pageable pageable, ActivityPlanItemBudgetDto dto) {
        return activityPlanItemRepository.findItemBudgetByConditions(pageable, dto);
    }

    /**
     * 活动方案明细预算金额使用
     */
    @Override
    public List<ActivityPlanItemBudgetVo> findItemBudgetListByConditions(ActivityPlanItemBudgetDto dto) {
        return activityPlanItemRepository.findItemBudgetListByConditions(dto);
    }

    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @Override
    public List<ActivityPlanBudgetSumVo> findBudgetCacheSumList(String businessUnitCode, String cacheKey) {
        List<ActivityPlanItemDto> itemList = this.findCacheList(cacheKey);
        Map<String, ActivityPlanBudgetSumVo> budgetSumVoMap = Maps.newHashMap();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (ActivityPlanItemDto item : itemList) {
            if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode) && !CollectionUtils.isEmpty(item.getBudgetShares())) {
                List<ActivityPlanBudgetDto> budgetShares = item.getBudgetShares();
                for (ActivityPlanBudgetDto budgetShare : budgetShares) {
                    if (StringUtils.isBlank(budgetShare.getMonthBudgetCode())) {
                        continue;
                    }
                    //预算不为空才处理
                    ActivityPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(budgetShare.getMonthBudgetCode(), (key) -> new ActivityPlanBudgetSumVo() {{
                        this.setUseAmount(BigDecimal.ZERO);
                        this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                    }});
                    budgetSumVo.setMonthBudgetCode(budgetShare.getMonthBudgetCode());
                    budgetSumVo.setBudgetItemCode(budgetShare.getBudgetItemCode());
                    budgetSumVo.setBudgetItemName(budgetShare.getBudgetItemName());
                    if (null != budgetShare.getUseAmountStr()) {
                        try {
                            budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(budgetShare.getUseAmountStr().trim())));
                        } catch (Exception ignore) {
                        }
                    }
                    feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
                }
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode) && StringUtils.isNotEmpty(item.getHeadMonthBudgetCode())) {
                //预算不为空才处理
                ActivityPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getHeadMonthBudgetCode(), (key) -> new ActivityPlanBudgetSumVo() {{
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getHeadMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getHeadBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getHeadBudgetItemName());
                if (null != item.getHeadFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getHeadFeeAmountStr().trim())));
                    } catch (Exception e) {
                        log.error("获取活动方案明细预算汇总时，预算金额有误！");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode) && StringUtils.isNotEmpty(item.getMonthBudgetCode())) {
                //预算不为空才处理
                ActivityPlanBudgetSumVo budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getMonthBudgetCode(), (key) -> new ActivityPlanBudgetSumVo() {{
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }});
                budgetSumVo.setMonthBudgetCode(item.getMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getBudgetItemName());
                if (null != item.getDepartmentFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getDepartmentFeeAmountStr().trim())));
                    } catch (Exception e) {
                        log.error("获取活动方案明细预算汇总时，预算金额有误！");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
        }
        if (feeBudgetCodeSet.size() > 0) {
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(feeBudgetCodeList, null);
            if (null != budgetVos) {
                for (MonthBudgetVo budgetVo : budgetVos) {
                    ActivityPlanBudgetSumVo budgetSumVo = budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                    budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                    budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                    budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                    budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                    budgetSumVo.setOrgCode(budgetVo.getOrgCode());
                    budgetSumVo.setOrgName(budgetVo.getOrgName());
                    if (null != budgetVo.getAccumulatedAvailableBalance()) {
                        budgetSumVo.setAccumulatedAvailableBalance(budgetVo.getAccumulatedAvailableBalance());
                    }
                    if (null != budgetVo.getControlBalanceAmount()) {
                        budgetSumVo.setControlBalanceAmount(budgetVo.getControlBalanceAmount());
                    }
                }
            }
        }
        List<ActivityPlanBudgetSumVo> budgetSumList = new ArrayList<>(budgetSumVoMap.values());
        return budgetSumList;
    }

    /**
     * 保存活动方案明细数据-默认走校验逻辑
     *
     * @param itemCacheList 活动方案明细数据
     */
    @Override
    public void saveActivityPlanItemList(ActivityPlan entity, boolean update, List<ActivityPlanItemDto> itemCacheList) {
        saveActivityPlanItemList(entity, update, itemCacheList, true, false);
    }

    /**
     * 保存活动方案明细数据
     *
     * @param itemCacheList  活动方案明细数据
     * @param createValidate 是否走校验逻辑
     */
    @Override
    public void saveActivityPlanItemList(ActivityPlan entity, boolean update, List<ActivityPlanItemDto> itemCacheList, boolean createValidate, boolean tempSave) {
        if (createValidate && !tempSave) {
            createValidateList(itemCacheList);
        } else if (tempSave) {
            tempSaveValidata(new ActivityPlanDto(), itemCacheList);
        }
        Map<String, ActivityPlanItem> oldMap = Maps.newHashMap();
        if (update) {
            activityPlanItemPageCacheHelper.sendMsg("查询旧数据...");
            List<ActivityPlanItem> oldList = activityPlanItemRepository.findListByPlanCode(entity.getPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityPlanItem::getId, Function.identity()));
        }
        List<ActivityPlanItem> saveList = Lists.newArrayList();
        List<ActivityPlanItemExtendField> extendFieldSaveList = Lists.newArrayList();
        List<ActivityPlanItem> updateList = Lists.newArrayList();
        Set<String> needFindPriceProductCode = Sets.newHashSet();
        Map<String, ActivityPlanItemDto> dtoMap = Maps.newHashMap();
        for (ActivityPlanItemDto item : itemCacheList) {
            dtoMap.put(item.getId(), item);
            item.setPlanCode(entity.getPlanCode());
            if (BusinessUnitEnum.VERTICAL.getCode().equals(entity.getBusinessUnitCode()) && StringUtils.isNotEmpty(item.getProductCode())) {
                //是垂直，去询价
                needFindPriceProductCode.add(item.getProductCode());
            }
            String bonusType = item.getBonusType();
            if (StringUtils.isNotEmpty(bonusType)) {
                String activityDesc = Optional.ofNullable(item.getActivityDesc()).orElse("");
                activityDesc = activityDesc.replace("A-", "");
                activityDesc = activityDesc.replace("B-", "");
                if ("A-".equals(activityDesc) || "B-".equals(activityDesc)) {
                    activityDesc = "";
                }
                if (BonusTypeEnum.BONUS.getCode().equals(bonusType)) {
                    item.setActivityDesc("A-" + activityDesc);
                }
                if (BonusTypeEnum.PURE_SEND.getCode().equals(bonusType)) {
                    item.setActivityDesc("B-" + activityDesc);
                }
            }
            ActivityPlanItem itemEntity = null;
            if (oldMap.containsKey(item.getId())) {
                ActivityPlanItem oldItemEntity = oldMap.get(item.getId());
                item.setPlanItemCode(oldItemEntity.getPlanItemCode());
                itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityPlanItem.class, HashSet.class, ArrayList.class);
                updateList.add(itemEntity);
                oldMap.remove(item.getId());


                List<ActivityPlanItemExtendField> activityPlanItemExtendFields = extendFieldService.buildExtendFieldEntityList(item, ActivityPlanItemExtendFieldBase.class, ActivityPlanItemExtendField.class);
                if (!CollectionUtils.isEmpty(activityPlanItemExtendFields)) {
                    for (ActivityPlanItemExtendField extendField : activityPlanItemExtendFields) {
                        extendField.setId(null);
                        extendField.setPlanCode(item.getPlanCode());
                        extendField.setPlanItemCode(item.getPlanItemCode());
                        extendField.setTenantCode(itemEntity.getTenantCode());
                    }
                    extendFieldSaveList.addAll(activityPlanItemExtendFields);
                }
            } else {
                itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityPlanItem.class, HashSet.class, ArrayList.class);
                itemEntity.setPlanCode(entity.getPlanCode());
                itemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                itemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                itemEntity.setIsClose(BooleanEnum.FALSE.getCapital());
                itemEntity.setTenantCode(entity.getTenantCode());
                saveList.add(itemEntity);
            }
            if (StringUtils.isNotEmpty(item.getProductCode()) && item.getProductCode().contains(",")) {
                //如果是多选的话，设置成空的，单独存表
                itemEntity.setProductCode("");
                itemEntity.setProductName("");
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            activityPlanItemPageCacheHelper.sendMsg("处理方案扩展数据...");
            // redis生成活动方案明细编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
            List<String> codeList = generateCodeList(itemCacheList.size());
            Iterator<String> codeIterator = codeList.iterator();
            int i = 0;
            int size = saveList.size();
            for (ActivityPlanItem activityPlanItem : saveList) {
                if (i % 1000 == 0) {
                    activityPlanItemPageCacheHelper.sendMsg("正在处理第[" + 1000 * (i++) + "/" + size + "]条方案扩展数据...");
                }
                activityPlanItem.setPlanItemCode(codeIterator.next());
                ActivityPlanItemDto dto = dtoMap.get(activityPlanItem.getId());
                dto.setPlanItemCode(activityPlanItem.getPlanItemCode());
                activityPlanItem.setId(null);
                List<ActivityPlanItemExtendField> activityPlanItemExtendFields = extendFieldService.buildExtendFieldEntityList(dto, ActivityPlanItemExtendFieldBase.class, ActivityPlanItemExtendField.class);
                if (!CollectionUtils.isEmpty(activityPlanItemExtendFields)) {
                    activityPlanItemExtendFields.forEach(item -> {
                        item.setPlanCode(activityPlanItem.getPlanCode());
                        item.setPlanItemCode(activityPlanItem.getPlanItemCode());
                        item.setTenantCode(activityPlanItem.getTenantCode());
                    });
                    extendFieldSaveList.addAll(activityPlanItemExtendFields);
                }
                i++;
            }
            i = 0;
            for (List<ActivityPlanItem> activityPlanItems : Lists.partition(saveList, 1000)) {
                activityPlanItemPageCacheHelper.sendMsg("正在保存第[" + 1000 * (i++) + "/" + size + "]条方案明细...");
                activityPlanItemRepository.saveBatch(activityPlanItems);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            int i = 0;
            int size = updateList.size();
            for (List<ActivityPlanItem> activityPlanItems : Lists.partition(updateList,1000)) {
                activityPlanItemPageCacheHelper.sendMsg("正在更新第["+1000*(i++)+"/"+size+"]条方案明细...");
                activityPlanItemRepository.alwaysUpdateSomeColumnBatchById(activityPlanItems,1000);//更新所有字段
            }
        }
        if (!CollectionUtils.isEmpty(extendFieldSaveList)) {
            int i = 0;
            int size = extendFieldSaveList.size();
            for (List<ActivityPlanItemExtendField> extendFields : Lists.partition(extendFieldSaveList, 1000)) {
                activityPlanItemPageCacheHelper.sendMsg("正在保存第[" + 1000 * (i++) + "/" + size + "]条方案明细...");
                activityPlanItemExtendFieldRepository.saveBatch(extendFields);
            }
        }
        if (oldMap.size() > 0) {
            activityPlanItemPageCacheHelper.sendMsg("正在处理历史数据...");
            //待删除的数据
            List<String> planItemCodeList = oldMap.values().stream().map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList());
//          删除关联的扩展字段
            activityPlanItemExtendFieldRepository.deleteByPlanItemCodeList(planItemCodeList);
            activityPlanItemRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }

        activityPlanItemPageCacheHelper.sendMsg("正在保存预算信息...");
        //保存方案-预算数据
        activityPlanBudgetService.saveActivityPlanBudgetList(entity, update, itemCacheList);
    }

    private void isBreakPrice(List<ActivityPlanItemDto> dtoList, Map<String, PriceModelVo> priceModelVoMap) {
        if (CollectionUtils.isEmpty(dtoList) || CollectionUtils.isEmpty(priceModelVoMap)) {
            return;
        }
        dtoList.forEach(dto -> {
            String productCode = dto.getProductCode();
            if (priceModelVoMap.containsKey(productCode)) {
                PriceModelVo priceModelVo = priceModelVoMap.get(productCode);
//                log.error("是否破价priceModelVo:{}", priceModelVo);
//                log.error("是否破价entity.getPromotionalPrice():{}", dto.getPromotionalPrice());
//                log.error("是否破价priceModelVo.getPrice():{}", priceModelVo.getPrice());
                if (Objects.nonNull(dto.getPromotionalPrice()) && Objects.nonNull(priceModelVo.getPrice())
                        && priceModelVo.getPrice().compareTo(dto.getPromotionalPrice()) > 0) {
                    dto.setIsBreakPrice(BooleanEnum.TRUE.getCapital());
                }
            }
        });
    }

    @Override
    public String generateCode() {
        return generateCodeList(1).get(0);
    }

    @Override
    public List<String> generateCodeList(int size) {
        // redis生成活动方案明细编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
//        String ruleCode = StringUtils.join(ActivityPlanConstant.ACTIVITY_PLAN_ITEM_RULE_CODE_PRE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        return this.generateCodeService.generateCode(ActivityPlanConstant.ACTIVITY_PLAN_ITEM_RULE_CODE_PRE, size, 6, 2, TimeUnit.DAYS);
    }

    /**
     * 营销策略明细新增校验逻辑
     *
     * @param dtoList 营销策略明细数据
     */
    @Override
    public void createValidateList(List<ActivityPlanItemDto> dtoList) {
        createValidateList(new ActivityPlanDto(), dtoList);
    }

    @Override
    public void createValidateList(ActivityPlanDto planDto, List<ActivityPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        //是否必填从模板上获取，这里再做下主要字段的必填校验
        Set<String> templateConfigCodeSet = Sets.newHashSet();
        for (ActivityPlanItemDto dto : dtoList) {
            Validate.notBlank(dto.getTemplateConfigCode(), "活动方案明细模板不能为空！");
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
        }
        List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(Lists.newArrayList(templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("活动方案明细模板数据有误！");
        }

        Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<ActivityPlanItemDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemDto::getTemplateConfigCode));

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        Map<String, Field> dateFieldMap = ObjectConvertStringUtil.getPropertyFieldMap(ActivityPlanItemDto.class);

        Date nowDate = new Date();
        Date nowDateYearMonth = new Date(nowDate.getYear(), nowDate.getMonth(), 1);
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
        String nowYearMonthStr = yearMonthFormat.format(nowDateYearMonth);
        for (Map.Entry<String, List<ActivityPlanItemDto>> dtoEntry : dtoMap.entrySet()) {
            List<ActivityPlanItemDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(dtoEntry.getKey());
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            for (ActivityPlanItemDto dto : thisDtoList) {

                if (dto.getIndexNo() % 500 == 0) {
                    activityPlanItemPageCacheHelper.sendMsg("基础信息校验:正在校验第[" + dto.getIndexNo() + "]条数据...");
                }

                //后端验证必填字段
                Validate.notBlank(dto.getActivityTypeCode(), templateDetailTitleMap.getOrDefault("activityTypeCode", "活动分类") + "不能为空！");
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityBeginDateStr(), "方案开始时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityBeginDate);
                DateStringDealUtil.validateDateStrAndSet(dto.getActivityEndDateStr(), "方案结束时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityEndDate);
                Date beginDateYearMonth = new Date(dto.getActivityBeginDate().getYear(), dto.getActivityEndDate().getMonth(), 1);
                String beginDateYearMonthStr = yearMonthFormat.format(beginDateYearMonth);
                //垂直的费用归属年月取   当前时间和活动开始时间取大
                if (BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())){
                    String feeYearMonthStr = null;
                    if (nowDateYearMonth.after(beginDateYearMonth)){
                        dto.setFeeYearMonth(nowDateYearMonth);
                        feeYearMonthStr = nowYearMonthStr;
                    }else{
                        dto.setFeeYearMonth(beginDateYearMonth);
                        feeYearMonthStr = beginDateYearMonthStr;
                    }
                    if (!feeYearMonthStr.equals(dto.getFeeYearMonthStr())){
                        throw new RuntimeException("费用归属年月应为["+feeYearMonthStr+"]");
                    }
                    dto.setFeeYearMonthStr(feeYearMonthStr);
                }else{
                    dto.setFeeYearMonth(beginDateYearMonth);
                    dto.setFeeYearMonthStr(beginDateYearMonthStr);
                }

                //原供价（本品）/（1+本品税率）=原未税价格（本品），取小数点后三位，超出部分舍五入
                if (StringUtils.isNotBlank(dto.getOriginalSupplyPriceStr()) && StringUtils.isNotBlank(dto.getTaxRateStr())) {
                    dto.setOriginalPriceProduct(new BigDecimal(dto.getOriginalSupplyPriceStr()).divide((BigDecimal.ONE.add(new BigDecimal(dto.getTaxRateStr()))), 3, BigDecimal.ROUND_HALF_UP));
                    dto.setOriginalPriceProductStr(dto.getOriginalPriceProduct().toString());
                }

                //销售机构、销售大区、销售省区的最下级放到区域字段上
                if (StringUtils.isEmpty(dto.getActivityOrgCode())) {
                    if (StringUtils.isNotEmpty(dto.getSalesOrgCode())) {
                        dto.setActivityOrgCode(dto.getSalesOrgCode());
                        dto.setActivityOrgName(dto.getSalesOrgName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesRegionCode())) {
                        dto.setActivityOrgCode(dto.getSalesRegionCode());
                        dto.setActivityOrgName(dto.getSalesRegionName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesInstitutionCode())) {
                        dto.setActivityOrgCode(dto.getSalesInstitutionCode());
                        dto.setActivityOrgName(dto.getSalesInstitutionName());
                    }
                }


                if (BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
                    //垂直，保留两位小数
                    ObjectConvertStringUtil.convertObjectListStrProperties(dto, dateFieldMap, propertyMap, 2, true, templateDetailTitleMap);
                } else {
                    ObjectConvertStringUtil.convertObjectListStrProperties(dto, dateFieldMap, propertyMap, null, true, templateDetailTitleMap);
                }
            }
            //模板验证必填字段
            for (ActivitiesTemplateConfigDetailVo configDetail : templateConfigVo.getDetails()) {
                if (null != configDetail.getRequired() && configDetail.getRequired()) {
                    if (!propertyMap.containsKey(configDetail.getField())) {
                        throw new RuntimeException("模板[" + templateConfigVo.getConfigName() + "]属性[" + configDetail.getTitle() + "]配置有误");
                    }
                    PropertyDescriptor propertyDescriptor = propertyMap.get(configDetail.getField());
                    if (null != propertyDescriptor) {
                        for (ActivityPlanItemDto dto : thisDtoList) {
                            try {
                                Object invoke = propertyDescriptor.getReadMethod().invoke(dto);
                                if (null == invoke || StringUtils.isEmpty(invoke.toString())) {
                                    throw new RuntimeException("[" + configDetail.getTitle() + "]不能为空！");
                                }
                            } catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException("[" + configDetail.getTitle() + "]读取失败！");
                            }
                        }
                    } else {
                        throw new RuntimeException("[" + configDetail.getTitle() + "]配置有误，请检查！");
                    }
                }
            }

            activityPlanItemPageCacheHelper.sendMsg("正在校验活动时间...");
            for (ActivityPlanItemDto dto : thisDtoList) {
                if (null != dto.getActivityBeginDate() && null != dto.getActivityEndDate()) {
                    if (dto.getActivityBeginDate().after(dto.getActivityEndDate())) {
                        throw new RuntimeException("活动开始时间不能晚于活动结束时间！");
                    }
                }
            }
        }

        if (BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
            createValidateListVertical(planDto, dtoList);
        } else {
            createValidateListHeadQuarters(planDto, dtoList);
        }
    }

    public void createValidateListHeadQuarters(ActivityPlanDto planDto, List<ActivityPlanItemDto> dtoList) {
        Calendar calendar = Calendar.getInstance();
        Set<String> budgetItemCodeSet = Sets.newHashSet();
        Set<String> feeBudgetCodeSet = Sets.newHashSet();
        for (ActivityPlanItemDto itemDto : dtoList) {
            Validate.notNull(itemDto.getTotalFeeAmountStr(), "费用合计不能为空！");

            //主体处理逻辑
            //预估费率=（总部承担金额+大区承担金额）/预估销售额
            if (null != itemDto.getSalesAmount() && BigDecimal.ZERO.compareTo(itemDto.getSalesAmount()) != 0) {
                BigDecimal sumFeeAmount = BigDecimal.ZERO;
                if (null != itemDto.getHeadFeeAmount()) {
                    sumFeeAmount = sumFeeAmount.add(itemDto.getHeadFeeAmount());
                }
                if (null != itemDto.getDepartmentFeeAmount()) {
                    sumFeeAmount = sumFeeAmount.add(itemDto.getDepartmentFeeAmount());
                }
                itemDto.setFeeRate(sumFeeAmount.divide(itemDto.getSalesAmount(), 4, RoundingMode.HALF_DOWN));
            }
            if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())) {
                budgetItemCodeSet.add(itemDto.getHeadBudgetItemCode());
                feeBudgetCodeSet.add(itemDto.getHeadMonthBudgetCode());
            }
            if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())) {
                budgetItemCodeSet.add(itemDto.getBudgetItemCode());
                feeBudgetCodeSet.add(itemDto.getMonthBudgetCode());
            }

//                1022565 【正式环境】活动细案 随车搭赠模板数据缺失校验,销售机构/分销渠道/销售部门/客户组/物料
            if (StringUtils.isNotEmpty(itemDto.getCarGiftGroup())) {
                //有填随车搭赠组合，做校验
                if (StringUtils.isEmpty(itemDto.getSalesInstitutionCode())) {
                    throw new RuntimeException("随车搭赠组合[" + itemDto.getCarGiftGroup() + "]销售机构不能为空!");
                }
                if (StringUtils.isEmpty(itemDto.getProductCode())) {
                    throw new RuntimeException("随车搭赠组合[" + itemDto.getCarGiftGroup() + "]物料不能为空!");
                }
                if (StringUtils.isEmpty(itemDto.getSalesRegionCode()) &&
                        (
                                CarGiftGroupEnum.GroupA.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupE.getCode().equals(itemDto.getCarGiftGroup())
                        )) {
                    throw new RuntimeException("随车搭赠组合[" + itemDto.getCarGiftGroup() + "]销售部门不能为空!");
                }
                if (StringUtils.isEmpty(itemDto.getDistributionChannelCode()) &&
                        (
                                CarGiftGroupEnum.GroupD.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupE.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupF.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupG.getCode().equals(itemDto.getCarGiftGroup())
                        )) {
                    throw new RuntimeException("随车搭赠组合[" + itemDto.getCarGiftGroup() + "]分销渠道不能为空!");
                }
                if (StringUtils.isEmpty(itemDto.getCustomerGroupCode()) &&
                        (
                                CarGiftGroupEnum.GroupA.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupC.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupD.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupE.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupG.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupI.getCode().equals(itemDto.getCarGiftGroup())
                        )) {
                    throw new RuntimeException("随车搭赠组合[" + itemDto.getCarGiftGroup() + "]客户组不能为空!");
                }
                if (StringUtils.isEmpty(itemDto.getCustomerCode()) &&
                        (
                                CarGiftGroupEnum.GroupB.getCode().equals(itemDto.getCarGiftGroup())
                        )) {
                    throw new RuntimeException("随车搭赠组合[" + itemDto.getCarGiftGroup() + "]客户不能为空!");
                }
                if (StringUtils.isEmpty(itemDto.getSalesOrgCode()) &&
                        (
                                CarGiftGroupEnum.GroupC.getCode().equals(itemDto.getCarGiftGroup()) ||
                                        CarGiftGroupEnum.GroupD.getCode().equals(itemDto.getCarGiftGroup())
                        )) {
                    throw new RuntimeException("随车搭赠组合[" + itemDto.getCarGiftGroup() + "]销售组不能为空!");
                }
            }
        }

        activityPlanItemPageCacheHelper.sendMsg("正在校验方案跨月使用...");

        validateCrossMonth:
        {
            if (CollectionUtils.isEmpty(feeBudgetCodeSet)) {
                break validateCrossMonth;
            }
            List<BudgetItemVo> budgetItemVos = budgetItemService.listByCodes(Lists.newArrayList(budgetItemCodeSet));
            if (CollectionUtils.isEmpty(budgetItemVos)) {
                throw new RuntimeException("预算项目查询失败！");
            }
            ArrayList<String> feeBudgetCodeList = Lists.newArrayList(feeBudgetCodeSet);
            //设置预算总金额（年初分解金额）
            List<MonthBudgetVo> budgetVos = monthBudgetService.findByCodes(feeBudgetCodeList, null);
            Map<String, MonthBudgetVo> budgetVoMap = budgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));

            Map<String, BudgetItemVo> budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            for (ActivityPlanItemDto item : dtoList) {
                String allowAcrossMonth = BooleanEnum.FALSE.getCapital();//默认不允许跨月
                String headYearMonth = null;
                String yearMonth = null;
                String budgetItemCode = null;
                if (StringUtils.isNotEmpty(item.getHeadMonthBudgetCode())) {
                    BudgetItemVo budgetItemVo = budgetItemMap.get(item.getHeadBudgetItemCode());
                    if (null == budgetItemVo) {
                        throw new RuntimeException("预算项目[" + item.getHeadBudgetItemCode() + "]有误！");
                    }
                    budgetItemCode = item.getHeadBudgetItemCode();
                    if (BooleanEnum.TRUE.getCapital().equals(budgetItemVo.getAllowCrossMonth())) {
                        allowAcrossMonth = BooleanEnum.TRUE.getCapital();
                    }
                    MonthBudgetVo monthBudgetVo = budgetVoMap.get(item.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("总部预算[" + item.getHeadMonthBudgetCode() + "]有误！");
                    }
                    headYearMonth = monthBudgetVo.getYearMonthLy();
                }
                if (StringUtils.isNotEmpty(item.getMonthBudgetCode())) {
                    BudgetItemVo budgetItemVo = budgetItemMap.get(item.getBudgetItemCode());
                    if (null == budgetItemVo) {
                        throw new RuntimeException("预算项目[" + item.getBudgetItemCode() + "]有误！");
                    }
                    budgetItemCode = item.getMonthBudgetCode();
                    if (BooleanEnum.TRUE.getCapital().equals(budgetItemVo.getAllowCrossMonth())) {
                        allowAcrossMonth = BooleanEnum.TRUE.getCapital();
                    }
                    MonthBudgetVo monthBudgetVo = budgetVoMap.get(item.getMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("大区预算[" + item.getMonthBudgetCode() + "]有误！");
                    }
                    yearMonth = monthBudgetVo.getYearMonthLy();
                }
                if (!BooleanEnum.FALSE.getCapital().equals(allowAcrossMonth)) {
                    continue;
                }
                if (StringUtils.isNotEmpty(headYearMonth)) {
                    //此预算项目不允许跨月使用，请修改策略开始时间、策略结束时间！
                    int year = Integer.parseInt(headYearMonth.substring(0, 4));
                    int month = Integer.parseInt(headYearMonth.substring(5)) - 1;
                    calendar.setTime(item.getActivityBeginDate());
                    if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)) {
                        throw new RuntimeException("预算项目[" + budgetItemCode + "]不允许跨月使用，请修改活动开始时间、活动结束时间！");
                    }
                    calendar.setTime(item.getActivityEndDate());
                    if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)) {
                        throw new RuntimeException("预算项目[" + budgetItemCode + "]不允许跨月使用，请修改活动开始时间、活动结束时间！");
                    }
                }
                if (StringUtils.isNotEmpty(yearMonth)) {
                    //此预算项目不允许跨月使用，请修改策略开始时间、策略结束时间！
                    int year = Integer.parseInt(yearMonth.substring(0, 4));
                    int month = Integer.parseInt(yearMonth.substring(5)) - 1;
                    calendar.setTime(item.getActivityBeginDate());
                    if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)) {
                        throw new RuntimeException("预算项目[" + item.getBudgetItemCode() + "]不允许跨月使用，请修改活动开始时间、活动结束时间！");
                    }
                    calendar.setTime(item.getActivityEndDate());
                    if ((calendar.get(Calendar.YEAR) != year || calendar.get(Calendar.MONTH) != month)) {
                        throw new RuntimeException("预算项目[" + item.getBudgetItemCode() + "]不允许跨月使用，请修改活动开始时间、活动结束时间！");
                    }
                }
            }
        }
    }

    /**
     * 活动方案明细新增校验逻辑
     *
     * @param dtoList 营销策略明细数据
     */
    public void createValidateListVertical(ActivityPlanDto planDto, List<ActivityPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }

        activityPlanItemPageCacheHelper.sendMsg("开始执行垂直活动方案校验...");
        Set<String> productCodeSet = Sets.newHashSet();

        List<DictDataVo> validateParamList = dictDataVoService.findByDictTypeCode("tpm_activity_validate_param");
        BigDecimal totalFeeAmountTail = BigDecimal.ZERO;
        if (null != validateParamList){
            Map<String, String> validateParamMap = validateParamList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
            String totalFeeAmountTailStr = validateParamMap.get("total_fee_amount_tail");//总费用金额尾差
            if (null != totalFeeAmountTailStr){
                totalFeeAmountTail = new BigDecimal(totalFeeAmountTailStr);
            }
        }


        int partitionIndex = 0;
        int size = dtoList.size();
        //500条一次处理
        List<List<ActivityPlanItemDto>> dtoPartitionList = Lists.partition(dtoList, 500);
        for (List<ActivityPlanItemDto> thisDtoList : dtoPartitionList) {
            activityPlanItemPageCacheHelper.sendMsg("垂直活动方案校验:第[" + 500 * (partitionIndex++) + "/" + size + "]条方案明细...");

            Set<String> activityFormCodeSet = Sets.newHashSet();
            Set<String> terminalCodeSet = Sets.newHashSet();
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            for (ActivityPlanItemDto dto : thisDtoList) {
                if (StringUtils.isNotEmpty(dto.getActivityFormCode())) {
                    activityFormCodeSet.add(dto.getActivityFormCode());
                }
                if (StringUtils.isNotEmpty(dto.getProductCode())) {
                    productCodeSet.add(dto.getProductCode());
                }
                if (StringUtils.isNotEmpty(dto.getTerminalCode())) {
                    terminalCodeSet.add(dto.getTerminalCode());
                } else {
                    if (!CollectionUtils.isEmpty(dto.getActivityPlanItemTerminalList())) {
                        terminalCodeSet.add(dto.getActivityPlanItemTerminalList().get(0).getTerminalCode());
                    }
                }
                if (!CollectionUtils.isEmpty(dto.getBudgetShares())){
                    List<String> thisMonthBudgetCodeList = dto.getBudgetShares().stream().map(ActivityPlanBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(thisMonthBudgetCodeList)){
                        monthBudgetCodeSet.addAll(thisMonthBudgetCodeList);
                    }
                }
            }

            //方案类型不是总部方案和方案模版为促销方案模版（HDMBPZ3922）才执行下面逻辑
            if (TEMPLATE_CONFIG_CODE.equals(planDto.getTemplateConfigCode())) {
                //当业务单位为垂直，活动形式SAP编码为ZS42时，保存时进行校验
                List<String> activityFormZs42 = new ArrayList<>();
                List<List<String>> partition = Lists.partition(new ArrayList<>(activityFormCodeSet), 500);

                activityPlanItemPageCacheHelper.sendMsg("垂直活动方案正在校验搭赠类型...");
                activityFormZs42 = activityFormService.findFormByCodesZs42(partition);
                for (ActivityPlanItemDto dto : thisDtoList) {
                    boolean result = BonusTypeEnum.OTHER.getCode().equals(dto.getBonusType());
                    if (activityFormZs42.contains(dto.getActivityFormCode())) {
                        if (result) {
                            throw new RuntimeException("SAP编码为ZS42时,搭赠类型只能选择搭赠或者纯赠");

                        }
                        //当业务单位为垂直，活动形式SAP编码不为ZS42时，保存时进行校验
                    } else if (!result) {
                        throw new RuntimeException("SAP编码不为ZS42时,搭赠类型只能选择其他");
                    }
                }
            }

            //当业务单位为垂直，活动形式SAP编码为ZS03时，保存时进行校验
            List<String> activityFormZs03 = new ArrayList<>();
            Map<String, TerminalVo> terminalMap = new HashMap<>();
            activityPlanItemPageCacheHelper.sendMsg("垂直活动方案正在校验共用信息...");
            List<List<String>> partition = Lists.partition(new ArrayList<>(activityFormCodeSet), 500);

            activityFormZs03 = activityFormService.findFormByCodesZs03(partition);
            if (!CollectionUtils.isEmpty(terminalCodeSet)) {
                List<TerminalVo> terminalVoList = terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList<>(terminalCodeSet));
                if (!CollectionUtils.isEmpty(terminalVoList)) {
                    terminalMap = terminalVoList.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, v -> v, (oldValue, newValue) -> newValue));
                }
            }

            Map<String, MonthBudgetVo> monthBudgetMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(monthBudgetCodeSet)){
                List<MonthBudgetVo> monthBudgetList = monthBudgetService.listByCodes(com.google.common.collect.Lists.newArrayList(monthBudgetCodeSet));
                monthBudgetMap = monthBudgetList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            }

            for (ActivityPlanItemDto dto : thisDtoList) {
                if (activityFormZs03.contains(dto.getActivityFormCode())) {
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                        // 如果产品编码不为空原供价要进行询价
                        // 销售机构（销售机构erp编码）【如：6140】
                        // 产品组（业态）【如：常温】
                        // 分销渠道（根据门店编码去查，门店管理--客户渠道编码）  【如：A1】
                        // 售达方（根据门店编码去查，门店管理--售达方）  【如：5100000011】
                        // 销售单位（根据本品产品编号->产品管理去查）【如：件】（带过去）
                        // 物料（本品的编码）【如：130100003244】（带过去）
                        if (StringUtils.isNotBlank(dto.getProductCode())) {
                            PriceDto priceDto = validateRelatePrice(dto, terminalMap);
                            List<PriceVo> priceVoList = priceVoService.findByPriceDto(priceDto);

                            if (!CollectionUtils.isEmpty(priceVoList)) {
                                dto.setOriginalSupplyPrice(priceVoList.get(0).getPrice());
                                dto.setOriginalSupplyPriceStr(dto.getOriginalSupplyPrice().toString());
                            } else {
                                String originalSupplyPriceStr = StringUtils.isNotEmpty(dto.getOriginalSupplyPriceStr()) ? dto.getOriginalSupplyPriceStr() : "0";
                                dto.setOriginalSupplyPrice(new BigDecimal(originalSupplyPriceStr).setScale(2, RoundingMode.HALF_UP));
                            }
                        } else {
                            String originalSupplyPriceStr = StringUtils.isNotEmpty(dto.getOriginalSupplyPriceStr()) ? dto.getOriginalSupplyPriceStr() : "0";
                            dto.setOriginalSupplyPrice(new BigDecimal(originalSupplyPriceStr).setScale(2, RoundingMode.HALF_UP));
                        }
                        // 大区方案    核销方式=事中(促销含税供价需低于原供价)，促销售价需大于等于促销含税供价
                        BigDecimal promotionPriceTax = new BigDecimal(StringUtils.defaultIfBlank(dto.getPromotionPriceTaxStr(), "0"));
                        if (ActivityPlanConstant.SZ.equals(dto.getWriteOffMethod())) {
                            Validate.isTrue(promotionPriceTax.compareTo(dto.getOriginalSupplyPrice()) <= 0, "促销含税供价不能高于原供价【" + dto.getOriginalSupplyPriceStr() + "】");
                        }
                        Validate.isTrue(new BigDecimal(StringUtils.defaultIfBlank(dto.getPromotionalPriceStr(), "0")).compareTo(promotionPriceTax) >= 0, "促销售价需大于等于促销含税供价");
                    }

                }
                // 1026635
                DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode("plan_template_map", dto.getTemplateConfigCode());
                Validate.notNull(dictDataVo, "请用模版编码【%s】在数据字典plan_template_map中配置模版映射", dto.getTemplateConfigCode());
                if (!ActivityPlanTemplateMapEnum.MILK_CARD.getCode().equals(dictDataVo.getDictValue())) {
                    Validate.notNull(dto.getTotalFeeAmountStr(), "费用合计不能为空！");
                }
                //期间促销件数
                dto.setPeriodPromotionalNumberStr(Optional.ofNullable(dto.getPeriodPromotionalNumberStr()).orElse("0"));
                dto.setPeriodPromotionalNumber(new Integer(dto.getPeriodPromotionalNumberStr()));
                //费用合计
                dto.setTotalFeeAmountStr(Optional.ofNullable(dto.getTotalFeeAmountStr()).orElse("0"));
                dto.setTotalFeeAmount(new BigDecimal(dto.getTotalFeeAmountStr()).setScale(2, RoundingMode.HALF_UP));
                //单件申请费用
                dto.setSingleApplicationFeeStr(Optional.ofNullable(dto.getSingleApplicationFeeStr()).orElse("0"));
                dto.setSingleApplicationFee(new BigDecimal(dto.getSingleApplicationFeeStr()).setScale(2, RoundingMode.HALF_UP));
                //促销售价
                dto.setPromotionPriceTaxStr(Optional.ofNullable(dto.getPromotionPriceTaxStr()).orElse("0"));
                dto.setPromotionPriceTax(new BigDecimal(dto.getPromotionPriceTaxStr()).setScale(2, RoundingMode.HALF_UP));
                //期间促销金额
                dto.setPeriodPromotionalAmountStr(Optional.ofNullable(dto.getPeriodPromotionalAmountStr()).orElse("0"));
                dto.setPeriodPromotionalAmount(new BigDecimal(dto.getPeriodPromotionalAmountStr()).setScale(2, RoundingMode.HALF_UP));
                //我方承担金额
                dto.setFeeAmountStr(Optional.ofNullable(dto.getFeeAmountStr()).orElse("0"));
                dto.setFeeAmount(new BigDecimal(dto.getFeeAmountStr()).setScale(2, RoundingMode.HALF_UP));
                //系统承担金额
                dto.setSystemBorneAmountStr(Optional.ofNullable(dto.getSystemBorneAmountStr()).orElse("0"));
                dto.setSystemBorneAmount(new BigDecimal(dto.getSystemBorneAmountStr()).setScale(2, RoundingMode.HALF_UP));
                Validate.isTrue(BigDecimal.ZERO.compareTo(dto.getFeeAmount()) != 0, "费用合计/我方承担金额不能为0");
                if (StringUtils.isBlank(dto.getFirstChannelCode()) && !StringUtils.isBlank(dto.getSecondChannelCode())) {
                    throw new IllegalArgumentException("填写了二级管理渠道前，请先填写一级管理渠道！");
                }
                //促销活动模板
                if (ActivityPlanTemplateMapEnum.PROMOTION.getCode().equals(dictDataVo.getDictValue())) {
                    if ("1".equals(dto.getFirstChannelCode())) {
                        Validate.notBlank(dto.getSecondChannelCode(), "二级管理渠道必填");
                    }
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                        BigDecimal tempTotalFeeAmount = dto.getSingleApplicationFee().multiply(new BigDecimal(dto.getPeriodPromotionalNumber()));
                        boolean expression = dto.getTotalFeeAmount().compareTo(tempTotalFeeAmount) == 0;
                        if (!ActivityPlanWhereFrom.MANUAL.getCode().equals(planDto.getWhereFrom())){
//                            1040468 【ALL】活动方案： 在点击提交 校验费用合计金额时，若活动是KMS或牛e推送的，只要费用合计减去（单件费用*件数）小于某个参数值，则允许提交成功
                            expression = dto.getTotalFeeAmount().subtract(tempTotalFeeAmount).abs().compareTo(totalFeeAmountTail) <= 0;
                        }
                        Validate.isTrue(expression, "促销活动，费用合计 应等于 期间促销件数*单件申请费用！");
                    }
                    Validate.isTrue(dto.getPeriodPromotionalAmount().compareTo(dto.getPromotionPriceTax().multiply(new BigDecimal(dto.getPeriodPromotionalNumber()))) == 0, "促销活动，期间促销金额 应等于 促销含税供价*期间促销件数！");
                } else if (ActivityPlanTemplateMapEnum.MILK_CARD.getCode().equals(dictDataVo.getDictValue())) {
                    //                        return;
                } else if (ActivityPlanTemplateMapEnum.DISPLAY.getCode().equals(dictDataVo.getDictValue())) {
                    //1035896 【活动方案/活动细案】陈列活动模板增加字段“档期名称”
                    if (BooleanEnum.TRUE.getNumStr().equals(dto.getOnScheduleOrNot()) && StringUtils.isEmpty(dto.getScheduleName())) {
                        throw new RuntimeException("陈列活动模板是否档期为是档期名称必填");
                    }
                } else {
                    //其他活动模板
                    Validate.isTrue(dto.getTotalFeeAmount().compareTo(dto.getFeeAmount().add(dto.getSystemBorneAmount())) == 0, "非促销活动，费用申请合计 应等于 我方承担金额+系统承担金额！");
                }

                //1032603 促销政策和合同合同校验门店
                    if (StringUtils.isNotBlank(dto.getTerminalCode())) {
                        Validate.notEmpty(terminalMap, "根据门店编码，未查询到任何门店信息");
                        TerminalVo terminalVo = terminalMap.get(dto.getTerminalCode());
                        Validate.notNull(terminalVo, "根据门店编码【" + dto.getTerminalCode() + "】未查询到门店信息");
                        if (!BusinessUnitEnum.VERTICAL.getCode().equals(terminalVo.getBusinessUnitCode())) {
                            throw new RuntimeException("门店【" + dto.getTerminalCode() + "】不属于垂直");
                        }
                        if (StringUtils.isEmpty(terminalVo.getSellerCode())){
                            throw new RuntimeException("门店【" + dto.getTerminalCode() + "】未维护售达方");
                        }
                        if (StringUtils.isEmpty(terminalVo.getSalesInstitutionCode())){
                            throw new RuntimeException("门店【" + dto.getTerminalCode() + "】未维护销售机构");
                        }
                        dto.setCustomerCode(terminalVo.getSellerCode() + dto.getSalesInstitutionErpCode() + dto.getDistributionChannelCode() + planDto.getBusinessFormatCode());
                        dto.setCustomerErpCode(terminalVo.getSellerCode());
                        dto.setActivityOrgCode(terminalVo.getSalesInstitutionCode());
                        dto.setActivityOrgName(terminalVo.getSalesInstitutionName());
                    } else if (StringUtils.isNotBlank(dto.getCustomerCode())) {
                        dto.setCustomerErpCode(dto.getCustomerCode());
                        dto.setCustomerCode(dto.getCustomerCode() + dto.getSalesInstitutionErpCode() + dto.getDistributionChannelCode() + planDto.getBusinessFormatCode());
                    }
                if (ActivityPlanConstant.ENTERPRISE_BUY.equals(dto.getRegion())) {
                    Validate.notBlank(dto.getActivityOrgSubdivisionCode(), "区域为企业购时，区域细分必填！");
                }


                if (BooleanEnum.TRUE.getCapital().equals(dto.getPublicOrNot()) && StringUtils.isEmpty(dto.getActivityNumber())){
                    throw new RuntimeException("是否公用为是，活动便签号不能为空!");
                }

                if (CollectionUtils.isEmpty(dto.getBudgetShares())){
                    throw new RuntimeException("请选择预算!");
                }
//                1039138 [2023年12月07]活动方案提交未校验
                for (ActivityPlanBudgetDto budgetShare : dto.getBudgetShares()) {
                    if (StringUtils.isEmpty(budgetShare.getSchemeForecastDetailCode())){
                        //垂直大区方案兑付明细编码不为空才校验总部预算的年月
                        MonthBudgetVo monthBudgetVo = monthBudgetMap.get(budgetShare.getMonthBudgetCode());
                        if (null == monthBudgetVo){
                            throw new RuntimeException("月度预算["+budgetShare.getMonthBudgetCode()+"]有误");
                        }
                        if (!monthBudgetVo.getYearMonthLy().equals(dto.getFeeYearMonthStr())){
                            throw new RuntimeException("费用归属年月["+dto.getFeeYearMonthStr()+"]与预算["+budgetShare.getMonthBudgetCode()+"]年月不一致");
                        }
                    }
                }



            }

            activityPlanItemPageCacheHelper.sendMsg("正在校验方案跨月使用...");

            Map<String, ActivityFormVo> activityFormVoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(activityFormCodeSet)) {
                List<ActivityFormVo> activityFormList = activityFormService.findByCodes(Lists.newArrayList(activityFormCodeSet));
                activityFormVoMap = activityFormList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (o, n) -> n));
            }

            if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                for (int i = 0; i < thisDtoList.size(); i++) {
                    ActivityPlanItemDto item = thisDtoList.get(i);
                    //门店明细上的金额之和要等于外面的汇总
                    if (!CollectionUtils.isEmpty(item.getActivityPlanItemTerminalList())){
                        BigDecimal totalAmount = item.getActivityPlanItemTerminalList().stream().map(ActivityPlanItemTerminalDto::getFeeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                        Validate.isTrue(item.getFeeAmount().compareTo(totalAmount) == 0, "第【" + (i + 1) + "】行，我方承担金额["+item.getFeeAmountStr()+"]与实际费用(" + totalAmount + ")不一致！");
                    }

                    if (("HDMBPZ0064".equals(item.getTemplateConfigCode())
                            || "HDMBPZ3922".equals(item.getTemplateConfigCode())
                            || "HDMBPZ3921".equals(item.getTemplateConfigCode())
                            || "HDMBPZ0065".equals(item.getTemplateConfigCode()))){
                        //只有人员费用、促销方案、陈列方案、合同方案校验门店必填
                        Validate.isTrue(StringUtils.isNotEmpty(item.getTerminalCode())
                                        || (!CollectionUtils.isEmpty(item.getActivityPlanItemTerminalList()))
                                , "第【" + (i + 1) + "】行，方案明细上的门店信息或门店明细下的数据不能为空！");
                    }
                }
            }

            activityPlanItemPageCacheHelper.sendMsg("正在校验活动形式控制...");
            Set<String> needFindPriceProductCode = Sets.newHashSet();
            for (ActivityPlanItemDto itemDto : thisDtoList) {
                //垂直的大区方案不能允许跨月
                if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                    if (itemDto.getActivityBeginDate().getYear() != itemDto.getActivityEndDate().getYear() ||
                            itemDto.getActivityBeginDate().getMonth() != itemDto.getActivityEndDate().getMonth()) {
                        throw new RuntimeException("大区方案活动开始结束时间不能跨月!");
                    }
                }
                ActivityFormVo activityFormVo = activityFormVoMap.getOrDefault(itemDto.getActivityFormCode(), new ActivityFormVo());
                if (VerticalActivityTypeEnum.temporary_staff.getCode().equals(activityFormVo.getVerticalActivityType())) {
                    //活动形式下“垂直活动类型”为“临促人员活动”的活动做校验，临促人员的人员信息不允许维护。
                    if (StringUtils.isNotEmpty(itemDto.getEmployeeCode()) ||
                            StringUtils.isNotEmpty(itemDto.getEmployeeId())) {
                        throw new RuntimeException("临促人员的人员信息不允许维护");
                    }
                    List<ActivityPlanItemTerminalDto> activityPlanItemTerminalList = itemDto.getActivityPlanItemTerminalList();
                    if (!CollectionUtils.isEmpty(activityPlanItemTerminalList)) {
                        for (ActivityPlanItemTerminalDto activityPlanItemTerminalDto : activityPlanItemTerminalList) {
                            if (StringUtils.isNotEmpty(activityPlanItemTerminalDto.getEmployeeCode()) ||
                                    StringUtils.isNotEmpty(activityPlanItemTerminalDto.getEmpId())) {
                                throw new RuntimeException("临促人员的人员信息不允许维护");
                            }
                        }
                    }
                }

                //            1029206  当是否公用为Y时，门店共用量、门店公用金额、浮动量、浮动金额为必填
                if (BooleanEnum.TRUE.getCapital().equals(itemDto.getPublicOrNot())) {
                    Validate.isTrue(null != itemDto.getStoreUtility(), "是否公用为Y门店共用量必填");
                    Validate.isTrue(null != itemDto.getStorePublicAmount(), "是否公用为Y门店公用金额必填");
                    Validate.isTrue(null != itemDto.getFloatingNumber(), "是否公用为Y浮动量必填");
                    Validate.isTrue(null != itemDto.getFloatingAmount(), "是否公用为Y浮动金额必填");
                }

                //是否大日期选“是”时，“大日期来源”字段必填
                if (BooleanEnum.TRUE.getCapital().equals(itemDto.getIsBigDate())) {
                    Validate.notBlank(itemDto.getBigDateSource(), "是否大日期选“是”时，“大日期来源”字段必填");
                }

                activityPlanItemTerminalService.createValidateList(planDto, itemDto, itemDto.getActivityPlanItemTerminalList());
                if (!StringUtils.isEmpty(itemDto.getProductCode())) {
                    needFindPriceProductCode.add(itemDto.getProductCode());
                }
            }

            if (!CollectionUtils.isEmpty(needFindPriceProductCode)) {
                activityPlanItemPageCacheHelper.sendMsg("正在查询是否破价信息...");
                List<String> list = Lists.newArrayList(needFindPriceProductCode);
                List<List<String>> partitions = Lists.partition(list, 10);
                Map<String, PriceModelVo> priceModelVoMap = Maps.newHashMap();
                for (List<String> e : partitions) {
                    SearchPriceDto searchPriceDto = new SearchPriceDto();
                    searchPriceDto.setPriceTypeCode(PriceTypeEnum.REGULAR_LOW_PRICE.getDictCode());
                    SearchPriceDimensionItemDto searchPriceDimensionItemDto = new SearchPriceDimensionItemDto();
                    searchPriceDimensionItemDto.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
                    searchPriceDimensionItemDto.setRelateCodeSet(Sets.newHashSet(e));
                    activityPlanItemPageCacheHelper.sendMsg("查询产品[" + e + "]价格...");
                    searchPriceDto.setDimensionItems(Lists.newArrayList(searchPriceDimensionItemDto));
                    Map<String, PriceModelVo> stringPriceModelVoMap = priceModelVoService.handleSearchPrice(searchPriceDto);
                    priceModelVoMap.putAll(stringPriceModelVoMap);
                }
//                log.error("是否破价priceModelVoMap:{}", priceModelVoMap);
                //是否破价
                this.isBreakPrice(thisDtoList, priceModelVoMap);
            }
        }

            /*
                同一方案 ，相同便签号的明细，每个明细的门店共用量和共用金额都相同，且共用量=组内明细的促销件数之和，共用金额=组内明细的促销金额之和
             */
        activityPlanItemPageCacheHelper.sendMsg("垂直活动方案正在校验共用信息...");
        Map<String, List<ActivityPlanItemDto>> actNumberMap = dtoList.stream().filter(item -> StringUtils.isNotEmpty(item.getActivityNumber())).collect(Collectors.groupingBy(ActivityPlanItemDto::getActivityNumber));
        List<String> activityFormCodes = dtoList.stream().map(ActivityPlanItemDto::getActivityFormCode).distinct().collect(Collectors.toList());
        Map<String, List<ActivityFormExeDetailVo>> pushSapFormCodeMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(activityFormCodes)) {
            //推送sap的活动形式
            pushSapFormCodeMap = activityFormService.findPushSap(activityFormCodes);
        }
        Set<String> keySet = pushSapFormCodeMap.keySet();
        List<ActivityPlanItemDto> promotionList = dtoList.stream().filter(d -> keySet.contains(d.getActivityFormCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(actNumberMap)) {
            Map<String, ProductVo> productVoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(productCodeSet)) {
                activityPlanItemPageCacheHelper.sendMsg("产品信息查询...");
                List<ProductVo> productVoList = productVoService.findByCodes(com.google.common.collect.Lists.newArrayList(productCodeSet));
                if (!CollectionUtils.isEmpty(productVoList)) {
                    productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
                }
            }

            for (Map.Entry<String, List<ActivityPlanItemDto>> entry : actNumberMap.entrySet()) {
                String k = entry.getKey();
                List<ActivityPlanItemDto> v = entry.getValue();
                if (v.size() <= 1){
                    continue;//只有一条数据，不做共用校验
                }
                activityPlanItemPageCacheHelper.sendMsg("活动便签号[" + k + "]数据校验...");
                String cartonBarCode = null;
                for (ActivityPlanItemDto itemDto : entry.getValue()) {
                    if (!BooleanEnum.TRUE.getCapital().equals(itemDto.getPublicOrNot())){
                        throw new RuntimeException("活动便签号["+k+"]存在多条明细，是否共用必须为是");
                    }
                    if (StringUtils.isEmpty(itemDto.getProductCode())) {
                        continue;
                    }
                    ProductVo productVo = productVoMap.get(itemDto.getProductCode());
                    if (null == productVo) {
                        continue;
                    }
                    String thisCartonBarCode = productVo.getCartonBarCode();
                    if (StringUtils.isEmpty(cartonBarCode)) {
                        cartonBarCode = thisCartonBarCode;
                    } else if (!cartonBarCode.equals(thisCartonBarCode)) {
                        throw new RuntimeException("活动便签号[" + k + "]纸箱条码外包不一致");
                    }

                    //共用量
                    itemDto.setStoreUtilityStr(Optional.ofNullable(itemDto.getStoreUtilityStr()).orElse("0"));
                    itemDto.setStoreUtility(new Integer(itemDto.getStoreUtilityStr()));
                    //共用金额
                    itemDto.setStorePublicAmountStr(Optional.ofNullable(itemDto.getStorePublicAmountStr()).orElse("0"));
                    itemDto.setStorePublicAmount(new BigDecimal(itemDto.getStorePublicAmountStr()).setScale(2, RoundingMode.HALF_UP));
                    //期间促销件数
                    itemDto.setPeriodPromotionalNumberStr(Optional.ofNullable(itemDto.getPeriodPromotionalNumberStr()).orElse("0"));
                    itemDto.setPeriodPromotionalNumber(new Integer(itemDto.getPeriodPromotionalNumberStr()));
                    //费用合计
                    itemDto.setFeeAmountStr(Optional.ofNullable(itemDto.getFeeAmountStr()).orElse("0"));
                    itemDto.setFeeAmount(new BigDecimal(itemDto.getFeeAmountStr()).setScale(2, RoundingMode.HALF_UP));
                }

                if (!CollectionUtils.isEmpty(promotionList)) {
                    //校验同组共用量相同
                    List<Integer> storeUtilityStrList = v.stream().map(ActivityPlanItemDto::getStoreUtility).distinct().collect(Collectors.toList());
                    Validate.isTrue(storeUtilityStrList.size() == 1, "相同便签号的活动，他们的门店共用量也必须相同");
                    //校验同组共用金额相同
                    List<BigDecimal> storePublicAmountStrList = v.stream().map(ActivityPlanItemDto::getStorePublicAmount).distinct().collect(Collectors.toList());
                    Validate.isTrue(storePublicAmountStrList.size() == 1, "相同便签号的活动，他们的门店共用金额也必须相同");
                    //校验 共用量 = 同组期间促销量之和
                    Integer periodPromotionalNumberSum = v.stream().mapToInt(ActivityPlanItemDto::getPeriodPromotionalNumber).sum();
                    Validate.isTrue(storeUtilityStrList.get(0).equals(periodPromotionalNumberSum), "相同便签号的活动，每个活动的门店共用量 都必须等于 组内活动的期间促销件数之和");
                    //校验 共用金额 = 同组费用合计之和
                    BigDecimal totalFeeAmount = v.stream().map(ActivityPlanItemDto::getFeeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    Validate.isTrue(storePublicAmountStrList.get(0).compareTo(totalFeeAmount) == 0, "相同便签号的活动，每个活动的门店共用金额 都必须等于 组内活动的我方承担金额之和");
                }
            }

            activityPlanItemPageCacheHelper.sendMsg("活动便签号重复校验...");
            //垂直活动便签号重复校验
            List<String> activityNumberList = dtoList.stream().map(ActivityPlanItemDto::getActivityNumber).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(activityNumberList)) {
                List<String> existsActivityNumberList = activityPlanItemRepository.findActivityPlanItemCodeByActivityNumber(activityNumberList, planDto.getPlanCode());
                if (!CollectionUtils.isEmpty(existsActivityNumberList)) {
                    throw new RuntimeException("活动便签号[" + String.join(",", existsActivityNumberList) + "]已存在！");
                }
            }
        }
    }

    /**
     * 询价参数校验
     *
     * @param itemDto
     * @param terminalMap
     */
    private PriceDto validateRelatePrice(ActivityPlanItemDto itemDto, Map<String, TerminalVo> terminalMap) {
        Validate.notBlank(itemDto.getSalesInstitutionErpCode(), "原供价询价参数：【销售机构erp编码】不能为空");
        Validate.notBlank(itemDto.getDistributionChannelCode(), "原供价询价参数：【分销渠道编码】不能为空");
        Validate.notBlank(itemDto.getProductCode(), "原供价询价参数：【本品编码】不能为空");
        Validate.notBlank(itemDto.getProductUnit(), "原供价询价参数：【产品单位】不能为空");
        String terminalCode = "";
        if (StringUtils.isNotBlank(itemDto.getTerminalCode())) {
            terminalCode = itemDto.getTerminalCode();
        } else if (!CollectionUtils.isEmpty(itemDto.getActivityPlanItemTerminalList())) {
            terminalCode = itemDto.getActivityPlanItemTerminalList().get(0).getTerminalCode();
        }
        //奶卡方案模版没有门店逻辑
        TerminalVo terminalVo = null;
        PriceDto priceDto = new PriceDto();
        if (!itemDto.getTemplateConfigCode().equals(TEMPLATE_MILK_CARD_CODE)) {
            Validate.isTrue(StringUtils.isNotBlank(terminalCode), "原供价询价参数：【门店】不能为空");
            Validate.isTrue(!terminalMap.isEmpty() && terminalMap.containsKey(terminalCode), "原供价询价参数：未找到门店编码【" + terminalCode + "】所对应的门店数据");
            terminalVo = terminalMap.get(terminalCode);
            Validate.notBlank(terminalVo.getSellerCode(), "原供价询价参数：门店编码【" + terminalCode + "】上的【售达方】不能为空");
            priceDto.setSellerCode(terminalVo.getSellerCode());
        }
        priceDto.setBusinessFormatCode(ActivityPlanConstant.CW);
        priceDto.setTypeCode("zp01");
        priceDto.setSalesInstitutionCode(itemDto.getSalesInstitutionErpCode());
        priceDto.setGoodsCode(itemDto.getProductCode());
        priceDto.setSaleUnit(itemDto.getProductUnit());
        priceDto.setDistributionChannel(itemDto.getDistributionChannelCode());
        return priceDto;
    }

    @Override
    public void tempSaveValidata(ActivityPlanDto planDto, List<ActivityPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        //是否必填从模板上获取，这里再做下主要字段的必填校验
        Set<String> templateConfigCodeSet = Sets.newHashSet();
        for (ActivityPlanItemDto dto : dtoList) {
            Validate.notBlank(dto.getTemplateConfigCode(), "活动方案明细模板不能为空！");
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
        }
        List<ActivitiesTemplateConfigVo> templateList = activitiesTemplateSdkService.findByCodeList(Lists.newArrayList(templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("活动方案明细模板数据有误！");
        }

        Map<String, ActivitiesTemplateConfigVo> templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<ActivityPlanItemDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemDto::getTemplateConfigCode));

        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemDto.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(PropertyDescriptor::getName, Function.identity()));

        Map<String, Field> dateFieldMap = ObjectConvertStringUtil.getPropertyFieldMap(ActivityPlanItemDto.class);

        for (Map.Entry<String, List<ActivityPlanItemDto>> dtoEntry : dtoMap.entrySet()) {
            List<ActivityPlanItemDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = templateMap.get(dtoEntry.getKey());
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            for (ActivityPlanItemDto dto : thisDtoList) {
                //每500条提示一下
                if (dto.getIndexNo() % 500 == 0) {
                    activityPlanItemPageCacheHelper.sendMsg("正在校验第[" + dto.getIndexNo() + "]条数据");
                }
                //后端验证必填字段
                if (!StringUtils.isBlank(dto.getActivityBeginDateStr())) {
                    DateStringDealUtil.validateDateStrAndSet(dto.getActivityBeginDateStr(), "方案开始时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityBeginDate);
                }
                if (!StringUtils.isBlank(dto.getActivityEndDateStr())) {

                    DateStringDealUtil.validateDateStrAndSet(dto.getActivityEndDateStr(), "方案结束时间", true, DateUtil.DEFAULT_YEAR_MONTH_DAY, dto::setActivityEndDate);
                }
                if (!StringUtils.isBlank(dto.getActivityBeginDateStr()) && !StringUtils.isBlank(dto.getActivityEndDateStr())) {
                    dto.setFeeYearMonth(new Date(dto.getActivityBeginDate().getYear(), dto.getActivityEndDate().getMonth(), 1));
                }

                //销售机构、销售大区、销售省区的最下级放到区域字段上
                if (StringUtils.isEmpty(dto.getActivityOrgCode())) {
                    if (StringUtils.isNotEmpty(dto.getSalesOrgCode())) {
                        dto.setActivityOrgCode(dto.getSalesOrgCode());
                        dto.setActivityOrgName(dto.getSalesOrgName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesRegionCode())) {
                        dto.setActivityOrgCode(dto.getSalesRegionCode());
                        dto.setActivityOrgName(dto.getSalesRegionName());
                    } else if (StringUtils.isNotEmpty(dto.getSalesInstitutionCode())) {
                        dto.setActivityOrgCode(dto.getSalesInstitutionCode());
                        dto.setActivityOrgName(dto.getSalesInstitutionName());
                    }
                }

                if (BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
                    //垂直，保留两位小数
                    ObjectConvertStringUtil.convertObjectListStrProperties(dto, dateFieldMap, propertyMap, 2, true, templateDetailTitleMap);
                } else {
                    ObjectConvertStringUtil.convertObjectListStrProperties(dto, dateFieldMap, propertyMap, null, true, templateDetailTitleMap);
                }
            }
        }
    }

    @Override
    public List<ActivityPlanItemVo> findByHeadquartersPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty(planItemCode)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanItem> activityPlanItems = this.activityPlanItemRepository.findByHeadquartersPlanItemCode(planItemCode);
        if (CollectionUtils.isEmpty(activityPlanItems)) {
            return Lists.newArrayList();
        }
        Collection<ActivityPlanItemVo> activityPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityPlanItems, ActivityPlanItem.class, ActivityPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityPlanItemVo>) activityPlanItemVos;
    }

    @Override
    public ActivityPlanItemVo findListByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty(planItemCode)) {
            return null;
        }
        ActivityPlanItem activityPlanItem = this.activityPlanItemRepository.findListByPlanItemCode(planItemCode);
        if (Objects.isNull(activityPlanItem)) {
            return null;
        }
        return this.nebulaToolkitService.copyObjectByWhiteList(activityPlanItem, ActivityPlanItemVo.class, null, null);
    }

    @Override
    public List<ActivityPlanBudgetVo> findItemBudgetListByPlanCode(String planCode) {
        if (StringUtils.isEmpty(planCode)) {
            return Lists.newArrayList();
        }
        return this.activityPlanBudgetRepository.findItemBudgetListByPlanCode(planCode);

    }

    @Override
    public void updateAuditStatusByCodes(List<String> auditPlanItemCodes) {
        if (!CollectionUtils.isEmpty(auditPlanItemCodes)) {
            this.activityPlanItemRepository.updateAuditStatusByCodes(auditPlanItemCodes);
        }
    }

    @Override
    public List<ActivityPlanBudgetVo> findItemBudgetListByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty(planItemCode)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanBudget> activityPlanBudgets = this.activityPlanBudgetRepository.findItemBudgetListByPlanItemCode(planItemCode);
        if (CollectionUtils.isEmpty(activityPlanBudgets)) {
            return Lists.newArrayList();
        }
        Collection<ActivityPlanBudgetVo> activityPlanBudgetVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityPlanBudgets, ActivityPlanBudget.class, ActivityPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityPlanBudgetVo>) activityPlanBudgetVos;
    }

    @Override
    public List<ActivityPlanItemVo> findListByPlanCodes(List<String> planCodes) {
        if(CollectionUtils.isEmpty(planCodes)){
            return Lists.newArrayList();
        }
        List<ActivityPlanItem> activityPlanItems = this.activityPlanItemRepository.findListByPlanCodes(planCodes);
        if(CollectionUtils.isEmpty(activityPlanItems)){
            return Lists.newArrayList();
        }
        Collection<ActivityPlanItemVo> activityPlanItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(activityPlanItems, ActivityPlanItem.class, ActivityPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<ActivityPlanItemVo>) activityPlanItemVos;
    }

    @Override
    public void updatePlanItemSapState(String planItemCode, boolean success) {
        if(StringUtils.isBlank(planItemCode)){
            return;
        }
        activityPlanItemRepository.updatePlanItemSapState(planItemCode,success);
    }


    /**
     * 活动类型下拉
     *
     * @param dto 活动类型查询参数
     */
    @Override
    public List<CommonSelectVo> findActivityTypeSelectList(ActivityTypeSelectDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
        return activityTypeService.findActivityTypeSelectList(dto);
    }

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     */
    @Override
    public List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notBlank(dto.getActivityTypeCode(), "活动类型不能为空！");
        return activityFormService.findActivityFormSelectList(dto);
    }

    @Override
    public void deleteByPlanCodes(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        activityPlanItemRepository.deleteByPlanCodes(planCodes);
        activityPlanItemExtendFieldRepository.deleteByPlanCodeList(planCodes);
    }

    /**
     * 活动方案关闭明细
     *
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<String> closeItem(List<String> ids, boolean throwException) {
        List<String> errorMsgList = Lists.newArrayList();
        //10活动方案明细基础验证
        List<ActivityPlanItem> itemList = this.closeItemBaseVerifyItem(ids, throwException, errorMsgList);
        List<String> errorMsgList2 = closeItemList(itemList, throwException);
        if (!CollectionUtils.isEmpty(errorMsgList2)) {
            errorMsgList.addAll(errorMsgList2);
        }
        return errorMsgList;
    }

    /**
     * 活动方案关闭明细
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<String> closeItemList(List<ActivityPlanItem> itemList, boolean throwException) {
        StopWatch stopWatch1 = new StopWatch("方案关闭时间统计");
        activityPlanItemPageCacheHelper.sendCloseMsg("开始执行活动方案关闭...");
        List<String> errorMsgList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(itemList)) {
            return errorMsgList;
        }
        //20活动方案头部信息基础验证
        List<String> planCodeList = itemList.stream()
                .map(ActivityPlanItem::getPlanCode)
                .distinct().collect(Collectors.toList());
        stopWatch1.start("头信息验证");
        activityPlanItemPageCacheHelper.sendCloseMsg("活动方案关闭头信息验证...");
        List<ActivityPlan> planList = this.closeItemBaseVerifyHead(planCodeList, throwException, errorMsgList);
        if (CollectionUtils.isEmpty(planList)) {
            return errorMsgList;
        }
        stopWatch1.stop();
        log.info("头信息验证耗时:{}", stopWatch1.getLastTaskTimeMillis());
        String businessUnitCode = planList.get(0).getBusinessUnitCode();
        //30活动方案 是否被细案关联验证
        //方案自动生成细案的模板编码
        stopWatch1.start("方案自动生成细案的模板编码");
        activityPlanItemPageCacheHelper.sendCloseMsg("活动方案关闭关联细案数据校验...");
        Set<String> configCodeSet = this.closeItemDetailPlanVerifyItem(itemList, throwException, errorMsgList);
        stopWatch1.stop();
        log.info("方案自动生成细案的模板编码耗时:{}", stopWatch1.getLastTaskTimeMillis());
        if (CollectionUtils.isEmpty(itemList)) {
            return errorMsgList;
        }
        stopWatch1.start("释放预算");
        activityPlanItemPageCacheHelper.sendCloseMsg("活动方案关闭释放预算处理...");
        //40释放预算
        //主体需要释放预算,垂直不需要
        List<String> itemCodeList = itemList.stream().map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList());
        if (BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)) {
            List<String> carGiftItemCodeList = Lists.newArrayList();
            List<String> otherItemCodeList = Lists.newArrayList();
            for (ActivityPlanItem item : itemList) {
                if (PromotionTypeEnum.PROMOTION_GIFT.getCode().equals(item.getPromotionType())
                        && ActivityFormDataConstant.ACTIVITY_FORM_FREE_RIDE_CODE.equals(item.getActivityFormCode())) {
                    carGiftItemCodeList.add(item.getPlanItemCode());
                } else {
                    otherItemCodeList.add(item.getPlanItemCode());
                }
            }
            if (!CollectionUtils.isEmpty(carGiftItemCodeList)) {
                activityPlanBudgetService.returnCarGiftMonthBudgetByPlanItemCodeList(carGiftItemCodeList);
            }
            if (!CollectionUtils.isEmpty(otherItemCodeList)) {
                activityPlanBudgetService.returnMonthBudgetByPlanItemCodeList(otherItemCodeList);
            }
        } else if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            //垂直也需要释放预算（这里先关闭，预算定时任务来退）
            this.verticalClosePlan(itemList);
        }
        stopWatch1.stop();
        log.info("释放预算耗时:{}", stopWatch1.getLastTaskTimeMillis());

        if (BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)) {
            List<String> ids = itemList.stream().map(ActivityPlanItem::getId).collect(Collectors.toList());
            activityPlanItemRepository.closeItem(ids);
        }
        activityPlanItemPageCacheHelper.sendCloseMsg("活动方案关闭更新头状态...");
        stopWatch1.start("更新头状态");
        activityPlanItemRepository.updateHeadStatus(itemCodeList);
        stopWatch1.stop();
        log.info("更新头状态耗时:{}", stopWatch1.getLastTaskTimeMillis());

        //方案自动生成细案 关闭方案,自动关闭细案
        List<String> autoItemHeadCodeList = itemList.stream()
                .filter(k -> configCodeSet.contains(k.getTemplateConfigCode()))
                .map(ActivityPlanItem::getPlanItemCode)
                .distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(autoItemHeadCodeList)) {
            ActivityDetailPlanPlanEventDto eventDto = new ActivityDetailPlanPlanEventDto();
            eventDto.setPlanItemCodeList(autoItemHeadCodeList);
            SerializableBiConsumer<ActivityDetailPlanPlanListener, ActivityDetailPlanPlanEventDto> serializableBiConsumer = ActivityDetailPlanPlanListener::closeActivityDetailPlanItem;
            nebulaNetEventClient.publish(eventDto, ActivityDetailPlanPlanListener.class, serializableBiConsumer);
        }

        activityPlanItemPageCacheHelper.sendCloseMsg("活动方案关闭日志存储...");
        stopWatch1.start("关闭日志");
        //关闭业务日志，这里就只记录关闭状态吧
        if (BusinessUnitEnum.HEADQUARTERS.getCode().equals(businessUnitCode)) {
            if(!CollectionUtils.isEmpty(itemList)){
                List<ActivityPlanItemVo> activityPlanItemVos = (List<ActivityPlanItemVo>)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanItem.class, ActivityPlanItemVo.class, LinkedHashSet.class, ArrayList.class);
                //批量加锁
                boolean hasLock = false;
                List<String> planItemCodes = activityPlanItemVos.stream().map(ActivityPlanItemVo::getPlanItemCode).collect(Collectors.toList());
                log.info("方案关闭随车打针推送sap,planItemCodes:{}",JsonUtils.obj2JsonString(planItemCodes));
                try {
                    hasLock = redisLockService.batchLock(ActivityPlanConstant.FREE_GOODS_LOCK, planItemCodes, TimeUnit.MINUTES, 30);
                    if (!hasLock) {
                        log.error("免费货物正在推送SAP中，请勿重复推送，方案明细编码：{}", JsonUtils.obj2JsonString(planItemCodes));
                        throw new RuntimeException("免费货物正在推送SAP中,请勿重复推送");
                    }
                    planPushFreeGoods.pushActivityToFreeGoods(activityPlanItemVos, OperationTypeEnum.DELETE);
                    log.info("方案关闭随车打针推送sap成功,planItemCodes:{}",JsonUtils.obj2JsonString(planItemCodes));
                }finally {
                    if (hasLock) {
                        redisLockService.batchUnLock(ActivityPlanConstant.FREE_GOODS_LOCK, planItemCodes);
                    }
                }
            }
        }

            //关闭业务日志，这里就只记录关闭状态吧
        Map<String, ActivityPlan> planMap = planList.stream().collect(Collectors.toMap(ActivityPlan::getPlanCode, Function.identity()));
        SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanItemCloseLogEventDto> onClosed =
                ActivityPlanLogEventListener::onCloseItem;
        for (ActivityPlanItem activityPlanItem : itemList) {
            ActivityPlan activityPlan = planMap.get(activityPlanItem.getPlanCode());
            ActivityPlanItemCloseLogEventDto logEventDto = new ActivityPlanItemCloseLogEventDto();
            ActivityPlanItemCloseLogDto oldDto = new ActivityPlanItemCloseLogDto();
            oldDto.setId(activityPlan.getId());
//            oldDto.setPlanCode(activityPlanItem.getPlanCode());
//            oldDto.setPlanItemCode(activityPlanItem.getPlanItemCode());
            oldDto.setIsClose(BooleanEnum.FALSE.getSure());
            logEventDto.setOriginal(oldDto);
            ActivityPlanItemCloseLogDto newDto = new ActivityPlanItemCloseLogDto();
            newDto.setId(activityPlan.getId());
            newDto.setPlanCode(activityPlanItem.getPlanCode());
            newDto.setPlanItemCode(activityPlanItem.getPlanItemCode());
            newDto.setIsClose(BooleanEnum.TRUE.getSure());
            logEventDto.setNewest(newDto);
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onClosed);
        }
        stopWatch1.stop();
        log.info("关闭日志:{}", stopWatch1.getLastTaskTimeMillis());

        closePushMq(businessUnitCode,itemList);

        return errorMsgList;
    }

    private void closePushMq(String businessUnitCode,List<ActivityPlanItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)){
            return;
        }
        List<String> planItemCodeList = itemList.stream().map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList());
        //更新方案预算跟踪表
        MqMessageVo mqMessageVo = new MqMessageVo();
        mqMessageVo.setMsgBody(JSONObject.toJSONString(planItemCodeList));
        mqMessageVo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag(ActivityPlanPassMqTagConstant.CONFIRM_ITEM_CREATE_CLOSE_RECORD_DETAIL);
        rocketMqProducer.sendMqMsg(mqMessageVo,10);

        if (BusinessUnitEnum.isDefaultBusinessUnit(businessUnitCode)){
            mqMessageVo = new MqMessageVo();
            mqMessageVo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(ActivityPlanPassMqTagConstant.PASS_TPM_HEAD_SCHEME_FORECAST);
            mqMessageVo.setMsgBody(JSONObject.toJSONString(planItemCodeList));
            rocketMqProducer.sendMqMsg(mqMessageVo,10);
        }
    }

    /**
     * 关闭方案基础验证
     */
    @Override
    public List<ActivityPlanItem> closeItemBaseVerifyItem(List<String> ids, boolean throwException, List<String> errorMsgList) {
        StopWatch stopWatch = new StopWatch("活动方案基础校验时间统计");
        Assert.notEmpty(ids, "请选择活动方案数据!");
        stopWatch.start("查询方案明细数据");
        List<ActivityPlanItem> itemList = activityPlanItemRepository.findByIdList(ids);
        List<ActivityPlanItem> operationList = Lists.newArrayList(itemList);
        Assert.notEmpty(ids, "选择的数据不存在,请刷新重试!");
        itemList.forEach(item -> {
            try {
                Assert.hasLength(item.getPlanCode(), "活动方案明细编码为空!");
                Assert.hasLength(item.getPlanItemCode(), "活动方案明细编码为空!");
                Assert.hasLength(item.getIsClose(), "活动方案[" + item.getPlanItemCode() + "]是否关闭标记为空!");
                Assert.hasLength(item.getActivityFormCode(), "活动方案[" + item.getPlanItemCode() + "]活动形式为空!");
                Assert.notNull(item.getActivityBeginDate(), "活动方案[" + item.getPlanItemCode() + "]开始时间为空!");
                Assert.notNull(item.getActivityEndDate(), "活动方案[" + item.getPlanItemCode() + "]结束时间为空!");
            } catch (Exception e) {
                log.error("", e);
                if (throwException) {
                    throw e;
                } else {
                    errorMsgList.add(e.getMessage());
                    operationList.remove(item);
                }
            }
        });
        stopWatch.stop();
        log.info("方案明细查询耗时:{}", stopWatch.getLastTaskTimeMillis());
        stopWatch.start("方案关闭状态校验");
        List<ActivityPlanItem> hasCloseItemList = itemList.stream()
                .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsClose()))
                .collect(Collectors.toList());
        List<String> planItemCodeList = itemList.stream()
                .filter(k -> StringUtil.isNotEmpty(k.getPlanItemCode()))
                .map(ActivityPlanItem::getPlanItemCode)
                .distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(hasCloseItemList)) {
            List<String> hasCloseItemCodeSet = hasCloseItemList.stream().map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList());
            String errorMsg = "活动方案明细" + hasCloseItemCodeSet + "已关闭！";
            if (throwException) {
                throw new RuntimeException(errorMsg);
            } else {
                errorMsgList.add(errorMsg);
                operationList.removeAll(hasCloseItemList);
            }
        }
        //已结束活动方案不允许关闭
        Date nowDate = new Date();
        //这里区分业务单元
        List<String> planCodeList = itemList.stream().map(ActivityPlanItem::getPlanCode).distinct().collect(Collectors.toList());
        Map<String, ActivityPlanItem> planItemCodeForPlanItemMap = itemList.stream().collect(Collectors.toMap(ActivityPlanItem::getPlanItemCode, v -> v, (n, o) -> n));

        List<ActivityPlan> planList = activityPlanRepository.findByPlanCodeList(planCodeList);
        if (CollectionUtil.isEmpty(planList)) {
            String errorMsg = "活动方案" + planCodeList + "不存在！";
            if (throwException) {
                throw new IllegalArgumentException(errorMsg);
            } else {
                errorMsgList.add(errorMsg);
                operationList.clear();
                return Collections.emptyList();
            }
        }
        Set<String> businessUnitCodeSet = new HashSet<>();
        Set<String> planTypeSet = new HashSet<>();
        planList.forEach(item -> {
            try {
                Assert.hasLength(item.getPlanCode(), "活动方案明细编码为空!");
                Assert.hasLength(item.getBusinessUnitCode(), "活动方案明细对应的方案[" + item.getPlanCode() + "]无业务单元!");
                Assert.hasLength(item.getPlanType(), "活动方案明细对应的方案[" + item.getPlanCode() + "]无业务单元!");
                businessUnitCodeSet.add(item.getBusinessUnitCode());
                planTypeSet.add(item.getPlanType());
            } catch (Exception e) {
                log.error("", e);
                if (throwException) {
                    throw e;
                } else {
                    errorMsgList.add(e.getMessage());
                    operationList.clear();
                }
            }
        });
        if (businessUnitCodeSet.size() > 1) {
            String errorMsg = "单次关闭必须是同一个业务单元的方案！";
            if (throwException) {
                throw new IllegalArgumentException(errorMsg);
            } else {
                errorMsgList.add(errorMsg);
                operationList.clear();
                return Collections.emptyList();
            }
        }
        if (planTypeSet.size() > 1) {
            String errorMsg = "单次关闭必须是同一个类型的方案！";
            if (throwException) {
                throw new IllegalArgumentException(errorMsg);
            } else {
                errorMsgList.add(errorMsg);
                operationList.clear();
                return Collections.emptyList();
            }
        }
        if (CollectionUtil.isEmpty(operationList)) {
            return Collections.emptyList();
        }
        String businessUnitCode = planList.get(0).getBusinessUnitCode();
        ActivityPlanTypeEnum planTypeEnum = ActivityPlanTypeEnum.codeToEnum(planList.get(0).getPlanType());
        if (Objects.isNull(planTypeEnum)) {
            String errorMsg = "方案类型不合法！";
            if (throwException) {
                throw new IllegalArgumentException(errorMsg);
            } else {
                errorMsgList.add(errorMsg);
                operationList.clear();
                return Collections.emptyList();
            }
        }
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            //已结束活动细案不允许关闭
            List<ActivityPlanItem> itemHasEndList = itemList.stream()
                    .filter(k -> {
                        Date compareDate = k.getActivityEndDate();
                        if (null != k.getOrderEndDate() && k.getOrderEndDate().compareTo(compareDate) > 0) {
                            compareDate = k.getOrderEndDate();
                        }
                        return nowDate.compareTo(compareDate) > 0;
                    })
                    .collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(itemHasEndList)) {
                List<String> itemHasEndCodeList = itemHasEndList.stream().map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList());
                String errorMsg = "活动细案明细" + itemHasEndCodeList + "已结束,不允许关闭！";
                if (throwException) {
                    throw new IllegalArgumentException(errorMsg);
                } else {
                    errorMsgList.add(errorMsg);
                    operationList.removeAll(itemHasEndList);
                }
            }
            if (ActivityPlanTypeEnum.headquarters.equals(planTypeEnum)) {
                List<ActivityPlanVerticalSchemeForecastVo> verticalSchemeForecastVoList = activityPlanRepository.findVerticalSchemeForecastByPlanItemCodes(planItemCodeList);
                if (CollectionUtil.isNotEmpty(verticalSchemeForecastVoList)) {
                    verticalSchemeForecastVoList.forEach(item -> {
                        if ("2".equals(item.getStatus())) {
                            String errorMsg = "活动细案明细" + item.getSchemeItemCode() +
                                    "已被兑付表[" + item.getSchemeForecastCode() + "]确认,请勿关闭！";
                            if (throwException) {
                                throw new IllegalArgumentException(errorMsg);
                            } else {
                                errorMsgList.add(errorMsg);
                                operationList.remove(planItemCodeForPlanItemMap.get(item.getSchemeItemCode()));
                            }
                        }
                    });
                }
            } else {
                List<ActivityPlanAuditVo> planAuditVoList = activityPlanRepository.findAuditInfoByPlanItemCodes(planItemCodeList);
                if (CollectionUtil.isNotEmpty(planAuditVoList)) {
                    planAuditVoList.forEach(item -> {
                        if (YesOrNoEnum.YES.getCode().equals(item.getWholeAudit())) {
                            String errorMsg = "方案明细[" + item.getPlanItemCode() +
                                    "]被细案承接,细案对应结案明细[" + item.getAuditDetailCode() + "]已完全结案，请勿关闭！";
                            if (throwException) {
                                throw new IllegalArgumentException(errorMsg);
                            } else {
                                errorMsgList.add(errorMsg);
                                operationList.remove(planItemCodeForPlanItemMap.get(item.getPlanItemCode()));
                            }
                        }
                        if (!ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus())) {
                            String errorMsg = "方案明细[" + item.getPlanItemCode() +
                                    "]被细案承接,细案对应结案明细[" + item.getAuditDetailCode() + "]未审批通过，请勿关闭！";
                            if (throwException) {
                                throw new IllegalArgumentException(errorMsg);
                            } else {
                                errorMsgList.add(errorMsg);
                                operationList.remove(planItemCodeForPlanItemMap.get(item.getPlanItemCode()));
                            }
                        }
                    });
                }

            }
        } else {
            if (ActivityPlanTypeEnum.headquarters.equals(planTypeEnum)) {
                List<ActivityPlanVo> relatePlanList = activityPlanRepository.findActivityPlanByRelatePlanItemCodes(planItemCodeList);
                if (CollectionUtil.isNotEmpty(relatePlanList)) {
                    relatePlanList.forEach(item -> {
                        if (ProcessStatusEnum.COMMIT.getDictCode().equals(item.getProcessStatus())
                                || ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus())) {
                            String errorMsg = "活动方案明细[" + item.getRelatePlanItemCode() +
                                    "]已被大区方案[" + item.getPlanCode() + "]承接，请勿关闭！";
                            if (throwException) {
                                throw new IllegalArgumentException(errorMsg);
                            } else {
                                errorMsgList.add(errorMsg);
                                operationList.remove(planItemCodeForPlanItemMap.get(item.getRelatePlanItemCode()));
                            }
                        }
                    });

                }
            } else {
                ActivityPlanQueryActivityDetailPlanDto queryActivityDetailPlanDto = new ActivityPlanQueryActivityDetailPlanDto();
                queryActivityDetailPlanDto.setPlanItemCodeList(planItemCodeList);
                SerializableBiConsumer<ActivityPlanQueryActivityDetailPlanListener, ActivityPlanQueryActivityDetailPlanDto> queryActivityDetailPlan =
                        ActivityPlanQueryActivityDetailPlanListener::getDetailPlanInfoByPlanItemCodeList;
                ActivityPlanQueryActivityDetailPlanResponse detailPlanResponse = (ActivityPlanQueryActivityDetailPlanResponse) this.nebulaNetEventClient.directPublish(queryActivityDetailPlanDto,
                        ActivityPlanQueryActivityDetailPlanListener.class, queryActivityDetailPlan);
                if (CollectionUtil.isNotEmpty(detailPlanResponse.getPlanPlanVoList())) {
                    detailPlanResponse.getPlanPlanVoList().forEach(item -> {
                        if ("方案生成".equals(item.getWhereFrom())){
                            //方案生成的细案不做校验
                            return;
                        }
                        if (BooleanEnum.TRUE.getCapital().equals(item.getIsClose())){
                            //1040345 活动方案关闭问题。方案关联的细案关闭后，方案可以被关闭
                            return;
                        }
                        if (ProcessStatusEnum.COMMIT.getDictCode().equals(item.getProcessStatus())
                                || ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus())
                        ) {
                            String errorMsg = "大区方案明细[" + item.getPlanItemCode() +
                                    "]已被细案明细[" + item.getDetailPlanCode() + "]承接，请勿关闭！";
                            if (throwException) {
                                throw new IllegalArgumentException(errorMsg);
                            } else {
                                errorMsgList.add(errorMsg);
                                operationList.remove(planItemCodeForPlanItemMap.get(item.getPlanItemCode()));
                            }
                        }
                    });
                }


            }

        }
        stopWatch.stop();
        log.info("方案关闭状态校验耗时:{}", stopWatch.getLastTaskTimeMillis());
        return operationList;
    }

    /**
     * 关闭方案是验证是否关联细案基础验证
     *
     * @param itemList
     * @return
     */
    private Set<String> closeItemDetailPlanVerifyItem(List<ActivityPlanItem> itemList, boolean throwException, List<String> errorMsgList) {
        Assert.notEmpty(itemList, "请选择活动方案数据!");
        List<String> planItemCodeList = itemList.stream().map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return Sets.newHashSet();
        }
        StopWatch stopWatch1 = new StopWatch("方案关闭是否关联细案时间统计");
        stopWatch1.start("总部方案校验下是否有未关闭的大区方案");
        //总部方案校验下是否有未关闭的大区方案
        List<String> hasRelatePlanItemCodeList = activityPlanItemRepository.findApprovedItemCodeListByRelatePlanItemCodeList(planItemCodeList);
        if (hasRelatePlanItemCodeList.size() > 0) {
            String errorMsg = "方案[" + String.join(",", hasRelatePlanItemCodeList) + "]存在已关联大区方案";
            if (throwException) {
                throw new RuntimeException(errorMsg);
            } else {
                errorMsgList.add(errorMsg);
                itemList.removeIf(next -> hasRelatePlanItemCodeList.contains(next.getPlanItemCode()));
            }
        }
        stopWatch1.stop();
        log.info("方案关闭是否关联细案时间统计-总部方案校验下是否有未关闭的大区方案:{}", stopWatch1.getLastTaskTimeMillis());
        stopWatch1.start("总部方案校验下是否有未关闭的大区方案");
        //活动方案已被细案应关联不可关闭 ,活动细案由方案自动生产的的不在限制行列
        List<String> templateConfigCodeList = itemList.stream()
                .filter(k -> StringUtils.isNotBlank(k.getTemplateConfigCode()))
                .map(ActivityPlanItem::getTemplateConfigCode)
                .distinct()
                .collect(Collectors.toList());
        List<ActivitiesTemplateConfigVo> templateConfigList = activitiesTemplateSdkService.findByCodeList(templateConfigCodeList);
        //方案自动生成细案的模板编码
        Set<String> configCodeSet = new HashSet<>(templateConfigCodeList.size());
        if (CollectionUtil.isNotEmpty(templateConfigList)) {
            configCodeSet.addAll(templateConfigList.stream()
                    .filter(k -> BooleanEnum.TRUE.getCapital().equals(k.getIsAutoCreateActivityDetailPlan()))
                    .map(ActivitiesTemplateConfigVo::getConfigCode)
                    .collect(Collectors.toSet()));
        }
        planItemCodeList = itemList.stream()
                .filter(k -> StringUtils.isNotBlank(k.getPlanCode()))
                .filter(k -> !configCodeSet.contains(k.getTemplateConfigCode()))
                .map(ActivityPlanItem::getPlanItemCode)
                .distinct()
                .collect(Collectors.toList());
        stopWatch1.stop();
        log.info("方案关闭是否关联细案时间统计-总部方案校验下是否有未关闭的大区方案:{}", stopWatch1.getLastTaskTimeMillis());
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return configCodeSet;
        }
        stopWatch1.start("校验是否有未关闭的细案");
        ActivityPlanQueryActivityDetailPlanDto eventDto = new ActivityPlanQueryActivityDetailPlanDto();
        eventDto.setPlanItemCodeList(planItemCodeList);
        SerializableBiConsumer<ActivityPlanQueryActivityDetailPlanListener, ActivityPlanQueryActivityDetailPlanDto> serializableBiConsumer = ActivityPlanQueryActivityDetailPlanListener::hasRelateDetailPlanCodeList;
        ActivityPlanQueryActivityDetailPlanResponse eventResponse = (ActivityPlanQueryActivityDetailPlanResponse) nebulaNetEventClient.directPublish(eventDto, ActivityPlanQueryActivityDetailPlanListener.class, serializableBiConsumer);
        if (null != eventResponse && !CollectionUtils.isEmpty(eventResponse.getPlanItemCodeList())) {
            String errorMsg = "存在未关闭的细案关联了此方案明细" + eventResponse.getPlanItemCodeList().toString();
            if (throwException) {
                throw new RuntimeException(errorMsg);
            } else {
                errorMsgList.add(errorMsg);
                Iterator<ActivityPlanItem> iterator = itemList.iterator();
                while (iterator.hasNext()) {
                    ActivityPlanItem next = iterator.next();
                    if (planItemCodeList.contains(next.getPlanItemCode())) {
                        iterator.remove();
                    }
                }
            }
        }
        stopWatch1.stop();
        log.info("方案关闭是否关联细案时间统计-校验是否有未关闭的细案:{}",stopWatch1.getLastTaskTimeMillis());

//       1038320 主体方案预测表的方案明细点击确认之后则不允许再关闭或调整该方案明细，再关闭或调整时应当做出提示【该方案明细已确认，不允许关闭或调整】
        stopWatch1.start("主体方案预测表是否确认");
        ActivityPlanQueryHeadSchemeForecastDto headSchemeForecastEventDto = new ActivityPlanQueryHeadSchemeForecastDto();
        headSchemeForecastEventDto.setPlanItemCodeList(planItemCodeList);
        SerializableBiConsumer<ActivityPlanQueryHeadSchemeForecastListener, ActivityPlanQueryHeadSchemeForecastDto> headSchemeForecastConsumer = ActivityPlanQueryHeadSchemeForecastListener::findListByConditions;
        ActivityPlanQueryHeadSchemeForecastResponse headSchemeForecastEventResponse = (ActivityPlanQueryHeadSchemeForecastResponse) nebulaNetEventClient.directPublish(headSchemeForecastEventDto, ActivityPlanQueryHeadSchemeForecastListener.class, headSchemeForecastConsumer);
        if (null != headSchemeForecastEventResponse && !CollectionUtils.isEmpty(headSchemeForecastEventResponse.getList())) {
            Map<String, ActivityPlanQueryHeadSchemeForecastVo> headSchemeForecastVoMap = headSchemeForecastEventResponse.getList().stream().collect(Collectors.toMap(ActivityPlanQueryHeadSchemeForecastVo::getSchemeItemCode, Function.identity()));
            Iterator<ActivityPlanItem> iterator = itemList.iterator();
            while (iterator.hasNext()){
                ActivityPlanItem next = iterator.next();
                ActivityPlanQueryHeadSchemeForecastVo headSchemeForecastVo = headSchemeForecastVoMap.get(next.getPlanItemCode());
                if (null != headSchemeForecastVo && "2".equals(headSchemeForecastVo.getStatus())){
                    //主体方案预测表已确认
                    String errorMsg = "方案明细["+next.getPlanItemCode()+"]已确认，不允许关闭";
                    if (throwException){
                        throw new RuntimeException(errorMsg);
                    }else{
                        errorMsgList.add(errorMsg);
                        iterator.remove();
                    }
                }
            }
        }
        stopWatch1.stop();
        log.info("方案关闭是否关联细案时间统计-校验主体方案预测表确认状态:{}",stopWatch1.getLastTaskTimeMillis());

        return configCodeSet;
    }

    /**
     * 关闭方案基础验证
     *
     * @param planCodeList
     * @return
     */
    private List<ActivityPlan> closeItemBaseVerifyHead(List<String> planCodeList, boolean throwException, List<String> errorMsgList) {
        Assert.notEmpty(planCodeList, "方案明细未找到方案头部信息,关闭失败!");
        List<ActivityPlan> planList = activityPlanRepository.findByPlanCodeList(planCodeList);
        Assert.notEmpty(planList, "方案明细未找到方案头部信息,关闭失败!");
        Assert.isTrue(planList.size() == planCodeList.size(),
                "选择的方案明细存在无头部信息,关闭失败!");
        Set<String> businessUnitEnumSet = new HashSet<>();
        Iterator<ActivityPlan> iterator = planList.iterator();
        while (iterator.hasNext()) {
            ActivityPlan item = iterator.next();
            Assert.hasLength(item.getPlanCode(), "活动方案编码为空!");
            Assert.hasLength(item.getBusinessUnitCode(),
                    "活动方案[" + item.getPlanCode() + "]业务单元为空!");
            BusinessUnitEnum unitEnum = BusinessUnitEnum.codeToEnum(item.getBusinessUnitCode());
            Assert.notNull(unitEnum, "活动方案[" + item.getPlanCode() + "]业务单元不合法!");
            businessUnitEnumSet.add(unitEnum.getCode());

            if (throwException) {
                //垂直的，只能关闭审批通过的
                Assert.isTrue(StringUtils.isNotBlank(item.getProcessStatus()) && ProcessStatusEnum.PASS.getDictCode().equals(item.getProcessStatus()),
                        "只有审批通过的活动方案才可关闭!");
            } else {
                iterator.remove();
                errorMsgList.add("方案[" + item.getPlanCode() + "]不处于审批通过状态！");
            }
        }
        Assert.isTrue(businessUnitEnumSet.size() == 1, "活动方案关闭单次只能操作同一个业务单元的方案!");
        return planList;
    }

    @Override
    public void createActivityPlanItem(List<ActivityPlanItemDto> itemList) {
        List<ActivityPlanItem> saveList = Lists.newArrayList();
        List<ActivityPlanItemExtendField> extendFieldSaveList = Lists.newArrayList();
        Map<String, ActivityPlanItemDto> dtoMap = Maps.newHashMap();
        for (ActivityPlanItemDto item : itemList) {
            dtoMap.put(item.getId(), item);
            String bonusType = item.getBonusType();
            if (StringUtils.isNotEmpty(bonusType)) {
                String activityDesc = Optional.ofNullable(item.getActivityDesc()).orElse("");
                activityDesc = activityDesc.replace("A-", "");
                activityDesc = activityDesc.replace("B-", "");
                if ("A-".equals(activityDesc) || "B-".equals(activityDesc)) {
                    activityDesc = "";
                }
                if (BonusTypeEnum.BONUS.getCode().equals(bonusType)) {
                    item.setActivityDesc("A-" + activityDesc);
                }
                if (BonusTypeEnum.PURE_SEND.getCode().equals(bonusType)) {
                    item.setActivityDesc("B-" + activityDesc);
                }
            }
            ActivityPlanItem itemEntity = null;
            itemEntity = nebulaToolkitService.copyObjectByWhiteList(item, ActivityPlanItem.class, HashSet.class, ArrayList.class);
            itemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            itemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            itemEntity.setIsClose(BooleanEnum.FALSE.getCapital());
            itemEntity.setTenantCode(TenantUtils.getTenantCode());
            saveList.add(itemEntity);
            if (StringUtils.isNotEmpty(item.getProductCode()) && item.getProductCode().contains(",")) {
                //如果是多选的话，设置成空的，单独存表
                itemEntity.setProductCode("");
                itemEntity.setProductName("");
            }
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            // redis生成活动方案明细编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
            List<String> codeList = generateCodeList(itemList.size());
            Iterator<String> codeIterator = codeList.iterator();
            for (ActivityPlanItem activityPlanItem : saveList) {
                activityPlanItem.setPlanItemCode(codeIterator.next());
                ActivityPlanItemDto dto = dtoMap.get(activityPlanItem.getId());
                dto.setPlanItemCode(activityPlanItem.getPlanItemCode());
                activityPlanItem.setId(null);
            }
            activityPlanItemRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(extendFieldSaveList)) {
            activityPlanItemExtendFieldRepository.saveBatch(extendFieldSaveList);
        }

        //保存方案-预算数据
        ActivityPlan entity = new ActivityPlan();
        entity.setTenantCode(TenantUtils.getTenantCode());
        activityPlanBudgetService.saveActivityPlanBudgetList(entity, false, itemList);
    }

    @Override
    public Page<ActivityPlanItemVo> findPlanItemNoActivityDetail(Pageable pageable, String yearMonth, String salesOrgCode) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
        Page<ActivityPlanItemVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());

        String salesOrgErpCode = null;
        if (StringUtils.isEmpty(salesOrgCode)) {
            FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            //获取用户销售组织，并判断时否存在分子公司
            String orgCode = loginDetails.getOrgCode();
            List<OrgVo> orgList = orgVoService.findAllParentByOrgCode(orgCode);
            List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findBySalesOrgCodes(orgList.stream().map(OrgVo::getSalesOrgCode).collect(Collectors.toList()));
            if (CollectionUtils.isEmpty(salesOrgVoList)) {
                throw new UnsupportedOperationException("用户所在部门及上级部门均没有关联销售组织数据");
            }
            //过滤出层级为销售机构的销售组织
            Optional<SalesOrgVo> salesOrgVo = salesOrgVoList.stream().filter(o -> SalesOrgLevelTypeEnum.MECHANISM.getCode().equals(o.getSalesOrgLevel())).findFirst();
            if (salesOrgVo.isPresent()) {
                salesOrgErpCode = salesOrgVo.get().getErpCode();
            }
        } else {
            List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findAllParentBySalesOrgCode(salesOrgCode);
            Optional<SalesOrgVo> salesOrgVo = salesOrgVoList.stream().filter(o -> SalesOrgLevelTypeEnum.MECHANISM.getCode().equals(o.getSalesOrgLevel())).findFirst();
            if (salesOrgVo.isPresent()) {
                salesOrgErpCode = salesOrgVo.get().getErpCode();
            }
        }

        if (StringUtils.isEmpty(salesOrgErpCode)) {
            return page;
        }

        //筛选其中的分子公司客户
        List<SalesOrgSubComOrgVo> salesOrgSubComOrgVos = salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgErpCode);
        if (CollectionUtils.isEmpty(salesOrgSubComOrgVos)) {
            throw new UnsupportedOperationException("不存在分子公司客户信息");
        }
        List<String> subComCustomerErpCodeList = salesOrgSubComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).collect(Collectors.toList());

        List<CustomerVo> subComCustomerList = customerVoService.findByErpCodeList(subComCustomerErpCodeList);
        List<String> legalSalesOrgCodeList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(subComCustomerList)) {
            for (CustomerVo customerVo : subComCustomerList) {
                legalSalesOrgCodeList.add(customerVo.getSalesRegionCode());
                legalSalesOrgCodeList.add(customerVo.getSalesOrgCode());
            }
        }
        if (CollectionUtils.isEmpty(legalSalesOrgCodeList)) {
            return page;
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(yearMonth + "-01", DateUtil.DEFAULT_YEAR_MONTH_DAY));
        String beginDate = DateUtil.format(calendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        calendar.add(Calendar.MONTH, 1);
        String endDate = DateUtil.format(calendar.getTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        return activityPlanItemRepository.findPlanItemNoActivityDetail(page, beginDate, endDate, salesOrgCode, legalSalesOrgCodeList);
    }

    @Override
    public Map<String, BigDecimal> calculateSalePlanProportion(ActivityPlanItemDto dto) {

        Validate.notBlank(dto.getFeeBelongYearMonth(), "费用归属年月不能为空");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元不能为空");
        Validate.notBlank(dto.getRegion(), "区域不能为空");
        Validate.notBlank(dto.getSystemCode(), "零售商不能为空");
        //获取门店明细
        activityPlanItemTerminalService.addTerminalFromCache(dto);
        //是否自动填充标识
        boolean autoFill = false;
        if (CollectionUtils.isEmpty(dto.getActivityPlanItemTerminalList())) {

            TerminalPaginationDto terminalPaginationDto = new TerminalPaginationDto();
            terminalPaginationDto.setRegionCode(dto.getRegion());
            terminalPaginationDto.setCustomerRetailerCode(dto.getSystemCode());
            terminalPaginationDto.setDistrictLevelCode(dto.getCityLevel());
            terminalPaginationDto.setTerminalTypeCode(dto.getAcStoreType());
            terminalPaginationDto.setPointsWarehouseCode(dto.getAcWarehouseCode());

            List<TerminalVo> terminalVoList = terminalVoService.findListByConditions(terminalPaginationDto);
            List<ActivityPlanItemTerminalDto> activityPlanItemTerminalDtoList = new ArrayList<>();
            for (TerminalVo terminalVo : terminalVoList) {
                ActivityPlanItemTerminalDto activityPlanItemTerminalDto = new ActivityPlanItemTerminalDto();
                activityPlanItemTerminalDto.setTerminalCode(terminalVo.getTerminalCode());
                activityPlanItemTerminalDto.setTerminalName(terminalVo.getTerminalName());
                activityPlanItemTerminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
                activityPlanItemTerminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                activityPlanItemTerminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanItemTerminalDtoList.add(activityPlanItemTerminalDto);
            }
            dto.setActivityPlanItemTerminalList(activityPlanItemTerminalDtoList);
            autoFill = true;
        }
        Validate.isTrue(!CollectionUtils.isEmpty(dto.getActivityPlanItemTerminalList()), "门店明细不能为空");
        Validate.notBlank(dto.getProductCode(), "产品编码不能为空");
        if (StringUtils.isNotEmpty(dto.getPeriodPromotionalNumberStr())) {
            try {
                dto.setPeriodPromotionalNumber(Integer.parseInt(dto.getPeriodPromotionalNumberStr()));
            } catch (Exception e) {
                throw new RuntimeException("期间促销件数格式有误！");
            }
        }
        Validate.notNull(dto.getPeriodPromotionalNumber(), "期间促销件数不能为空");
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setYearMonthLy(dto.getFeeBelongYearMonth());
        salesPlanDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        salesPlanDto.setTerminalCodes(dto.getActivityPlanItemTerminalList().stream().map(ActivityPlanItemTerminalDto::getTerminalCode).collect(Collectors.toList()));
        salesPlanDto.setProductCode(dto.getProductCode());
        List<SalesPlanVo> salesPlanVoList = salesPlanService.findByConditions(salesPlanDto);

        Map<String, BigDecimal> resultMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(salesPlanVoList)) {
            BigDecimal totalAmount = salesPlanVoList.stream().map(SalesPlanVo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);

            Map<String, List<SalesPlanVo>> salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(SalesPlanVo::getTerminalCode));

            //尾差外的数量合计
            BigDecimal otherPeriodPromotionQuantity = BigDecimal.ZERO;
            for (int i = 0; i < dto.getActivityPlanItemTerminalList().size(); i++) {
                ActivityPlanItemTerminalDto dto1 = dto.getActivityPlanItemTerminalList().get(i);

                //处理尾差
                if (i == dto.getActivityPlanItemTerminalList().size() - 1) {
                    BigDecimal quantity = new BigDecimal(dto.getPeriodPromotionalNumber()).subtract(otherPeriodPromotionQuantity);
                    resultMap.put(dto1.getTerminalCode(), quantity);
                    dto1.setQuantity(quantity);
                } else {
                    List<SalesPlanVo> salesPlanVoList1 = salesPlanVoMap.get(dto1.getTerminalCode());
                    if (!CollectionUtils.isEmpty(salesPlanVoList1)) {
                        BigDecimal amount = salesPlanVoList1.stream().map(SalesPlanVo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        BigDecimal periodPromotionQuantity = amount.divide(totalAmount, 0, RoundingMode.HALF_UP).multiply(new BigDecimal(dto.getPeriodPromotionalNumber()));
                        resultMap.put(dto1.getTerminalCode(), periodPromotionQuantity);
                        dto1.setQuantity(periodPromotionQuantity);
                        otherPeriodPromotionQuantity = otherPeriodPromotionQuantity.add(periodPromotionQuantity);
                    }
                }
                if (Objects.nonNull(dto1.getStandard()) && Objects.nonNull(dto1.getQuantity())) {
                    dto1.setAmount(dto1.getStandard().multiply(dto1.getQuantity()));
                }
            }
        }
        activityPlanItemTerminalService.changeTerminalDetail(dto, autoFill);
        return resultMap;
    }

    @Override
    public ActivityPlanItemVo calculateItemData(ActivityPlanItemDto dto) {

        ActivityPlanItemVo activityPlanItemVo = new ActivityPlanItemVo();
        DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode("plan_template_map", dto.getTemplateConfigCode());
        if (null == dictDataVo) {
            return null;
        }
        Validate.notNull(dictDataVo, "请用模版编码【%s】在数据字典plan_template_map中配置模版映射", dto.getTemplateConfigCode());
        //促销
        if (ActivityPlanTemplateMapEnum.PROMOTION.getCode().equals(dictDataVo.getDictValue())) {
            //税率 = 本品税率
//            if(StringUtils.isNotEmpty(dto.getProductCode())){
//                List<ProductVo> productVoList = productVoService.findByProductCodes(Collections.singletonList(dto.getProductCode()));
//                if(!CollectionUtils.isEmpty(productVoList)){
//                    activityPlanItemVo.setTaxRate(productVoList.get(0).getRate());
//                }
//            }
            if (Objects.nonNull(dto.getGiftProductionDateStr()) && StringUtils.isNotEmpty(dto.getRegion()) && StringUtils.isNotEmpty(dto.getProductCode())) {
                TpmInventoryCheckDto tpmInventoryCheckDto = new TpmInventoryCheckDto();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                tpmInventoryCheckDto.setProductionStartDate(dto.getGiftProductionDateStr());
                tpmInventoryCheckDto.setTerminalRegionCode(dto.getRegion());
                tpmInventoryCheckDto.setCustomerRetailerCode(dto.getSystemCode());
                tpmInventoryCheckDto.setProductCode(dto.getProductCode());
                tpmInventoryCheckDto.setInventoryType(TpmInventoryCheckConstant.CUSTOMER_INVENTORY);
                List<TpmInventoryCheckVo> tpmInventoryCheckVoList = inventoryCheckService.findListByConditions(tpmInventoryCheckDto);
                Optional<TpmInventoryCheckVo> first = tpmInventoryCheckVoList.stream().max(Comparator.comparing(TpmInventoryCheckVo::getDateOfReporting));

                first.ifPresent(tpmInventoryCheckVo -> activityPlanItemVo.setPeriodPromotionalNumber(tpmInventoryCheckVo.getQuantity()));

            }
            if (StringUtils.isNotEmpty(dto.getSystemCode()) && StringUtils.isNotEmpty(dto.getRegion()) && StringUtils.isNotEmpty(dto.getProductCode()) && Objects.nonNull(dto.getActivityEndDate())) {
                SalesPlanDto salesPlanDto = new SalesPlanDto();
                salesPlanDto.setCustomerRetailerCode(dto.getSystemCode());
                salesPlanDto.setRegionCode(dto.getRegion());
                salesPlanDto.setProductCode(dto.getProductCode());
                salesPlanDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM");
                salesPlanDto.setYearMonthLy(sdf2.format(dto.getActivityEndDate()));
                List<SalesPlanVo> salesPlanVoList = salesPlanService.findByConditions(salesPlanDto);
                if (!CollectionUtils.isEmpty(salesPlanVoList)) {
                    BigDecimal planQuantity = salesPlanVoList.stream().map(SalesPlanVo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    activityPlanItemVo.setSystemMonthPlanQuantity(planQuantity);
                }
            }
        } else if (ActivityPlanTemplateMapEnum.CONTRACT.getCode().equals(dictDataVo.getDictValue())) {

        } else if (ActivityPlanTemplateMapEnum.TRADE_SALE.getCode().equals(dictDataVo.getDictValue())) {
            if (StringUtils.isNotEmpty(dto.getMaterialCode())) {
                PromotionMaterialVO promotionMaterialVO = promotionMaterialService.findByIdOrMaterialCode(null, dto.getMaterialCode());
                if (promotionMaterialVO != null) {
                    activityPlanItemVo.setSupplierCode(promotionMaterialVO.getSupplierCode());
                    activityPlanItemVo.setSupplierName(promotionMaterialVO.getSupplierName());
                }
            }
        }
        return activityPlanItemVo;
    }

    @Override
    public void proportionByPos(ActivityPlanDto dto, String cacheKey) {
        //垂直
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            return;
        }
        List<ActivityPlanItemDto> itemCacheList = this.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        activityPlanItemTerminalService.proportionByPos(dto, cacheKey, itemCacheList);
    }

    @Override
    public ActivityPlanItemBase applyAmountFindByItemCode(ActivityPlanItemDto dto) {
        return activityPlanItemRepository.applyAmountFindByItemCode(dto);
    }
    /**
     * 条件查询总条数
     *
     * @param activityPlanItemDto
     * @return
     */
    @Override
    public Integer findTotalByConditions(ActivityPlanItemDto activityPlanItemDto) {
        return activityPlanItemRepository.findTotalByConditions(activityPlanItemDto);
    }


    /**
     * 垂直关闭活动方案明细
     *
     * @param itemList 垂直活动方案明细
     */
    public void verticalClosePlan(List<ActivityPlanItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Set<String> planCodeSet = new HashSet<>();
        List<String> itemNos = new ArrayList<>();
        for (ActivityPlanItem item : itemList) {
            itemNos.add(item.getPlanItemCode());
            planCodeSet.add(item.getPlanCode());
        }
        if (planCodeSet.size() > 1) {
            throw new RuntimeException("活动方案明细不属于同一个活动方案" + planCodeSet.toString());
        }
        ActivityPlan plan = this.activityPlanRepository.lambdaQuery()
                .eq(ActivityPlan::getPlanCode, itemList.get(0).getPlanCode())
                .eq(ActivityPlan::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityPlan::getTenantCode, TenantUtils.getTenantCode())
                .one();

        //关闭限制，总部方案
        if (ActivityPlanTypeEnum.headquarters.getCode().equals(plan.getPlanType())) {
            //无大区方案关联，或已关联的方案完全关闭，且无细案关联，或已关联的细案完全关闭
            //关联了大区方案，没有完全关闭的明细编码
            List<String> codes1 = this.activityPlanBudgetRepository.getNoClosePlanItemNo(itemNos);
            if (!CollectionUtils.isEmpty(codes1)) {
                throw new RuntimeException("存在未关闭大区方案关联了此方案明细" + codes1.toString());
            }
            //关联了细案，没有完全关闭的明细编码
            ActivityDetailPlanPlanEventDto eventDto = new ActivityDetailPlanPlanEventDto();
            eventDto.setPlanItemCodeList(itemNos);
            SerializableBiConsumer<ActivityDetailPlanPlanListener, ActivityDetailPlanPlanEventDto> getNoClosePlanItemNo =
                    ActivityDetailPlanPlanListener::getNoClosePlanItemNo;
            ActivityPlanNoCloseItemResponse itemResponse = (ActivityPlanNoCloseItemResponse) this.nebulaNetEventClient.directPublish(eventDto,
                    ActivityDetailPlanPlanListener.class, getNoClosePlanItemNo);
            if (null != itemResponse && !CollectionUtils.isEmpty(itemResponse.getItemNos())) {
                throw new RuntimeException("存在未关闭的细案关联了此方案明细" + itemResponse.getItemNos().toString());
            }
        }
        //大区方案，这里关闭没有限制

        //保存关闭标识与关闭时间，设置预算未回退标识
        List<String> ids = itemList.stream().map(ActivityPlanItem::getId).collect(Collectors.toList());
        this.activityPlanItemRepository.closeItemVertical(ids);
    }

}

