package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanRelatePlanDto;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanRelatePlan;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRelatePlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanRelatePlanService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案-关联策略服务
 * @author wanghaojia
 * @date 2022/11/23 16:01
 */
@Service
public class ActivityPlanRelatePlanServiceImpl implements ActivityPlanRelatePlanService {

    @Autowired(required = false)
    private ActivityPlanRelatePlanRepository activityPlanRelatePlanRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param planList  活动方案关联策略数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityPlanRelatePlanList(ActivityPlan entity,boolean update, List<ActivityPlanRelatePlanDto> planList) {

        Map<String,ActivityPlanRelatePlan> oldMap = Maps.newHashMap();
        if (update){
            List<ActivityPlanRelatePlan> oldList = activityPlanRelatePlanRepository.findListByPlanCode(entity.getPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityPlanRelatePlan::getId, Function.identity()));
        }
        if (CollectionUtils.isEmpty(planList)){
            if (oldMap.size() > 0){
                //待删除的数据
                activityPlanRelatePlanRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
            }
            return;
        }

        List<ActivityPlanRelatePlan> activityPlanRelatePlans = (List<ActivityPlanRelatePlan>) nebulaToolkitService.copyCollectionByWhiteList(planList, ActivityPlanRelatePlanDto.class, ActivityPlanRelatePlan.class, HashSet.class, ArrayList.class);

        List<ActivityPlanRelatePlan> saveList = Lists.newArrayList();
        List<ActivityPlanRelatePlan> updateList = Lists.newArrayList();
        for (ActivityPlanRelatePlan item : activityPlanRelatePlans) {
            if (oldMap.containsKey(item.getId())){
                updateList.add(item);
                oldMap.remove(item.getId());
            }else{
                item.setPlanCode(entity.getPlanCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityPlanRelatePlanRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityPlanRelatePlanRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0){
            //待删除的数据
            activityPlanRelatePlanRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }


}
