package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRelatePlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanStrategyRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanOutDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanRelatePlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanStrategyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * 活动方案对外接口内部实现
 * @author wanghaojia
 * @date 2022/11/25 10:24
 */
@Service
public class ActivityPlanSdkServiceImpl implements ActivityPlanSdkService {

    @Autowired(required = false)
    private ActivityPlanService activityPlanService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityPlanRepository activityPlanRepository;


    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private ActivityPlanBudgetService activityPlanBudgetService;

    @Autowired(required = false)
    private ActivityPlanRelatePlanRepository activityPlanRelatePLanRepository;

    @Autowired(required = false)
    private ActivityPlanStrategyRepository activityPlanStrategyRepository;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityPlanVo> findByConditions(Pageable pageable, ActivityPlanDto dto) {
        return activityPlanService.findByConditions(pageable,dto);
    }

    @Override
    public void operateBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList) {
        activityPlanBudgetService.operateBudget(planBudgetOperateList);
    }

    @Override
    public void operateCustomerBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList) {
        activityPlanBudgetService.operateCustomerBudget(planBudgetOperateList);
    }

    /**
     * 更据方案编码查询详情
     * @param planCodes 方案编码集合
     * @return
     */
    @Override
    public List<ActivityPlanVo> findByCodes(Set<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        return activityPlanService.findByCodes(planCodes);
    }

    @Override
    public List<ActivityPlanVo> findByPlanCodeList(Set<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityPlan> list = activityPlanRepository.findByPlanCodeList(Lists.newArrayList(planCodes));
        return (List<ActivityPlanVo>) nebulaToolkitService.copyCollectionByWhiteList(list,ActivityPlan.class,ActivityPlanVo.class, HashSet.class,ArrayList.class);
    }

    /**
     * 更据名称查询对应编码
     * @param planName
     * @return
     */
    @Override
    public String findPlanCodeByPlanName(String planName) {
        return null;
    }

    @Override
    public List<ActivityPlanDto> buildActivityPlanParms(List<String> businessNoList) {
        return activityPlanService.buildActivityPlanParms(businessNoList);
    }

    @Override
    public List<ActivityPlanDto> findPlanDtoListByCodeList(List<String> planCodeList) {
        return activityPlanRepository.findDtoListByPlanCodeList(planCodeList);
    }

    @Override
    public List<ActivityPlanItemDto> findItemDtoAndAttachListByPlanCodeList(List<String> planCodeList) {
        return activityPlanItemRepository.findDtoAndAttachListByPlanCodeList(planCodeList);
    }

    @Override
    public List<ActivityPlanVo> findPlanActivityEndTime(Set<String> activityDetailCodes) {
        return activityPlanService.findPlanActivityEndTime(activityDetailCodes);
    }

    @Override
    public List<ActivityPlanItemDto> findByPlanItem(String planCode) {
        return activityPlanService.findByPlanItem(planCode);
    }

    /**
     * 大区方案关联的总部方案
     *
     * @param planCode
     * @return
     */
    @Override
    public List<ActivityPlanRelatePlanVo> findRelatePLan(String planCode) {
        if (!StringUtils.hasText(planCode)) {
            return Collections.emptyList();
        }
        return activityPlanRelatePLanRepository.findListVoByPlanCode(planCode);
    }

    @Override
    public List<ActivityPlanStrategyVo> findActivityPlanStrategyVoList(List<String> planCodeList) {
        return activityPlanStrategyRepository.findListVoByPlanCodeList(planCodeList);
    }

    @Override
    public void createActivityPlan(ActivityPlanDto planDto) {
        if (Objects.isNull(planDto)) {
            return;
        }
        this.activityPlanService.createActivityPlan(planDto);
    }

    @Override
    public ActivityPlanVo findByPlanItemCode(String planItemCode) {
        if(!StringUtils.hasText(planItemCode)){
            return null;
        }
        return this.activityPlanService.findByPlanItemCode(planItemCode);
    }

    @Override
    public ActivityPlanVo findById(String id) {
        return null;
    }

    @Override
    public ActivityPlanOutDto createForOut(ActivityPlanOutDto dto) {
        return null;
    }

    @Override
    public ActivityPlanOutDto updateForOut(ActivityPlanOutDto dto) {
        return null;
    }

    @Override
    public void delete(List<String> ids) {

    }

    @Override
    public Object atomCreate(ActivityPlanOutDto dto) {
        this.activityPlanService.atomSaveActivityPlan(dto);
        return null;
    }

    @Transactional
    @Override
    public void updateActivityDelayEndTime(List<ActivityPlanItemDto> list) {
        this.activityPlanService.updateActivityDelayEndTime(list);
    }

    @Override
    public List<ActivityPlanBudgetVo> findHeadquartersByRegionPlanCodes(Set<String> planCodes) {

        if(CollectionUtils.isEmpty(planCodes)){
            return Lists.newArrayList();
        }
        return activityPlanRepository.findHeadquartersByRegionPlanCodes(planCodes);
    }

    @Override
    public List<ActivityPlanVo> findActivityUsableBudget(List<String> planCodeList) {
        return activityPlanRepository.findActivityUsableBudget(planCodeList);
    }

    @Override
    public List<ActivityPlanVo> findOrgCodeByPlanCode(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanVo> list = this.activityPlanRepository.findOrgCodeByPlanCode(planCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}
