package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.kms.business.audit.match.sdk.service.NotMatchedAcceptanceVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.price.sdk.dto.PriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRegionRetailerCityDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.extend.field.service.ExtendFieldService;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.contract.sdk.service.ActivityContractSdkService;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractFeeVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractScopeVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import com.biz.crm.tpm.business.activity.form.sdk.enums.VerticalActivityTypeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.local.entity.*;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.*;
import com.biz.crm.tpm.business.activity.plan.local.service.*;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.thirld.PlanPushFreeGoods;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanProcessBusinessForm;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.*;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanLogEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.ActivityPlanItemPushSfaDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.ActivityPlanItemPushSfaDisplayDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.*;
import com.biz.crm.tpm.business.activity.plan.sdk.event.log.ActivityPlanLogEventListener;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemExtendFieldBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.*;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportMainVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportSubVo;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeBudgetDto;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeRelationDto;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeRelationDetailVo;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.enums.ControlSituationEnum;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.dto.OperateInventoryCheckDto;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.enums.InventoryCheckOperationTypeEnum;
import com.biz.crm.tpm.business.inventory.check.manage.sdk.service.TpmInventoryCheckService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyItemSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetReportVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.jsonwebtoken.lang.Assert;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案表(ActivityPlan)表服务实现类
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:47
 */
@Service("activityPlanService")
@Slf4j
public class ActivityPlanServiceImpl implements ActivityPlanService {

    /**
     * 区域数据字典编码
     */
    private static final String DICT_REGION_CODE = "MDM_CUSTOMIZE_ORG";

    @Autowired(required = false)
    private ActivityPlanRepository activityPlanRepository;

    @Autowired(required = false)
    private ActivityPlanStrategyRepository activityPlanStrategyRepository;
    @Autowired(required = false)
    private ActivityPlanRelatePlanRepository activityPlanRelatePLanRepository;
    @Autowired(required = false)
    private ActivityPlanTemplateRepository activityPlanTemplateRepository;
    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private ActivityPlanItemRelateDetailItemRepository activityPlanItemRelateDetailItemRepository;

    @Autowired(required = false)
    private ActivityPlanItemExtendFieldRepository activityPlanItemExtendFieldRepository;

    @Autowired(required = false)
    private MarketingStrategyBudgetSdkService marketingStrategyBudgetSdkService;


    @Autowired(required = false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityPlanItemTerminalRepository activityPlanItemTerminalRepository;

    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;

    @Autowired(required = false)
    private SalesPerformanceVoService salesPerformanceVoService;

    /**
     * 月度预算服务
     */
    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;
    /**
     * 活动方案明细服务
     */
    @Autowired(required = false)
    private ActivityPlanItemService activityPlanItemService;

    /**
     * 活动方案关联细案明细
     */
    @Autowired(required = false)
    private ActivityPlanItemRelateDetailItemService activityPlanItemRelateDetailItemService;

    @Autowired(required = false)
    private LoginUserService loginUserService;
    /**
     * 活动方案-关联策略服务
     */
    @Autowired(required = false)
    private ActivityPlanStrategyService activityPlanStrategyService;
    /**
     * 活动方案-关联预算服务
     */
    @Autowired(required = false)
    private ActivityPlanBudgetService activityPlanBudgetService;
    /**
     * 活动方案-大区方案关联总部方案表
     */
    @Autowired(required = false)
    private ActivityPlanRelatePlanService activityPlanRelatePlanService;
    /**
     * 活动方案-模板配置
     */
    @Autowired(required = false)
    private ActivityPlanTemplateService activityPlanTemplateService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private ProcessBatchBusinessService processBatchBusinessService;

    @Autowired(required = false)
    private ActivityContractSdkService activityContractSdkService;

    @Autowired(required = false)
    private ActivityPlanItemTerminalService activityPlanItemTerminalService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Autowired(required = false)
    private SalesPlanService salesPlanService;

    @Autowired(required = false)
    private VariableService variableService;

    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;

    @Autowired(required = false)
    private ActivityTypeService activityTypeService;

    @Autowired(required = false)
    private TerminalVoService terminalVoService;

    @Autowired(required = false)
    private PromotersVoService promotersVoService;
    @Autowired(required = false)
    private ExtendFieldService extendFieldService;
    /**
     * 活动形式服务
     */
    @Autowired(required = false)
    private ActivityFormService activityFormService;

    @Autowired(required = false)
    private MarketingStrategyItemSdkService marketingStrategyItemSdkService;

    @Autowired(required = false)
    private ActivityPlanItemModifyRepository activityPlanItemModifyRepository;

    @Autowired(required = false)
    private ActivityPlanModifyRepository activityPlanModifyRepository;

    @Autowired(required = false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Autowired(required = false)
    private TpmInventoryCheckService tpmInventoryCheckService;

    @Autowired
    private NotMatchedAcceptanceVoService notMatchedAcceptanceVoService;

    /**
     * redis服务
     */
    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private PriceVoService priceVoService;

    @Autowired(required = false)
    private PlanPushFreeGoods planPushFreeGoods;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @Override
    public Page<ActivityPlanVo> findByConditions(Pageable pageable, ActivityPlanDto dto) {
        return activityPlanRepository.findByConditions(pageable, dto);
    }

    /**
     * 查询可以选择的月度预算
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @Override
    public Page<MonthBudgetVo> findMonthBudgetByConditions(Pageable pageable, ActivityPlanBudgetDto planBudgetDto, MonthBudgetDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态不能为空");
        List<String> budgetItemCodeList = new ArrayList<>();
        // 活动分类
        if (StringUtils.isNotEmpty(dto.getActivityTypeCode())) {
            ActivityTypeVo activityTypeVo = activityTypeService.getActivityTypeByActivityTypeCode(dto.getActivityTypeCode());
            if (ObjectUtils.isEmpty(activityTypeVo)) {
                return new Page<>();
            }
            List<ActivityTypeRelationDto> activityTypeRelationDtoList = activityTypeVo.getActivityTypeRelationDtoList();
            if (CollectionUtils.isEmpty(activityTypeRelationDtoList)) {
                return new Page<>();
            }
            activityTypeRelationDtoList.forEach(activityTypeRelationDto -> {
                if (CollectionUtils.isEmpty(activityTypeRelationDto.getActivityTypeBudgetDtoList())) {
                    return;
                }
                List<String> collect = activityTypeRelationDto.getActivityTypeBudgetDtoList().stream()
                        .map(ActivityTypeBudgetDto::getBudgetProjectCode)
                        .collect(Collectors.toList());
                budgetItemCodeList.addAll(collect);
            });
        }
        dto.setBudgetItemCodeList(budgetItemCodeList);
        List<String> monthBudgetCodeList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(planBudgetDto.getStrategyCodeList())) {
            MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
            budgetDto.setStrategyCodeList(planBudgetDto.getStrategyCodeList());
            List<MarketingStrategyBudgetDto> strategyBudgetDtos = marketingStrategyBudgetSdkService.findListByConditions(budgetDto);
            monthBudgetCodeList.addAll(strategyBudgetDtos.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).distinct().collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(planBudgetDto.getPlanCodeList())) {
            List<ActivityPlanBudget> activityPlanBudgets = activityPlanBudgetRepository.listByPlanCodeList(planBudgetDto.getPlanCodeList());
            monthBudgetCodeList.addAll(activityPlanBudgets.stream().map(ActivityPlanBudget::getMonthBudgetCode).distinct().collect(Collectors.toList()));
        }
        dto.setMonthBudgetCodeList(monthBudgetCodeList);
        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            if (ActivityPlanTypeEnum.region.getCode().equals(planBudgetDto.getPlanType())) {
                if (StringUtils.isNotBlank(dto.getYearMonthLy())){
                    dto.setPlanFeeYearMonth(dto.getYearMonthLy());
                    dto.setPlanFeeYear(dto.getYearMonthLy().substring(0, 4));
                    dto.setYearMonthLy(null);
                }
            }else{
                //总部方案年月用区间范围查询
                if (StringUtils.isNotEmpty(planBudgetDto.getActivityBeginDateStr())){
                    dto.setYearMonthLyLt(planBudgetDto.getActivityBeginDateStr().substring(0,7));
                }
                if (StringUtils.isNotEmpty(planBudgetDto.getActivityEndDateStr())){
                    dto.setYearMonthLyGt(planBudgetDto.getActivityEndDateStr().substring(0,7));
                }
            }
        }
        if (!CollectionUtils.isEmpty(dto.getSystemCodes())) {
            dto.setSystemCode(null);
        }
        return monthBudgetService.findByConditionsNoFilter(pageable, dto);
    }

    /**
     * 通过id获取活动方案数据
     *
     * @param id 活动方案id
     */
    @Override
    public ActivityPlanVo findById(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        ActivityPlanVo activityPlanVo = activityPlanRepository.getVoById(id);
        if (null != activityPlanVo) {
            //再查下关联的策略
            List<ActivityPlanStrategyVo> strategyDtos = activityPlanStrategyRepository.findListVoByPlanCode(activityPlanVo.getPlanCode());
            activityPlanVo.setStrategyList(strategyDtos);
            //再查下大区方案关联的总部方案
            List<ActivityPlanRelatePlanVo> relatePlanList = activityPlanRelatePLanRepository.findListVoByPlanCode(activityPlanVo.getPlanCode());
            activityPlanVo.setRelatePlanList(relatePlanList);
            //再查下关联的模板配置
            List<ActivityPlanTemplateVo> templateList = activityPlanTemplateRepository.findListVoByPlanCode(activityPlanVo.getPlanCode());
            activityPlanVo.setTemplateList(templateList);
            return activityPlanVo;
        }
        return null;
    }

    /**
     * 通过id获取活动方案数据
     *
     * @param code 活动方案编码
     */
    @Override
    public ActivityPlanVo findByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        ActivityPlanVo activityPlanVo = activityPlanRepository.getVoByPlanCode(code);
        if (null != activityPlanVo) {
            //再查下关联的策略
            List<ActivityPlanStrategyVo> strategyDtos = activityPlanStrategyRepository.findListVoByPlanCode(activityPlanVo.getPlanCode());
            activityPlanVo.setStrategyList(strategyDtos);
            //再查下大区方案关联的总部方案
            List<ActivityPlanRelatePlanVo> relatePlanList = activityPlanRelatePLanRepository.findListVoByPlanCode(activityPlanVo.getPlanCode());
            activityPlanVo.setRelatePlanList(relatePlanList);
            //再查下关联的模板配置
            List<ActivityPlanTemplateVo> templateList = activityPlanTemplateRepository.findListVoByPlanCode(activityPlanVo.getPlanCode());
            activityPlanVo.setTemplateList(templateList);
            return activityPlanVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityPlan(ActivityPlanDto dto, String cacheKey) {
        boolean lockSuccess = false;
        String lockKey = ActivityPlanConstant.LOCK_ACTIVITY_PLAN_SAVE + cacheKey;
        try {
            lockSuccess = redisLockService.tryLock(lockKey, TimeUnit.HOURS, 2);
            if (!lockSuccess){
                throw new RuntimeException("数据已提交，请勿重复操作！");
            }
            activityPlanItemPageCacheHelper.sendMsg("数据加载中...");
            List<ActivityPlanItemDto> itemCacheList = activityPlanItemService.findCacheList(cacheKey);
            if(BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                List<String> terminalCodes = itemCacheList.stream().map(ActivityPlanItemDto::getTerminalCode).filter(Objects::nonNull).collect(Collectors.toList());
                Map<String, TerminalVo> terminalVoMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty(terminalCodes)) {
                    List<TerminalVo> terminalVos = terminalVoService.findBaseByTerminalCodes(terminalCodes);
                    if (!CollectionUtils.isEmpty(terminalVos)) {
                        terminalVoMap = terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (o, n) -> n));
                    }
                }
                for (ActivityPlanItemDto itemDto : itemCacheList) {
                    if (StringUtils.isNotBlank(itemDto.getTerminalCode())) {
                        if (terminalVoMap.containsKey(itemDto.getTerminalCode())) {
                            TerminalVo terminalVo = terminalVoMap.get(itemDto.getTerminalCode());
                            itemDto.setActivityOrgCode(terminalVo.getSalesInstitutionCode());
                            itemDto.setActivityOrgName(terminalVo.getSalesInstitutionName());
                        }
                    }
                }
            }

            List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList = activityPlanItemRelateDetailItemService.findCacheList(cacheKey);
            saveActivityPlan(dto, itemCacheList,cacheKey,relateDetailItemDtoList);
            activityPlanItemService.clearCache(cacheKey);
            activityPlanItemRelateDetailItemService.clearCache(cacheKey);
        } catch (RuntimeException e) {
            if (lockSuccess){
                redisLockService.unlock(lockKey);
            }
            throw e;
        }
    }

    @Override
    public ActivityPlanDto atomSaveActivityPlan(ActivityPlanDto dto) {

        //校验必要参数
        this.checkAtomSave(dto);
        //保存活动方案主体
        ActivityPlan entity;
        entity = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlan.class, HashSet.class, ArrayList.class);
        // redis生成营销策略编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
        String code = this.generateCode();
        entity.setPlanCode(code);
        entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
        Boolean tempSave = Optional.ofNullable(dto.getTempSave()).orElse(false);
        entity.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
        entity.setPlanStatus(ActivityPlanStatusEnum.normal.getCode());
        //activityPlanRepository.save(entity);
        //dto.setId(entity.getId());
        dto.setPlanCode(code);
        //保存方案-策略关联
        List<ActivityPlanStrategy> activityPlanStrategies = (List<ActivityPlanStrategy>) nebulaToolkitService.copyCollectionByWhiteList(dto.getStrategyList(), ActivityPlanStrategyDto.class, ActivityPlanStrategy.class, HashSet.class, ArrayList.class);
        for (ActivityPlanStrategy item : activityPlanStrategies) {
            item.setPlanCode(entity.getPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
        }
        //activityPlanStrategyRepository.saveBatch(activityPlanStrategies);

        //保存大区方案-方案关联
        List<ActivityPlanRelatePlan> activityPlanRelatePlans = (List<ActivityPlanRelatePlan>) nebulaToolkitService.copyCollectionByWhiteList(dto.getRelatePlanList(), ActivityPlanRelatePlanDto.class, ActivityPlanRelatePlan.class, HashSet.class, ArrayList.class);
        for (ActivityPlanRelatePlan item : activityPlanRelatePlans) {
            item.setPlanCode(entity.getPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
        }
        //activityPlanRelatePLanRepository.saveBatch(activityPlanRelatePlans);

        //保存方案-模板配置关联
        List<ActivityPlanTemplate> activityPlanTemplates = (List<ActivityPlanTemplate>) nebulaToolkitService.copyCollectionByWhiteList(dto.getTemplateList(), ActivityPlanTemplateDto.class, ActivityPlanTemplate.class, HashSet.class, ArrayList.class);

        for (ActivityPlanTemplate item : activityPlanTemplates) {
            item.setPlanCode(entity.getPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
        }
        //activityPlanTemplateRepository.saveBatch(activityPlanTemplates);

        //预算数据
        List<ActivityPlanBudget> activityPlanBudgetList = new ArrayList<>();
        //门店信息
        List<ActivityPlanItemTerminal> activityPlanItemTerminalList = new ArrayList<>();
        //保存方案明细
        List<ActivityPlanItemDto> itemList = dto.getItemList();
        List<ActivityPlanItemExtendField> extendFieldSaveList = new ArrayList<>();
        // redis生成活动方案明细编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
        String ruleCode = StringUtils.join(ActivityPlanConstant.ACTIVITY_PLAN_ITEM_RULE_CODE_PRE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        List<String> generateCodes = this.generateCodeService.generateCode(ruleCode, itemList.size(), 6, 2, TimeUnit.DAYS);
        Iterator<String> codeIterator = generateCodes.iterator();
        for (ActivityPlanItemDto itemDto : itemList) {
            itemDto.setPlanItemCode(codeIterator.next());
            itemDto.setPlanCode(entity.getPlanCode());
            itemDto.setId(null);
            String bonusType = itemDto.getBonusType();
            if (StringUtils.isNotEmpty(bonusType)) {
                String activityDesc = Optional.ofNullable(itemDto.getActivityDesc()).orElse("");
                activityDesc = activityDesc.replace("A-", "");
                activityDesc = activityDesc.replace("B-", "");
                if ("A-".equals(activityDesc) || "B-".equals(activityDesc)) {
                    activityDesc = "";
                }
                if (BonusTypeEnum.BONUS.getCode().equals(bonusType)) {
                    itemDto.setActivityDesc("A-" + activityDesc);
                }
                if (BonusTypeEnum.PURE_SEND.getCode().equals(bonusType)) {
                    itemDto.setActivityDesc("B-" + activityDesc);
                }
            }
            itemDto.setPlanCode(entity.getPlanCode());
            itemDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            itemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            itemDto.setIsClose(BooleanEnum.FALSE.getCapital());
            itemDto.setTenantCode(entity.getTenantCode());

            if (StringUtils.isNotEmpty(itemDto.getProductCode()) && itemDto.getProductCode().contains(",")) {
                //如果是多选的话，设置成空的，单独存表
                itemDto.setProductCode("");
                itemDto.setProductName("");
            }

            List<ActivityPlanItemExtendField> activityPlanItemExtendFields = extendFieldService.buildExtendFieldEntityList(itemDto, ActivityPlanItemExtendFieldBase.class, ActivityPlanItemExtendField.class);
            if (!CollectionUtils.isEmpty(activityPlanItemExtendFields)) {
                activityPlanItemExtendFields.forEach(item -> {
                    item.setPlanCode(itemDto.getPlanCode());
                    item.setPlanItemCode(itemDto.getPlanItemCode());
                    item.setTenantCode(itemDto.getTenantCode());
                });
                extendFieldSaveList.addAll(activityPlanItemExtendFields);
            }
            //保存方案-预算数据
            if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())) {
                itemDto.getBudgetShares().forEach(item -> {
                    item.setPlanItemCode(itemDto.getPlanItemCode());
                    item.setPlanCode(itemDto.getPlanCode());
                    item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                    item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    item.setTenantCode(entity.getTenantCode());
                    item.setId(null);
                });
                List<ActivityPlanBudget> activityPlanBudgets = (List<ActivityPlanBudget>) nebulaToolkitService.copyCollectionByWhiteList(itemDto.getBudgetShares(),ActivityPlanBudgetDto.class,ActivityPlanBudget.class,HashSet.class,ArrayList.class);
                activityPlanBudgetList.addAll(activityPlanBudgets);
                //activityPlanBudgetRepository.saveBatch(activityPlanBudgets);
            }

            //保存方案明细的门店信息
            List<ActivityPlanItemTerminalDto> terminalList = itemDto.getActivityPlanItemTerminalList();
            if (!CollectionUtils.isEmpty(terminalList)) {
                for (ActivityPlanItemTerminalDto terminalDto : terminalList) {
                    terminalDto.setPlanCode(entity.getPlanCode());
                    terminalDto.setPlanItemCode(itemDto.getPlanItemCode());
                    terminalDto.setBeginDate(itemDto.getActivityBeginDate());
                    terminalDto.setEndDate(itemDto.getActivityEndDate());
                    terminalDto.setTenantCode(TenantUtils.getTenantCode());
                }
                List<ActivityPlanItemTerminal> activityPlanItemTerminals = (List<ActivityPlanItemTerminal>)this.nebulaToolkitService.copyCollectionByBlankList(terminalList, ActivityPlanItemTerminalDto.class, ActivityPlanItemTerminal.class, LinkedHashSet.class, ArrayList.class);
                if(!CollectionUtils.isEmpty(activityPlanItemTerminals)){
                    activityPlanItemTerminalList.addAll(activityPlanItemTerminals);
                    //this.activityPlanItemTerminalRepository.saveBatch(activityPlanItemTerminals);
                }
            }

        }
        List<ActivityPlanItem> activityPlanItems = (List<ActivityPlanItem>)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanItemDto.class, ActivityPlanItem.class, HashSet.class, ArrayList.class);
        //activityPlanItemRepository.saveBatch(activityPlanItems);
        //保存明细拓展信息
        //activityPlanItemExtendFieldRepository.saveBatch(extendFieldSaveList);
        String dtoId = this.atomSaveActivityPlan(entity,activityPlanItems,activityPlanStrategies,activityPlanRelatePlans,activityPlanTemplates,activityPlanBudgetList,activityPlanItemTerminalList,extendFieldSaveList);
        dto.setId(dtoId);
        return dto;
    }

    @Transactional(rollbackFor = Exception.class)
    public String atomSaveActivityPlan(ActivityPlan entity,
                                       List<ActivityPlanItem> activityPlanItems,
                                       List<ActivityPlanStrategy> activityPlanStrategies,
                                       List<ActivityPlanRelatePlan> activityPlanRelatePlans,
                                       List<ActivityPlanTemplate> activityPlanTemplates,
                                       List<ActivityPlanBudget> activityPlanBudgetList,
                                       List<ActivityPlanItemTerminal> activityPlanItemTerminalList,
                                       List<ActivityPlanItemExtendField> extendFieldSaveList
                                       ) {
        Validate.notNull(entity,"活动方案基本信息不能为空！");
        //保存主表
        activityPlanRepository.save(entity);
        String id = entity.getId();
        if (!CollectionUtils.isEmpty(activityPlanStrategies)){
            //保存方案-策略关联
            activityPlanStrategyRepository.saveBatch(activityPlanStrategies);
        }
        if (!CollectionUtils.isEmpty(activityPlanRelatePlans)){
            //保存大区方案-方案关联
            activityPlanRelatePLanRepository.saveBatch(activityPlanRelatePlans);
        }
        if (!CollectionUtils.isEmpty(activityPlanTemplates)){
            //保存方案-模板配置关联
            activityPlanTemplateRepository.saveBatch(activityPlanTemplates);
        }
        if (!CollectionUtils.isEmpty(activityPlanItems)) {
            //保存明细表
            activityPlanItemRepository.saveBatch(activityPlanItems);
            if(!CollectionUtils.isEmpty(extendFieldSaveList)) {
                //保存明细拓展信息
                activityPlanItemExtendFieldRepository.saveBatch(extendFieldSaveList);
            }
            if (!CollectionUtils.isEmpty(activityPlanBudgetList)){
                //保存方案-预算数据
                activityPlanBudgetRepository.saveBatch(activityPlanBudgetList);
            }
            if (!CollectionUtils.isEmpty(activityPlanItemTerminalList)){
                //保存方案明细的门店信息
                this.activityPlanItemTerminalRepository.saveBatch(activityPlanItemTerminalList);
            }
        }
        return id;
    }


    /**
     * 原子保存接口校验（只校验必要参数是否为空）
     */
    private void checkAtomSave(ActivityPlanDto dto) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        if (!StringUtils.isBlank(dto.getBeginDateStr())) {
            try {
                Date beginDate = dayFormat.parse(dto.getBeginDateStr());
                dto.setBeginDate(beginDate);
            } catch (Exception e) {
                throw new RuntimeException("方案开始时间格式有误！");
            }
        }
        if (!StringUtils.isBlank(dto.getEndDateStr())) {
            try {
                Date endDate = dayFormat.parse(dto.getEndDateStr());
                dto.setEndDate(endDate);
            } catch (Exception e) {
                throw new RuntimeException("方案结束时间格式有误！");
            }
        }
        //主表基础信息非空校验
        Assert.isTrue(StringUtils.isNotEmpty(dto.getPlanName()), "方案名称不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getPlanType()), "方案类型不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getBusinessFormatCode()), "业态不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getBusinessUnitCode()), "业务单元不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getDepartmentCode()), "部门编码不能为空！");
//        Assert.isTrue(StringUtils.isNotEmpty(dto.getDepartmentName()),"部门名称不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getBeginDateStr()), "方案开始时间不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getEndDateStr()), "方案结束时间不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getPlanOrgCode()), "方案范围编码不能为空！");
//        Assert.isTrue(StringUtils.isNotEmpty(dto.getPlanOrgName()),"方案范围名称不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getPlanClassify()), "方案分类不能为空！");
        Assert.isTrue(StringUtils.isNotEmpty(dto.getPlanRelateLimitCode()), "方案方案关联限制不能为空！");

        //营销策略非空校验
        List<ActivityPlanStrategyDto> strategyList = dto.getStrategyList();
        if (!CollectionUtils.isEmpty(strategyList)) {
            for (ActivityPlanStrategyDto strategyDto : strategyList) {
                Assert.isTrue(StringUtils.isNotEmpty(strategyDto.getStrategyCode()), "营销策略-营销策略编码不能为空！");
//                Assert.isTrue(StringUtils.isNotEmpty(strategyDto.getStrategyName()),"营销策略-营销策略名称不能为空！");
                Assert.isTrue(StringUtils.isNotEmpty(strategyDto.getStrategyItemCode()), "营销策略-营销策略明细编码不能为空！");
                Assert.isTrue(StringUtils.isNotEmpty(strategyDto.getStrategyType()), "营销策略-营销策略类型不能为空！");
                Assert.isTrue(ObjectUtils.isNotEmpty(strategyDto.getUseAmount()), "营销策略-本次使用策略金额不能为空！");
            }
        }

        //方案关联非空校验
        List<ActivityPlanRelatePlanDto> relatePlanList = dto.getRelatePlanList();
        if (!CollectionUtils.isEmpty(relatePlanList)) {
            for (ActivityPlanRelatePlanDto planDto : relatePlanList) {
                Assert.isTrue(ObjectUtils.isNotEmpty(planDto.getRelatePlanCode()), "方案关联-关联方案编码不能为空！");
//                Assert.isTrue(ObjectUtils.isNotEmpty(planDto.getRelatePlanName()),"方案关联-关联方案名称不能为空！");
                Assert.isTrue(ObjectUtils.isNotEmpty(planDto.getRelateOrgName()), "方案关联-关联方案范围不能为空！");
                Assert.isTrue(ObjectUtils.isNotEmpty(planDto.getRelatePlanBeginDate()), "方案关联-关联方案开始时间不能为空！");
                Assert.isTrue(ObjectUtils.isNotEmpty(planDto.getRelatePlanEndDate()), "方案关联-关联方案结束时间不能为空！");
            }
        }

        //模板配置非空校验
        List<ActivityPlanTemplateDto> templateList = dto.getTemplateList();
        if (!CollectionUtils.isEmpty(templateList)) {
            for (ActivityPlanTemplateDto templateDto : templateList) {
                Assert.isTrue(ObjectUtils.isNotEmpty(templateDto.getTemplateConfigCode()), "模板配置-方案模板编码不能为空！");
//                Assert.isTrue(ObjectUtils.isNotEmpty(templateDto.getTemplateConfigName()),"模板配置-方案模板名称不能为空！");
                Assert.isTrue(ObjectUtils.isNotEmpty(templateDto.getAuditType()), "模板配置-核销类型不能为空！");
                Assert.isTrue(ObjectUtils.isNotEmpty(templateDto.getAuditConditionCode()), "模板配置-核销条件编码不能为空！");
//                Assert.isTrue(ObjectUtils.isNotEmpty(templateDto.getAuditConditionName()),"模板配置-核销条件名称不能为空！");
            }
        }

        //活动方案明细非空校验
        List<ActivityPlanItemDto> itemList = dto.getItemList();
        if (!CollectionUtils.isEmpty(itemList)) {
            for (ActivityPlanItemDto itemDto : itemList) {
                //门店明细非空校验
                List<ActivityPlanItemTerminalDto> terminalList = itemDto.getActivityPlanItemTerminalList();
                if (!CollectionUtils.isEmpty(terminalList)) {
                    for (ActivityPlanItemTerminalDto terminalDto : terminalList) {
                        Assert.isTrue(StringUtils.isNotEmpty(terminalDto.getTerminalCode()), "门店明细-门店编码不能为空！");
                        Assert.isTrue(StringUtils.isNotEmpty(terminalDto.getName()), "门店明细-用户姓名不能为空！");
                        Assert.isTrue(ObjectUtils.isNotEmpty(terminalDto.getQuantity()), "门店明细-数量不能为空！");
                        Assert.isTrue(ObjectUtils.isNotEmpty(terminalDto.getAmount()), "门店明细-金额不能为空！");
                        Assert.isTrue(ObjectUtils.isNotEmpty(terminalDto.getFloatingRate()), "门店明细-浮动率不能为空！");
                    }
                }
                //预算使用信息非空校验
                List<ActivityPlanBudgetDto> budgetList = itemDto.getBudgetShares();
                if (!CollectionUtils.isEmpty(budgetList)) {
                    for (ActivityPlanBudgetDto budgetDto : budgetList) {
                        Assert.isTrue(StringUtils.isNotEmpty(budgetDto.getBudgetItemCode()), "预算使用-预算项目编码不能为空！");
//                        Assert.isTrue(StringUtils.isNotEmpty(budgetDto.getBudgetItemName()),"预算使用-预算项目名称不能为空！");
                        Assert.isTrue(StringUtils.isNotEmpty(budgetDto.getYearMonthLy()), "预算使用-年月不能为空！");
                        Assert.isTrue(StringUtils.isNotEmpty(budgetDto.getFeeBelongCode()), "预算使用-归口不能为空！");
                        Assert.isTrue(ObjectUtils.isNotEmpty(budgetDto.getUseAmount()), "预算使用-使用金额不能为空！");
                    }
                }
            }
        }

    }

    /**
     * 活动方案新增编辑
     *
     * @param itemDtoList 活动方案明细数据
     * @param cacheKey
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityPlan(ActivityPlanDto dto, List<ActivityPlanItemDto> itemDtoList, String cacheKey,List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList) {
        ActivityPlan entity;
        boolean tempSave = Optional.ofNullable(dto.getTempSave()).orElse(false);
        boolean update = !StringUtils.isBlank(dto.getId());
        ActivityPlanDto oldDto = new ActivityPlanDto();

        if (update){
            //更新数据，先赋值一些属性
            ActivityPlan oldEntity = activityPlanRepository.getById(dto.getId());
            if (null == oldEntity){
                throw new RuntimeException("数据不存在！");
            }
            if (!ProcessStatusEnum.PREPARE.getKey().equals(oldEntity.getProcessStatus()) &&
                    !ProcessStatusEnum.REJECT.getKey().equals(oldEntity.getProcessStatus()) &&
                    !ProcessStatusEnum.RECOVER.getKey().equals(oldEntity.getProcessStatus())) {
                throw new RuntimeException("只能编辑待提交、驳回、追回状态的数据！");
            }
            dto.setPlanCode(oldEntity.getPlanCode());
            dto.setTenantCode(oldEntity.getTenantCode());
            dto.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            dto.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            dto.setPlanStatus(ActivityPlanStatusEnum.normal.getCode());
            dto.setWhereFrom(oldEntity.getWhereFrom());
            oldDto = nebulaToolkitService.copyObjectByWhiteList(oldEntity, ActivityPlanDto.class, HashSet.class, ArrayList.class);
        }

        if (tempSave){
            activityPlanItemPageCacheHelper.sendMsg("开始处理数据...");
            tempSaveValidate(dto,itemDtoList,relateDetailItemDtoList);
        }else {
            activityPlanItemPageCacheHelper.sendMsg("开始校验数据...");
            createValidate(dto,itemDtoList,relateDetailItemDtoList);
        }
        if (!update) {
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlan.class, HashSet.class, ArrayList.class);
            // redis生成营销策略编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
            String code = this.generateCode();
            entity.setPlanCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            entity.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            entity.setPlanStatus(ActivityPlanStatusEnum.normal.getCode());
            entity.setWhereFrom(ActivityPlanWhereFrom.MANUAL.getCode());
            activityPlanRepository.save(entity);
        } else {
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlan.class, HashSet.class, ArrayList.class);
            activityPlanRepository.updateById(entity);
        }
        activityPlanItemPageCacheHelper.sendMsg("开始保存数据...");
        //保存方案-策略关联
        activityPlanStrategyService.saveActivityPlanStrategyList(entity, update, dto.getStrategyList());

        //保存大区方案-方案关联
        activityPlanRelatePlanService.saveActivityPlanRelatePlanList(entity, update, dto.getRelatePlanList());

        //保存方案-模板配置关联
        activityPlanTemplateService.saveActivityPlanTemplateList(entity, update, dto.getTemplateList());
        activityPlanItemPageCacheHelper.sendMsg("开始保存方案明细...");
        //保存方案明细
        activityPlanItemService.saveActivityPlanItemList(entity, update, itemDtoList,false,tempSave);
        activityPlanItemPageCacheHelper.sendMsg("开始保存方案明细门店信息...");
        //保存方案明细的门店信息
        activityPlanItemTerminalService.saveActivityPlanItemTerminal(entity, update, itemDtoList, cacheKey);
        //保存方案关联细案明细数据
        activityPlanItemRelateDetailItemService.savePlanItemRelateDetailItem(entity,update,relateDetailItemDtoList);

        activityPlanItemPageCacheHelper.sendMsg("正在保存业务日志！");
        //新增修改业务日志
        ActivityPlanLogEventDto logEventDto = new ActivityPlanLogEventDto();
        dto.setId(entity.getId());
        logEventDto.setNewest(dto);
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanLogEventDto> onCreate =
                    ActivityPlanLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onCreate);
        } else {
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanLogEventDto> onUpdate =
                    ActivityPlanLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onUpdate);
        }
        activityPlanItemPageCacheHelper.sendMsg("数据保存成功！", ExecStatusEnum.FINISH.getKey());
    }

    private void tempSaveValidate(ActivityPlanDto dto, List<ActivityPlanItemDto> itemCacheList, List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        if (!StringUtils.isBlank(dto.getBeginDateStr())) {
            try {
                Date beginDate = dayFormat.parse(dto.getBeginDateStr());
                dto.setBeginDate(beginDate);
            } catch (Exception e) {
                throw new RuntimeException("方案开始时间格式有误！");
            }
        }
        if (!StringUtils.isBlank(dto.getEndDateStr())) {
            try {
                Date endDate = dayFormat.parse(dto.getEndDateStr());
                dto.setEndDate(endDate);
            } catch (Exception e) {
                throw new RuntimeException("方案结束时间格式有误！");
            }
        }

        initIndexNo(itemCacheList);
        activityPlanItemService.tempSaveValidata(dto,itemCacheList);
    }

    private void initIndexNo(List<ActivityPlanItemDto> itemCacheList){
        int size = itemCacheList.size();
        for (int i = 0; i < size; i++) {
            ActivityPlanItemDto itemDto = itemCacheList.get(i);
            itemDto.setIndexNo(i+1);
        }
    }

    /**
     * 策略新增保存逻辑
     *  @param dto           策略数据
     * @param itemCacheList 策略行数据
     * @param relateDetailItemDtoList
     */
    private void createValidate(ActivityPlanDto dto, List<ActivityPlanItemDto> itemCacheList, List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList) {
        Validate.notNull(dto, "新增时，对象信息不能为空！");
//        方案编码：提交时系统自动生成，可不显示。
        Validate.notBlank(dto.getBusinessFormatCode(), "新增时，业态不能为空！");
        Validate.notBlank(dto.getBusinessUnitCode(), "新增时，业务单元不能为空！");
//        方案名称：输入框、必填项，提交时校验不能为空。
        Validate.notBlank(dto.getPlanName(), "新增时，方案名称不能为空！");
//        方案类型：下拉单选框、必填项 ，提交时校验不能为空；下拉选项值（数据字典）：总部方案、大区方案、分子公司方案、垂直重客方案、电商方案；选总部方案，不显示关联方案内容。选其他方案，均显示关联方案内容。
        Validate.notBlank(dto.getPlanType(), "新增时，方案类型不能为空！");
//        方案范围：下拉多选框、必填项，提交时校验不能为空；数据来源于组织主数据；方案范围影响填写方案内容时区域范围的选择，区域只能在方案范围之内的组织数据选择。
//        Validate.notBlank(dto.getPlanOrgCode(), "新增时，方案范围不能为空！");
//        预估费用：系统自动计算，等于方案使用预算金额的累计值。
//        方案投产比：系统自动自动计算，计算逻辑：预结案金额/销售额。
//        方案时间：时间选择器（年月日）、必填项，提交是校验不能为空。
        Validate.notBlank(dto.getBeginDateStr(), "新增时，方案开始时间不能为空！");
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            Date beginDate = dayFormat.parse(dto.getBeginDateStr());
            dto.setBeginDate(beginDate);
        } catch (Exception e) {
            throw new RuntimeException("方案开始时间格式有误！");
        }
        Validate.notBlank(dto.getEndDateStr(), "新增时，方案结束时间不能为空！");
        try {
            Date endDate = dayFormat.parse(dto.getEndDateStr());
            dto.setEndDate(endDate);
        } catch (Exception e) {
            throw new RuntimeException("方案结束时间格式有误！");
        }
//        方案关联限制：下拉单选框，总部方案为必填项，其他方案为不必填项；下拉选项值（数据字典）：核销后申请、核销前申请。1）核销后申请：计算方案达成及方案可核销金额，区域关联方案，以方案可核销金额为上限申请细案（允许补强），活动执行结束后系统按活动细案计算结案；2）核销前申请：跟据活动细案同时计算方案达成条件及核销金额、计算细案达成条件及核销金额，自动校验对比，细案中可使用的金额不允许超方案金额。
        if (ActivityPlanTypeEnum.headquarters.getCode().equals(dto.getPlanType())) {
            Validate.notBlank(dto.getPlanRelateLimitCode(), "新增时，总部方案方案关联限制不能为空！");
        }
//        方案主题：输入框、必填项；提交时校验不能为空。
//        Validate.notBlank(dto.getPlanTitle(), "新增时，方案主题不能为空！");
//        方案目的：文本框、必填项；提交时不能为空。
//        Validate.notBlank(dto.getPlanGoal(), "新增时，方案目的不能为空！");
//        活动背景：文本框、必填项；提交时不能为空。
//        Validate.notBlank(dto.getActivityBackground(), "新增时，活动背景不能为空！");
//        活动目标：文本框、必填项；提交时不能为空。
//        Validate.notBlank(dto.getActivityTarget(), "新增时，活动目标不能为空！");
//        明细说明：文本框、必填项；提交时不能为空。
//        Validate.notBlank(dto.getDetailExplain(), "新增时，明细说明不能为空！");
        Validate.notBlank(dto.getPlanClassify(), "新增时，方案分类不能为空！");
        Validate.isTrue(!CollectionUtils.isEmpty(itemCacheList), "新增时，方案明细不能为空");

        initIndexNo(itemCacheList);
        activityPlanItemService.createValidateList(dto,itemCacheList);

        activityPlanItemPageCacheHelper.sendMsg("开始处理方案预算信息...");
        List<ActivityPlanBudgetDto> budgetDtos = matchActivityPlanBudgetRelate(dto,itemCacheList);
        activityPlanItemPageCacheHelper.sendMsg("正在校验预算余额...");
        activityPlanBudgetService.useMonthBudget(budgetDtos,false);
        useInventoryCheck(dto,itemCacheList,false);

        Map<String, BigDecimal> strategyUseAmountMap = Maps.newHashMap();
        Map<String, BigDecimal> relatePlanUseAmountMap = Maps.newHashMap();

        //设置表头汇总金额
        BigDecimal budgetFeeAmount = BigDecimal.ZERO;
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal departmentFeeAmount = BigDecimal.ZERO;
        BigDecimal customerFeeAmount = BigDecimal.ZERO;
        BigDecimal totalFeeAmount = BigDecimal.ZERO;
        BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
        BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;

        //编辑的时候校验活动方案关联细案明细
        boolean update = StringUtils.isNotEmpty(dto.getId());
        Map<String, List<ActivityPlanItemRelateDetailItemDto>> relateDetailItemMap = new HashMap<>();
        Map<String, ActivitiesTemplateConfigVo> activitiesTemplateConfigMap = new HashMap<>();
        Map<String, String> carGiftGroupMap = dictToolkitService.findMapByDictTypeCode(ActivityPlanConstant.carGiftGroup);
        itemCacheList.forEach(item -> {
            if (StringUtil.isNotEmpty(item.getCarGiftGroup())) {
                Assert.isTrue(carGiftGroupMap.containsKey(item.getCarGiftGroup()), "随车搭赠模板不合法");
            }
        });
        if(update) {
            //随车搭赠 904 关联细案明细必须为空
            if(CarGiftGroupEnum.GroupB.getCode().equals(itemCacheList.get(0).getCarGiftGroup())){
                Validate.isTrue(CollectionUtils.isEmpty(relateDetailItemDtoList),"随车搭赠组合904关联细案明细必须为空");
            }
            if (!CollectionUtils.isEmpty(relateDetailItemDtoList)) {
                for (ActivityPlanItemRelateDetailItemDto relateDetailItemDto : relateDetailItemDtoList) {
                    Validate.notBlank(relateDetailItemDto.getPlanItemCode(), "活动方案关联细案明细的方案明细编码不能为空");
                }
                relateDetailItemMap = relateDetailItemDtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemRelateDetailItemDto::getPlanItemCode));
                List<String> templateConfigCodes = itemCacheList.stream().map(ActivityPlanItemDto::getTemplateConfigCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(templateConfigCodes)) {
                    List<ActivitiesTemplateConfigVo> activitiesTemplateConfigList = activitiesTemplateSdkService.findByCodeList(templateConfigCodes);
                    activitiesTemplateConfigMap = activitiesTemplateConfigList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
                }
            }
        }else {
            Validate.isTrue(CollectionUtils.isEmpty(relateDetailItemDtoList),"新增不能选择关联细案明细数据");
        }
        for (ActivityPlanItemDto activityPlanItemDto : itemCacheList) {
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                //费用总金额要=总部+大区+客户
                BigDecimal feeTotal = bdNull(activityPlanItemDto.getHeadFeeAmount())
                        .add(bdNull(activityPlanItemDto.getDepartmentFeeAmount()))
                        .add(bdNull(activityPlanItemDto.getCustomerFeeAmount()));
                Validate.isTrue(feeTotal.compareTo(activityPlanItemDto.getTotalFeeAmount()) == 0, "费用总金额不等于总部承担金额加大区承担金额加客户承担金额");
            }
            BigDecimal thisFeeAmount = BigDecimal.ZERO;
            if (null != activityPlanItemDto.getHeadFeeAmount()) {
                headFeeAmount = headFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
            }
            if (null != activityPlanItemDto.getDepartmentFeeAmount()) {
                departmentFeeAmount = departmentFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
            }
            if (null != activityPlanItemDto.getCustomerFeeAmount()) {
                customerFeeAmount = customerFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                activityPlanItemDto.setFeeAmount(thisFeeAmount);
            }
            if (null != activityPlanItemDto.getFeeAmount()) {
                feeAmount = feeAmount.add(activityPlanItemDto.getFeeAmount());
            }
            if (null != activityPlanItemDto.getRegionAutomaticFeeAmount()) {
                regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(activityPlanItemDto.getRegionAutomaticFeeAmount());
            }
            if (null != activityPlanItemDto.getRegionReferendumFeeAmount()) {
                regionReferendumFeeAmount = regionReferendumFeeAmount.add(activityPlanItemDto.getRegionReferendumFeeAmount());
            }
            if (null != activityPlanItemDto.getTotalFeeAmount()) {
                totalFeeAmount = totalFeeAmount.add(activityPlanItemDto.getTotalFeeAmount());
                if (!CollectionUtils.isEmpty(activityPlanItemDto.getBudgetShares())) {
                    for (ActivityPlanBudgetDto budgetShare : activityPlanItemDto.getBudgetShares()) {
                        if (null != budgetShare.getUseAmount()) {
                            budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
                        }
                        if (StringUtils.isNotEmpty(budgetShare.getRelateStrategyItemCode())) {
                            BigDecimal strategyUseAmount = Optional.ofNullable(strategyUseAmountMap.get(budgetShare.getRelateStrategyItemCode())).orElse(BigDecimal.ZERO);
                            strategyUseAmountMap.put(budgetShare.getRelateStrategyItemCode(), strategyUseAmount.add(budgetShare.getUseAmount()));
                        }
                        if (StringUtils.isNotEmpty(budgetShare.getRelatePlanCode())) {
                            BigDecimal relatePlanUseAmount = Optional.ofNullable(relatePlanUseAmountMap.get(budgetShare.getRelatePlanCode())).orElse(BigDecimal.ZERO);
                            relatePlanUseAmountMap.put(budgetShare.getRelatePlanCode(), relatePlanUseAmount.add(budgetShare.getUseAmount()));
                        }
                    }
                }
            }
            if(update) {
                if(!CarGiftGroupEnum.GroupB.getCode().equals(itemCacheList.get(0).getCarGiftGroup())) {
                    ActivitiesTemplateConfigVo activitiesTemplateConfigVo = activitiesTemplateConfigMap.get(activityPlanItemDto.getTemplateConfigCode());
                    if (activitiesTemplateConfigVo != null) {
                        if (GenerateRuleEnum.RELATE_DETAIL_PLAN.getCode().equals(activitiesTemplateConfigVo.getGenerateRule())) {
                            List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList1 = relateDetailItemMap.get(activityPlanItemDto.getPlanItemCode());
                            Validate.isTrue(!CollectionUtils.isEmpty(relateDetailItemDtoList1), "方案明细编码【%s】关联细案没有数据", activityPlanItemDto.getPlanItemCode());
                            //费用合计
                            BigDecimal totalFeeAmount2 = relateDetailItemDtoList1.stream().filter(o -> StringUtils.isNotEmpty(o.getTotalFeeAmountStr())).map(o -> new BigDecimal(o.getTotalFeeAmountStr())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            BigDecimal itemTotalFeeAmount = new BigDecimal(Optional.ofNullable(activityPlanItemDto.getTotalFeeAmountStr()).orElse("0"));
                            Validate.isTrue(totalFeeAmount2.compareTo(itemTotalFeeAmount) == 0, "方案明细编码【%s】费用合计金额["+itemTotalFeeAmount+"]与关联的细案明细费用合计金额["+totalFeeAmount2+"]不相等", activityPlanItemDto.getPlanItemCode());
                            //总部承担金额
                            BigDecimal headFeeAmount2 = relateDetailItemDtoList1.stream().filter(o -> StringUtils.isNotEmpty(o.getHeadFeeAmountStr())).map(o -> new BigDecimal(o.getHeadFeeAmountStr())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            Validate.isTrue(headFeeAmount2.compareTo(new BigDecimal(Optional.ofNullable(activityPlanItemDto.getHeadFeeAmountStr()).orElse("0"))) == 0, "方案明细编码【%s】总部承担金额与关联的细案明细总部承担金额不相等", activityPlanItemDto.getPlanItemCode());
                            //大区承担金额
                            BigDecimal departmentFeeAmount2 = relateDetailItemDtoList1.stream().filter(o -> StringUtils.isNotEmpty(o.getDepartmentFeeAmountStr())).map(o -> new BigDecimal(o.getDepartmentFeeAmountStr())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            Validate.isTrue(departmentFeeAmount2.compareTo(new BigDecimal(Optional.ofNullable(activityPlanItemDto.getDepartmentFeeAmountStr()).orElse("0"))) == 0, "方案明细编码【%s】大区承担金额与关联的细案明细大区承担金额不相等", activityPlanItemDto.getPlanItemCode());
                            //客户承担金额
                            BigDecimal customerFeeAmount2 = relateDetailItemDtoList1.stream().filter(o -> StringUtils.isNotEmpty(o.getCustomerFeeAmountStr())).map(o -> new BigDecimal(o.getCustomerFeeAmountStr())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            Validate.isTrue(customerFeeAmount2.compareTo(new BigDecimal(Optional.ofNullable(activityPlanItemDto.getCustomerFeeAmountStr()).orElse("0"))) == 0, "方案明细编码【%s】客户承担金额与关联的细案明细客户承担金额不相等", activityPlanItemDto.getPlanItemCode());
                            for (ActivityPlanItemRelateDetailItemDto relateDetailItemDto : relateDetailItemDtoList1) {
                                if (StringUtils.isNotEmpty(relateDetailItemDto.getCarGiftGroup())) {
                                    //有填随车搭赠组合，做校验
                                    if (StringUtils.isEmpty(relateDetailItemDto.getSalesInstitutionCode())) {
                                        throw new RuntimeException("随车搭赠组合[" + relateDetailItemDto.getCarGiftGroup() + "]销售机构不能为空!");
                                    }
                                    if (StringUtils.isEmpty(relateDetailItemDto.getProductCode())) {
                                        throw new RuntimeException("随车搭赠组合[" + relateDetailItemDto.getCarGiftGroup() + "]物料不能为空!");
                                    }
                                    if (StringUtils.isEmpty(relateDetailItemDto.getSalesRegionCode()) &&
                                            (
                                                    CarGiftGroupEnum.GroupA.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupE.getCode().equals(relateDetailItemDto.getCarGiftGroup())
                                            )) {
                                        throw new RuntimeException("随车搭赠组合[" + relateDetailItemDto.getCarGiftGroup() + "]销售部门不能为空!");
                                    }
                                    if (StringUtils.isEmpty(relateDetailItemDto.getDistributionChannelCode()) &&
                                            (
                                                    CarGiftGroupEnum.GroupD.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupE.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupF.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupG.getCode().equals(relateDetailItemDto.getCarGiftGroup())
                                            )) {
                                        throw new RuntimeException("随车搭赠组合[" + relateDetailItemDto.getCarGiftGroup() + "]分销渠道不能为空!");
                                    }
                                    if (StringUtils.isEmpty(relateDetailItemDto.getCustomerGroupCode()) &&
                                            (
                                                    CarGiftGroupEnum.GroupA.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupC.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupD.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupE.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupG.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupI.getCode().equals(relateDetailItemDto.getCarGiftGroup())
                                            )) {
                                        throw new RuntimeException("随车搭赠组合[" + relateDetailItemDto.getCarGiftGroup() + "]客户组不能为空!");
                                    }
                                    if (StringUtils.isEmpty(relateDetailItemDto.getCustomerCode()) &&
                                            (
                                                    CarGiftGroupEnum.GroupB.getCode().equals(relateDetailItemDto.getCarGiftGroup())
                                            )) {
                                        throw new RuntimeException("随车搭赠组合[" + relateDetailItemDto.getCarGiftGroup() + "]客户不能为空!");
                                    }
                                    if (StringUtils.isEmpty(relateDetailItemDto.getSalesOrgCode()) &&
                                            (
                                                    CarGiftGroupEnum.GroupC.getCode().equals(relateDetailItemDto.getCarGiftGroup()) ||
                                                            CarGiftGroupEnum.GroupD.getCode().equals(relateDetailItemDto.getCarGiftGroup())
                                            )) {
                                        throw new RuntimeException("随车搭赠组合[" + relateDetailItemDto.getCarGiftGroup() + "]销售组不能为空!");
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (null != dto.getSalesAmount() && dto.getSalesAmount().compareTo(BigDecimal.ZERO) != 0) {
            if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                //方案投产比=费用合计/预估销售额   垂直
                dto.setPlanIoRate(feeAmount.divide(dto.getSalesAmount(), 2, RoundingMode.HALF_DOWN));
            } else {
                //方案投产比=（总计总部承担金额+总计大区承担金额）/预估销售额    主体
                dto.setPlanIoRate(totalFeeAmount.add(departmentFeeAmount).divide(dto.getSalesAmount(), 2, RoundingMode.HALF_DOWN));
            }
        }
        dto.setFeeAmount(feeAmount);
        dto.setHeadFeeAmount(headFeeAmount);
        dto.setDepartmentFeeAmount(departmentFeeAmount);
        dto.setCustomerFeeAmount(customerFeeAmount);
        dto.setTotalFeeAmount(totalFeeAmount);
        dto.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
        dto.setRegionReferendumFeeAmount(regionReferendumFeeAmount);

        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            //垂直多选预算，校验预算金额之和要等于行上的费用金额
            if (feeAmount.compareTo(budgetFeeAmount) != 0) {
                throw new RuntimeException("费用金额[" + feeAmount + "]不等于实际预算使用金额[" + budgetFeeAmount + "]");
            }
        }


        if (strategyUseAmountMap.size() > 0) {
            List<ActivityPlanStrategyDto> strategyList = dto.getStrategyList();
            if (!CollectionUtils.isEmpty(strategyList)) {
                Map<String, ActivityPlanStrategyDto> strategyMap = strategyList.stream().collect(Collectors.toMap(ActivityPlanStrategyDto::getStrategyItemCode, Function.identity(), (o, n) -> n));
                for (Map.Entry<String, BigDecimal> entry : strategyUseAmountMap.entrySet()) {
                    ActivityPlanStrategyDto strategyDto = strategyMap.get(entry.getKey());
                    if (null != strategyDto) {
                        strategyDto.setUseAmount(entry.getValue());
                    }
                }
            }
        }
        if (relatePlanUseAmountMap.size() > 0) {
            List<ActivityPlanRelatePlanDto> relatePlanList = dto.getRelatePlanList();
            if (!CollectionUtils.isEmpty(relatePlanList)) {
                Map<String, ActivityPlanRelatePlanDto> relatePlanMap = relatePlanList.stream().collect(Collectors.toMap(ActivityPlanRelatePlanDto::getRelatePlanCode, Function.identity(), (o, n) -> n));
                for (Map.Entry<String, BigDecimal> entry : relatePlanUseAmountMap.entrySet()) {
                    ActivityPlanRelatePlanDto planRelatePlanDto = relatePlanMap.get(entry.getKey());
                    if (null != planRelatePlanDto) {
                        planRelatePlanDto.setUseAmount(entry.getValue());
                    }
                }
            }
        }
    }

    /**
     * 活动方案预算关联策略、方案
     *
     * @param planDto 方案头数据
     */
    public List<ActivityPlanBudgetDto> matchActivityPlanBudgetRelate(ActivityPlanDto planDto, List<ActivityPlanItemDto> itemList) {
        List<ActivityPlanStrategyDto> strategyList = planDto.getStrategyList();
        List<ActivityPlanRelatePlanDto> relatePlanList = planDto.getRelatePlanList();
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
            //总部方案，关联策略不能为空
            if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())) {
                Validate.isTrue(!CollectionUtils.isEmpty(strategyList), "总部方案关联策略不能为空!");
            } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                Validate.isTrue(!CollectionUtils.isEmpty(strategyList) || !CollectionUtils.isEmpty(relatePlanList), "大区方案关联策略和方案不能同时为空!");
            } else {
                throw new RuntimeException("方案类型有误");
            }
        }

        Set<String> monthBudgetCodeSet = Sets.newHashSet();
        Map<String, List<MarketingStrategyBudgetDto>> relateStrategyBudgetMap = Maps.newHashMap();
        Map<String, List<MarketingStrategyBudgetDto>> strategyBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(strategyList)) {
            List<String> strategyItemCodeList = strategyList.stream().map(ActivityPlanStrategyDto::getStrategyItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<String> strategyCodeList = strategyList.stream().map(ActivityPlanStrategyDto::getStrategyCode).distinct().collect(Collectors.toList());
            MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
            budgetDto.setStrategyCodeList(strategyCodeList);
            budgetDto.setStrategyItemCodeList(strategyItemCodeList);
            List<MarketingStrategyBudgetDto> strategyBudgetDtos = marketingStrategyBudgetSdkService.findListByConditions(budgetDto);
            relateStrategyBudgetMap = strategyBudgetDtos.stream().collect(Collectors.groupingBy(MarketingStrategyBudgetDto::getMonthBudgetCode));
            strategyBudgetMap = strategyBudgetDtos.stream().collect(Collectors.groupingBy(MarketingStrategyBudgetDto::getStrategyItemCode));
            monthBudgetCodeSet.addAll(strategyBudgetDtos.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }

        Map<String, List<ActivityPlanBudget>> relatePlanBudgetMap = Maps.newHashMap();
        Map<String, List<ActivityPlanBudget>> planBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(relatePlanList)) {
            List<String> planCodeList = relatePlanList.stream().map(ActivityPlanRelatePlanDto::getRelatePlanCode).distinct().collect(Collectors.toList());
            List<ActivityPlanBudget> activityPlanBudgets = activityPlanBudgetRepository.listByPlanCodeList(planCodeList);
            relatePlanBudgetMap = activityPlanBudgets.stream().filter(item -> StringUtils.isNotEmpty(item.getMonthBudgetCode())).collect(Collectors.groupingBy(ActivityPlanBudget::getMonthBudgetCode));
            planBudgetMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudget::getPlanItemCode));

            monthBudgetCodeSet.addAll(activityPlanBudgets.stream().map(ActivityPlanBudget::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }
        //查下月度预算信息，保存费用归口
        Map<String, MonthBudgetVo> monthBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(monthBudgetCodeSet)) {
            List<MonthBudgetVo> monthBudgetList = monthBudgetService.listByCodes(Lists.newArrayList(monthBudgetCodeSet));
            monthBudgetMap = monthBudgetList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        }


        List<ActivityPlanBudgetDto> budgetDtos = Lists.newArrayList();
        for (int i = 0; i < itemList.size(); i++) {
            ActivityPlanItemDto itemDto = itemList.get(i);
            if (itemDto.getIndexNo()%500 == 0){
                activityPlanItemPageCacheHelper.sendMsg("正在处理第["+itemDto.getIndexNo()+"]条方案明细预算信息...");
            }
            //业务单元不是垂直，清空掉明细上的预算信息，按明细上的预算信息重新保存
            List<ActivityPlanBudgetDto> budgetList = Lists.newArrayList();
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
                //其他业务单元重新组装预算信息
                if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())) {
                    Validate.isTrue(!StringUtils.isEmpty(itemDto.getHeadMonthBudgetCode()), "总部方案总部预算不能为空!");
                } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                    Validate.isTrue(!StringUtils.isEmpty(itemDto.getHeadMonthBudgetCode()) || !StringUtils.isEmpty(itemDto.getMonthBudgetCode()), "大区方案总部预算和大区预算不能同时为空!");
                }
                if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())) {
                    BigDecimal headFeeAmount = itemDto.getHeadFeeAmount();
                    if (null == headFeeAmount || BigDecimal.ZERO.compareTo(headFeeAmount) == 0) {
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择总部预算后总部承担金额不能为空或0");
                    }
                } else {
                    if (null != itemDto.getHeadFeeAmount() && itemDto.getHeadFeeAmount().compareTo(BigDecimal.ZERO) != 0) {
                        throw new RuntimeException("未选择总部预算编码，总部承担金额只能为0");
                    }
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                        if (StringUtils.isNotEmpty(itemDto.getRelatePlanItemCode())) {
                            throw new RuntimeException("大区方案未填写总部预算编码不能填写关联方案明细编码");
                        }
                    }
                }
                if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())) {
                    BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount();
                    if (null == departmentFeeAmount || BigDecimal.ZERO.compareTo(departmentFeeAmount) == 0) {
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择大区预算后大区承担金额不能为空或0");
                    }
                } else if (null != itemDto.getDepartmentFeeAmount() && itemDto.getDepartmentFeeAmount().compareTo(BigDecimal.ZERO) != 0) {
                    //总部方案允许填
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                        throw new RuntimeException("未选择大区预算编码，大区承担金额只能为0");
                    }
                }

                String relateStrategyCode = itemDto.getRelateStrategyCode();
                String relateStrategyItemCode = itemDto.getRelateStrategyItemCode();

                String relateHeadStrategyCode = itemDto.getRelateHeadStrategyCode();
                String relateHeadStrategyItemCode = itemDto.getRelateHeadStrategyItemCode();

                String relatePlanCode = itemDto.getRelatePlanCode();
                String relatePlanItemCode = itemDto.getRelatePlanItemCode();

                headBudget:
                if (StringUtils.isNotEmpty(itemDto.getHeadMonthBudgetCode())) {
                    BigDecimal headFeeAmount = itemDto.getHeadFeeAmount();
                    if (null == headFeeAmount || BigDecimal.ZERO.compareTo(headFeeAmount) == 0) {
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择总部预算后总部承担金额不能为空或0");
                    }
                    BigDecimal leaveAmount = headFeeAmount;
                    if (StringUtils.isNotEmpty(relatePlanItemCode)) {
                        List<ActivityPlanBudget> planItemBudgetList = planBudgetMap.get(relatePlanItemCode);
                        if (CollectionUtils.isEmpty(planItemBudgetList)) {
                            throw new RuntimeException("总部预算编码[" + itemDto.getHeadMonthBudgetCode() + "]不属于方案明细[" + relatePlanItemCode + "]");
                        }
                        Set<String> planBudgetItemSet = planItemBudgetList.stream().map(ActivityPlanBudget::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(itemDto.getHeadMonthBudgetCode())) {
                            throw new RuntimeException("总部预算编码[" + itemDto.getHeadMonthBudgetCode() + "]不属于方案明细[" + relatePlanItemCode + "]");
                        }
                        //前端导入的时候没有，重新赋值
                        relatePlanCode = planItemBudgetList.get(0).getPlanCode();

                        ActivityPlanBudgetDto monthBudget = new ActivityPlanBudgetDto();
                        monthBudget.setPlanCode(itemDto.getPlanCode());
                        monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                        monthBudget.setRelatePlanCode(relatePlanCode);
                        monthBudget.setRelatePlanItemCode(relatePlanItemCode);
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getHeadBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getHeadBudgetItemName());
                        monthBudget.setUseAmount(leaveAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getHeadMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getHeadMonthBudgetCode()).getFeeBelongCode() : null);
                        budgetList.add(monthBudget);
                        break headBudget;//有关联方案编码，跳过
                    }
                    if (StringUtils.isNotEmpty(relateHeadStrategyItemCode)) {
                        List<MarketingStrategyBudgetDto> strategyBudgetDtos = strategyBudgetMap.get(relateHeadStrategyItemCode);
                        if (CollectionUtils.isEmpty(strategyBudgetDtos)) {
                            throw new RuntimeException("总部预算编码[" + itemDto.getHeadMonthBudgetCode() + "]不属于策略明细[" + relateHeadStrategyItemCode + "]");
                        }
                        Set<String> planBudgetItemSet = strategyBudgetDtos.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(itemDto.getHeadMonthBudgetCode())) {
                            throw new RuntimeException("总部预算编码[" + itemDto.getHeadMonthBudgetCode() + "]不属于策略明细[" + relateHeadStrategyItemCode + "]");
                        }
                        //前端导入的时候没有，重新赋值
                        relateHeadStrategyCode = strategyBudgetDtos.get(0).getStrategyCode();


                        ActivityPlanBudgetDto monthBudget = new ActivityPlanBudgetDto();
                        monthBudget.setPlanCode(itemDto.getPlanCode());
                        monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                        monthBudget.setRelateStrategyCode(relateHeadStrategyCode);
                        monthBudget.setRelateStrategyItemCode(relateHeadStrategyItemCode);
                        monthBudget.setMonthBudgetCode(itemDto.getHeadMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getHeadBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getHeadBudgetItemName());
                        monthBudget.setUseAmount(leaveAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getHeadMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getHeadMonthBudgetCode()).getFeeBelongCode() : null);
                        budgetList.add(monthBudget);
                        break headBudget;//有关联策略编码，跳过
                    }
                    List<MarketingStrategyBudgetDto> strategyBudgetDtos = relateStrategyBudgetMap.get(itemDto.getHeadMonthBudgetCode());
                    if (null != strategyBudgetDtos) {
                        for (MarketingStrategyBudgetDto strategyBudgetDto : strategyBudgetDtos) {
                            if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                break;
                            }
                            BigDecimal useAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usableAmount = useAmount.subtract(usedAmount);
                            if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                continue;
                            }
                            if (StringUtils.isNotEmpty(relateHeadStrategyItemCode)) {
                                if (!relateHeadStrategyItemCode.equals(strategyBudgetDto.getStrategyItemCode())) {
                                    //选中一个了就一个到底
                                    continue;
                                }
                            } else {
                                relateHeadStrategyItemCode = strategyBudgetDto.getStrategyItemCode();
                                relateHeadStrategyCode = strategyBudgetDto.getStrategyCode();
                            }
                            BigDecimal thisAmount = leaveAmount;
                            if (usableAmount.compareTo(thisAmount) < 0) {
                                thisAmount = usableAmount;
                            }
                            ActivityPlanBudgetDto monthBudget = new ActivityPlanBudgetDto();
                            monthBudget.setPlanCode(itemDto.getPlanCode());
                            monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                            monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                            monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                            monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                            monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                            monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                            monthBudget.setUseAmount(thisAmount);
                            monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode() : null);
                            budgetList.add(monthBudget);
                            leaveAmount = leaveAmount.subtract(thisAmount);
                            strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                        }
                    }
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                        //1、总部下发的方案，关联总部方案，做大区方案
                        List<ActivityPlanBudget> activityPlanBudgets = relatePlanBudgetMap.get(itemDto.getHeadMonthBudgetCode());
                        if (null != activityPlanBudgets) {
                            for (ActivityPlanBudget activityPlanBudget : activityPlanBudgets) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                    break;
                                }
                                BigDecimal useAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount = useAmount.subtract(usedAmount);
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                    continue;
                                }
                                if (StringUtils.isNotEmpty(relatePlanItemCode)) {
                                    if (!relatePlanItemCode.equals(activityPlanBudget.getPlanItemCode())) {
                                        //选中一个了就一个到底
                                        continue;
                                    }
                                } else {
                                    relatePlanItemCode = activityPlanBudget.getPlanItemCode();
                                    relatePlanCode = activityPlanBudget.getPlanCode();
                                }
                                BigDecimal thisAmount = leaveAmount;
                                if (usableAmount.compareTo(thisAmount) < 0) {
                                    thisAmount = usableAmount;
                                }
                                ActivityPlanBudgetDto monthBudget = new ActivityPlanBudgetDto();
                                monthBudget.setPlanCode(itemDto.getPlanCode());
                                monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                                monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                                monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                                monthBudget.setMonthBudgetCode(activityPlanBudget.getMonthBudgetCode());
                                monthBudget.setBudgetItemCode(activityPlanBudget.getBudgetItemCode());
                                monthBudget.setBudgetItemName(activityPlanBudget.getBudgetItemName());
                                monthBudget.setUseAmount(thisAmount);
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                                monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode() : null);
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }

                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) > 0) {
                        throw new RuntimeException("总部费用金额[" + headFeeAmount + "]超过实际可用余额");
                    }
                }
                departBudget:
                if (StringUtils.isNotEmpty(itemDto.getMonthBudgetCode())) {
                    BigDecimal departmentFeeAmount = itemDto.getDepartmentFeeAmount();
                    if (null == departmentFeeAmount || BigDecimal.ZERO.compareTo(departmentFeeAmount) == 0) {
                        //选择总部预算后总部承担金额不能为空
                        throw new RuntimeException("选择大区预算后大区承担金额不能为空或0");
                    }
                    BigDecimal leaveAmount = departmentFeeAmount;

                    if (StringUtils.isNotEmpty(itemDto.getRelateStrategyItemCode())) {
                        List<MarketingStrategyBudgetDto> strategyItemBudgetList = strategyBudgetMap.get(relateStrategyItemCode);
                        if (CollectionUtils.isEmpty(strategyItemBudgetList)) {
                            throw new RuntimeException("大区预算编码[" + itemDto.getMonthBudgetCode() + "]不属于策略明细[" + relateStrategyItemCode + "]");
                        }
                        Set<String> planBudgetItemSet = strategyItemBudgetList.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(itemDto.getMonthBudgetCode())) {
                            throw new RuntimeException("大区预算编码[" + itemDto.getMonthBudgetCode() + "]不属于策略明细[" + relateStrategyItemCode + "]");
                        }

                        //前端可能没传，重新赋值
                        relateStrategyCode = strategyItemBudgetList.get(0).getStrategyCode();

                        ActivityPlanBudgetDto monthBudget = new ActivityPlanBudgetDto();
                        monthBudget.setPlanCode(itemDto.getPlanCode());
                        monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                        monthBudget.setRelateStrategyCode(relateStrategyCode);
                        monthBudget.setRelateStrategyItemCode(itemDto.getRelateStrategyItemCode());
                        monthBudget.setMonthBudgetCode(itemDto.getMonthBudgetCode());
                        monthBudget.setBudgetItemCode(itemDto.getBudgetItemCode());
                        monthBudget.setBudgetItemName(itemDto.getBudgetItemName());
                        monthBudget.setUseAmount(leaveAmount);
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode() : null);
                        budgetList.add(monthBudget);
                        break departBudget;//有关联策略编码，跳过
                    }

                    //大区方案占用策略金额
                    List<MarketingStrategyBudgetDto> activityPlanBudgets = relateStrategyBudgetMap.get(itemDto.getMonthBudgetCode());
                    if (!CollectionUtils.isEmpty(activityPlanBudgets)) {
                        for (MarketingStrategyBudgetDto strategyBudgetDto : activityPlanBudgets) {
                            if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                break;
                            }
                            BigDecimal useAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usableAmount = useAmount.subtract(usedAmount);
                            if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                continue;
                            }
                            if (StringUtils.isNotEmpty(relateStrategyItemCode)) {
                                if (!relateStrategyItemCode.equals(strategyBudgetDto.getStrategyItemCode())) {
                                    //选中一个了就一个到底
                                    continue;
                                }
                            } else {
                                relateStrategyItemCode = strategyBudgetDto.getStrategyItemCode();
                                relateStrategyCode = strategyBudgetDto.getStrategyCode();
                            }
                            BigDecimal thisAmount = leaveAmount;
                            if (usableAmount.compareTo(thisAmount) < 0) {
                                thisAmount = usableAmount;
                            }
                            ActivityPlanBudgetDto monthBudget = new ActivityPlanBudgetDto();
                            monthBudget.setPlanCode(itemDto.getPlanCode());
                            monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                            monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                            monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                            monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                            monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                            monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                            monthBudget.setUseAmount(thisAmount);
                            monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(itemDto.getMonthBudgetCode()) ? monthBudgetMap.get(itemDto.getMonthBudgetCode()).getFeeBelongCode() : null);
                            budgetList.add(monthBudget);
                            leaveAmount = leaveAmount.subtract(thisAmount);
                            strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                        }
                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) > 0) {
                        throw new RuntimeException("大区方案占用策略金额[" + departmentFeeAmount + "]超过实际可用余额");
                    }
                }

                BigDecimal customerFeeAmount = itemDto.getCustomerFeeAmount();
                if (null != customerFeeAmount && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0) {
                    //有客户承担金额的话也生成一条数据，供细案占用处理
                    ActivityPlanBudgetDto monthBudget = new ActivityPlanBudgetDto();
                    monthBudget.setPlanCode(itemDto.getPlanCode());
                    monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                    monthBudget.setUseAmount(customerFeeAmount);
                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode());
                    budgetList.add(monthBudget);
                }

                itemDto.setRelatePlanCode(relatePlanCode);
                itemDto.setRelatePlanItemCode(relatePlanItemCode);
                itemDto.setRelateStrategyCode(relateStrategyCode);
                itemDto.setRelateStrategyItemCode(relateStrategyItemCode);
                itemDto.setRelateHeadStrategyCode(relateHeadStrategyCode);
                itemDto.setRelateHeadStrategyItemCode(relateHeadStrategyItemCode);
            } else {
                //垂直预算的逻辑
                if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())) {
                    for (ActivityPlanBudgetDto budgetDto : itemDto.getBudgetShares()) {
                        BigDecimal useAmount = budgetDto.getUseAmount();
                        BigDecimal leaveAmount = useAmount;
                        List<MarketingStrategyBudgetDto> strategyBudgetDtos = strategyBudgetMap.get(budgetDto.getMonthBudgetCode());
                        if (!CollectionUtils.isEmpty(strategyBudgetDtos)) {
                            for (MarketingStrategyBudgetDto strategyBudgetDto : strategyBudgetDtos) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                    break;
                                }
                                BigDecimal strategyBudgetUseAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount = strategyBudgetUseAmount.subtract(usedAmount);
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                    continue;
                                }
                                BigDecimal thisAmount = leaveAmount;
                                if (usableAmount.compareTo(thisAmount) < 0) {
                                    thisAmount = usableAmount;
                                }
                                ActivityPlanBudgetDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto, ActivityPlanBudgetDto.class, HashSet.class, ArrayList.class);
                                monthBudget.setPlanCode(itemDto.getPlanCode());
                                monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                                monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                                monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                                monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                                monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                                monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                                monthBudget.setUseAmount(thisAmount);
                                //总部方案，“方案关联限制”为“核销后申请”的方案在方案提交时，冻结预算，不占用批复金额；
                                if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())
                                        && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                                } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())
                                        && StringUtils.isNotBlank(monthBudget.getSchemeForecastDetailCode())) {
                                    //大区方案，关联了大区方案兑付表，使用总部冻结过的预算
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                                } else {
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                                }
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }
                        List<ActivityPlanBudget> activityPlanBudgets = relatePlanBudgetMap.get(budgetDto.getMonthBudgetCode());
                        if (!CollectionUtils.isEmpty(activityPlanBudgets)) {
                            for (ActivityPlanBudget activityPlanBudget : activityPlanBudgets) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) {
                                    break;
                                }
                                BigDecimal planBudgetUseAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount = planBudgetUseAmount.subtract(usedAmount);
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                    continue;
                                }
                                BigDecimal thisAmount = leaveAmount;
                                if (usableAmount.compareTo(thisAmount) < 0) {
                                    thisAmount = usableAmount;
                                }
                                ActivityPlanBudgetDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto, ActivityPlanBudgetDto.class, HashSet.class, ArrayList.class);
                                monthBudget.setPlanCode(itemDto.getPlanCode());
                                monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                                monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                                monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                                monthBudget.setMonthBudgetCode(activityPlanBudget.getMonthBudgetCode());
                                monthBudget.setBudgetItemCode(activityPlanBudget.getBudgetItemCode());
                                monthBudget.setBudgetItemName(activityPlanBudget.getBudgetItemName());
                                monthBudget.setUseAmount(thisAmount);
                                if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())
                                        && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                                } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())
                                        && StringUtils.isNotBlank(monthBudget.getSchemeForecastDetailCode())) {
                                    //大区方案，关联了大区方案兑付表，使用总部冻结过的预算
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                                } else {
                                    monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                                }
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }
                        if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
                            //还有没处理的就直接扣预算了
                            ActivityPlanBudgetDto monthBudget = nebulaToolkitService.copyObjectByWhiteList(budgetDto, ActivityPlanBudgetDto.class, HashSet.class, ArrayList.class);
                            monthBudget.setPlanCode(itemDto.getPlanCode());
                            monthBudget.setPlanItemCode(itemDto.getPlanItemCode());
                            monthBudget.setUseAmount(leaveAmount);
                            if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())
                                    && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                            } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())
                                    && StringUtils.isNotBlank(monthBudget.getSchemeForecastDetailCode())) {
                                //大区方案，关联了大区方案兑付表，使用总部冻结过的预算
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                            } else {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            }
                            budgetList.add(monthBudget);
                        }
                    }
                }
            }
            itemDto.setBudgetShares(budgetList);
            for (ActivityPlanBudgetDto dto : budgetList) {
                dto.setIndexNo(itemDto.getIndexNo());
            }
            if (!CollectionUtils.isEmpty(budgetList)){
                budgetDtos.addAll(budgetList);
            }
        }

        return budgetDtos;
    }


    /**
     * 垂直扣减大日期库存
     */
    @Override
    public void useInventoryCheck(List<String> planCodeList){
        List<ActivityPlanDto> planList = activityPlanRepository.findDtoListByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(planList)){
            return ;
        }
        List<ActivityPlanItemDto> activityPlanItems = activityPlanItemRepository.findDtoListByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(activityPlanItems)){
            return ;
        }
        Map<String, List<ActivityPlanItemDto>> itemMap = activityPlanItems.stream().collect(Collectors.groupingBy(ActivityPlanItemDto::getPlanCode));
        for (ActivityPlanDto activityPlanDto : planList) {
            List<ActivityPlanItemDto> itemList = itemMap.get(activityPlanDto.getPlanCode());
            if(CollectionUtils.isEmpty(itemList)){
                continue;
            }
            useInventoryCheck(activityPlanDto, itemList,true);
        }
    }

    /**
     * 垂直扣减大日期库存
     */
    public void useInventoryCheck(ActivityPlanDto planDto,List<ActivityPlanItemDto> itemList,boolean doSave){
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        List<OperateInventoryCheckDto> inventoryCheckOperateList = itemList.stream().filter(item -> {
            return BooleanEnum.TRUE.getCapital().equals(item.getIsBigDate())
                    && StringUtils.isNotEmpty(item.getProductCode())
                    && (StringUtils.isNotEmpty(item.getTerminalCode()) || StringUtils.isNotEmpty(item.getAcWarehouseCode()))
                    && null != item.getThisProductProductionDate()
                    && null != item.getPeriodPromotionalNumber() && item.getPeriodPromotionalNumber() != 0;
        }).map(item -> {
            OperateInventoryCheckDto operateDto = new OperateInventoryCheckDto();
            operateDto.setBusinessFormatCode(planDto.getBusinessFormatCode());
            operateDto.setBusinessUnitCode(planDto.getBusinessUnitCode());
            operateDto.setRegion(item.getRegion());
            operateDto.setSystemCode(item.getSystemCode());
            operateDto.setSystemName(item.getSystemName());
            operateDto.setThisProductProductionDateStr(dayFormat.format(item.getThisProductProductionDate()));
            operateDto.setBusinessCode(item.getPlanItemCode());
            operateDto.setTerminalCode(item.getTerminalCode());
            operateDto.setAcWarehouseCode(item.getAcWarehouseCode());
            operateDto.setProductCode(item.getProductCode());
            operateDto.setTerminalCode(item.getTerminalCode());
            operateDto.setOperationQuantity(item.getPeriodPromotionalNumber());
            operateDto.setInventoryType(item.getBigDateSource());
            operateDto.setOperationType(InventoryCheckOperationTypeEnum.USE.getCode());
            operateDto.setDoSave(doSave);
            operateDto.setThrowException(true);
            return operateDto;
        }).collect(Collectors.toList());
        if ((!CollectionUtils.isEmpty(inventoryCheckOperateList))) {
            tpmInventoryCheckService.operateInventoryCheck(inventoryCheckOperateList);
        }
    }



    /**
     * 垂直回退大日期库存扣减
     */
    @Override
    public void returnInventoryCheck(List<String> planCodeList){
        List<ActivityPlanDto> planList = activityPlanRepository.findDtoListByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(planList)){
            return ;
        }
        List<ActivityPlanItemDto> activityPlanItems = activityPlanItemRepository.findDtoListByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(activityPlanItems)){
            return ;
        }
        Map<String, List<ActivityPlanItemDto>> itemMap = activityPlanItems.stream().collect(Collectors.groupingBy(ActivityPlanItemDto::getPlanCode));
        for (ActivityPlanDto activityPlanDto : planList) {
            List<ActivityPlanItemDto> itemList = itemMap.get(activityPlanDto.getPlanCode());
            if(CollectionUtils.isEmpty(itemList)){
                continue;
            }
            returnInventoryCheck(activityPlanDto, itemList,true);
        }
    }

    /**
     * 垂直回退大日期库存扣减
     */
    public void returnInventoryCheck(ActivityPlanDto planDto,List<ActivityPlanItemDto> itemList,boolean doSave){
        SimpleDateFormat dayFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        List<OperateInventoryCheckDto> inventoryCheckOperateList = itemList.stream().filter(item -> {
            return BooleanEnum.TRUE.getCapital().equals(item.getIsBigDate())
                    && StringUtils.isNotEmpty(item.getProductCode())
                    && (StringUtils.isNotEmpty(item.getTerminalCode()) || StringUtils.isNotEmpty(item.getAcWarehouseCode()))
                    && null != item.getThisProductProductionDate()
                    && null != item.getPeriodPromotionalNumber() && item.getPeriodPromotionalNumber() != 0;
        }).map(item -> {
            OperateInventoryCheckDto operateDto = new OperateInventoryCheckDto();
            operateDto.setBusinessFormatCode(planDto.getBusinessFormatCode());
            operateDto.setBusinessUnitCode(planDto.getBusinessUnitCode());
            operateDto.setRegion(item.getRegion());
            operateDto.setSystemCode(item.getSystemCode());
            operateDto.setSystemName(item.getSystemName());
            operateDto.setThisProductProductionDateStr(dayFormat.format(item.getThisProductProductionDate()));
            operateDto.setBusinessCode(item.getPlanItemCode());
            operateDto.setTerminalCode(item.getTerminalCode());
            operateDto.setAcWarehouseCode(item.getAcWarehouseCode());
            operateDto.setProductCode(item.getProductCode());
            operateDto.setTerminalCode(item.getTerminalCode());
            operateDto.setOperationQuantity(item.getPeriodPromotionalNumber());
            operateDto.setInventoryType(item.getBigDateSource());
            operateDto.setOperationType(InventoryCheckOperationTypeEnum.RETURN.getCode());
            operateDto.setDoSave(doSave);
            operateDto.setThrowException(true);
            return operateDto;
        }).collect(Collectors.toList());
        if ((!CollectionUtils.isEmpty(inventoryCheckOperateList))) {
            tpmInventoryCheckService.operateInventoryCheck(inventoryCheckOperateList);
        }
    }

    /**
     * 删除活动方案
     *
     * @param ids 要删除的活动方案id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
//        只能删除【待提交】、【驳回】状态的方案
        List<ActivityPlan> activityPlans = activityPlanRepository.listByIds(ids);
        for (ActivityPlan activityPlan : activityPlans) {
            if (!ProcessStatusEnum.PREPARE.getKey().equals(activityPlan.getProcessStatus())
                    && !ProcessStatusEnum.REJECT.getKey().equals(activityPlan.getProcessStatus())
                    && !ProcessStatusEnum.RECOVER.getKey().equals(activityPlan.getProcessStatus())) {
                throw new RuntimeException("活动方案[" + activityPlan.getPlanCode() + "]未处于【待提交】、【驳回】状态，不能删除！");
            }
        }
        activityPlanRepository.deleteByIds(ids);
        List<String> planCodes = activityPlans.stream().map(ActivityPlan::getPlanCode).collect(Collectors.toList());
        activityPlanItemService.deleteByPlanCodes(planCodes);
        activityPlanBudgetService.deleteByPlanCodes(planCodes);

        //如果数据来源是kms，活动方案删除后修改kms空进空退信息
        this.notMatchedAcceptanceVoService.updateByPlanCodes(planCodes);

        //删除业务日志
        Collection<ActivityPlanDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(activityPlans,
                ActivityPlan.class, ActivityPlanDto.class, HashSet.class, ArrayList.class);
        SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanLogEventDto> onDelete =
                ActivityPlanLogEventListener::onDelete;
        for (ActivityPlanDto dto : dtoList) {
            ActivityPlanLogEventDto logEventDto = new ActivityPlanLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onDelete);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submitApproval(List<String> ids, ActivityPlanApproveSubmitDto dto) {
        List<ActivityPlan> activityPlans = activityPlanRepository.listByIds(ids);
        Set<String> businessUnitCodeSet = new HashSet<>();
        Set<String> planTypeSet = new HashSet<>();
        String businessUnitCode = null;
        String planType = null;
        for (ActivityPlan activityPlan : activityPlans) {
            Assert.hasLength(activityPlan.getBusinessUnitCode(), "方案[" + activityPlan.getPlanCode() + "]无业务单元信息!");
            Assert.hasLength(activityPlan.getPlanType(), "方案[" + activityPlan.getPlanCode() + "]无方案类型信息!");
            Assert.isTrue(BooleanEnum.TRUE.getCapital().equals(activityPlan.getIsValidate()),
                    "【" + activityPlan.getPlanCode() + "】该方案当前数据为草稿状态，请前往编辑，完善信息并提交！");
            businessUnitCodeSet.add(activityPlan.getBusinessUnitCode());
            businessUnitCode = activityPlan.getBusinessUnitCode();
            BusinessUnitEnum unitEnum = BusinessUnitEnum.codeToEnum(businessUnitCode);
            Assert.notNull(unitEnum, "方案【" + activityPlan.getPlanCode() + "】类型不合法！");
            planTypeSet.add(activityPlan.getPlanType());
            planType = activityPlan.getPlanType();
            ActivityPlanTypeEnum planTypeEnum = ActivityPlanTypeEnum.codeToEnum(planType);
            Assert.notNull(planTypeEnum, "方案【" + activityPlan.getPlanCode() + "】类型不合法！");
            //待提交、驳回、追回的数据才能提交
            if (!ProcessStatusEnum.PREPARE.getKey().equals(activityPlan.getProcessStatus()) &&
                    !ProcessStatusEnum.RECOVER.getKey().equals(activityPlan.getProcessStatus()) &&
                    !ProcessStatusEnum.REJECT.getKey().equals(activityPlan.getProcessStatus())) {
                throw new RuntimeException("活动方案[" + activityPlan.getPlanCode() + "]不处于待提交、驳回、追回状态，不能提交审批！");
            }
        }
        Assert.isTrue(businessUnitCodeSet.size() < 2, "不能选择多个业务单元的数据同时提交！");
        Assert.isTrue(planTypeSet.size() < 2, "不能选择多种方案类型的数据同时提交！");
        List<String> planCodeList = activityPlans.stream().map(ActivityPlan::getPlanCode).collect(Collectors.toList());

        //提交校验
        submitVerify(planCodeList);

        if (!BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
            if (ActivityPlanTypeEnum.region.getCode().equals(planType)) {
                List<ActivityPlanItemVo> planItemDtoList = activityPlanRepository.findActivityPlanByRelatePlanCodes(planCodeList);
                if (CollectionUtil.isNotEmpty(planItemDtoList)) {
                    planItemDtoList.forEach(item -> {
                        Assert.isTrue(BooleanEnum.FALSE.getCapital().equals(item.getIsClose())
                                , "【关联的方案明细[" + item.getPlanItemCode() + "]已被关闭，请重新选择！】");
                    });
                }
            }
        }
        //扣减预算
        List<ActivityPlanBudgetDto> budgetDtoList = activityPlanBudgetService.useMonthBudgetByPlanCodeList(planCodeList);
        //垂直扣减大日期库存
        useInventoryCheck(planCodeList);

        ActivityPlanProcessBusinessForm processBusinessForm = activityPlanRepository.getActivityPlanProcessBusinessForm(planCodeList);
        List<ActivityPlanBudget> isOverBudgetList = getIsOverBudget(planCodeList);
        String isOverBudget = CollectionUtils.isEmpty(isOverBudgetList) ? BooleanEnum.FALSE.getCapital() : BooleanEnum.TRUE.getCapital();
        processBusinessForm.setIsOverBudget(isOverBudget);
        //查询管控力度
        List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.findByCodes(budgetDtoList.stream().map(ActivityPlanBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toList()), null);
        Set<String> controlSituationList = monthBudgetVoList.stream().map(MonthBudgetVo::getControlSituation).collect(Collectors.toSet());
        String isSpecialGrantProcess = controlSituationList.contains(ControlSituationEnum.SPECIAL_GRANT_PROCESS.getCode()) ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital();
        String isSpecialProcess = BooleanEnum.TRUE.getCapital().equals(isSpecialGrantProcess)
                && (BooleanEnum.TRUE.getCapital().equals(isOverBudget) || BooleanEnum.TRUE.getCapital().equals(processBusinessForm.getIsBreakPrice()))
                ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital();
        processBusinessForm.setIsSpecialGrantProcess(isSpecialGrantProcess);
        processBusinessForm.setIsSpecialProcess(isSpecialProcess);
        log.error("方案提交审批:{}", processBusinessForm);

        ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
        processBusinessDto.setBusinessNoList(planCodeList);
        processBusinessDto.setBusinessCode(ActivityPlanConstant.PROCESS_NAME_ACTIVITY_PLAN);
        //批量提交-业务编码设置为uuid
        String businessNo = UUID.randomUUID().toString().replace("-", "");
        processBusinessDto.setBusinessNo(businessNo);
        processBusinessDto.setBusinessFormJson(JSONObject.toJSONString(processBusinessForm));
        ProcessBusinessVo processBusinessVo = processBatchBusinessService.processStart(processBusinessDto);
        //提交成功
        activityPlanRepository.updateProcessStatusAndProcessNo(planCodeList, ProcessStatusEnum.COMMIT.getKey(), processBusinessVo.getProcessNo());
    }

    private void submitVerify(List<String> planCodeList) {
        if(CollectionUtils.isEmpty(planCodeList)){
            return;
        }
        List<ActivityPlanItemVo> carGiftList = this.activityPlanItemRepository.findCountForCarGift(planCodeList);
        List<String> planItemCodes = carGiftList.stream().map(ActivityPlanItemVo::getPlanItemCode).collect(Collectors.toList());
        List<ActivityPlanItemRelateDetailItemVo> relateDetailItemVoList = this.activityPlanItemRelateDetailItemRepository.findCountByPlanCodeList(planItemCodes);
        List<String> relatePlanItemCodes = relateDetailItemVoList.stream().map(ActivityPlanItemRelateDetailItemVo::getPlanItemCode).distinct().collect(Collectors.toList());
        for (ActivityPlanItemVo activityPlanItemVo : carGiftList) {
            Validate.isTrue(relatePlanItemCodes.contains(activityPlanItemVo.getPlanItemCode()),"活动方案明细【"+activityPlanItemVo.getPlanItemCode()+"】无随车搭赠明细内容");
        }
    }


    /**
     * 0未超预算 1超预算
     *
     * @param planCodeList
     * @return
     */
    private List<ActivityPlanBudget> getIsOverBudget(List<String> planCodeList) {
        List<ActivityPlanBudget> overBudgetList = new ArrayList<>();
        List<ActivityPlan> planList = activityPlanRepository.findByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(planList)){
            return Lists.newArrayList();
        }
        Map<String, ActivityPlan> planMap = planList.stream().collect(Collectors.toMap(ActivityPlan::getPlanCode, Function.identity()));
        List<ActivityPlanBudget> activityPlanBudgets = activityPlanBudgetRepository.listByPlanCodeList(planCodeList).stream().filter(e -> Objects.nonNull(e.getUseAmount()) && StringUtils.isNotEmpty(e.getMonthBudgetCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityPlanBudgets)) {
            return new ArrayList<>();
        }
        List<String> monthBudgetCodeList = activityPlanBudgets.stream().map(ActivityPlanBudget::getMonthBudgetCode).distinct().collect(Collectors.toList());
        List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.listByCodes(monthBudgetCodeList).stream().filter(e -> Objects.nonNull(e.getAccumulatedAvailableBalance()) && StringUtils.isNotEmpty(e.getMonthBudgetCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(monthBudgetVoList)) {
            return new ArrayList<>();
        }
        Map<String, MonthBudgetVo> codeToMonthBudgetVoMap = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(), (e1, e2) -> e1));
        for (ActivityPlanBudget planItem : activityPlanBudgets) {
            //只管占用类型是预算的
            if (!ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(planItem.getOccupyType())){
                continue;
            }
            String monthBudgetCode = planItem.getMonthBudgetCode();
            if (codeToMonthBudgetVoMap.containsKey(monthBudgetCode)) {
                ActivityPlan activityPlan = planMap.get(planItem.getPlanCode());
                MonthBudgetVo monthBudgetVo = codeToMonthBudgetVoMap.get(monthBudgetCode);
                BigDecimal useAmount = planItem.getUseAmount();
                BigDecimal accumulatedAvailableBalance = monthBudgetVo.getAccumulatedAvailableBalance();
                if (ProcessStatusEnum.COMMIT.getDictCode().equals(activityPlan.getProcessStatus()) || ProcessStatusEnum.PASS.getDictCode().equals(activityPlan.getProcessStatus()) ){
                    //审批中和审批通过，
                    accumulatedAvailableBalance = accumulatedAvailableBalance.add(useAmount);
                }
                if (useAmount.compareTo(accumulatedAvailableBalance) > 0) {
                    overBudgetList.add(planItem);
                }
            }
        }
        return overBudgetList;
    }

    /**
     * 营销策略审批通过
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processPass(ProcessStatusDto dto) {
        activityPlanRepository.updateProcessStatus(dto.getBusinessNoList(), dto.getProcessStatus());
    }

    /**
     * 审批驳回|流程追回
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processRejectAndRecover(ProcessStatusDto dto) {
        activityPlanBudgetService.returnMonthBudgetByPlanCodeList(dto.getBusinessNoList());
        returnInventoryCheck(dto.getBusinessNoList());
        activityPlanRepository.updateProcessStatus(dto.getBusinessNoList(),dto.getProcessStatus());
    }

    @Override
    public List<ActivityPlanDto> buildActivityPlanParms(List<String> businessNoList) {
        List<ActivityPlanDto> activityPlanDtoList = new ArrayList<>();
        if(CollectionUtils.isEmpty(businessNoList)) {
            return activityPlanDtoList;
        }
        List<ActivityPlanDto> dtoList = this.activityPlanRepository.findDtoListByPlanCodeList(businessNoList);
        List<ActivityPlanItemDto> itemList = activityPlanItemRepository.findDtoAndAttachListByPlanCodeList(businessNoList);
        List<ActivityPlanItemRelateDetailItemDto> activityPlanItemRelateDetailItemDtos = activityPlanItemRelateDetailItemService.findDtoByPlanCodeList(businessNoList);
        Map<String, List<ActivityPlanItemRelateDetailItemDto>> relateDetailItemMap = new HashMap<>();
        if(!CollectionUtils.isEmpty(activityPlanItemRelateDetailItemDtos)){
            relateDetailItemMap = activityPlanItemRelateDetailItemDtos.stream().collect(Collectors.groupingBy(ActivityPlanItemRelateDetailItemDto::getPlanCode));
        }
        Map<String, List<ActivityPlanItemDto>> planItemMap = itemList.stream().collect(Collectors.groupingBy(ActivityPlanItemDto::getPlanCode));
        for (ActivityPlanDto planDto : dtoList) {
            if (planItemMap.containsKey(planDto.getPlanCode())){
                planDto.setItemList(planItemMap.get(planDto.getPlanCode()));
                if(relateDetailItemMap.containsKey(planDto.getPlanCode())){
                    List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList = relateDetailItemMap.get(planDto.getPlanCode());
                    planDto.setRelateDetailItemDtoList(relateDetailItemDtoList);
                }
            }
        }
        return dtoList;
    }

    @Override
    public List<ActivityPlanItemPushSfaDto> findSfaDataByPlanCodes(List<String> planCodes) {
        if (CollUtil.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        return activityPlanRepository.findSfaDataByPlanCodes(planCodes);
    }

    @Override
    public List<ActivityPlanItemPushSfaDisplayDto> findSfaDisplayDataByPlanCodes(List<String> planCodes) {
        if(CollUtil.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        return activityPlanRepository.findSfaDisplayDataByPlanCodes(planCodes);
    }

    @Override
    public List<ActivityPlanVo> findByCodes(Set<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        return activityPlanRepository.findByCodes(planCodes);
    }

    @Override
    public List<ActivityPlanVo> findPlanActivityEndTime(Set<String> activityDetailCodes) {
        if (!CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }

        return activityPlanRepository.findPlanActivityEndTime(activityDetailCodes);
    }

    @Override
    public List<ActivityPlanItemDto> findByPlanItem(String planCode) {
        return activityPlanItemRepository.findDtoListByPlanCode(planCode);
    }

    @Override
    public ActivityPlanVo calculateHeadAmount(ActivityPlanDto planDto, String cacheKey) {
        ActivityPlanVo planVo = new ActivityPlanVo();
        if (StringUtils.isEmpty(planDto.getBusinessUnitCode())) {
            return planVo;
        }
        List<ActivityPlanItemDto> itemList = activityPlanItemService.findCacheList(cacheKey);
        //设置表头汇总金额
        BigDecimal budgetFeeAmount = BigDecimal.ZERO;
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal departmentFeeAmount = BigDecimal.ZERO;
        BigDecimal customerFeeAmount = BigDecimal.ZERO;
        BigDecimal totalFeeAmount = BigDecimal.ZERO;
        BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
        BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;
        ObjectConvertStringUtil.convertObjectListStrProperties(itemList, ActivityPlanItemDto.class);
        for (ActivityPlanItemDto activityPlanItemDto : itemList) {
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
                //费用总金额要=总部+大区+客户
                BigDecimal feeTotal = bdNull(activityPlanItemDto.getHeadFeeAmount())
                        .add(bdNull(activityPlanItemDto.getDepartmentFeeAmount()))
                        .add(bdNull(activityPlanItemDto.getCustomerFeeAmount()));
                Validate.isTrue(feeTotal.compareTo(bdNull(activityPlanItemDto.getTotalFeeAmount())) == 0, "费用总金额不等于总部承担金额加大区承担金额加客户承担金额");
            }
            BigDecimal thisFeeAmount = BigDecimal.ZERO;
            if (null != activityPlanItemDto.getHeadFeeAmount()) {
                headFeeAmount = headFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
            }
            if (null != activityPlanItemDto.getDepartmentFeeAmount()) {
                departmentFeeAmount = departmentFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
            }
            if (null != activityPlanItemDto.getCustomerFeeAmount()) {
                customerFeeAmount = customerFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(planVo.getBusinessUnitCode())) {
                activityPlanItemDto.setFeeAmount(thisFeeAmount);
            }
            if (null != activityPlanItemDto.getFeeAmount()) {
                feeAmount = feeAmount.add(activityPlanItemDto.getFeeAmount());
            }
            if (null != activityPlanItemDto.getRegionAutomaticFeeAmount()) {
                regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(activityPlanItemDto.getRegionAutomaticFeeAmount());
            }
            if (null != activityPlanItemDto.getRegionReferendumFeeAmount()) {
                regionReferendumFeeAmount = regionReferendumFeeAmount.add(activityPlanItemDto.getRegionReferendumFeeAmount());
            }
            if (null != activityPlanItemDto.getTotalFeeAmount()) {
                totalFeeAmount = totalFeeAmount.add(activityPlanItemDto.getTotalFeeAmount());
                if (!CollectionUtils.isEmpty(activityPlanItemDto.getBudgetShares())) {
                    for (ActivityPlanBudgetDto budgetShare : activityPlanItemDto.getBudgetShares()) {
                        if (null != budgetShare.getUseAmount()) {
                            budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
                        }
                    }
                }
            }
        }
        if (null != planDto.getSalesAmount() && planDto.getSalesAmount().compareTo(BigDecimal.ZERO) != 0) {
            if (BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
                //方案投产比=费用合计/预估销售额   垂直
                planVo.setPlanIoRate(feeAmount.divide(planDto.getSalesAmount(), 2, RoundingMode.HALF_DOWN));
            } else {
                //方案投产比=（总计总部承担金额+总计大区承担金额）/预估销售额    主体
                planVo.setPlanIoRate(totalFeeAmount.add(departmentFeeAmount).divide(planDto.getSalesAmount(), 2, RoundingMode.HALF_DOWN));
            }
        }
        planVo.setFeeAmount(feeAmount);
        planVo.setHeadFeeAmount(headFeeAmount);
        planVo.setDepartmentFeeAmount(departmentFeeAmount);
        planVo.setCustomerFeeAmount(customerFeeAmount);
        planVo.setTotalFeeAmount(totalFeeAmount);
        planVo.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
        planVo.setRegionReferendumFeeAmount(regionReferendumFeeAmount);

        return planVo;
    }

    @Override
    public void proportionByTerminalEmployee(ActivityPlanDto dto, String cacheKey) {
        //垂直
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            return;
        }
        List<ActivityPlanItemDto> itemCacheList = activityPlanItemService.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        itemCacheList.forEach(item -> activityPlanItemTerminalService.clearCache(cacheKey + ":" + item.getId()));

        List<String> activityFormCodeList = itemCacheList.stream().map(ActivityPlanItemDto::getActivityFormCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, ActivityFormVo> activityFormVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(activityFormCodeList)) {
            List<ActivityFormVo> activityFormList = activityFormService.findByCodes(activityFormCodeList);
            activityFormVoMap = activityFormList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity(), (o, n) -> n));
        }

        List<String> regionCodeList = Lists.newArrayList();
        List<String> retailerCodeList = Lists.newArrayList();
        List<String> cityNameList = Lists.newArrayList();
        List<String> terminalCodeList = Lists.newArrayList();
        boolean hasNoTerminalCode = false;
        for (int i = 0; i < itemCacheList.size(); i++) {
            ActivityPlanItemDto itemDto = itemCacheList.get(i);
            if (StringUtils.isEmpty(itemDto.getActivityFormCode())) {
                throw new RuntimeException("第【" + (i + 1) + "】行，活动形式不能为空！");
            }
            ActivityFormVo activityFormVo = activityFormVoMap.get(itemDto.getActivityFormCode());
            if (null == activityFormVo) {
                throw new RuntimeException("第【" + (i + 1) + "】行，活动形式[" + itemDto.getActivityFormCode() + "]有误！");
            }
            if (VerticalActivityTypeEnum.temporary_staff.getCode().equals(activityFormVo.getVerticalActivityType())) {
                //活动形式下“垂直活动类型”为“临促人员活动”的活动做校验，临促人员的人员信息不允许维护。
                continue;
            }
            String salesRegionCode = itemDto.getRegion();
            String systemCode = itemDto.getSystemCode();
            String cityName = itemDto.getCityName();
            String quantityStr = itemDto.getQuantityStr();
            Validate.isTrue(StringUtils.isNotEmpty(salesRegionCode) && StringUtils.isNotEmpty(systemCode) && StringUtils.isNotEmpty(cityName), "第【" + (i + 1) + "】行，区域、零售商、城市为必填！");
            Validate.isTrue(StringUtils.isNotEmpty(quantityStr), "第【" + (i + 1) + "】行，数量为必填！");
            try {
                itemDto.setQuantityInt(Integer.valueOf(quantityStr));
            } catch (Exception e) {
                throw new RuntimeException("第【" + (i + 1) + "】行，数量必须为整数！");
            }
            try {
                itemDto.setPrice(new BigDecimal(itemDto.getPriceStr()));
            } catch (Exception e) {
                throw new RuntimeException("第【" + (i + 1) + "】行，标准为必填！");
            }
            regionCodeList.add(salesRegionCode);
            retailerCodeList.add(systemCode);
            cityNameList.add(cityName);
            if (StringUtils.isEmpty(itemDto.getTerminalCode())){
                hasNoTerminalCode = true;
            }else{
                terminalCodeList.add(itemDto.getTerminalCode());
            }
        }
        TerminalRegionRetailerCityDto mdmTerminalQueryDto = new TerminalRegionRetailerCityDto();
        mdmTerminalQueryDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        if (!hasNoTerminalCode){
            mdmTerminalQueryDto.setTerminalCodeList(terminalCodeList);
        }
        mdmTerminalQueryDto.setRegionCodeList(regionCodeList.stream().distinct().collect(Collectors.toList()));
        mdmTerminalQueryDto.setRetailerCodeList(retailerCodeList.stream().distinct().collect(Collectors.toList()));
        mdmTerminalQueryDto.setCityNameList(cityNameList.stream().distinct().collect(Collectors.toList()));
        List<TerminalVo> terminalVoList = terminalVoService.findListByRegionRetailerCityCodes(mdmTerminalQueryDto);
        Map<String, List<TerminalVo>> dimensionToTerminalVoListMap = terminalVoList.stream().collect(Collectors.groupingBy(e -> e.getRegionCode() + e.getCustomerRetailerCode() + e.getCityName()));
        Map<String, Set<String>> dimensionToTerminalCodeListMap = Maps.newHashMap();
        for (int i = 0; i < itemCacheList.size(); i++) {
            ActivityPlanItemDto itemDto = itemCacheList.get(i);
            String dimension = itemDto.getRegion() + itemDto.getSystemCode() + itemDto.getCityName();
            String acStoreType = itemDto.getAcStoreType();
            if (StringUtils.isEmpty(acStoreType)) {
                Validate.isTrue(dimensionToTerminalVoListMap.containsKey(dimension), "第【" + (i + 1) + "】行，根据区域+零售商+城市未找到对应门店！");
                if (!dimensionToTerminalCodeListMap.containsKey(dimension)) {
                    Set<String> terminalCodeSet = dimensionToTerminalVoListMap.get(dimension).stream().map(TerminalVo::getTerminalCode).collect(Collectors.toSet());
                    dimensionToTerminalCodeListMap.put(dimension, terminalCodeSet);
                }
            }
            if (StringUtils.isNotEmpty(acStoreType)) {
                Validate.isTrue(dimensionToTerminalVoListMap.containsKey(dimension), "第【" + (i + 1) + "】行，根据区域+零售商+城市未找到对应门店！");
                String acDimension = dimension + acStoreType;
                if (!dimensionToTerminalCodeListMap.containsKey(acDimension)) {
                    Set<String> terminalCodeSet = dimensionToTerminalVoListMap.get(dimension).stream()
                            .filter(e -> StringUtils.isNotEmpty(e.getTerminalTypeCode()) && acStoreType.equals(e.getTerminalTypeCode()))
                            .map(TerminalVo::getTerminalCode).collect(Collectors.toSet());
                    Validate.isTrue(!CollectionUtils.isEmpty(terminalCodeSet), "第【" + (i + 1) + "】行，根据区域+零售商+城市+AC门店类型未找到对应门店！");
                    dimensionToTerminalCodeListMap.put(acDimension, terminalCodeSet);
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(itemDto.getTotalFeeAmountStr())) {
                try {
                    String totalFeeAmountStr = itemDto.getTotalFeeAmountStr();
                    BigDecimal totalFeeAmount = new BigDecimal(totalFeeAmountStr);
                    itemDto.setTotalFeeAmount(totalFeeAmount);
                } catch (Exception e) {
                    throw new RuntimeException("费用合计格式有误！");
                }
            }else{
                throw new RuntimeException("费用合计不能为空");
            }
        }
        Set<String> allTerminalCodeSet = Sets.newHashSet();
        dimensionToTerminalCodeListMap.forEach((key, value) -> allTerminalCodeSet.addAll(value));
        PromotersDto mdmPromotersQueryDto = new PromotersDto();
        //TODO 2023.03.03 人员类型未接入 预计下周接入，接入后改为枚举
        //2023.04.12还未接入 就这样吧
        mdmPromotersQueryDto.setUserType("ZKCC");
        mdmPromotersQueryDto.setTerminalCodeSet(allTerminalCodeSet);
        List<PromotersVo> promoterVoList = promotersVoService.findTerminalPromotersByTerminal(mdmPromotersQueryDto);
        if (CollectionUtils.isEmpty(promoterVoList)) {
            throw new RuntimeException("明细行内区域+零售商+城市对应的所有门店都没有促销人员！");
        }
        Map<String, Integer> dimensionToPromoterNumberMap = Maps.newHashMap();
        Map<String, List<PromotersVo>> dimensionToPromoterVoListMap = Maps.newHashMap();
        dimensionToTerminalCodeListMap.forEach((dimension, terminalCodeSet) -> {
            Integer count = (int) promoterVoList.stream().filter(e -> terminalCodeSet.contains(e.getTerminalCode())).count();
            dimensionToPromoterNumberMap.put(dimension, count);
            dimensionToPromoterVoListMap.put(dimension, promoterVoList.stream().filter(e -> terminalCodeSet.contains(e.getTerminalCode())).collect(Collectors.toList()));
        });
        for (int i = 0; i < itemCacheList.size(); i++) {
            ActivityPlanItemDto itemDto = itemCacheList.get(i);
            String acStoreType = StringUtils.isEmpty(itemDto.getAcStoreType()) ? "" : itemDto.getAcStoreType();
            String dimension = itemDto.getRegion() + itemDto.getSystemCode() + itemDto.getCityName() + acStoreType;
            Integer quantityInt = itemDto.getQuantityInt();
            Integer promoterNumber = dimensionToPromoterNumberMap.get(dimension);
            Validate.isTrue(quantityInt.compareTo(promoterNumber) == 0, "第【" + (i + 1) + "】行，分摊人数(" + promoterNumber + ")与实际数量不一致！");
            List<PromotersVo> promotersVoList = dimensionToPromoterVoListMap.get(dimension);
            if (StringUtils.isNotEmpty(itemDto.getTerminalCode())){
                promotersVoList = promotersVoList.stream().filter(item -> item.getTerminalCode().equals(itemDto.getTerminalCode())).collect(Collectors.toList());
            }
            List<ActivityPlanItemTerminalDto> itemTerminalDtoList = (List<ActivityPlanItemTerminalDto>) this.nebulaToolkitService.copyCollectionByWhiteList(promotersVoList, PromotersVo.class, ActivityPlanItemTerminalDto.class, LinkedHashSet.class, ArrayList.class);
            itemTerminalDtoList.forEach(e -> {
                BigDecimal price = itemDto.getPrice();
                e.setStandard(price);
                e.setQuantity(BigDecimal.ONE);
                e.setAmount(price);
                e.setFloatingRate(itemDto.getFloatingRate());
                e.setFloatingRateStr(itemDto.getFloatingRateStr());
                e.setId(UUID.randomUUID().toString().replace("-", ""));
                e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
            BigDecimal totalAmount = itemTerminalDtoList.stream().map(ActivityPlanItemTerminalDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            Validate.isTrue(new BigDecimal(itemDto.getTotalFeeAmountStr()).compareTo(totalAmount) == 0, "第【" + (i + 1) + "】行，费用合计与实际费用(" + totalAmount + ")不一致！");
            itemDto.setActivityPlanItemTerminalList(itemTerminalDtoList);
            activityPlanItemTerminalService.proportionAmountByTotalFeeAmount(itemDto);
        }
        itemCacheList.forEach(item -> activityPlanItemTerminalService.saveListCache(cacheKey + ":" + item.getId(), item.getActivityPlanItemTerminalList()));
    }

    @Override
    public void calculateSalePlanProportion(ActivityPlanDto dto, String cacheKey) {
        //垂直
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            return;
        }
        List<ActivityPlanItemDto> itemCacheList = activityPlanItemService.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        itemCacheList.forEach(item -> activityPlanItemTerminalService.clearCache(cacheKey + ":" + item.getId()));
        for (int i = 0; i < itemCacheList.size(); i++) {
            try {
                ActivityPlanItemDto item = itemCacheList.get(i);
                item.setCacheKey(cacheKey);
                activityPlanItemService.calculateSalePlanProportion(item);
            } catch (Exception e) {
                List<String> itemIdList = itemCacheList.stream().map(ActivityPlanItemDto::getId).collect(Collectors.toList());
                for (int k = 0; k <= i; k++) {
                    activityPlanItemTerminalService.clearCache(cacheKey + ":" + itemIdList.get(k));
                }
                log.error(e.getMessage(), e);
                throw new RuntimeException("第【" + (i + 1) + "】行，" + e.getMessage());
            }
        }
    }

    @Override
    public void proportionByTerminal(ActivityPlanDto dto, String cacheKey) {
        //垂直
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            return;
        }
        List<ActivityPlanItemDto> itemCacheList = activityPlanItemService.findCacheList(cacheKey);
        if (CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        itemCacheList.forEach(item -> activityPlanItemTerminalService.clearCache(cacheKey + ":" + item.getId()));
        for (int i = 0; i < itemCacheList.size(); i++) {
            try {
                ActivityPlanItemDto item = itemCacheList.get(i);
                if (!StringUtils.isEmpty(item.getTerminalCode())) {
                    continue;
                }
                item.setCacheKey(cacheKey);
                item.setTemplateConfigName(dto.getTemplateConfigName());
                activityPlanItemTerminalService.proportionByTerminal(item);
            } catch (Exception e) {
                List<String> itemIdList = itemCacheList.stream().map(ActivityPlanItemDto::getId).collect(Collectors.toList());
                for (int k = 0; k <= i; k++) {
                    activityPlanItemTerminalService.clearCache(cacheKey + ":" + itemIdList.get(k));
                }
                log.error(e.getMessage(), e);
                throw new RuntimeException("第【" + (i + 1) + "】行，" + e.getMessage());
            }
        }
    }

    /**
     * 合同生成方案
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void contractGenerateActivityPlan() {

        //1.抓取合同数据
        List<ActivityContractVo> activityContractVoList = activityContractSdkService.getContractForActivityPlan();

        activityContractVoList.forEach(this::createActivityPlan);

    }

    /**
     * 合同生成方案
     *
     * @param item
     */
    private void createActivityPlan(ActivityContractVo item) {

        if (isCreatePlan(item)) {
            //2.保存明细
            createActivityPlanItem(item);
        }
    }

    private boolean isCreatePlan(ActivityContractVo item) {
        if (CollectionUtils.isEmpty(item.getFeeVoList())) {
            return false;
        }
        List<ActivityContractFeeVo> feeVoList = item.getFeeVoList();
        List<ActivityContractFeeVo> activityContractFeeVoList = feeVoList.stream().filter(o -> StringUtils.isNotEmpty(o.getIsAutoApply())).filter(o -> BooleanEnum.TRUE.getCapital().equals(o.getIsAutoApply())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityContractFeeVoList)) {
            return false;
        }
        if (CollectionUtils.isEmpty(item.getAreaContainsList())) {
            return false;
        }
        return true;
    }

    private void createActivityPlanItem(ActivityContractVo item) {

        List<ActivityContractFeeVo> feeVoList = item.getFeeVoList();
        List<ActivityContractFeeVo> activityContractFeeVoList = feeVoList.stream().filter(o -> StringUtils.isNotEmpty(o.getIsAutoApply())).filter(o -> BooleanEnum.TRUE.getCapital().equals(o.getIsAutoApply())).collect(Collectors.toList());
        List<ActivityContractScopeVo> areaContainsList = item.getAreaContainsList();

        //按区域+客户取笛卡尔积
        List<ActivityContractScopeVo> productContainsList = item.getProductContainsList();
        //区域和客户不能同时为空
        if (CollectionUtils.isEmpty(productContainsList)) {
            productContainsList = Lists.newArrayList(new ActivityContractScopeVo());
        }
        //根据零售商+区域查询销售计划上的产品
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setCustomerRetailerCode(item.getRetailerCode());
        Set<String> regionCodes = areaContainsList.stream().map(ActivityContractScopeVo::getScopeCode).collect(Collectors.toSet());
        salesPlanDto.setRegionCodes(new ArrayList<>(regionCodes));
//        List<SalesPlanVo> salesPlanVoList = salesPlanService.findByConditions(salesPlanDto);
//        salesPlanVoList = salesPlanVoList.stream().filter(o -> Objects.nonNull(o.getPlanQuantity()) && o.getPlanQuantity().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
//        //map(零售商+区域,)
//        Map<String, List<SalesPlanVo>> salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(o->o.getCustomerRetailerCode()+"-"+o.getRegionCode()));

        //查下核销条件配置
        Map<String, List<AuditFormulaInfoVo>> auditFormulaMap = Maps.newHashMap();
        Set<String> auditFormulaCodeSet = activityContractFeeVoList.stream().map(ActivityContractFeeVo::getAuditConditionCode).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(auditFormulaCodeSet)) {
            List<AuditFormulaInfoVo> auditFormulaInfoList = auditFormulaMainService.findFormulaInfoListByCodeList(Lists.newArrayList(auditFormulaCodeSet));
            if (!CollectionUtils.isEmpty(auditFormulaInfoList)) {
                auditFormulaMap = auditFormulaInfoList.stream().collect(Collectors.groupingBy(AuditFormulaInfoVo::getAuditFormulaCode));
            }
        }
        List<ActivityContractScopeVo> productNotContainsList = item.getProductNotContainsList();
        List<String> productNotContainsCodeList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(productNotContainsList)) {
            productNotContainsCodeList = productNotContainsList.stream().map(ActivityContractScopeVo::getScopeCode).collect(Collectors.toList());
        }

        for (ActivityContractFeeVo activityContractFeeVo : activityContractFeeVoList) {
            List<String> feeDimensionList = activityContractFeeVo.getFeeDimensionList();
            List<ActivityContractScopeVo> thisStoresContainsList = activityContractFeeVo.getStoresContainsList();
            List<ActivityContractScopeVo> storesNotContainsList = activityContractFeeVo.getStoresNotContainsList();
            List<String> storesNotContainsCodeList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(storesNotContainsList)) {
                storesNotContainsCodeList = storesNotContainsList.stream().map(ActivityContractScopeVo::getScopeCode).collect(Collectors.toList());
            }

            if (feeDimensionList.contains(ContractFeeDimensionEnum.STORE.getCode())) {
                //扣费维度到门店，没有配置门店，才查门店信息
                if (CollectionUtils.isEmpty(thisStoresContainsList)) {
                    //                      没选门店的话根据零售商+客户+区域来查
                    TerminalPaginationDto terminalPaginationDto = new TerminalPaginationDto();
                    terminalPaginationDto.setCustomerRetailerCode(item.getRetailerCode());
                    terminalPaginationDto.setRegionCode(activityContractFeeVo.getRegionCode());
                    terminalPaginationDto.setSellerCode(activityContractFeeVo.getCustomerCode().substring(0, 10));
                    terminalPaginationDto.setTerminalState(BooleanEnum.TRUE.getNumStr());
                    List<TerminalVo> terminaList = terminalVoService.findListByConditions(terminalPaginationDto);
                    if (!CollectionUtils.isEmpty(terminaList)) {
                        List<String> finalStoresNotContainsCodeList = storesNotContainsCodeList;
                        thisStoresContainsList = terminaList.stream().filter(store -> {
                            if (CollectionUtils.isEmpty(finalStoresNotContainsCodeList)) {
                                return true;
                            }
                            return !finalStoresNotContainsCodeList.contains(store.getTerminalCode());
                        }).map(temp -> {
                            return new ActivityContractScopeVo() {{
                                this.setScopeCode(temp.getTerminalCode());
                                this.setScopeName(temp.getTerminalName());
                            }};
                        }).collect(Collectors.toList());
                    }
                }
            }

            for (ActivityContractScopeVo areaVo : areaContainsList) {
                //1.生成方案抬头
                ActivityPlan activityPlan = createActivityPlanHeader(item);
                List<ActivityPlanItem> activityPlanItemList = new ArrayList<>();
                List<ActivityPlanItemTerminal> activityPlanItemTerminalList = new ArrayList<>();

                if (!CollectionUtils.isEmpty(feeDimensionList)) {
                    //如果扣费维度到产品
//                            if(feeDimensionList.contains(ContractFeeDimensionEnum.PRODUCT.getCode())){
//                                List<SalesPlanVo> salesPlanVoList1 = salesPlanVoMap.get(item.getRetailerCode() + "-" + areaVo.getScopeCode());
//                                if(!CollectionUtils.isEmpty(salesPlanVoList1)) {
//                                    Map<String, List<SalesPlanVo>> salesPlanVoMap2 = salesPlanVoList1.stream().collect(Collectors.groupingBy(SalesPlanVo::getProductCode));
//                                    Set<Map.Entry<String, List<SalesPlanVo>>> entries = salesPlanVoMap2.entrySet();
//                                    for (Map.Entry<String, List<SalesPlanVo>> entry : entries) {
//                                        for (ActivityContractScopeVo productScore : productContainsList) {
//                                            ActivityPlanItem planItem = buildItemDetail(activityPlan, item, activityContractFeeVo, areaVo,customerScore,regionScore, entry);
//                                            planItem.setProductCode(productScore.getScopeCode());
//                                            planItem.setProductName(productScore.getScopeName());
//                                            activityPlanItemTerminalList.addAll(buildStoresData(feeDimensionList,thisStoresContainsList, planItem));
//                                            activityPlanItemList.add(planItem);
//                                        }
//                                    }
//                                }
//                            }else {
                    for (ActivityContractScopeVo productScore : productContainsList) {
                        ActivityPlanItem planItem = buildItemDetail(activityPlan, item, activityContractFeeVo, areaVo, null);
                        planItem.setProductCode(productScore.getScopeCode());
                        planItem.setProductName(productScore.getScopeName());
                        activityPlanItemTerminalList.addAll(buildStoresData(feeDimensionList, thisStoresContainsList, planItem));
                        activityPlanItemList.add(planItem);
                    }
//                            }
                }


                if (!CollectionUtils.isEmpty(activityPlanItemList)) {
                    Map<String, List<ActivityPlanItemTerminal>> activityPlanItemTerminalMap = new HashMap<>();
                    if (!CollectionUtils.isEmpty(activityPlanItemTerminalList)) {
                        activityPlanItemTerminalMap = activityPlanItemTerminalList.stream().collect(Collectors.groupingBy(ActivityPlanItemTerminal::getPlanItemCode));
                    }
                    List<CalculateDto> dtoList = new ArrayList<>();
                    SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
                    for (ActivityPlanItem activityPlanItem : activityPlanItemList) {
                        List<ActivityPlanItemTerminal> activityPlanItemTerminalList1 = activityPlanItemTerminalMap.get(activityPlanItem.getPlanItemCode());
                        if (!CollectionUtils.isEmpty(activityPlanItemTerminalList1)) {
                            for (ActivityPlanItemTerminal activityPlanItemTerminal : activityPlanItemTerminalList1) {
                                CalculateDto calculateDto = new CalculateDto();
                                calculateDto.setCode(activityPlanItem.getPlanItemCode());
                                calculateDto.setBusinessUnitCode(activityPlan.getBusinessUnitCode());
                                calculateDto.setBusinessFormatCode(activityPlan.getBusinessFormatCode());
                                calculateDto.setYearMonthLy(yearMonthFormat.format(activityPlanItem.getFeeYearMonth()));
                                calculateDto.setActivityOrgCode(activityPlanItem.getRegion());
                                calculateDto.setActivityOrgName(activityPlanItem.getActivityOrgName());
                                calculateDto.setProductCode(activityPlanItem.getProductCode());
                                calculateDto.setRetailBusinessmanCode(activityPlanItem.getSystemCode());
                                calculateDto.setRetailBusinessmanName(activityPlanItem.getSystemName());
                                calculateDto.setStartTimeOrDate(activityPlanItem.getActivityBeginDate());
                                calculateDto.setEndTimeOrDate(activityPlanItem.getActivityEndDate());
                                calculateDto.setStoresCode(activityPlanItemTerminal.getTerminalCode());
                                calculateDto.setExcludeProductCodeList(productNotContainsCodeList);
//                                        List<ActivityContractFeeFormulaVo> feeFormulaVoList = activityPlanItem.getFeeFormulaVoList();
                                List<AuditFormulaInfoVo> feeFormulaVoList = auditFormulaMap.get(activityPlanItem.getAuditConditionCode());
                                if (!CollectionUtils.isEmpty(feeFormulaVoList)) {
                                    List<FormulaInfoDto> formulaInfoDtoList = new ArrayList<>();
                                    for (AuditFormulaInfoVo activityContractFeeFormulaVo : feeFormulaVoList) {
                                        FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
                                        formulaInfoDto.setFormulaCondition(activityContractFeeFormulaVo.getAuditFormulaCondition());
                                        formulaInfoDto.setFormulaConditionName(activityContractFeeFormulaVo.getAuditFormulaConditionName());
                                        formulaInfoDto.setFormula(activityContractFeeFormulaVo.getAuditFormula());
                                        formulaInfoDto.setFormulaName(activityContractFeeFormulaVo.getAuditFormulaName());

                                        formulaInfoDtoList.add(formulaInfoDto);
                                    }
                                    calculateDto.setFormulaInfoDtoList(formulaInfoDtoList);
                                }
                                String auditConditionCode = activityPlanItem.getAuditConditionCode();
                                calculateDto.setTerminalCode(activityPlanItemTerminal.getTerminalCode());
                                dtoList.add(calculateDto);
                            }
                        } else {
                            CalculateDto calculateDto = new CalculateDto();
                            calculateDto.setCode(activityPlanItem.getPlanItemCode());
                            calculateDto.setBusinessUnitCode(activityPlan.getBusinessUnitCode());
                            calculateDto.setBusinessFormatCode(activityPlan.getBusinessFormatCode());
                            calculateDto.setYearMonthLy(yearMonthFormat.format(activityPlanItem.getFeeYearMonth()));
                            calculateDto.setActivityOrgCode(activityPlanItem.getActivityOrgCode());
                            calculateDto.setActivityOrgName(activityPlanItem.getActivityOrgName());
                            calculateDto.setProductCode(activityPlanItem.getProductCode());
                            calculateDto.setRetailBusinessmanCode(activityPlanItem.getSystemCode());
                            calculateDto.setRetailBusinessmanName(activityPlanItem.getSystemName());
                            calculateDto.setStartTimeOrDate(activityPlanItem.getActivityBeginDate());
                            calculateDto.setEndTimeOrDate(activityPlanItem.getActivityEndDate());
                            calculateDto.setStoresCode(activityPlanItem.getTerminalCode());
                            calculateDto.setExcludeProductCodeList(productNotContainsCodeList);
//                                    List<ActivityContractFeeFormulaVo> feeFormulaVoList = activityPlanItem.getFeeFormulaVoList();
                            List<AuditFormulaInfoVo> feeFormulaVoList = auditFormulaMap.get(activityPlanItem.getAuditConditionCode());
                            if (!CollectionUtils.isEmpty(feeFormulaVoList)) {
                                List<FormulaInfoDto> formulaInfoDtoList = new ArrayList<>();
                                for (AuditFormulaInfoVo activityContractFeeFormulaVo : feeFormulaVoList) {
                                    FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
                                    formulaInfoDto.setFormulaCondition(activityContractFeeFormulaVo.getAuditFormulaCondition());
                                    formulaInfoDto.setFormulaConditionName(activityContractFeeFormulaVo.getAuditFormulaConditionName());
                                    formulaInfoDto.setFormula(activityContractFeeFormulaVo.getAuditFormula());
                                    formulaInfoDto.setFormulaName(activityContractFeeFormulaVo.getAuditFormulaName());

                                    formulaInfoDtoList.add(formulaInfoDto);
                                }
                                calculateDto.setFormulaInfoDtoList(formulaInfoDtoList);
                            }
                            calculateDto.setTerminalCode(activityPlanItem.getTerminalCode());
                            dtoList.add(calculateDto);
                        }

                    }

                    //todo 公式替换
                    List<CalculateVo> calculateVos = variableService.orCalculateConditionAndExpression(dtoList);
                    Map<String, List<CalculateVo>> calculateVoMap = calculateVos.stream().collect(Collectors.groupingBy(CalculateVo::getCode));
                    for (ActivityPlanItem activityPlanItem : activityPlanItemList) {
                        List<CalculateVo> calculateVoList = calculateVoMap.get(activityPlanItem.getPlanItemCode());
                        List<ActivityPlanItemTerminal> activityPlanItemTerminalList1 = activityPlanItemTerminalMap.get(activityPlanItem.getPlanItemCode());
                        if (!CollectionUtils.isEmpty(activityPlanItemTerminalList1)) {
                            Map<String, CalculateVo> terminalCalMap = calculateVoList.stream().collect(Collectors.toMap(CalculateVo::getTerminalCode, Function.identity()));
                            for (ActivityPlanItemTerminal activityPlanItemTerminal : activityPlanItemTerminalList1) {
                                CalculateVo calculateVo = terminalCalMap.get(activityPlanItemTerminal.getTerminalCode());
                                BigDecimal formulaValue = BigDecimal.ZERO;
                                if (null != calculateVo) {
                                    formulaValue = calculateVo.getFormulaValue();
                                }
                                activityPlanItemTerminal.setAmount(formulaValue);
                            }
                        }
                        BigDecimal feeAmount = BigDecimal.ZERO;
                        if (!CollectionUtils.isEmpty(calculateVoList)) {
                            for (CalculateVo calculateVo : calculateVoList) {
                                feeAmount = feeAmount.add(calculateVo.getFormulaValue());
                            }
                        }
                        activityPlanItem.setTotalFeeAmount(feeAmount);
                        activityPlanItem.setFeeAmount(feeAmount);
//                    activityPlanItem.setAuditConditionCode(null);
//                    activityPlanItem.setAuditConditionName(calculateVo.getFormulaConditionName());
                    }

                    createTerminalData(activityPlanItemTerminalList);


                    //List<ActivityPlanBudget> activityPlanBudgetList = buildBudget(activityPlanItemList);
                    createItemData(activityPlanItemList);
                    //2023.5.12生成批复不在占预算
                    //createBudget(activityPlanBudgetList);
                }
            }
        }
    }

    private void createBudget(List<ActivityPlanBudget> activityPlanBudgetList) {

        this.activityPlanBudgetRepository.saveBatch(activityPlanBudgetList);
    }

    private List<ActivityPlanBudget> buildBudget(List<ActivityPlanItem> activityPlanItemList) {

        List<ActivityPlanBudget> activityPlanBudgetList = new ArrayList<>();
        for (ActivityPlanItem activityPlanItem : activityPlanItemList) {
            MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            monthBudgetDto.setYearMonthLy(sdf.format(activityPlanItem.getFeeYearMonth()));
            monthBudgetDto.setSystemCode(activityPlanItem.getSystemCode());
            monthBudgetDto.setRegionCode(activityPlanItem.getRegion());
            monthBudgetDto.setBudgetItemCode(activityPlanItem.getBudgetItemCode());
//            monthBudgetDto.setFeeBelongCode(ActivityPlanConstant.TPM_FEE_BELONG_VERTICAL);
            List<MonthBudgetVo> monthBudgetVoList = monthBudgetService.findListByConditions(monthBudgetDto);
            if (CollectionUtils.isEmpty(monthBudgetVoList)) {
                continue;
            }
            MonthBudgetVo monthBudgetVo = monthBudgetVoList.get(0);
            ActivityPlanBudget activityPlanBudget = new ActivityPlanBudget();
            activityPlanBudget.setPlanCode(activityPlanItem.getPlanCode());
            activityPlanBudget.setPlanItemCode(activityPlanItem.getPlanItemCode());
            activityPlanBudget.setMonthBudgetCode(monthBudgetVo.getMonthBudgetCode());
            activityPlanBudget.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
            activityPlanBudget.setBudgetItemName(monthBudgetVo.getBudgetItemName());
            activityPlanBudget.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
            activityPlanBudget.setAccumulatedAvailableBalance(monthBudgetVo.getAccumulatedAvailableBalance());
            activityPlanBudget.setUseAmount(activityPlanItem.getTotalFeeAmount());
            activityPlanBudget.setUsedAmount(BigDecimal.ZERO);
            activityPlanBudget.setTenantCode(TenantUtils.getTenantCode());
            activityPlanBudget.setId(null);

            activityPlanBudgetList.add(activityPlanBudget);

            activityPlanItem.setRegionAutomaticFeeAmount(activityPlanBudget.getUseAmount());
            activityPlanItem.setRegionAutomaticBudgetItemCode(activityPlanBudget.getBudgetItemCode());
            activityPlanItem.setRegionAutomaticBudgetItemName(activityPlanBudget.getBudgetItemName());
            activityPlanItem.setRegionAutomaticMonthBudgetCode(activityPlanBudget.getMonthBudgetCode());
        }
        return activityPlanBudgetList;
    }

    private void createTerminalData(List<ActivityPlanItemTerminal> activityPlanItemTerminalList) {
        this.activityPlanItemTerminalRepository.saveBatch(activityPlanItemTerminalList);
    }

    private void createItemData(List<ActivityPlanItem> activityPlanItemList) {
        this.activityPlanItemRepository.saveBatch(activityPlanItemList);
    }

    private List<ActivityPlanItemTerminal> buildStoresData(List<String> feeDimensionList, List<ActivityContractScopeVo> storesContainsList, ActivityPlanItem planItem) {
        //如果扣费维度到门店
        List<ActivityPlanItemTerminal> activityPlanItemTerminalList = new ArrayList<>();
        if (feeDimensionList.contains(ContractFeeDimensionEnum.STORE.getCode())) {
            if (!CollectionUtils.isEmpty(storesContainsList)) {
                for (ActivityContractScopeVo contractScopeVo : storesContainsList) {
                    ActivityPlanItemTerminal activityPlanItemTerminal = new ActivityPlanItemTerminal();
                    activityPlanItemTerminal.setPlanCode(planItem.getPlanCode());
                    activityPlanItemTerminal.setPlanItemCode(planItem.getPlanItemCode());
                    activityPlanItemTerminal.setTerminalCode(contractScopeVo.getScopeCode());
                    activityPlanItemTerminal.setTerminalName(contractScopeVo.getScopeName());
                    activityPlanItemTerminal.setStandard(null);
                    activityPlanItemTerminal.setQuantity(null);
                    activityPlanItemTerminal.setAmount(null);
                    activityPlanItemTerminal.setTenantCode(TenantUtils.getTenantCode());

                    activityPlanItemTerminalList.add(activityPlanItemTerminal);
                }
            }
        }
        return activityPlanItemTerminalList;
    }

    private BigDecimal bdNull(BigDecimal b) {
        return b == null ? BigDecimal.ZERO : b;
    }

    private ActivityPlanItem buildItemDetail(ActivityPlan activityPlan, ActivityContractVo contractVo, ActivityContractFeeVo activityContractFeeVo, ActivityContractScopeVo areaVo, Map.Entry<String, List<SalesPlanVo>> entry) {
        SalesPlanVo salesPlanVo = new SalesPlanVo();
        if (entry != null) {
            salesPlanVo = entry.getValue().get(0);
        }
        ActivityPlanItem activityPlanItem = new ActivityPlanItem();

//        activityPlanItem.setFeeFormulaVoList(activityContractFeeVo.getFeeFormulaVoList());
        activityPlanItem.setPlanCode(activityPlan.getPlanCode());
        String code = this.activityPlanItemService.generateCode();
        activityPlanItem.setPlanItemCode(code);

        activityPlanItem.setTemplateConfigCode(activityPlan.getTemplateConfigCode());
        activityPlanItem.setActivityTypeCode(activityContractFeeVo.getActivityTypeCode());
        activityPlanItem.setActivityTypeName(activityContractFeeVo.getActivityTypeName());
        activityPlanItem.setActivityFormCode(activityContractFeeVo.getActivityFormCode());
        activityPlanItem.setActivityFormName(activityContractFeeVo.getActivityFormName());
        activityPlanItem.setActivityBeginDate(activityPlan.getBeginDate());
        activityPlanItem.setActivityEndDate(activityPlan.getEndDate());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        try {
            activityPlanItem.setFeeYearMonth(sdf.parse(sdf.format(date)));
        } catch (ParseException e) {
            log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        activityPlanItem.setActivityOrgCode(areaVo.getScopeCode());
        activityPlanItem.setActivityOrgName(areaVo.getScopeName());
        activityPlanItem.setSystemCode(contractVo.getRetailerCode());
        activityPlanItem.setSystemName(contractVo.getRetailerName());
        activityPlanItem.setProductBrandCode(salesPlanVo.getProductBrandCode());
        activityPlanItem.setProductBrandName(salesPlanVo.getProductBrandName());
        activityPlanItem.setProductCategoryCode(salesPlanVo.getProductCategoryCode());
        activityPlanItem.setProductCategoryName(salesPlanVo.getProductCategoryName());
        activityPlanItem.setProductItemCode(salesPlanVo.getProductItemCode());
        activityPlanItem.setProductItemName(salesPlanVo.getProductItemName());
        activityPlanItem.setProductCode(salesPlanVo.getProductCode());
        activityPlanItem.setProductName(salesPlanVo.getProductName());
        activityPlanItem.setAuditForm(AuditFormEnum.DISCOUNT.getCode());
        activityPlanItem.setFeeBelongYearMonth(sdf.format(date));
        activityPlanItem.setContractCode(contractVo.getContractNo());
        activityPlanItem.setSystemBorneAmount(BigDecimal.ZERO);
//        activityPlanItem.setDeductionDetailsName(activityContractFeeVo.getFeeName());
        activityPlanItem.setDeductionDetails(activityContractFeeVo.getFeeName());
        activityPlanItem.setFeeType(activityContractFeeVo.getFeeType());
        activityPlanItem.setFeeStandard(activityContractFeeVo.getFeeStandard());
        activityPlanItem.setActivityDesc(activityContractFeeVo.getFeeName());
        activityPlanItem.setCustomerCode(activityContractFeeVo.getCustomerCode());
        activityPlanItem.setCustomerName(activityContractFeeVo.getCustomerName());
        activityPlanItem.setRegion(activityContractFeeVo.getRegionCode());
//        activityPlanItem.setFeeStandard(activityContractFeeVo.getFeeStandard());
        activityPlanItem.setTenantCode(TenantUtils.getTenantCode());
        activityPlanItem.setId(null);
        activityPlanItem.setBudgetItemCode(activityContractFeeVo.getBudgetProjectCode());
        activityPlanItem.setAuditConditionCode(activityContractFeeVo.getAuditConditionCode());
        activityPlanItem.setAuditConditionName(activityContractFeeVo.getAuditConditionName());
        activityPlanItem.setAuditType(TpmAuditTypeEnum.AUDITTYPE2.getCode());
        return activityPlanItem;
    }

    //生成方案抬头
    private ActivityPlan createActivityPlanHeader(ActivityContractVo item) {
        ActivityPlan activityPlan = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityPlan.class, null, null);
        activityPlan.setPlanCode(generateCode());
        activityPlan.setPlanName(item.getContractName());
        activityPlan.setPlanType(ActivityPlanTypeEnum.region.getCode());
        //当前日期最后一天
        Calendar lastTime = Calendar.getInstance();
        int lastDay = lastTime.getActualMaximum(Calendar.DAY_OF_MONTH);
        lastTime.set(Calendar.DAY_OF_MONTH, lastDay);

        //当前日期第一天
        Calendar firstTime = Calendar.getInstance();
        firstTime.set(Calendar.DAY_OF_MONTH, 1);
        if (firstTime.getTime().compareTo(item.getEnableDate()) >= 0) {
            activityPlan.setBeginDate(firstTime.getTime());
        } else {
            activityPlan.setBeginDate(item.getEnableDate());
        }
        if (lastTime.getTime().compareTo(item.getEndDate()) <= 0) {
            activityPlan.setEndDate(lastTime.getTime());
        } else {
            activityPlan.setEndDate(item.getEndDate());
        }
        activityPlan.setDepartmentCode("");//todo
        activityPlan.setDepartmentName("");//todo
        activityPlan.setPlanOrgCode("");//todo
        activityPlan.setPlanOrgName("");//todo
        activityPlan.setPlanClassify(ActivityClassifyEnum.RULE_PLAN.getCode());
        activityPlan.setPlanRelateLimitCode(PlanRelateLimitEnum.BEFORE.getCode());
        activityPlan.setFeeAmount(new BigDecimal("0"));//todo
        activityPlan.setHeadFeeAmount(new BigDecimal("0"));//todo
        activityPlan.setDepartmentFeeAmount(new BigDecimal("0"));//todo
        activityPlan.setCustomerFeeAmount(new BigDecimal("0"));//todo
        activityPlan.setTotalFeeAmount(new BigDecimal("0"));//todo
        activityPlan.setUsedAmount(new BigDecimal("0"));//todo
        activityPlan.setSalesAmount(new BigDecimal("0"));//todo
        activityPlan.setPlanIoRate(new BigDecimal("0"));//todo
        activityPlan.setPlanTitle(item.getContractName());
        activityPlan.setPlanGoal(item.getContractName());
        activityPlan.setActivityBackground(item.getContractName());
        activityPlan.setActivityTarget(item.getContractName());
        activityPlan.setDetailExplain(item.getContractName());
        activityPlan.setFullAccept(BooleanEnum.TRUE.getCapital());
        DictDataVo dictDataVo = dictDataVoService.findByDictTypeCodeAndDictCode("activity_plan_template", "contract");
        Validate.notNull(dictDataVo, "请配置数据字典activity_plan_template字典编码contract的值");
        ActivitiesTemplateConfigVo activitiesTemplateConfigVo = activitiesTemplateSdkService.findByCode(dictDataVo.getDictValue());
        Validate.notNull(activitiesTemplateConfigVo, "未找到活动模版【%s】", dictDataVo.getDictValue());
        activityPlan.setTemplateConfigCode(activitiesTemplateConfigVo.getConfigCode());
        activityPlan.setTemplateConfigName(activitiesTemplateConfigVo.getConfigName());
        activityPlan.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        activityPlan.setTenantCode(TenantUtils.getTenantCode());
        activityPlan.setId(null);
        activityPlan.setIsValidate(BooleanEnum.TRUE.getCapital());

        this.activityPlanRepository.save(activityPlan);
        return activityPlan;
    }

    /**
     * 活动方案申请可以选择的总部方案
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据ø
     */
    @Override
    public Page<ActivityPlanVo> findRelateActivityPlanListByConditions(Pageable pageable, ActivityPlanDto dto) {
        return activityPlanRepository.findRelateActivityPlanListByConditions(pageable, dto);
    }

    private String generateCode() {
        // redis生成营销策略编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
//        String ruleCode = StringUtils.join(ActivityPlanConstant.ACTIVITY_PLAN_RULE_CODE_PRE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        return this.generateCodeService.generateCode(ActivityPlanConstant.ACTIVITY_PLAN_RULE_CODE_PRE, 1, 6, 2, TimeUnit.DAYS).get(0);
    }

    @Override
    public String createActivityPlan(ActivityPlanDto dto) {
        Validate.isTrue(!CollectionUtils.isEmpty(dto.getItemList()), "明细行不能为空");
        //活动方案头表数据保存
        ActivityPlan entity = null;
        if (StringUtils.isNotEmpty(dto.getPlanCode())){
            entity = activityPlanRepository.getByPlanCode(dto.getPlanCode());
            if (null == entity){
                throw new RuntimeException("方案编码有误！");
            }
            //如果是更新操作，查下历史数据的预算项目，活动分类，活动形式设置进去
            List<ActivityPlanItem> list = activityPlanItemRepository.findListByPlanCode(dto.getPlanCode());
            if (CollectionUtils.isEmpty(list)){
                throw new RuntimeException("活动方案["+dto.getPlanCode()+"]无明细，无法获取预算项目，请重新选择");
            }
            ActivityPlanItem activityPlanItem = list.get(0);
            //寻下明细行对应的预算
            for (ActivityPlanItemDto itemDto : dto.getItemList()) {
                itemDto.setBudgetItemCode(activityPlanItem.getBudgetItemCode());
                itemDto.setBudgetItemName(activityPlanItem.getBudgetItemName());
                itemDto.setActivityTypeCode(activityPlanItem.getActivityTypeCode());
                itemDto.setActivityTypeName(activityPlanItem.getActivityTypeName());
                itemDto.setActivityFormCode(activityPlanItem.getActivityFormCode());
                itemDto.setActivityFormName(activityPlanItem.getActivityFormName());
            }
        }else{
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlan.class, HashSet.class, ArrayList.class);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
        }

        SimpleDateFormat yearMonthFormat = new SimpleDateFormat(DateUtil.DEFAULT_YEAR_MONTH);
        //寻下明细行对应的预算
        for (ActivityPlanItemDto itemDto : dto.getItemList()) {
            if (!CollectionUtils.isEmpty(itemDto.getBudgetShares())) {
                continue;//已经寻好了的不处理
            }
            List<ActivityPlanBudgetDto> budgetShares = Lists.newArrayList();
            Validate.notNull(itemDto.getFeeAmount(), "费用金额不能为空");
            //垂直逻辑：区域+年月+零售商+预算项目编码
            if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                Validate.notBlank(itemDto.getRegion(), "区域不能为空");
                Validate.notNull(itemDto.getFeeYearMonth(), "费用归属年月不能为空");
                Validate.notBlank(itemDto.getSystemCode(), "零售商不能为空");
                Validate.notBlank(itemDto.getBudgetItemCode(), "预算项目不能为空");
                MonthBudgetDto monthBudgetDto = new MonthBudgetDto();
                monthBudgetDto.setRegionCode(itemDto.getRegion());
                monthBudgetDto.setYearMonthLy(yearMonthFormat.format(itemDto.getFeeYearMonth()));
                monthBudgetDto.setSystemCode(itemDto.getSystemCode());
                monthBudgetDto.setBudgetItemCode(itemDto.getBudgetItemCode());
                List<MonthBudgetVo> monthBudgetVos = monthBudgetService.findListByConditions(monthBudgetDto);
                if (CollectionUtils.isEmpty(monthBudgetVos)) {
                    throw new RuntimeException("年月[" + monthBudgetDto.getYearMonthLy() + "]预算项目[" + monthBudgetDto.getBudgetItemCode() + "]区域[" + itemDto.getRegion() + "]零售商[" + monthBudgetDto.getSystemCode() + "]未匹配到月度预算！");
                }
                MonthBudgetVo monthBudgetVo = monthBudgetVos.get(0);
                ActivityPlanBudgetDto budgetDto = new ActivityPlanBudgetDto();
                budgetDto.setMonthBudgetCode(monthBudgetVo.getMonthBudgetCode());
                budgetDto.setYearMonthLy(monthBudgetVo.getYearMonthLy());
                budgetDto.setBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                budgetDto.setBudgetItemName(monthBudgetVo.getBudgetItemName());
                budgetDto.setAccumulatedAvailableBalance(monthBudgetVo.getAccumulatedAvailableBalance());
                budgetDto.setFeeBelongCode(monthBudgetVo.getFeeBelongCode());
                budgetDto.setUseAmount(itemDto.getFeeAmount());
                budgetDto.setUseAmountStr(itemDto.getFeeAmount().toString());
                budgetShares.add(budgetDto);
            }
            itemDto.setBudgetShares(budgetShares);
        }

        //匹配下模板
        Set<String> activityTypeCodeList = dto.getItemList().stream().map(ActivityPlanItemDto::getActivityTypeCode).collect(Collectors.toSet());
        Map<String, List<ActivityTypeRelationDetailVo>> activityTypeVoMap = Maps.newHashMap();
        Map<String, ActivitiesTemplateConfigVo> activityTemplateMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(activityTypeCodeList)) {
            List<ActivityTypeRelationDetailVo> relationDetailList = activityTypeService.getRelationDetailByTypeCodes(Lists.newArrayList(activityTypeCodeList));
            if (!CollectionUtils.isEmpty(relationDetailList)) {
                activityTypeVoMap = relationDetailList.stream().filter(item -> {
                    return dto.getBusinessFormatCode().equals(item.getBusinessFormatCode()) && item.getBusinessUnitCode().equals(dto.getBusinessUnitCode());
                }).collect(Collectors.groupingBy(ActivityTypeRelationDetailVo::getActivityTypeCode));

                List<String> templateCodeList = relationDetailList.stream()
                        .filter(item -> StringUtils.isNotEmpty(item.getTemplate()))
                        .flatMap(item -> Arrays.stream(item.getTemplate().split(",")))
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(templateCodeList)) {
                    List<ActivitiesTemplateConfigVo> templateConfigVoList = activitiesTemplateSdkService.findBaseByCodeList(templateCodeList);
                    activityTemplateMap = templateConfigVoList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
                }
            }

        }
        Set<String> templateConfigCodeList = Sets.newHashSet();
        for (ActivityPlanItemDto itemDto : dto.getItemList()) {
            List<ActivityTypeRelationDetailVo> activityTypeRelationDetailVos = activityTypeVoMap.get(itemDto.getActivityTypeCode());
            if (CollectionUtils.isEmpty(activityTypeRelationDetailVos)) {
                throw new RuntimeException("活动分类[" + itemDto.getActivityTypeCode() + "]未匹配到模板配置");
            }
            String templateConfigCode = null;
            for (ActivityTypeRelationDetailVo activityTypeRelationDetailVo : activityTypeRelationDetailVos) {
                if (StringUtils.isNotEmpty(templateConfigCode)) {
                    break;
                }
                if (StringUtils.isEmpty(activityTypeRelationDetailVo.getTemplate())) {
                    continue;
                }
                for (String templateCode : activityTypeRelationDetailVo.getTemplate().split(",")) {
                    ActivitiesTemplateConfigVo templateConfigVo = activityTemplateMap.get(templateCode);
                    if (dto.getPlanType().equals(templateConfigVo.getSchemeTypeCode())) {
                        templateConfigCode = templateCode;
                        break;
                    }
                }
            }
            if (StringUtils.isEmpty(templateConfigCode)) {
                throw new RuntimeException("活动分类[" + itemDto.getActivityTypeCode() + "]未匹配到模板配置");
            }
            itemDto.setTemplateConfigCode(templateConfigCode);
            itemDto.setId(UUID.randomUUID().toString().replace("-", ""));
            templateConfigCodeList.add(templateConfigCode);
        }
        if (StringUtils.isNotEmpty(entity.getTemplateConfigCode())){
            templateConfigCodeList.addAll(Arrays.asList(entity.getTemplateConfigCode().split(",")));
        }
        entity.setTemplateConfigCode(String.join(",", templateConfigCodeList));
        String code = dto.getPlanCode();
        if (StringUtils.isEmpty(dto.getPlanCode())){
            code = this.generateCode();
            entity.setPlanCode(code);
            activityPlanRepository.save(entity);
        }else{
            activityPlanRepository.updateById(entity);
        }
        for (ActivityPlanItemDto itemDto : dto.getItemList()) {
            itemDto.setPlanCode(code);
        }
        activityPlanItemService.createActivityPlanItem(dto.getItemList());

        return code;
    }


    @Override
    public List<String> submitIsOverBudget(String processNo) {
        if (StringUtils.isBlank(processNo)) {
            return Lists.newArrayList();
        }
        List<ActivityPlan> planList = activityPlanRepository.findByProcessNoList(Lists.newArrayList(processNo));
        List<String> planCodeList = planList.stream().map(e -> e.getPlanCode()).collect(Collectors.toList());
        return submitMsg(planCodeList);
    }

    @Override
    public List<String> submitIsOverBudgetByIds(List<String> ids) {
        List<ActivityPlan> activityPlans = activityPlanRepository.listByIds(ids);
        List<String> planCodeList = activityPlans.stream().map(ActivityPlan::getPlanCode).collect(Collectors.toList());
        return submitMsg(planCodeList);
    }

    private List<String> submitMsg(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)){
            throw new RuntimeException("未匹配到方案编码");
        }
        List<String> msgs = new ArrayList<>();
        List<ActivityPlanBudget> isOverBudgetList = getIsOverBudget(planCodeList);
        Map<String, Set<String>> isOverBudgetMap = isOverBudgetList.stream().collect(Collectors.groupingBy(e -> e.getPlanCode(), Collectors.mapping(e -> e.getMonthBudgetCode()+"-"+e.getBudgetItemName(), Collectors.toSet())));
        //超预算提示
        for (String key : isOverBudgetMap.keySet()) {
            Set<String> itemSet = isOverBudgetMap.get(key);
            for (String item : itemSet) {
                String msg = "方案申请【"+ key +"】中的月度预算【"+ item +"】已超预算；";
                msgs.add(msg);
            }
        }
        //破价提示
        List<ActivityPlanRedLineVo> activityPlanRedLineVoList = activityPlanRepository.getActivityPlanBreakPrice(planCodeList);
        if (!CollectionUtils.isEmpty(activityPlanRedLineVoList)) {
            activityPlanRedLineVoList = activityPlanRedLineVoList.stream().distinct().collect(Collectors.toList());
            List<String> productCodes = activityPlanRedLineVoList.stream().map(ActivityPlanRedLineVo::getProductCode).collect(Collectors.toList());

            PriceDto priceDto = new PriceDto();
            priceDto.setGoodsCodes(productCodes);
            priceDto.setTypeCodes(Collections.singletonList(ActivityPlanConstant.regularlowprice));
            List<PriceVo> priceVos = priceVoService.findByPriceDtoRedLine(priceDto);
            Map<String, List<PriceVo>> collect = priceVos.stream().collect(Collectors.groupingBy(PriceVo::getGoodsCode));
            for (ActivityPlanRedLineVo vo : activityPlanRedLineVoList) {
                List<PriceVo> priceVos1 = collect.get(vo.getProductCode());
                String msg = "产品【"+ vo.getProductName() +"】已破价；红线价:"+priceVos1.get(0).getPrice().toPlainString()+"，申请价格:"+vo.getPromotionalPrice().toPlainString()+";";
                msgs.add(msg);
            }
        }
        return  msgs;
    }

    @Override
    public ActivityPlanSubmitReportMainVo submitPageReport(String processNo) {
        ActivityPlanSubmitReportMainVo result = new ActivityPlanSubmitReportMainVo();
        if (StringUtils.isBlank(processNo)) {
            return result;
        }
        List<ActivityPlan> planList = activityPlanRepository.findByProcessNoList(Lists.newArrayList(processNo));
        List<String> planCodeList = planList.stream().filter(e -> BusinessUnitEnum.VERTICAL.getCode().equals(e.getBusinessUnitCode())).map(ActivityPlan::getPlanCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(planCodeList)) {
            return result;
        }
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DICT_REGION_CODE));
        List<DictDataVo> regionDict = mapDict.get(DICT_REGION_CODE);
        Map<String, String> regionCodeToNameMap = regionDict.stream().collect(Collectors.toMap(
                e -> Optional.ofNullable(e.getDictCode()).orElse(StringUtils.EMPTY),
                e -> Optional.ofNullable(e.getDictValue()).orElse(StringUtils.EMPTY)
                , (e1, e2) -> e1));
        log.error("区域codeToName：{}", regionCodeToNameMap);
        List<ActivityPlanSubmitReportSubVo> dimension1 = activityPlanItemRepository.submitPageReportDimension1(planCodeList);
        List<ActivityPlanSubmitReportSubVo> dimension2 = activityPlanItemRepository.submitPageReportDimension2(planCodeList);
        List<ActivityPlanSubmitReportSubVo> dimension3 = activityPlanItemRepository.submitPageReportDimension3(planCodeList);
        //去查预算的数据
        Collection<String> yearLyCollection = Sets.newHashSet();
        Collection<String> yearMonthLyCollection = Sets.newHashSet();
        Collection<String> budgetItemCodeCollection = Sets.newHashSet();
        Collection<String> regionCollection = Sets.newHashSet();
        Collection<String> regionNameCollection = Sets.newHashSet();
        Collection<String> systemCodeCollection = Sets.newHashSet();
        Collection<String> systemNameCollection = Sets.newHashSet();
        dimension3.forEach(sub -> {
            yearLyCollection.add(sub.getYearMonthly().substring(0, 4));
            yearMonthLyCollection.add(sub.getYearMonthly());
            budgetItemCodeCollection.add(sub.getBudgetItemCode());
            String region = sub.getRegion();
            regionCollection.add(region);
            String regionName = regionCodeToNameMap.getOrDefault(region, StringUtils.EMPTY);
            regionNameCollection.add(regionName);
            sub.setRegionName(regionName);
            systemCodeCollection.add(sub.getSystemCode());
            systemNameCollection.add(sub.getSystemName());
        });
        //根据零售商+区域查询销售计划上的产品
        List<SalesPlanVo> salesPlanVoList = Lists.newArrayList();
        for (String yearMonthLy : yearMonthLyCollection) {
            SalesPlanDto salesPlanDto = new SalesPlanDto();
            salesPlanDto.setYearMonthLy(yearMonthLy);
            salesPlanDto.setCustomerRetailerCodeList(Lists.newArrayList(systemCodeCollection));
            salesPlanDto.setRegionCodes(Lists.newArrayList(regionCollection));
            salesPlanVoList.addAll(salesPlanService.findSalesPlanSumVo(salesPlanDto));
        }

        YearBudgetDto budgetQueryDto = new YearBudgetDto();
        budgetQueryDto.setYearLyCollection(yearLyCollection);
        budgetQueryDto.setRegionCollection(regionCollection);
        budgetQueryDto.setBudgetItemCodeCollection(budgetItemCodeCollection);
        budgetQueryDto.setSystemCodeCollection(systemCodeCollection);
        List<YearBudgetReportVo> budgetSumVoList = yearBudgetSdkService.findYearBudgetSumVo(budgetQueryDto);
        //垂直销售业绩,这里实际上拿到的是折后实际销额
        SalesPerformanceDto salesPerformanceQueryDto = new SalesPerformanceDto();
        salesPerformanceQueryDto.setYearLyCollection(yearLyCollection);
        salesPerformanceQueryDto.setRegionNameCollection(regionNameCollection);
        salesPerformanceQueryDto.setSystemNameCollection(systemNameCollection);
        List<SalesPerformanceVo> salesPerformanceSumVo = salesPerformanceVoService.findSalesPerformanceSumVo(salesPerformanceQueryDto);
        Map<String, SalesPlanVo> salesPlanVoMap = salesPlanVoList.stream().collect(
                Collectors.toMap(e -> e.getYearMonthLy() + e.getRegionCode() + e.getCustomerRetailerCode(), Function.identity(), (e1, e2) -> e1));
        Map<String, YearBudgetReportVo> dimensionToYearBudgetVoMap = budgetSumVoList.stream().collect(
                Collectors.toMap(e -> e.getYearLy() + e.getBudgetItemCode() + e.getRegionCode() + e.getSystemCode(), Function.identity(), (e1, e2) -> e1));
        Map<String, SalesPerformanceVo> dimensionToSalesPerformanceVoMap = salesPerformanceSumVo.stream().collect(
                Collectors.toMap(e -> e.getYearCol() + e.getRegion() + e.getRetailer(), Function.identity(), (e1, e2) -> e1));
        dimension1.forEach(vo -> {
            String region = vo.getRegion();
            String regionName = regionCodeToNameMap.getOrDefault(region, StringUtils.EMPTY);
            vo.setRegionName(regionName);
            String key = vo.getYearMonthly() + region + vo.getSystemCode();
            if (salesPlanVoMap.containsKey(key)) {
                SalesPlanVo salesPlanVo = salesPlanVoMap.get(key);
                vo.setSalesTarget(Optional.ofNullable(salesPlanVo.getDiscountRestoreAmount()).orElse(BigDecimal.ZERO));
            }
        });
        dimension3.forEach(vo -> {
            String yearLy = vo.getYearMonthly().substring(0, 4);
            String yearBudgetKey = yearLy + vo.getBudgetItemCode() + vo.getRegion() + vo.getSystemCode();
            String yearBudgetNoRegionKey = yearLy + vo.getBudgetItemCode() + null + vo.getSystemCode();
            String yearBudgetNoSystemKey = yearLy + vo.getBudgetItemCode() + vo.getRegion() + null;
            String yearBudgetNoRegionAndSystemKey = yearLy + vo.getBudgetItemCode() + null + null;
            YearBudgetReportVo yearBudgetReportVo = new YearBudgetReportVo();
            if (dimensionToYearBudgetVoMap.containsKey(yearBudgetKey)) {
                yearBudgetReportVo = dimensionToYearBudgetVoMap.get(yearBudgetKey);
            } else if (dimensionToYearBudgetVoMap.containsKey(yearBudgetNoRegionKey)) {
                yearBudgetReportVo = dimensionToYearBudgetVoMap.get(yearBudgetNoRegionKey);
            } else if (dimensionToYearBudgetVoMap.containsKey(yearBudgetNoSystemKey)) {
                yearBudgetReportVo = dimensionToYearBudgetVoMap.get(yearBudgetNoSystemKey);
            } else if (dimensionToYearBudgetVoMap.containsKey(yearBudgetNoRegionAndSystemKey)) {
                yearBudgetReportVo = dimensionToYearBudgetVoMap.get(yearBudgetNoRegionAndSystemKey);
            }
            vo.setFeeAmount(yearBudgetReportVo.getBudgetTotalAmount());
            vo.setUsedAmount(yearBudgetReportVo.getUsedAmount());
            vo.setSalesTarget(yearBudgetReportVo.getTotalGoalQuantity());
            vo.setFeeAmount(yearBudgetReportVo.getBudgetTotalAmount());
            String salesPerformanceKey = yearLy + vo.getRegionName() + vo.getSystemName();
            if (dimensionToSalesPerformanceVoMap.containsKey(salesPerformanceKey)) {
                SalesPerformanceVo salesPerformanceVo = dimensionToSalesPerformanceVoMap.get(salesPerformanceKey);
                vo.setSalesQuantity(salesPerformanceVo.getWarehsOutQty());
            }
        });
        this.reportSubVoSetStrValue(dimension1);
        this.reportSubVoSetStrValue(dimension2);
        this.reportSubVoSetStrValue(dimension3);
        result.setDimension1(dimension1);
        result.setDimension2(dimension2);
        result.setDimension3(dimension3);
        return result;
    }

    @Override
    public ActivityPlanSubmitReportMainVo modifySubmitPageReport(String processNo) {
        ActivityPlanSubmitReportMainVo result = new ActivityPlanSubmitReportMainVo();
        if (StringUtils.isBlank(processNo)) {
            return result;
        }
        Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(DICT_REGION_CODE));
        List<DictDataVo> regionDict = mapDict.get(DICT_REGION_CODE);
        Map<String, String> regionCodeToNameMap = regionDict.stream().collect(Collectors.toMap(
                e -> Optional.ofNullable(e.getDictCode()).orElse(StringUtils.EMPTY),
                e -> Optional.ofNullable(e.getDictValue()).orElse(StringUtils.EMPTY)
                , (e1, e2) -> e1));
        log.error("区域codeToName：{}", regionCodeToNameMap);
        List<ActivityPlanModify> planList = activityPlanModifyRepository.findByProcessNoList(Lists.newArrayList(processNo));
        List<String> planCodeList = planList.stream().filter(e -> BusinessUnitEnum.VERTICAL.getCode().equals(e.getBusinessUnitCode())).map(ActivityPlanModify::getPlanCode).collect(Collectors.toList());
        List<String> modifyBusinessCodeList = planList.stream().filter(e -> BusinessUnitEnum.VERTICAL.getCode().equals(e.getBusinessUnitCode())).map(ActivityPlanModify::getModifyBusinessCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(planCodeList)) {
            return result;
        }
        List<ActivityPlanSubmitReportSubVo> modifyDimension1 = activityPlanItemModifyRepository.modifySubmitPageReportDimension1(planCodeList, modifyBusinessCodeList);
        List<ActivityPlanSubmitReportSubVo> dimension2 = activityPlanItemRepository.submitPageReportDimension2(planCodeList);
        List<ActivityPlanSubmitReportSubVo> modifyDimension3 = activityPlanItemModifyRepository.modifySubmitPageReportDimension3(planCodeList, modifyBusinessCodeList);
        //去查预算的数据
        Collection<String> yearLyCollection = Sets.newHashSet();
        Collection<String> yearMonthLyCollection = Sets.newHashSet();
        Collection<String> budgetItemCodeCollection = Sets.newHashSet();
        Collection<String> regionCollection = Sets.newHashSet();
        Collection<String> regionNameCollection = Sets.newHashSet();
        Collection<String> systemCodeCollection = Sets.newHashSet();
        Collection<String> systemNameCollection = Sets.newHashSet();
        modifyDimension3.forEach(sub -> {
            yearLyCollection.add(sub.getYearMonthly().substring(0, 4));
            yearMonthLyCollection.add(sub.getYearMonthly());
            budgetItemCodeCollection.add(sub.getBudgetItemCode());
            String region = sub.getRegion();
            regionCollection.add(region);
            String regionName = regionCodeToNameMap.getOrDefault(region, StringUtils.EMPTY);
            regionNameCollection.add(regionName);
            sub.setRegionName(regionName);
            systemCodeCollection.add(sub.getSystemCode());
            systemNameCollection.add(sub.getSystemName());
        });
        //根据零售商+区域查询销售计划上的产品
        List<SalesPlanVo> salesPlanVoList = Lists.newArrayList();
        for (String yearMonthLy : yearMonthLyCollection) {
            SalesPlanDto salesPlanDto = new SalesPlanDto();
            salesPlanDto.setYearMonthLy(yearMonthLy);
            salesPlanDto.setCustomerRetailerCodeList(Lists.newArrayList(systemCodeCollection));
            salesPlanDto.setRegionCodes(Lists.newArrayList(regionCollection));
            salesPlanVoList.addAll(salesPlanService.findSalesPlanSumVo(salesPlanDto));
        }

        YearBudgetDto budgetQueryDto = new YearBudgetDto();
        budgetQueryDto.setYearLyCollection(yearLyCollection);
        budgetQueryDto.setRegionCollection(regionCollection);
        budgetQueryDto.setBudgetItemCodeCollection(budgetItemCodeCollection);
        budgetQueryDto.setSystemCodeCollection(systemCodeCollection);
        List<YearBudgetReportVo> budgetSumVoList = yearBudgetSdkService.findYearBudgetSumVo(budgetQueryDto);
        //垂直销售业绩垂直销售业绩,这里实际上拿到的是折后实际销额
        SalesPerformanceDto salesPerformanceQueryDto = new SalesPerformanceDto();
        salesPerformanceQueryDto.setYearLyCollection(yearLyCollection);
        salesPerformanceQueryDto.setRegionNameCollection(regionNameCollection);
        salesPerformanceQueryDto.setSystemNameCollection(systemNameCollection);
        List<SalesPerformanceVo> salesPerformanceSumVo = salesPerformanceVoService.findSalesPerformanceSumVo(salesPerformanceQueryDto);
        Map<String, SalesPlanVo> salesPlanVoMap = salesPlanVoList.stream().collect(
                Collectors.toMap(e -> e.getYearMonthLy() + e.getRegionCode() + e.getCustomerRetailerCode(), Function.identity(), (e1, e2) -> e1));
        Map<String, YearBudgetReportVo> dimensionToYearBudgetVoMap = budgetSumVoList.stream().collect(
                Collectors.toMap(e -> e.getYearLy() + e.getBudgetItemCode() + e.getRegionCode() + e.getSystemCode(), Function.identity(), (e1, e2) -> e1));
        Map<String, SalesPerformanceVo> dimensionToSalesPerformanceVoMap = salesPerformanceSumVo.stream().collect(
                Collectors.toMap(e -> e.getYearCol() + e.getRegion() + e.getRetailer(), Function.identity(), (e1, e2) -> e1));
        modifyDimension1.forEach(vo -> {
            String region = vo.getRegion();
            String regionName = regionCodeToNameMap.getOrDefault(region, StringUtils.EMPTY);
            vo.setRegionName(regionName);
            String key = vo.getYearMonthly() + region + vo.getSystemCode();
            if (salesPlanVoMap.containsKey(key)) {
                SalesPlanVo salesPlanVo = salesPlanVoMap.get(key);
                vo.setSalesTarget(Optional.ofNullable(salesPlanVo.getDiscountRestoreAmount()).orElse(BigDecimal.ZERO));
            }
        });
        modifyDimension3.forEach(vo -> {
            String yearLy = vo.getYearMonthly().substring(0, 4);
            String yearBudgetKey = yearLy + vo.getBudgetItemCode() + vo.getRegion() + vo.getSystemCode();
            String yearBudgetNoRegionKey = yearLy + vo.getBudgetItemCode() + null + vo.getSystemCode();
            String yearBudgetNoSystemKey = yearLy + vo.getBudgetItemCode() + vo.getRegion() + null;
            String yearBudgetNoRegionAndSystemKey = yearLy + vo.getBudgetItemCode() + null + null;
            YearBudgetReportVo yearBudgetReportVo = new YearBudgetReportVo();
            if (dimensionToYearBudgetVoMap.containsKey(yearBudgetKey)) {
                yearBudgetReportVo = dimensionToYearBudgetVoMap.get(yearBudgetKey);
            } else if (dimensionToYearBudgetVoMap.containsKey(yearBudgetNoRegionKey)) {
                yearBudgetReportVo = dimensionToYearBudgetVoMap.get(yearBudgetNoRegionKey);
            } else if (dimensionToYearBudgetVoMap.containsKey(yearBudgetNoSystemKey)) {
                yearBudgetReportVo = dimensionToYearBudgetVoMap.get(yearBudgetNoSystemKey);
            } else if (dimensionToYearBudgetVoMap.containsKey(yearBudgetNoRegionAndSystemKey)) {
                yearBudgetReportVo = dimensionToYearBudgetVoMap.get(yearBudgetNoRegionAndSystemKey);
            }
            vo.setFeeAmount(yearBudgetReportVo.getBudgetTotalAmount());
            vo.setUsedAmount(yearBudgetReportVo.getUsedAmount());
            vo.setSalesTarget(yearBudgetReportVo.getTotalGoalQuantity());
            vo.setFeeAmount(yearBudgetReportVo.getBudgetTotalAmount());
            String salesPerformanceKey = yearLy + vo.getRegionName() + vo.getSystemName();
            if (dimensionToSalesPerformanceVoMap.containsKey(salesPerformanceKey)) {
                SalesPerformanceVo salesPerformanceVo = dimensionToSalesPerformanceVoMap.get(salesPerformanceKey);
                vo.setSalesQuantity(salesPerformanceVo.getWarehsOutQty());
            }
        });
        this.reportSubVoSetStrValue(modifyDimension1);
        this.reportSubVoSetStrValue(dimension2);
        this.reportSubVoSetStrValue(modifyDimension3);
        result.setDimension1(modifyDimension1);
        result.setDimension2(dimension2);
        result.setDimension3(modifyDimension3);
        return result;
    }

    private void reportSubVoSetStrValue(List<ActivityPlanSubmitReportSubVo> dimension) {
        dimension.forEach(e -> {
            BigDecimal oneHundred = new BigDecimal("100");
            BigDecimal salesTarget = e.getSalesTarget();
            if (Objects.nonNull(salesTarget)) {
                e.setSalesTargetStr(salesTarget.setScale(2, RoundingMode.HALF_UP).toString());
            }
            BigDecimal applyAmount = e.getApplyAmount();
            BigDecimal modifyApplyAmount = e.getModifyApplyAmount();
            String applyAmountModifyStr = Objects.isNull(modifyApplyAmount) ? "" : " -> " + modifyApplyAmount.setScale(2, RoundingMode.HALF_UP).toString();
            e.setApplyAmountStr(Optional.ofNullable(applyAmount).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP).toString() + applyAmountModifyStr);
            if (Objects.nonNull(salesTarget) && Objects.nonNull(applyAmount)) {
                e.setProductionRatio(BigDecimal.ZERO.compareTo(salesTarget) == 0 ? BigDecimal.ZERO : applyAmount.divide(salesTarget, 4, RoundingMode.HALF_UP));
                e.setProductionRatioStr(e.getProductionRatio().multiply(oneHundred).setScale(2, RoundingMode.HALF_UP) + "%");
            }
            if (Objects.nonNull(salesTarget) && Objects.nonNull(modifyApplyAmount)) {
                e.setModifyProductionRatio(BigDecimal.ZERO.compareTo(salesTarget) == 0 ? BigDecimal.ZERO : modifyApplyAmount.divide(salesTarget, 4, RoundingMode.HALF_UP));
                e.setProductionRatioStr(e.getProductionRatioStr() + " -> " + e.getModifyProductionRatio().multiply(oneHundred).setScale(2, RoundingMode.HALF_UP) + "%");
            }
            BigDecimal feeAmount = e.getFeeAmount();
            if (Objects.nonNull(feeAmount)) {
                e.setFeeAmountStr(feeAmount.setScale(2, RoundingMode.HALF_UP).toString());
            }
            BigDecimal usedAmount = e.getUsedAmount();
            if (Objects.nonNull(usedAmount)) {
                e.setUsedAmountStr(usedAmount.setScale(2, RoundingMode.HALF_UP).toString());
            }
            String useAmountModifyStr = Objects.isNull(e.getModifyUseAmount()) ? "" : " -> " + e.getModifyUseAmount().setScale(2, RoundingMode.HALF_UP);
            e.setUseAmountStr(Optional.ofNullable(e.getUseAmount()).orElse(BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP) + useAmountModifyStr);
            if (Objects.nonNull(usedAmount) && Objects.nonNull(feeAmount)) {
                e.setBudgetUseProgress(BigDecimal.ZERO.compareTo(feeAmount) == 0 ? BigDecimal.ZERO : usedAmount.divide(feeAmount, 4, RoundingMode.HALF_UP));
                e.setBudgetUseProgressStr(e.getBudgetUseProgress().multiply(oneHundred).setScale(2, RoundingMode.HALF_UP) + "%");
            }
            BigDecimal salesQuantity = e.getSalesQuantity();
            if (Objects.nonNull(salesTarget) && Objects.nonNull(salesQuantity)) {
                e.setSalesProgress(BigDecimal.ZERO.compareTo(salesTarget) == 0 ? BigDecimal.ZERO : salesQuantity.divide(salesTarget, 4, RoundingMode.HALF_UP));
                e.setSalesProgressStr(e.getSalesProgress().multiply(oneHundred).setScale(2, RoundingMode.HALF_UP) + "%");
            }
            BigDecimal salesProgress = e.getSalesProgress();
            BigDecimal budgetUseProgress = e.getBudgetUseProgress();
            if (Objects.nonNull(salesProgress) || Objects.nonNull(e.getBudgetUseProgress())) {
                e.setVsSalesProgress(Optional.ofNullable(budgetUseProgress).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(salesProgress).orElse(BigDecimal.ZERO)));
                e.setVsSalesProgressStr(e.getVsSalesProgress().multiply(oneHundred).setScale(2, RoundingMode.HALF_UP) + "%");
            }
            e.setRegion(e.getRegionName());
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ActivityPlanOutDto saveActivityPlanNoCache(ActivityPlanOutDto dto) {
        ActivityPlan entity;
        boolean tempSave = false;
        List<ActivityPlanItemDto> itemDtoList = dto.getItemList();
        createValidate(dto, itemDtoList, null);
        boolean update = !StringUtils.isBlank(dto.getId());
        ActivityPlanDto oldDto = new ActivityPlanDto();
        if (!update) {
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlan.class, HashSet.class, ArrayList.class);
            // redis生成营销策略编码，编码规则为MS+年月日+5位顺序数。每天都从00001开始
            String code = this.generateCode();
            entity.setPlanCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            entity.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            entity.setPlanStatus(ActivityPlanStatusEnum.normal.getCode());
            activityPlanRepository.save(entity);
            dto.setPlanCode(code);
            dto.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            dto.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            dto.setPlanStatus(ActivityPlanStatusEnum.normal.getCode());
        } else {
            ActivityPlan oldEntity = activityPlanRepository.getById(dto.getId());
            if (!ProcessStatusEnum.PREPARE.getKey().equals(oldEntity.getProcessStatus()) &&
                    !ProcessStatusEnum.REJECT.getKey().equals(oldEntity.getProcessStatus()) &&
                    !ProcessStatusEnum.RECOVER.getKey().equals(oldEntity.getProcessStatus())) {
                throw new RuntimeException("只能编辑待提交、驳回、追回状态的数据！");
            }
            dto.setPlanCode(oldEntity.getPlanCode());
            dto.setTenantCode(oldEntity.getTenantCode());
            dto.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            dto.setIsValidate(!tempSave ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
            dto.setPlanStatus(ActivityPlanStatusEnum.normal.getCode());
            dto.setWhereFrom(oldEntity.getWhereFrom());
            entity = nebulaToolkitService.copyObjectByWhiteList(dto, ActivityPlan.class, HashSet.class, ArrayList.class);
            activityPlanRepository.updateById(entity);
            oldDto = nebulaToolkitService.copyObjectByWhiteList(oldEntity, ActivityPlanDto.class, HashSet.class, ArrayList.class);
        }
        //保存方案-策略关联
        activityPlanStrategyService.saveActivityPlanStrategyList(entity, update, dto.getStrategyList());

        //保存大区方案-方案关联
        activityPlanRelatePlanService.saveActivityPlanRelatePlanList(entity, update, dto.getRelatePlanList());

        //保存方案-模板配置关联
        activityPlanTemplateService.saveActivityPlanTemplateList(entity, update, dto.getTemplateList());
        //保存方案明细
        activityPlanItemService.saveActivityPlanItemList(entity, update, itemDtoList, false, tempSave);

        //保存方案明细的门店信息
        if (!CollectionUtils.isEmpty(dto.getTerminalDtoList())) {
            List<ActivityPlanItemTerminal> activityPlanItemTerminals = (List<ActivityPlanItemTerminal>) this.nebulaToolkitService.copyCollectionByBlankList(dto.getTerminalDtoList(), ActivityPlanItemTerminalDto.class, ActivityPlanItemTerminal.class, LinkedHashSet.class, ArrayList.class);
            this.activityPlanItemTerminalRepository.saveBatch(activityPlanItemTerminals);
        }

        //新增修改业务日志
        ActivityPlanLogEventDto logEventDto = new ActivityPlanLogEventDto();
        dto.setId(entity.getId());
        logEventDto.setNewest(dto);
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanLogEventDto> onCreate =
                    ActivityPlanLogEventListener::onCreate;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onCreate);
        } else {
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer<ActivityPlanLogEventListener, ActivityPlanLogEventDto> onUpdate =
                    ActivityPlanLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, ActivityPlanLogEventListener.class, onUpdate);
        }
        return dto;
    }

    @Override
    public ActivityPlanVo findByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty(planItemCode)) {
            return null;
        }

        ActivityPlan activityPlan = this.activityPlanRepository.findByPlanItemCode(planItemCode);
        if (Objects.isNull(activityPlan)) {
            return null;
        }
        ActivityPlanVo activityPlanVo = this.nebulaToolkitService.copyObjectByBlankList(activityPlan, ActivityPlanVo.class, null, null);
        return activityPlanVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteForOut(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
//        只能删除【待提交】、【驳回】状态的方案
        List<ActivityPlan> activityPlans = activityPlanRepository.listByIds(ids);
        for (ActivityPlan activityPlan : activityPlans) {
            if (!ProcessStatusEnum.PREPARE.getKey().equals(activityPlan.getProcessStatus())
                    && !ProcessStatusEnum.REJECT.getKey().equals(activityPlan.getProcessStatus())
                    && !ProcessStatusEnum.RECOVER.getKey().equals(activityPlan.getProcessStatus())) {
                throw new RuntimeException("活动方案[" + activityPlan.getPlanCode() + "]未处于【待提交】、【驳回】状态，不能删除！");
            }
        }
        activityPlanRepository.deleteByIds(ids);
        List<String> planCodes = activityPlans.stream().map(ActivityPlan::getPlanCode).collect(Collectors.toList());
        activityPlanItemService.deleteByPlanCodes(planCodes);
        activityPlanBudgetService.deleteByPlanCodes(planCodes);
    }

    @Transactional
    @Override
    public void updateActivityDelayEndTime(List<ActivityPlanItemDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }

        List<String> planCodeList = list.stream().map(ActivityPlanItemDto::getPlanCode).distinct().collect(Collectors.toList());
        Map<String, Date> planMap = list.stream().collect(Collectors.toMap(ActivityPlanItemDto::getPlanCode, ActivityPlanItemDto::getActivityEndDate, (v1, v2) -> v1));

        List<String> planItemCodeList = list.stream().map(ActivityPlanItemDto::getPlanItemCode).distinct().collect(Collectors.toList());
        Map<String, Date> planItemMap = list.stream().collect(Collectors.toMap(ActivityPlanItemDto::getPlanItemCode, ActivityPlanItemDto::getActivityEndDate, (v1, v2) -> v1));

        List<ActivityPlan> planList = this.activityPlanRepository.findByPlanCodeList(planCodeList);
        List<ActivityPlanItem> planItemList = this.activityPlanItemRepository.listByDetailCodeList(planItemCodeList);

        planList.forEach(e->e.setEndDate(planMap.get(e.getPlanCode())));
        planItemList.forEach(e->e.setActivityEndDate(planItemMap.get(e.getPlanItemCode())));

        this.activityPlanRepository.updateBatchById(planList);
        this.activityPlanItemRepository.updateBatchById(planItemList);
    }

    @Override
    public void pushActivityToFreeGoods(List<String> planCodes) {
        if(CollectionUtils.isEmpty(planCodes)){
            return;
        }

        List<ActivityPlanItemVo> activityPlanItemVos = activityPlanItemService.findListByPlanCodes(planCodes);
        if(org.apache.commons.collections4.CollectionUtils.isNotEmpty(activityPlanItemVos)){
            activityPlanItemVos = activityPlanItemVos.stream().filter(o -> !InterfacePushStateEnum.SUCCESS.getCode().equals(o.getSapInterfaceState())).collect(Collectors.toList());

            List<String> planItemCodes = activityPlanItemVos.stream().map(ActivityPlanItemVo::getPlanItemCode).collect(Collectors.toList());
            //批量加锁
            boolean hasLock = false;
            try {
                hasLock = redisLockService.batchLock(ActivityPlanConstant.FREE_GOODS_LOCK, planItemCodes, TimeUnit.MINUTES, 30);
                if (!hasLock) {
                    throw new RuntimeException("免费货物正在推送SAP中,请勿重复推送");
                }
                planPushFreeGoods.pushActivityToFreeGoods(activityPlanItemVos, OperationTypeEnum.CREATE);
            }finally {
                if (hasLock) {
                    redisLockService.batchUnLock(ActivityPlanConstant.FREE_GOODS_LOCK, planItemCodes);
                }
            }
        }
    }
}

