package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanStrategy;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanStrategyRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanStrategyDto;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanStrategyService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案-关联策略服务
 * @author wanghaojia
 * @date 2022/11/23 16:01
 */
@Service
public class ActivityPlanStrategyServiceImpl implements ActivityPlanStrategyService {

    @Autowired(required = false)
    private ActivityPlanStrategyRepository activityPlanStrategyRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param strategyList  活动方案关联策略数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityPlanStrategyList(ActivityPlan entity,boolean update, List<ActivityPlanStrategyDto> strategyList) {

        Map<String, ActivityPlanStrategy> oldMap = Maps.newHashMap();
        if (update){
            List<ActivityPlanStrategy> oldList = activityPlanStrategyRepository.findListByPlanCode(entity.getPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityPlanStrategy::getId, Function.identity()));
        }
        if (CollectionUtils.isEmpty(strategyList)){
            if (oldMap.size() > 0){
                //待删除的数据
                activityPlanStrategyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
            }
            return;
        }
        List<ActivityPlanStrategy> activityPlanStrategies = (List<ActivityPlanStrategy>) nebulaToolkitService.copyCollectionByWhiteList(strategyList, ActivityPlanStrategyDto.class, ActivityPlanStrategy.class, HashSet.class, ArrayList.class);

        List<ActivityPlanStrategy> saveList = Lists.newArrayList();
        List<ActivityPlanStrategy> updateList = Lists.newArrayList();
        for (ActivityPlanStrategy item : activityPlanStrategies) {
            if (oldMap.containsKey(item.getId())){
                updateList.add(item);
                oldMap.remove(item.getId());
            }else{
                item.setPlanCode(entity.getPlanCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityPlanStrategyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityPlanStrategyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0){
            //待删除的数据
            activityPlanStrategyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }


}
