package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanTemplate;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanTemplateRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanTemplateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanTemplateSdkService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * 活动方案-模板配置
 * @author wanghaojia
 * @date 2022/11/23 16:01
 */
@Service
public class ActivityPlanTemplateSdkServiceImpl implements ActivityPlanTemplateSdkService {

    @Autowired(required = false)
    private ActivityPlanTemplateRepository activityPlanTemplateRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    /**
     * 根据活动编码查询 活动方案-模板配置数据
     */
    @Override
    public ActivityPlanTemplateDto findActivityPlanTemplateByPlanCode(String planCode) {
        if(StringUtils.isEmpty(planCode)){
            return null;
        }
        LambdaQueryWrapper<ActivityPlanTemplate> wrapper = Wrappers.<ActivityPlanTemplate>lambdaQuery();
        wrapper.eq(ActivityPlanTemplate::getPlanCode,planCode);
        wrapper.eq(ActivityPlanTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(ActivityPlanTemplate::getEnableStatus, EnableStatusEnum.ENABLE.getCode());
        ActivityPlanTemplate template = activityPlanTemplateRepository.getOne(wrapper);
        if(template != null){
            ActivityPlanTemplateDto planTemplateDto = this.nebulaToolkitService.copyObjectByWhiteList(template, ActivityPlanTemplateDto.class, null, null);
            return planTemplateDto;
        }else{
            return null;
        }
    }
}
