package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanTemplateRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanTemplateDto;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanTemplate;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanTemplateService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案-模板配置
 * @author wanghaojia
 * @date 2022/11/23 16:01
 */
@Service
public class ActivityPlanTemplateServiceImpl implements ActivityPlanTemplateService {

    @Autowired(required = false)
    private ActivityPlanTemplateRepository activityPlanTemplateRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 保存活动方案-关联营销策略数据
     *
     * @param templateList  活动方案模板配置数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveActivityPlanTemplateList(ActivityPlan entity,boolean update, List<ActivityPlanTemplateDto> templateList) {
        if (CollectionUtils.isEmpty(templateList)){
            return;
        }

        Map<String,ActivityPlanTemplate> oldMap = Maps.newHashMap();
        if (update){
            List<ActivityPlanTemplate> oldList = activityPlanTemplateRepository.findListByPlanCode(entity.getPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(ActivityPlanTemplate::getId, Function.identity()));
        }
        List<ActivityPlanTemplate> activityPlanStrategies = (List<ActivityPlanTemplate>) nebulaToolkitService.copyCollectionByWhiteList(templateList, ActivityPlanTemplateDto.class, ActivityPlanTemplate.class, HashSet.class, ArrayList.class);

        List<ActivityPlanTemplate> saveList = Lists.newArrayList();
        List<ActivityPlanTemplate> updateList = Lists.newArrayList();
        for (ActivityPlanTemplate item : activityPlanStrategies) {
            if (oldMap.containsKey(item.getId())){
                updateList.add(item);
                oldMap.remove(item.getId());
            }else{
                item.setPlanCode(entity.getPlanCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setTenantCode(entity.getTenantCode());
                item.setId(null);
                saveList.add(item);
            }
        }
        if (!CollectionUtils.isEmpty(saveList)){
            activityPlanTemplateRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)){
            activityPlanTemplateRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0){
            //待删除的数据
            activityPlanTemplateRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }


}
