package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanVoService;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动方案查询服务
 * @author wanghaojia
 * @date 2023/12/20 15:03
 */
@Service
public class ActivityPlanVoServiceImpl implements ActivityPlanVoService {

    @Autowired(required = false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;

    @Autowired(required = false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Autowired(required = false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Override
    public List<ActivityPlanItemVo> findActivityPlanItemSumInfoByProcessNo(String processNo) {
        if (StringUtils.isEmpty(processNo)){
            return Lists.newArrayList();
        }
        List<ProcessBusinessMappingVo> processBusinessMappingVos = processBusinessMappingService.findAllByProcessNoCollection(Lists.newArrayList(processNo));
        List<String> planCodeList = processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        List<ActivityPlanItemVo> planItemDtos = activityPlanItemRepository.findVoListByPlanCodeList(planCodeList);
//        年月	区域	活动分类	活动形式	费用合计（元）	总部承担金额（元）	大区承担金额(元)	预估销售额（元）	预估费率
//        以申请的活动方案明细的活动开始时间、活动结束时间、区域、活动分类、活动形式维度进行统计								费用合计/预估销售额
        Map<String, List<ActivityPlanItemVo>> groupMap = planItemDtos.stream().collect(Collectors.groupingBy(item -> {
            return item.getFeeYearMonthStr() + item.getActivityOrgCode() + item.getActivityTypeCode() + item.getActivityFormCode();
        }));

        List<ActivityPlanItemVo> result = Lists.newArrayList();
        BigDecimal multiplicand = new BigDecimal(100);
        for (Map.Entry<String, List<ActivityPlanItemVo>> entry : groupMap.entrySet()) {
            List<ActivityPlanItemVo> value = entry.getValue();
            ActivityPlanItemVo firstVo = value.get(0);
            ActivityPlanItemVo vo = new ActivityPlanItemVo();
            vo.setFeeYearMonthStr(firstVo.getFeeYearMonthStr());
            vo.setActivityOrgCode(firstVo.getActivityOrgCode());
            vo.setActivityOrgName(firstVo.getActivityOrgName());
            vo.setActivityTypeCode(firstVo.getActivityTypeCode());
            vo.setActivityTypeName(firstVo.getActivityTypeName());
            vo.setActivityForm(firstVo.getActivityFormCode());
            vo.setActivityFormName(firstVo.getActivityFormName());
            vo.setTotalFeeAmount(BigDecimal.ZERO);
            vo.setHeadFeeAmount(BigDecimal.ZERO);
            vo.setDepartmentFeeAmount(BigDecimal.ZERO);
            vo.setSalesAmount(BigDecimal.ZERO);
            for (ActivityPlanItemVo activityPlanItemVo : value) {
                if (null != activityPlanItemVo.getTotalFeeAmount()){
                    vo.setTotalFeeAmount(vo.getTotalFeeAmount().add(activityPlanItemVo.getTotalFeeAmount()));
                }
                if (null != activityPlanItemVo.getHeadFeeAmount()){
                    vo.setHeadFeeAmount(vo.getHeadFeeAmount().add(activityPlanItemVo.getHeadFeeAmount()));
                }
                if (null != activityPlanItemVo.getDepartmentFeeAmount()){
                    vo.setDepartmentFeeAmount(vo.getDepartmentFeeAmount().add(activityPlanItemVo.getDepartmentFeeAmount()));
                }
                if (null != activityPlanItemVo.getSalesAmount()){
                    vo.setSalesAmount(vo.getSalesAmount().add(activityPlanItemVo.getSalesAmount()));
                }
            }
            String feeRateStr = null;
            if (null != vo.getSalesAmount() && vo.getSalesAmount().compareTo(BigDecimal.ZERO) != 0){
                //            费用合计/预估销售额
                BigDecimal feeRate = vo.getTotalFeeAmount().multiply(multiplicand).divide(vo.getSalesAmount(),2,BigDecimal.ROUND_HALF_UP);
                feeRateStr = feeRate + "%";
            }
            vo.setFeeRateStr(feeRateStr);
            result.add(vo);
        }
        return result;
    }

    /**
     * 按流程编码查询活动方案预算信息
     * @param processNo 流程编码
     */
    @Override
    public List<ActivityPlanBudgetSumVo> findActivityPlanBudgetSumInfoByProcessNo(String processNo) {
        if (StringUtils.isEmpty(processNo)){
            return Lists.newArrayList();
        }
        List<ProcessBusinessMappingVo> processBusinessMappingVos = processBusinessMappingService.findAllByProcessNoCollection(Lists.newArrayList(processNo));
        List<String> planCodeList = processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        List<ActivityPlanBudget> activityPlanBudgets = activityPlanBudgetRepository.listByPlanCodeList(planCodeList);

        List<String> monthBudgetCodeList = activityPlanBudgets.stream()
//                .filter(item -> ActivityPlanBudgetOccupyTypeEnum.BUDGET item.getOccupyType())
                .map(ActivityPlanBudget::getMonthBudgetCode)
                .filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<MonthBudgetVo> monthBudgetVos = monthBudgetService.listByCodes(monthBudgetCodeList);
        //展示申请方案的关联的预算项目信息。按照预算项目+年月汇总本月累计可用金额、管控累计可用金额、本次使用金额
        Map<String, List<MonthBudgetVo>> budgetGroupMap = monthBudgetVos.stream().collect(Collectors.groupingBy(item -> item.getBudgetItemCode() + item.getYearMonthLy()));
        Map<String,ActivityPlanBudgetSumVo> resultMap = Maps.newHashMap();
        for (Map.Entry<String, List<MonthBudgetVo>> entry : budgetGroupMap.entrySet()) {
            List<MonthBudgetVo> value = entry.getValue();
            MonthBudgetVo firstMonthBudgetVo = value.get(0);
            ActivityPlanBudgetSumVo activityPlanBudgetSumVo = resultMap.computeIfAbsent(entry.getKey(), (tempKey) -> {
                ActivityPlanBudgetSumVo tempSumVo = new ActivityPlanBudgetSumVo();
                tempSumVo.setYearMonthLy(firstMonthBudgetVo.getYearMonthLy());
                tempSumVo.setBudgetItemCode(firstMonthBudgetVo.getBudgetItemCode());
                tempSumVo.setBudgetItemName(firstMonthBudgetVo.getBudgetItemName());
                tempSumVo.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                tempSumVo.setControlBalanceAmount(BigDecimal.ZERO);
                tempSumVo.setUseAmount(BigDecimal.ZERO);
                return tempSumVo;
            });
            for (MonthBudgetVo monthBudgetVo : value) {
                if (null != monthBudgetVo.getAccumulatedAvailableBalance()){
                    activityPlanBudgetSumVo.setAccumulatedAvailableBalance(activityPlanBudgetSumVo.getAccumulatedAvailableBalance().add(monthBudgetVo.getAccumulatedAvailableBalance()));
                }
                if (null != monthBudgetVo.getControlBalanceAmount()){
                    activityPlanBudgetSumVo.setControlBalanceAmount(activityPlanBudgetSumVo.getControlBalanceAmount().add(monthBudgetVo.getControlBalanceAmount()));
                }
            }
        }
        Map<String, MonthBudgetVo> budgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        for (ActivityPlanBudget activityPlanBudget : activityPlanBudgets) {
            if (StringUtils.isEmpty(activityPlanBudget.getMonthBudgetCode())){
                continue;
            }
            MonthBudgetVo monthBudgetVo = budgetMap.get(activityPlanBudget.getMonthBudgetCode());
            String key = monthBudgetVo.getBudgetItemCode() + monthBudgetVo.getYearMonthLy();
            ActivityPlanBudgetSumVo activityPlanBudgetSumVo = resultMap.get(key);
            if (null != activityPlanBudget.getUseAmount()){
                activityPlanBudgetSumVo.setUseAmount(activityPlanBudget.getUseAmount());
            }
        }
        return Lists.newArrayList(resultMap.values());
    }
}
