package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.CorrectionDiscountRateQuantum;
import com.biz.crm.tpm.business.activity.plan.local.repository.CorrectionDiscountRateQuantumRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.CorrectionDiscountRateQuantumService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.AuditFormEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.SurplusFeePoolBalanceSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @CLASS_DESCRIBE: 修正折扣率_量子
 * @AUTHOR: create by zkey on 2023-11-09
 */
@Slf4j
@Service
public class CorrectionDiscountRateQuantumServiceImpl implements CorrectionDiscountRateQuantumService {

    /**
     * 区域数据字典编码
     */
    private static final String DICT_REGION_CODE = "MDM_CUSTOMIZE_ORG";

    @Autowired(required = false)
    private CorrectionDiscountRateQuantumRepository correctionDiscountRateQuantumRepository;

    @Autowired(required = false)
    private CustomerRetailerVoService customerRetailerVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Autowired(required = false)
    private SurplusFeePoolBalanceSdkService surplusFeePoolBalanceSdkService;

    /**
     * 修正折扣率_量子-跑帆软
     * @param yearMonths
     */
    @Override
    @Transactional
    public void frJob(List<String> yearMonths,String regionCode,String systemCode) {
        //首先删除数据
        this.correctionDiscountRateQuantumRepository.removeByYearMonth(yearMonths,regionCode,systemCode);

        //查询垂直零售商
        Pageable pageable = PageRequest.of(1, 200);
        CustomerRetailerDto dto = new CustomerRetailerDto();
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto.setCustomerRetailerCode(systemCode);
        Page<CustomerRetailerVo> customerRetailerVoPage = this.customerRetailerVoService.findByConditions(pageable, dto);
        if (Objects.isNull(customerRetailerVoPage) || CollectionUtils.isEmpty(customerRetailerVoPage.getRecords()))
            return;

        //查询区域
        List<DictDataVo> dictDataVoList = this.dictDataVoService.findByDictTypeCode(DICT_REGION_CODE);
        if (CollectionUtils.isEmpty(dictDataVoList)) return;
        if(StringUtils.isNotEmpty(regionCode)) {
            dictDataVoList = dictDataVoList.stream().filter(o -> regionCode.equals(o.getDictCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(dictDataVoList)) return;

        //拆分数据大概是：零售商50个*区域18个*2个月=1800条数据(预估。但不会超过)
        List<CorrectionDiscountRateQuantum> quantumList = Lists.newArrayList();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        List<DictDataVo> finalDictDataVoList = dictDataVoList;
        yearMonths.forEach(yearMonth -> {
            customerRetailerVoPage.getRecords().forEach(retailer -> {
                finalDictDataVoList.forEach(dict -> {
                    CorrectionDiscountRateQuantum quantum = new CorrectionDiscountRateQuantum();
                    quantum.setTenantCode(TenantUtils.getTenantCode());
                    quantum.setYearMonthStr(yearMonth);
                    YearMonth ym = YearMonth.parse(yearMonth, formatter);
                    ym = ym.plusMonths(-1);
                    quantum.setLastMonth(ym.format(formatter));
                    ym = ym.plusMonths(-1);
                    quantum.setLastLastMonth(ym.format(formatter));
                    quantum.setRegionCode(dict.getDictCode());
                    quantum.setRegionName(dict.getDictValue());
                    quantum.setSystemCode(retailer.getCustomerRetailerCode());
                    quantum.setSystemName(retailer.getCustomerRetailerName());
                    quantum.setQuantum(StringUtils.join(quantum.getRegionName(),quantum.getSystemName()));
                    quantum.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                    quantum.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                    quantumList.add(quantum);
                });
            });
        });

        //这里还是拆分一下数据吧。
        Lists.partition(quantumList, 200).forEach(p -> {
            //内控销售任务
            List<SalesGoalDto> salesGoalDtos = p.stream().map(e -> new SalesGoalDto() {{
                this.setYearMonthLy(e.getYearMonthStr());
                this.setRegionCode(e.getRegionCode());
                this.setSystemCode(e.getSystemCode());
                this.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                this.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            }}).collect(Collectors.toList());
            List<SalesGoalVo> salesGoalVos = this.salesGoalService.findListForFR(salesGoalDtos);
            Map<String, SalesGoalVo> salesGoalVoMap = salesGoalVos
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()), Function.identity(), (v1, v2) -> v1));

            //事中费用申请：报表年月的活动，“核销方式”为“事中”，“结案形式”为“随单”TPM审批状态为“审批通过”的方案明细费用合计
            List<ActivityPlanItemDto> activityPlanItemDtos = p.stream().map(e -> new ActivityPlanItemDto() {{
                this.setYearMonthLy(e.getYearMonthStr());
                this.setRegion(e.getRegionCode());
                this.setSystemCode(e.getSystemCode());
                this.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                this.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            }}).collect(Collectors.toList());
            List<ActivityPlanItemVo> activityPlanItemVos = this.activityPlanItemSdkService.findListForFR(activityPlanItemDtos);
            Map<String, ActivityPlanItemVo> activityPlanItemVoMap = activityPlanItemVos
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthLy(), e.getRegion(), e.getSystemCode()), Function.identity(), (v1, v2) -> v1));

            //事后费用处理：活动结束时间所属年月截止到报表年月的上月，取“结案形式”为“折扣”（完全结案的活动不参与统计，未完全结案的金额=申请金额-已结案金额）
            List<ActivityPlanItemDto> itemDtos = p.stream().map(e -> new ActivityPlanItemDto() {{
                this.setYearMonthLy(e.getLastMonth());
                this.setRegion(e.getRegionCode());
                this.setSystemCode(e.getSystemCode());
            }}).collect(Collectors.toList());
            List<ActivityPlanItemVo> itemVoList = this.activityPlanItemSdkService.findCostListForFR(itemDtos, AuditFormEnum.DISCOUNT.getCode());
            Map<String, ActivityPlanItemVo> itemVoMap = itemVoList
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(getNextMonth(formatter,e.getYearMonthLy()), e.getRegion(), e.getSystemCode()), Function.identity(), (v1, v2) -> v1));
            //红票
            List<ActivityPlanItemVo> itemVoList1 = this.activityPlanItemSdkService.findCostListForFR(itemDtos, AuditFormEnum.RED_INVOICE.getCode());
            Map<String, ActivityPlanItemVo> itemVoMap1 = itemVoList1
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthLy(), e.getRegion(), e.getSystemCode()), Function.identity(), (v1, v2) -> v1));

            //费用池 取《费用池余额表报表年月的期初余额）
            List<SurplusFeePoolBalanceDto> balanceDtos = p.stream().map(e -> new SurplusFeePoolBalanceDto() {{
                this.setYearMonthStr(e.getYearMonthStr());
                this.setRegionCode(e.getRegionCode());
                this.setCustomerRetailerCode(e.getSystemCode());
            }}).collect(Collectors.toList());
            List<SurplusFeePoolBalanceVo> balanceVos = this.surplusFeePoolBalanceSdkService.findListForFR(balanceDtos, BusinessUnitEnum.VERTICAL.getCode());
            Map<String, SurplusFeePoolBalanceVo> balanceVoMap = balanceVos
                    .stream()
                    .collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthStr(), e.getRegionCode(), e.getCustomerRetailerCode()), Function.identity()));

            //组装数据
            p.forEach(e -> {
                String key =  StringUtils.join(e.getYearMonthStr(),e.getRegionCode(),e.getSystemCode());

                //折后销售额
                e.setDiscountAfterSalesAmount(BigDecimal.ZERO);
                if(salesGoalVoMap.containsKey(key)){
                    e.setDiscountAfterSalesAmount(salesGoalVoMap.get(key).getDeliveryDiscountSalesAmount());
                }
                //事中费用申请
                e.setEventCentreAmount(BigDecimal.ZERO);
                if(activityPlanItemVoMap.containsKey(key)){
                    e.setEventCentreAmount(activityPlanItemVoMap.get(key).getTotalFeeAmount());
                }
                //事后费用处理
                e.setEventAfterAmount(BigDecimal.ZERO);
                if(itemVoMap.containsKey(key)){
                    e.setEventAfterAmount(itemVoMap.get(key).getTotalFeeAmount());
                }
                //红票
                e.setRedTicket(BigDecimal.ZERO);
                if(itemVoMap1.containsKey(key)){
                    e.setRedTicket(itemVoMap1.get(key).getTotalFeeAmount());
                }
                //费用池
                e.setCostPoolResidue(BigDecimal.ZERO);
                if(balanceVoMap.containsKey(key)){
                    e.setCostPoolResidue(balanceVoMap.get(key).getBalance());
                }
                //费用合计=事中费用申请+事后费用处理+红票+费用池
                e.setCostTotal(e.getEventCentreAmount().add(e.getEventAfterAmount()).add(e.getRedTicket()).add(e.getCostPoolResidue()));
                //折前销售额：折后销售额+费用合计
                e.setDiscountBeforeSalesAmount(e.getDiscountAfterSalesAmount().add(e.getCostTotal()));
                //修正折前折扣率：费用合计/本月折前销售额*100%
                e.setCorrectionDiscountBeforeRate(BigDecimal.ZERO);
                if(BigDecimal.ZERO.compareTo(e.getDiscountBeforeSalesAmount()) != 0){
                    e.setCorrectionDiscountBeforeRate(e.getCostTotal().divide(e.getDiscountBeforeSalesAmount(),4,BigDecimal.ROUND_HALF_UP));
                }
                //修正折后折扣率：费用合计/本月折后销售额*100%
                e.setCorrectionDiscountAfterRate(BigDecimal.ZERO);
                if(BigDecimal.ZERO.compareTo(e.getDiscountAfterSalesAmount()) != 0){
                    e.setCorrectionDiscountAfterRate(e.getCostTotal().divide(e.getDiscountAfterSalesAmount(),4,BigDecimal.ROUND_HALF_UP));
                }
                //预算折后折扣率：（年初内控版折前销售目标-年初内控版折后销售目标）/年初内控版的折后销售目标数据*100%
                BigDecimal before = BigDecimal.ZERO;
                e.setBudgetDiscountAfterRate(BigDecimal.ZERO);
                if(salesGoalVoMap.containsKey(key)){
                    before = salesGoalVoMap.get(key).getDeliverySalesAmount();
                }
                if(BigDecimal.ZERO.compareTo(e.getDiscountAfterSalesAmount()) != 0){
                    e.setBudgetDiscountAfterRate((before.subtract(e.getDiscountAfterSalesAmount())).divide(e.getDiscountAfterSalesAmount(),4,BigDecimal.ROUND_HALF_UP));
                }
                //VS预算折后折扣率偏差：修正折后折扣率-预算折后折扣率
                e.setVsOffset(e.getCorrectionDiscountAfterRate().subtract(e.getBudgetDiscountAfterRate()));
            });

            this.correctionDiscountRateQuantumRepository.saveOrUpdateBatch(p);
        });
    }

    private String getNextMonth(DateTimeFormatter formatter, String yearMonthLy) {
        YearMonth ym = YearMonth.parse(yearMonthLy, formatter);
        ym = ym.plusMonths(1);
        return ym.format(formatter);
    }
}
