package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.activity.plan.local.entity.MarketingFeeUseProgress;
import com.biz.crm.tpm.business.activity.plan.local.repository.MarketingFeeUseProgressMiddleRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.MarketingFeeUseProgressRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.MarketingFeeUseProgressService;
import com.biz.crm.tpm.business.sales.goal.sdk.constant.DictTypeCodeConstant;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesPerformanceDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesPerformanceVoService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesPerformanceVo;
import com.biz.crm.tpm.business.year.budget.sdk.dto.YearBudgetDto;
import com.biz.crm.tpm.business.year.budget.sdk.service.YearBudgetSdkService;
import com.biz.crm.tpm.business.year.budget.sdk.vo.YearBudgetVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import java.util.*;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @CLASS_DESCRIBE: 营销费用使用进度
 * @AUTHOR: create by zkey on 2023-11-04
 */
@Slf4j
@Service
public class MarketingFeeUseProgressServiceImpl implements MarketingFeeUseProgressService {

    @Autowired(required = false)
    private MarketingFeeUseProgressRepository marketingFeeUseProgressRepository;

    @Autowired(required = false)
    private MarketingFeeUseProgressMiddleRepository marketingFeeUseProgressMiddleRepository;

    @Autowired(required = false)
    private SalesGoalService salesGoalService;

    @Autowired(required = false)
    private SalesPerformanceVoService salesPerformanceVoService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Autowired(required = false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    @Autowired(required = false)
    private YearBudgetSdkService yearBudgetSdkService;

    /**
     * 营销费用使用进度-跑帆软
     */
    @Override
    public void frJob(List<String> yearMonths) {
        //首先删除数据
        this.marketingFeeUseProgressRepository.lambdaUpdate().in(MarketingFeeUseProgress::getYearMonthStr, yearMonths).remove();
        this.marketingFeeUseProgressMiddleRepository.lambdaUpdate().remove();

        //跑一张中间表
        this.marketingFeeUseProgressMiddleRepository.frJob(yearMonths);

        //汇总中间表到结果表
        this.marketingFeeUseProgressRepository.insertTable();

        Map<String, String> region = this.dictToolkitService.findMapByDictTypeCode(DictTypeCodeConstant.MDM_CUSTOMIZE_ORG);
        //分页处理
        int current = 1;
        int pageSize = 300;
        int count = 1;
        Page<MarketingFeeUseProgress> result = null;
        LambdaQueryWrapper<MarketingFeeUseProgress> wrapper = Wrappers.<MarketingFeeUseProgress>lambdaQuery().in(MarketingFeeUseProgress::getYearMonthStr, yearMonths).orderByDesc(MarketingFeeUseProgress::getCreateTime);
        do {
            try {
                Page<MarketingFeeUseProgress> page = new Page<>(current, pageSize);
                result = this.marketingFeeUseProgressRepository.getBaseMapper().selectPage(page, wrapper);
                if(result == null ||CollectionUtils.isEmpty(result.getRecords())) break;
                current++;
                log.info("营销费用使用进度-跑帆软-页码{} 查询的marketingFeeUseProgress分页数据：{}", current-1, JSON.toJSONString(result));

                //取销售任务
                Map<String,SalesGoalVo> salesGoalVoMap = new HashMap<>();
                List<SalesGoalDto> salesGoalDtos = result.getRecords().stream().map(e -> new SalesGoalDto(){{
                    this.setYearMonthLy(e.getYearMonthStr());
                    this.setRegionCode(e.getRegion());
                    this.setSystemCode(e.getSystemCode());
                }}).collect(Collectors.toList());
                List<SalesGoalVo> salesGoalVos = this.salesGoalService.findListForFR(salesGoalDtos);
                if (!CollectionUtils.isEmpty(salesGoalVos)) {
                    salesGoalVoMap.putAll(salesGoalVos.stream().collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()), Function.identity())));
                }
                log.info("营销费用使用进度-跑帆软-页码{} 查询的SalesGoalVo：{}", current-1, JSON.toJSONString(salesGoalVoMap));

                //取垂直销售业绩
                Map<String,SalesPerformanceVo> salesPerformanceVoMap = new HashMap<>();
                List<SalesPerformanceDto> salesPerformanceDtos = result.getRecords().stream().map(e -> new SalesPerformanceDto(){{
                    this.setSalesMonth(e.getYearMonthStr().replace("-",""));
                    this.setRegion(region.getOrDefault(e.getRegion(),"not found"));
                    this.setRetailer(e.getSystemName());
                }}).collect(Collectors.toList());
                List<SalesPerformanceVo> salesPerformanceVos = this.salesPerformanceVoService.findListForFR(salesPerformanceDtos);
                if (!CollectionUtils.isEmpty(salesPerformanceVos)) {
                    salesPerformanceVoMap.putAll(salesPerformanceVos.stream().collect(Collectors.toMap(e -> StringUtils.join(e.getSalesMonth(), e.getRegion(), e.getRetailer()), Function.identity())));
                }
                log.info("营销费用使用进度-跑帆软-页码{} 查询的SalesPerformance：{}", current-1, JSON.toJSONString(salesPerformanceVoMap));

                //取POS
                Map<String,SalesDataVo> salesDataVoMap = new HashMap<>();
                List<SalesDataDto> salesDataDtos = result.getRecords().stream().map(e -> new SalesDataDto(){{
                    this.setYearMonth(e.getYearMonthStr());
                    this.setBusinessArea(e.getRegion());
                    this.setCustomerRetailerCode(e.getSystemCode());
                }}).collect(Collectors.toList());
                List<SalesDataVo> salesDataVos = this.invoiceSalesDataVoService.findListForFR(salesDataDtos);
                if (!CollectionUtils.isEmpty(salesDataVos)) {
                    salesDataVoMap.putAll(salesDataVos.stream().collect(Collectors.toMap(e -> StringUtils.join(e.getYearMonth(), e.getBusinessArea(), e.getCustomerRetailerCode()), Function.identity())));
                }
                log.info("营销费用使用进度-跑帆软-页码{} 查询的SalesDataVo：{}", current-1, JSON.toJSONString(salesDataVoMap));

                result.getRecords().forEach(e -> {
                    String key = StringUtils.join(e.getYearMonthStr(),e.getRegion(),e.getSystemCode());
                    String key1 = StringUtils.join(e.getYearMonthStr().replace("-",""),region.getOrDefault(e.getRegion(),"not found"),e.getSystemName());
                    //垂直销售业绩
                    e.setDiscountSalesAmount(BigDecimal.ZERO);
                    if(salesPerformanceVoMap.containsKey(key1)){
                        e.setDiscountSalesAmount(salesPerformanceVoMap.get(key1).getWarehsOutDiscountAmt());
                    }
                    //销售任务
                    e.setSalesDiscountAmount(BigDecimal.ZERO);
                    if(salesGoalVoMap.containsKey(key)){
                        e.setSalesDiscountAmount(salesGoalVoMap.get(key).getDeliveryDiscountSalesAmount());
                    }
                    //销售达成率
                    e.setSalesAchievementRate(BigDecimal.ZERO);
                    if(BigDecimal.ZERO.compareTo(e.getSalesDiscountAmount()) != 0){
                        e.setSalesAchievementRate(e.getDiscountSalesAmount().divide(e.getSalesDiscountAmount(),4,BigDecimal.ROUND_HALF_UP));
                    }

                    BigDecimal amount = ObjectUtils.defaultIfNull(e.getHeadReserve(),BigDecimal.ZERO)
                            .add(ObjectUtils.defaultIfNull(e.getExcessProfitConversion(),BigDecimal.ZERO))
                            .add(ObjectUtils.defaultIfNull(e.getRegionAuthFee(),BigDecimal.ZERO));

                    //POS费用率
                    e.setPosFeeRate(BigDecimal.ZERO);
                    if(salesDataVoMap.containsKey(key)){
                        BigDecimal pos = ObjectUtils.defaultIfNull(salesDataVoMap.get(key).getSalesAmount(),BigDecimal.ZERO);
                        if(BigDecimal.ZERO.compareTo(pos) != 0){
                            e.setPosFeeRate(amount.divide(pos,4,BigDecimal.ROUND_HALF_UP));
                        }
                    }
                    //整体营销费用率
                    e.setOverallMarketingFeeRate(BigDecimal.ZERO);
                    if(BigDecimal.ZERO.compareTo(e.getSalesDiscountAmount()) != 0){
                        e.setOverallMarketingFeeRate(amount.divide(e.getSalesDiscountAmount(),4,BigDecimal.ROUND_HALF_UP));
                    }
                    e.setTenantCode(TenantUtils.getTenantCode());
                });

                this.marketingFeeUseProgressRepository.saveOrUpdateBatch(result.getRecords());

                //查询公投、自投年度预算金额
                Set<YearBudgetDto> yearBudgetDtos = result.getRecords().stream().map(e -> new YearBudgetDto(){{
                    this.setYearLy(e.getYearMonthStr().substring(0,4));
                    this.setRegionCode(e.getRegion());
                    this.setSystemCode(e.getSystemCode());
                }}).collect(Collectors.toSet());
                List<YearBudgetVo> yearBudgetVos = this.yearBudgetSdkService.findListForFR(new ArrayList<>(yearBudgetDtos));
                Map<String,YearBudgetVo> yearBudgetVoMap = yearBudgetVos.stream().collect(Collectors.toMap(e -> StringUtils.join(e.getYearLy(),e.getRegionCode(),e.getSystemCode()),Function.identity()));

                //更新累计数据
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
                DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
                result.getRecords().forEach(e -> {
                    //VS同期：整体营销费用率本月值与去年同期营销费用率差异
                    YearMonth yearMonth = YearMonth.parse(e.getYearMonthStr(),formatter);
                    yearMonth = yearMonth.plusYears(-1);
                    MarketingFeeUseProgress last = this.marketingFeeUseProgressRepository
                            .lambdaQuery()
                            .eq(MarketingFeeUseProgress::getYearMonthStr,yearMonth.format(formatter))
                            .eq(MarketingFeeUseProgress::getRegion,e.getRegion())
                            .eq(MarketingFeeUseProgress::getSystemCode,e.getSystemCode())
                            .one();
                    e.setVsTq(BigDecimal.ZERO);
                    if(Objects.nonNull(last)){
                        e.setVsTq(e.getOverallMarketingFeeRate().subtract(ObjectUtils.defaultIfNull(last.getOverallMarketingFeeRate(),BigDecimal.ZERO)));
                    }

                    //累计到本月
                    YearMonth currentYearMonth = YearMonth.parse(e.getYearMonthStr(),formatter);
                    String startYearMonth = currentYearMonth.format(yearFormatter) + "-01";
                    String endYearMonth = currentYearMonth.format(formatter);
                    MarketingFeeUseProgress accumulate = this.marketingFeeUseProgressRepository.accumulate(startYearMonth,endYearMonth,e.getRegion(),e.getSystemCode());

                    //销量达成进度：截止统计年月《垂直销售业绩表》折后实际销额/内控版的全年销售任务折后金额*100%
                    e.setSalesAchievementProgress(BigDecimal.ZERO);
                    if(Objects.nonNull(accumulate) && BigDecimal.ZERO.compareTo(accumulate.getSalesDiscountAmount()) != 0){
                        e.setSalesAchievementProgress(accumulate.getDiscountSalesAmount().divide(accumulate.getSalesDiscountAmount(),4,BigDecimal.ROUND_HALF_UP));
                    }
                    //费用使用进度：截止统计年月的区域授权费用/公投、自投全年年度预算金额*100%
                    e.setFeeUseProgress(BigDecimal.ZERO);
                    String budgetKey = StringUtils.join(e.getYearMonthStr().substring(0,4),e.getRegion(),e.getSystemCode());
                    if(Objects.nonNull(accumulate) && yearBudgetVoMap.containsKey(budgetKey) && BigDecimal.ZERO.compareTo(yearBudgetVoMap.get(budgetKey).getBudgetTotalAmount()) != 0){
                        e.setFeeUseProgress(accumulate.getRegionAuthFee().divide(yearBudgetVoMap.get(budgetKey).getBudgetTotalAmount(),4,BigDecimal.ROUND_HALF_UP));
                    }
                });

                this.marketingFeeUseProgressRepository.saveOrUpdateBatch(result.getRecords());
                count++;

            } catch (Exception e) {
                log.info("营销费用使用进度-跑帆软-页码{} 错误：{}", current-1, e.getMessage());
                e.printStackTrace();
            }
        } while (count < 1000 && result.hasNext());
    }
}
