package com.biz.crm.tpm.business.activity.plan.local.service.internal.thirld;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.tpm.business.activity.plan.local.entity.PlanFreeGoodsMapping;
import com.biz.crm.tpm.business.activity.plan.local.repository.PlanFreeGoodsMappingRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.FreeGoodsInterfaceCallbackDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.SapInterfaceEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.FreeGoodsMappingService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author : dengwei
 * @Date :2023/9/28  16:44
 * @Description: TODO
 */
@Service
@Slf4j
public class PlanFreeGoodsMappingServiceImpl implements FreeGoodsMappingService {

    @Autowired(required = false)
    private PlanFreeGoodsMappingRepository planFreeGoodsMappingRepository;

    @Autowired(required = false)
    private ActivityPlanItemService activityPlanItemService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void freeGoodsCallback(FreeGoodsInterfaceCallbackDto dto) {
        if(ObjectUtils.isEmpty(dto) || ObjectUtils.isEmpty(dto.getItem1())){
            return;
        }
        FreeGoodsInterfaceCallbackDto.Item1 item1 = dto.getItem1().get(0);
        if(ObjectUtils.isEmpty(item1)){
            return;
        }
        List<PlanFreeGoodsMapping> planFreeGoodsMappings = planFreeGoodsMappingRepository.list(Wrappers.<PlanFreeGoodsMapping>lambdaQuery()
                .eq(PlanFreeGoodsMapping::getMessageId, dto.getMessageHeader().getMessageId())
        );
        if(SapInterfaceEnum.SUCCESS.getCode().equals(item1.getFLAG())){

            if (!CollectionUtils.isEmpty(planFreeGoodsMappings)){
                Map<String, PlanFreeGoodsMapping> freeGoodsMappingMap = planFreeGoodsMappings.stream().collect(Collectors.toMap(PlanFreeGoodsMapping::getCondNo, Function.identity()));
                for (FreeGoodsInterfaceCallbackDto.Item1 item11 : dto.getItem1()) {
                    PlanFreeGoodsMapping planFreeGoodsMapping = freeGoodsMappingMap.get(item11.getCOND_NO());
                    planFreeGoodsMapping.setCondNoNew(item11.getCOND_NO_NEW());
                    activityPlanItemService.updatePlanItemSapState(planFreeGoodsMapping.getPlanItemCode(),true);
                }
                planFreeGoodsMappingRepository.updateBatchById(planFreeGoodsMappings);
            }
        }else if(SapInterfaceEnum.FAIL.getCode().equals(item1.getFLAG())){
            if (!CollectionUtils.isEmpty(planFreeGoodsMappings)){
                Map<String, PlanFreeGoodsMapping> freeGoodsMappingMap = planFreeGoodsMappings.stream().collect(Collectors.toMap(PlanFreeGoodsMapping::getCondNo, Function.identity()));
                for (FreeGoodsInterfaceCallbackDto.Item1 item11 : dto.getItem1()) {
                    PlanFreeGoodsMapping planFreeGoodsMapping = freeGoodsMappingMap.get(item11.getCOND_NO());
                    planFreeGoodsMapping.setCondNoNew(item11.getCOND_NO_NEW());
                    activityPlanItemService.updatePlanItemSapState(planFreeGoodsMapping.getPlanItemCode(),false);
                }
                planFreeGoodsMappingRepository.updateBatchById(planFreeGoodsMappings);
            }
        }
    }
}
